<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/3">
	
	<xsl:import href="ech-0010-language-1-0_it.xsl"/>
	
	<!--Decode mrMrsType -->
	
	<xsl:template name="decode-mrMrs">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eCH-0010.mrMrs.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eCH-0010.mrMrs.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eCH-0010.mrMrs.3"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- output organisationName, organisationNameAddOn1 and organisationNameAddOn2 on one line, but only if a organisationName is there -->
	
	<xsl:template match="eCH-0010:organisationName" mode="inline">
		<xsl:value-of select="."/>
		<xsl:if test="../eCH-0010:organisationNameAddOn1">
			<xsl:value-of select="concat(', ', ../eCH-0010:organisationNameAddOn1)"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:organisationNameAddOn2">
			<xsl:value-of select="concat(', ', ../eCH-0010:organisationNameAddOn2)"/>
		</xsl:if>
	</xsl:template>

	<!-- output mrMrs, title, firstName and lastName on one line, but only if a lastName is there -->
	
	<xsl:template match="eCH-0010:lastName" mode="inline">
		<xsl:if test="../eCH-0010:mrMrs">
			<xsl:call-template name="decode-mrMrs">
				<xsl:with-param name="value"><xsl:value-of select="../eCH-0010:mrMrs"/></xsl:with-param>
			</xsl:call-template>
			<xsl:value-of select="' '"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:title">
			<xsl:value-of select="concat(../eCH-0010:title, ' ')"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:firstName">
			<xsl:value-of select="concat(../eCH-0010:firstName, ' ')"/>
		</xsl:if>
		<xsl:value-of select="."/>
	</xsl:template>
	
</xsl:stylesheet>