<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/3"
	xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044/1"
	xmlns:ssk-common="http://www.steuerkonferenz.ch/xmlns/ssk-common/1"
	xmlns:ssk-3001-000501="http://www.steuerkonferenz.ch/xmlns/ssk-3001-000501/1">
	
	<xsl:import href="../../ssk-common/1/ssk-common-1-1_it.xsl"/>
	<xsl:import href="3001-000501-language-1-1_it.xsl"/>
	
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//ssk-3001-000501:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//ssk-3001-000501:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//ssk-3001-000501:header" mode="message-header-block"/>
					<xsl:apply-templates select="//ssk-3001-000501:header" mode="special-message"/>
					<xsl:apply-templates select="//ssk-3001-000501:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<xsl:if test="count(ssk-3001-000501:message) > 0">
							<xsl:attribute name="page-break-after">always</xsl:attribute>
						</xsl:if>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3001-000501:header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3001-000501:content"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="ssk-3001-000501:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$ssk-common"/> | <xsl:value-of select="$ssk-3001-000501"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.chm-steuern.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="ssk-3001-000501:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="ssk-3001-000501:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="ssk-3001-000501:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.declarationLocalReference"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="ssk-3001-000501:declarationLocalReference" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="ssk-3001-000501:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.originalSenderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id" select="ssk-3001-000501:originalSenderId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.initialMessageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="ssk-3001-000501:initialMessageDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="ssk-3001-000501:ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="ssk-3001-000501:yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.eventDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="ssk-3001-000501:eventDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.eventPeriod"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-string">
															<xsl:with-param name="value" select="ssk-3001-000501:eventPeriod"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000501.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(ssk-3001-000501:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="ssk-3001-000501:declarationLocalReference" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:email"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="ssk-3001-000501:header" mode="special-message">
		<xsl:variable name="is-test" select="(ssk-3001-000501:testDeliveryFlag = '1') or (ssk-3001-000501:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="ssk-3001-000501:action != 1 and ssk-3001-000501:action != 5 and ssk-3001-000501:action != 6"/>
		<xsl:variable name="is-priority" select="ssk-3001-000501:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="ssk-3001-000501:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($ssk-3001-000501.messagePriority, ': ')"/>
					<xsl:value-of select="ssk-3001-000501:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $ssk-3001-000501.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="ssk-3001-000501:header">
		<xsl:apply-templates select="ssk-3001-000501:object"/>
		<xsl:apply-templates select="ssk-3001-000501:comment"/>
	</xsl:template>
	
	<!--
		Cover sheet: object field from the message header
	-->
	<xsl:template match="ssk-3001-000501:object">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.object"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
                                <xsl:choose>
                                    <xsl:when test="*">
                                        <xsl:apply-templates select="ssk-common:officialName"/>
                                        <xsl:apply-templates select="ssk-common:firstName"/>
                                        <xsl:apply-templates select="ssk-common:sex"/>
                                        <xsl:apply-templates select="ssk-common:dateOfBirth"/>
                                        <xsl:apply-templates select="ssk-common:vn"/>
                                        <xsl:apply-templates select="ssk-common:OtherPersonId"/>
                                        <xsl:apply-templates select="ssk-common:EuPersonId"/>
                                        <xsl:apply-templates select="ssk-common:address"/>
                                        <xsl:apply-templates select="ssk-common:taxMunicipality"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </xsl:otherwise>
                                </xsl:choose>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="ssk-3001-000501:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.comment"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="ssk-3001-000501:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}" >
							<xsl:value-of select="ssk-3001-000501:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="ssk-3001-000501:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="ssk-3001-000501:messageType"/>/<xsl:value-of select="ssk-3001-000501:subMessageType"/>
							| <xsl:value-of select="concat($ssk-3001-000501.messageId, ' ')"/>
							<xsl:value-of select="ssk-3001-000501:messageId"/>
							<xsl:if test="count(ssk-3001-000501:referenceMessageId) != 0">
								| <xsl:value-of select="concat($ssk-3001-000501.referenceMessageId, ' ')"/>
								<xsl:value-of select="ssk-3001-000501:referenceMessageId"/>
							</xsl:if>
							| <xsl:value-of select="concat($ssk-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		****************  Message content starts here ***************
	 -->
	
	<!-- 
		"Main" template for the message content; shows all relevant content blocks
	-->
	<xsl:template match="ssk-3001-000501:content">
		<xsl:apply-templates select="ssk-3001-000501:taxpayer"/>
		<xsl:apply-templates select="ssk-3001-000501:taxpayerWife"/>
		<xsl:apply-templates select="ssk-3001-000501:removalDate"/>
		<xsl:apply-templates select="ssk-3001-000501:taxationState"/>
		<xsl:if test="ssk-3001-000501:stateMunicipalityEarningTax">
			<xsl:call-template name="ssk-3001-000501:taxableAmount">
				<xsl:with-param name="name" select="$ssk-3001-000501.stateMunicipalityEarningTax"/>
				<xsl:with-param name="year" select="ssk-3001-000501:stateMunicipalityEarningTax/ssk-common:taxPeriod"/>
				<xsl:with-param name="amount" select="ssk-3001-000501:stateMunicipalityEarningTax/ssk-common:amount"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="ssk-3001-000501:stateMunicipalityAssetTax">
			<xsl:call-template name="ssk-3001-000501:taxableAmount">
				<xsl:with-param name="name" select="$ssk-3001-000501.stateMunicipalityAssetTax"/>
				<xsl:with-param name="year" select="ssk-3001-000501:stateMunicipalityAssetTax/ssk-common:taxPeriod"/>
				<xsl:with-param name="amount" select="ssk-3001-000501:stateMunicipalityAssetTax/ssk-common:amount"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:apply-templates select="ssk-3001-000501:stateMunicipalityScaleTax"/>
		<xsl:apply-templates select="ssk-3001-000501:stateMunicipalityDate"/>
		<xsl:if test="ssk-3001-000501:federalEarningTax">
			<xsl:call-template name="ssk-3001-000501:taxableAmount">
				<xsl:with-param name="name" select="$ssk-3001-000501.federalEarningTax"/>
				<xsl:with-param name="year" select="ssk-3001-000501:federalEarningTax/ssk-common:taxPeriod"/>
				<xsl:with-param name="amount" select="ssk-3001-000501:federalEarningTax/ssk-common:amount"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="ssk-3001-000501:federalAssetTax">
			<xsl:call-template name="ssk-3001-000501:taxableAmount">
				<xsl:with-param name="name" select="$ssk-3001-000501.federalAssetTax"/>
				<xsl:with-param name="year" select="ssk-3001-000501:federalAssetTax/ssk-common:taxPeriod"/>
				<xsl:with-param name="amount" select="ssk-3001-000501:federalAssetTax/ssk-common:amount"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:apply-templates select="ssk-3001-000501:federalScaleTax"/>
		<xsl:apply-templates select="ssk-3001-000501:federalMunicipalityDate"/>
		<xsl:apply-templates select="ssk-3001-000501:interkantonal"/>
		<xsl:apply-templates select="ssk-3001-000501:international"/>
		<xsl:apply-templates select="ssk-3001-000501:localRealEstate"/>
		<xsl:apply-templates select="ssk-3001-000501:localBusiness"/>
		<xsl:apply-templates select="ssk-3001-000501:localPartnership"/>
	</xsl:template>

	<!-- 
		Generate the taxpayer block.
	-->
	<xsl:template match="ssk-3001-000501:taxpayer[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.taxpayer"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-common:officialName"/>
								<xsl:apply-templates select="ssk-common:firstName"/>
								<xsl:apply-templates select="ssk-common:sex"/>
								<xsl:apply-templates select="ssk-common:dateOfBirth"/>
								<xsl:apply-templates select="ssk-common:vn"/>
								<xsl:apply-templates select="ssk-common:OtherPersonId"/>
								<xsl:apply-templates select="ssk-common:address"/>
								<xsl:apply-templates select="ssk-common:taxMunicipality"/>
								<xsl:apply-templates select="ssk-common:religion"/>
								<xsl:apply-templates select="ssk-common:maritalStatus"/>
								<xsl:apply-templates select="ssk-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="ssk-common:nbrOfChildren"/>
								<xsl:apply-templates select="ssk-common:dateOfDeath"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the taxpayerWife block.
	-->
	<xsl:template match="ssk-3001-000501:taxpayerWife[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.taxpayerWife"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-common:officialName"/>
								<xsl:apply-templates select="ssk-common:firstName"/>
								<xsl:apply-templates select="ssk-common:sex"/>
								<xsl:apply-templates select="ssk-common:dateOfBirth"/>
								<xsl:apply-templates select="ssk-common:vn"/>
								<xsl:apply-templates select="ssk-common:OtherPersonId"/>
								<xsl:apply-templates select="ssk-common:address"/>
								<xsl:apply-templates select="ssk-common:taxMunicipality"/>
								<xsl:apply-templates select="ssk-common:religion"/>
								<xsl:apply-templates select="ssk-common:maritalStatus"/>
								<xsl:apply-templates select="ssk-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="ssk-common:nbrOfChildren"/>
								<xsl:apply-templates select="ssk-common:dateOfDeath"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the removalDate block.
	-->
	<xsl:template match="ssk-3001-000501:removalDate">
		<xsl:call-template name="single-date-block">
			<xsl:with-param name="title" select="$ssk-3001-000501.removalDate"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- 
		Generate the taxationState block.
	-->
	<xsl:template match="ssk-3001-000501:taxationState">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.taxationState"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-taxationState">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	
	
	<!-- 
		Decodes the taxationState.
	-->
	<xsl:template name="decode-taxationState">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'"><xsl:value-of select="$ssk-3001-000501.taxationState.0"/></xsl:when>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$ssk-3001-000501.taxationState.1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- 
		Generate the stateMunicipalityScaleTax block.
	-->
	<xsl:template match="ssk-3001-000501:stateMunicipalityScaleTax">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.stateMunicipalityScaleTax"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-stateMunicipalityScaleTax">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	
	
	<!-- 
		Decodes the taxation state.
	-->
	<xsl:template name="decode-stateMunicipalityScaleTax">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'"><xsl:value-of select="$ssk-3001-000501.stateMunicipalityScaleTax.0"/></xsl:when>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$ssk-3001-000501.stateMunicipalityScaleTax.1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- 
		Generate the stateMunicipalityDate block.
	-->
	<xsl:template match="ssk-3001-000501:stateMunicipalityDate">
		<xsl:call-template name="single-date-block">
			<xsl:with-param name="title" select="$ssk-3001-000501.stateMunicipalityDate"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>



	<!-- 
		helper template for formatting ssk-common.taxableAmountType 
	-->
	<xsl:template name="ssk-3001-000501:taxableAmount">
		<xsl:param name="name"/>
		<xsl:param name="year"/>
		<xsl:param name="amount"/>

		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$name"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block><xsl:value-of select="$ssk-3001-000501.stateMunicipalityEarningTax.taxPeriod"/></fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$year"/>										
										</fo:block>
									</fo:table-cell>
								</fo:table-row>	
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block><xsl:value-of select="$ssk-3001-000501.stateMunicipalityEarningTax.amount"/></fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="format-number($amount, $integer-format)"/>										
										</fo:block>
									</fo:table-cell>
								</fo:table-row>	
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!-- 
		Generate the federalScaleTax block.
	-->
	<xsl:template match="ssk-3001-000501:federalScaleTax">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.federalScaleTax"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-federalScaleTax">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	
	
	<!-- 
		Decodes federalScaleTax.
	-->
	<xsl:template name="decode-federalScaleTax">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'"><xsl:value-of select="$ssk-3001-000501.federalScaleTax.0"/></xsl:when>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$ssk-3001-000501.federalScaleTax.1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 
		Generate the federalMunicipalityDate block.
	-->
	<xsl:template match="ssk-3001-000501:federalMunicipalityDate">
		<xsl:call-template name="single-date-block">
			<xsl:with-param name="title" select="$ssk-3001-000501.federalMunicipalityDate"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Generate the interkantonal block.
	-->
	<xsl:template match="ssk-3001-000501:interkantonal">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.interkantonal"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-noYes">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	

	<!-- 
		Generate the international block.
	-->
	<xsl:template match="ssk-3001-000501:international">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.international"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-noYes">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	

	<!-- 
		Generate the localRealEstate block.
	-->
	<xsl:template match="ssk-3001-000501:localRealEstate">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.localRealEstate"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-noYes">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	

	<!-- 
		Generate the localBusiness block.
	-->
	<xsl:template match="ssk-3001-000501:localBusiness">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.localBusiness"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-noYes">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	

	<!-- 
		Generate the localPartnership block.
	-->
	<xsl:template match="ssk-3001-000501:localPartnership">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000501.localPartnership"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-noYes">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	
	
	<!-- 
		Decodes noYes.
	-->
	<xsl:template name="decode-noYes">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'"><xsl:value-of select="$ssk-3001-000501.interkantonal.0"/></xsl:when>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$ssk-3001-000501.interkantonal.1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>