<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2010 itServe AG. All rights reserved.
  ~
  ~ This software is the proprietary information of itServe AG
  ~ Bern Switzerland. Use is subject to license terms.
  ~
  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
    <xsl:attribute-set name="text-attributes">
        <xsl:attribute name="font-family">Times</xsl:attribute>
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="font-style">normal</xsl:attribute>
        <xsl:attribute name="text-decoration">none</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-bold-attributes" use-attribute-sets="text-attributes">
        <xsl:attribute name="font-weight">bold</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-italic-attributes" use-attribute-sets="text-attributes">
        <xsl:attribute name="font-style">italic</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-alignright-attributes" use-attribute-sets="text-attributes">
        <xsl:attribute name="text-align">right</xsl:attribute>
        <!--<xsl:attribute name="border-right">2mm</xsl:attribute>-->
    </xsl:attribute-set>

    <xsl:attribute-set name="text-aligncenter-attributes" use-attribute-sets="text-attributes">
        <xsl:attribute name="text-align">center</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="leader-attributes" use-attribute-sets="text-attributes">
        <xsl:attribute name="leader-alignment">page</xsl:attribute>
        <xsl:attribute name="leader-pattern">rule</xsl:attribute>
        <xsl:attribute name="rule-thickness">0.05mm</xsl:attribute>
        <xsl:attribute name="leader-length">100%</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="leader-total-attributes" use-attribute-sets="leader-attributes">
        <xsl:attribute name="rule-thickness">0.7mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="title-attributes" use-attribute-sets="text-bold-attributes">
        <xsl:attribute name="font-size">14pt</xsl:attribute>
        <xsl:attribute name="margin-top">10mm</xsl:attribute>
        <xsl:attribute name="margin-bottom">5mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="title-warning-attributes" use-attribute-sets="title-attributes">
        <xsl:attribute name="background-color">#ff0000</xsl:attribute>
        <xsl:attribute name="font-size">13pt</xsl:attribute>
        <xsl:attribute name="margin-top">10mm</xsl:attribute>
        <xsl:attribute name="margin-bottom">5mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="subtitle-attributes" use-attribute-sets="text-bold-attributes">
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="margin-top">10mm</xsl:attribute>
        <xsl:attribute name="margin-bottom">5mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-warning-attributes" use-attribute-sets="text-attributes">
        <xsl:attribute name="background-color">#ff9966</xsl:attribute>
        <xsl:attribute name="padding-top">1mm</xsl:attribute>
        <xsl:attribute name="padding-bottom">1mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-footer-attributes" use-attribute-sets="text-attributes">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="table-attributes">
        <xsl:attribute name="table-omit-footer-at-break">true</xsl:attribute>
        <xsl:attribute name="table-layout">fixed</xsl:attribute>
        <xsl:attribute name="width">100%</xsl:attribute>

    </xsl:attribute-set>

    <xsl:attribute-set name="list-attributes">
        <xsl:attribute name="margin-bottom">1mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="border-header-attributes">
        <xsl:attribute name="border-top-style">solid</xsl:attribute>
        <xsl:attribute name="border-left-style">solid</xsl:attribute>
        <xsl:attribute name="border-right-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">thin</xsl:attribute>
        <xsl:attribute name="margin">1mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="table-body-attributes">
        <xsl:attribute name="border-left-style">solid</xsl:attribute>
        <xsl:attribute name="border-left-color">lightgrey</xsl:attribute>
        <xsl:attribute name="border-right-style">solid</xsl:attribute>
        <xsl:attribute name="border-right-color">lightgrey</xsl:attribute>
        <xsl:attribute name="border-width">thin</xsl:attribute>
        <xsl:attribute name="padding-left">1mm</xsl:attribute>
        <xsl:attribute name="padding-right">1mm</xsl:attribute>
        <xsl:attribute name="padding-bottom">-2mm</xsl:attribute>
        <!-- entspricht den beiden paddings von table-footer-attributes -->
    </xsl:attribute-set>

    <xsl:attribute-set name="linespacing-attributes">
        <xsl:attribute name="line-height">4.5mm</xsl:attribute>
        <xsl:attribute name="padding-top">2mm</xsl:attribute>
        <xsl:attribute name="padding-left">1mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="table-header-attributes" use-attribute-sets="table-body-attributes">
        <xsl:attribute name="padding-top">1mm</xsl:attribute>
        <xsl:attribute name="padding-bottom">1mm</xsl:attribute>
        <xsl:attribute name="background-color">lightgrey</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="table-footer-attributes" use-attribute-sets="table-header-attributes">
        <xsl:attribute name="space-before">-1mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="table-footer-summary-attributes"
                       use-attribute-sets="table-body-attributes">
        <xsl:attribute name="padding-bottom">1mm</xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
        <xsl:attribute name="border-bottom-color">lightgrey</xsl:attribute>
        <xsl:attribute name="space-before">5mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="border-bottom-attributes">
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
        <xsl:attribute name="border-bottom-color">lightgrey</xsl:attribute>
        <xsl:attribute name="border-width">thin</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-table-header" use-attribute-sets="text-bold-attributes">
        <xsl:attribute name="margin-top">1mm</xsl:attribute>
        <xsl:attribute name="margin-bottom">1mm</xsl:attribute>
        <xsl:attribute name="background-color">lightgrey</xsl:attribute>
        <xsl:attribute name="line-height">4.5mm</xsl:attribute>
        <!-- Workaround: rechtsbündige Texte werden durch die nachfolgende Zelle um 1 Pixel überdeckt -->
        <xsl:attribute name="padding-left">-0.1mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-footer-summary">
        <xsl:attribute name="padding-left">-0.2mm</xsl:attribute>
        <xsl:attribute name="padding-right">1mm</xsl:attribute>
        <xsl:attribute name="padding-top">1mm</xsl:attribute>
        <xsl:attribute name="padding-bottom">1mm</xsl:attribute>
        <xsl:attribute name="background-color">lightgrey</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="text-cell-header" use-attribute-sets="text-table-header">
        <xsl:attribute name="padding-left">-0.2mm</xsl:attribute>
        <!--     <xsl:attribute name="padding-top">1mm</xsl:attribute>
       <xsl:attribute name="padding-bottom">1mm</xsl:attribute>-->
    </xsl:attribute-set>

    <xsl:attribute-set name="spacer-before">
        <xsl:attribute name="space-before">3mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="padding-top">
        <xsl:attribute name="padding-top">3mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="margin-left">
        <xsl:attribute name="margin-left">2mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="spacer-after">
        <xsl:attribute name="padding-bottom">3mm</xsl:attribute>
    </xsl:attribute-set>


</xsl:stylesheet>
