<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


    <!-- Standard decimal format for swiss numbers. Empty numbers are shown as empty. -->
    <xsl:decimal-format grouping-separator="'" decimal-separator="." NaN=""/>
    <!-- Format string to use for integers -->
    <xsl:variable name="integer-format">###'###'###'###</xsl:variable>
    <!-- Format string to use for amounts including cents -->
    <xsl:variable name="cents-format">###'###'###'##0.00</xsl:variable>
    <!-- Format string to use for percentages. % sign is not added -->
    <xsl:variable name="percent-format">###.####</xsl:variable>

    <!-- Page margins -->
    <xsl:variable name="page-margins">5mm 5mm 5mm 5mm</xsl:variable>
    <xsl:variable name="first-header-height">0mm</xsl:variable>
    <xsl:variable name="header-height">11mm</xsl:variable>
    <xsl:variable name="footer-height">8mm</xsl:variable>
    <xsl:variable name="first-body-top-margin">0mm</xsl:variable>
    <xsl:variable name="body-top-margin">0mm</xsl:variable>
    <xsl:variable name="body-top-margin-test">11mm</xsl:variable>
    <xsl:variable name="body-bottom-margin">12mm</xsl:variable>

    <!-- Some standard definitions for the layout of data blocks in PDF message layout -->
    <!-- White space between data blocks -->
    <xsl:variable name="space-after-blocks">2mm</xsl:variable>              <!-- 6mm -->
    <!-- Font to use -->
    <xsl:variable name="font-family">Liberation Sans</xsl:variable>

    <!-- Width of the title column (leftmost column of a data block) -->
    <xsl:variable name="title-column-width">34mm</xsl:variable>                 <!-- 38mm -->
    <!-- Width of the description column (second column of a data block) -->
    <xsl:variable name="description-column-width">50mm</xsl:variable>           <!-- 50mm -->
    <xsl:variable name="titleColumnWidthMiddle">34mm</xsl:variable>
    <xsl:variable name="descriptionColumnWidthMiddle">25mm</xsl:variable>
    <xsl:variable name="titleColumnWidthRight">20mm</xsl:variable>
    <xsl:variable name="descriptionColumnWidthRight">10mm</xsl:variable>
    <xsl:variable name="titleColumnWidthC">25mm</xsl:variable>
    <xsl:variable name="descriptionColumnWidthC">90mm</xsl:variable>

    <!-- Colordefinition for grey background -->
    <xsl:variable name="grey-background">#cdcdcd</xsl:variable>

    <!-- ************* Formatting templates *************** -->

    <!--
        Format a date for display in PDF.
        @param value the date to be formatted (as defined in xs:date)
    -->
    <xsl:template name="format-date">
        <xsl:param name="value"/>
        <xsl:param name="yearDigits" select="4"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="string-length($trimmed-value) > 0">
                <xsl:variable name="year" select="substring($trimmed-value, 5 - $yearDigits, $yearDigits)"/>
                <xsl:variable name="month" select="substring($trimmed-value, 6, 2)"/>
                <xsl:variable name="day" select="substring($trimmed-value, 9, 2)"/>
                <xsl:value-of select="$day"/>.<xsl:value-of select="$month"/>.<xsl:value-of select="$year"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!--
    Format a date with time for display in PDF.
    @param value the date to be formatted (as defined in xs:date)
-->
    <xsl:template name="format-datetime">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="string-length($trimmed-value) > 0">
                <xsl:variable name="year" select="substring($trimmed-value, 1, 4)"/>
                <xsl:variable name="month" select="substring($trimmed-value, 6, 2)"/>
                <xsl:variable name="day" select="substring($trimmed-value, 9, 2)"/>
                <xsl:variable name="hour" select="substring($trimmed-value, 12, 2)"/>
                <xsl:variable name="min" select="substring($trimmed-value, 15, 2)"/>
                <xsl:variable name="sec" select="substring($trimmed-value, 18, 2)"/>
                <xsl:value-of select="$day"/>.<xsl:value-of select="$month"/>.<xsl:value-of select="$year"/> / <xsl:value-of select="$hour"/>:<xsl:value-of select="$min"/>:<xsl:value-of select="$sec"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!--
        Format a date with month and year for display in PDF.
        @param value the date to be formatted (YYYY-MM)
    -->
    <xsl:template name="format-month">
        <xsl:param name="value"/>
        <xsl:param name="delimiter" select="'/'"/>
        <xsl:param name="yearDigits" select="2"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="string-length($trimmed-value) > 0">
                <xsl:variable name="year" select="substring($trimmed-value, 5 - $yearDigits, $yearDigits)"/>
                <xsl:variable name="month" select="substring($trimmed-value, 6, 2)"/>
                <xsl:value-of select="$month"/><xsl:value-of select="$delimiter"/><xsl:value-of select="$year"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- ************* Templates specific to PDF message formatting *************** -->

    <xsl:attribute-set name="bold">
        <xsl:attribute name="font-weight">bold</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for header block -->
    <xsl:attribute-set name="header-block">
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="margin-top">1mm</xsl:attribute>
        <xsl:attribute name="margin-left">2mm</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for for the footer -->
    <xsl:attribute-set name="footer">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for information block left column (block title) -->
    <xsl:attribute-set name="main-left-column">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="margin-left">0mm</xsl:attribute>
        <xsl:attribute name="border-top-color">black</xsl:attribute>
        <xsl:attribute name="border-top-width">0.5pt</xsl:attribute>
        <xsl:attribute name="border-top-style">solid</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for information block right column (block contents of fixed size blocks) -->
    <xsl:attribute-set name="main-right-column">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="margin-left">1.5mm</xsl:attribute>
        <xsl:attribute name="border-left-color">black</xsl:attribute>
        <xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
        <xsl:attribute name="border-left-style">solid</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for information block (description column for fixed size blocks) -->
    <xsl:attribute-set name="denom-column">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="margin-left">0mm</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for table header-->
    <xsl:attribute-set name="table-header-row">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="border-bottom-color">black</xsl:attribute>
        <xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for table row -->
    <xsl:attribute-set name="table-row">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for table row -->
    <xsl:attribute-set name="table-main-row">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="border-bottom-color">black</xsl:attribute>
        <xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
        <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for table row -->
    <xsl:attribute-set name="helper-text">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="padding-before">3pt</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for information block (value column) -->
    <xsl:attribute-set name="value-column">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="margin-left">1.5mm</xsl:attribute>
    </xsl:attribute-set>

    <!-- attribute set for information block (value-like description column for dynamic size blocks) -->
    <xsl:attribute-set name="first-value-column">
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="margin-left">1.5mm</xsl:attribute>
        <xsl:attribute name="border-left-color">black</xsl:attribute>
        <xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
        <xsl:attribute name="border-left-style">solid</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="data-table-cell">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="data-table-cell-borderBold">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">1.5pt</xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="data-table-cell-bold">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="text-align">right</xsl:attribute>
        <xsl:attribute name="padding-right">1mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="data-table-cell-bold-Small">
        <xsl:attribute name="font-size">7pt</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="text-align">right</xsl:attribute>
        <xsl:attribute name="padding-right">1mm</xsl:attribute>
    </xsl:attribute-set>
</xsl:stylesheet>