<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
                xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"
                xmlns:sr="http://www.swissdec.ch/resources/sd/20130514/StandardRemarks"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                xmlns:exslt="http://exslt.org/strings"
                version="1.0"
                exclude-result-prefixes="soapenv wsse sr">

    <!--Achtung:-->
    <!--Diese Datei darf nicht automatisch formatiert werden! Durch Zeilenumbrüche können die Abstände ua. in den Adressen-->
    <!--verrissen werden. :-(((((   Anstatt &#160; gibts dann \n + &#160; oder &#160; + \n oder ...-->

    <xsl:output method="xml" encoding="iso-8859-2" indent="yes"/>

    <xsl:param name="filename"/>
    <xsl:param name="sigValue" select="'noCheck'"/>
    <xsl:param name="tempDir" select="'temp/'"/>
    <xsl:param name="companySig"/>
    <xsl:param name="issuerSig"/>
    <xsl:param name="ownerSig"/>
    <xsl:param name="fromPerson" select="'1'"/>
    <xsl:param name="toPerson" select="'30000'"/>
    <xsl:param name="alignment" select="'right'"/>
    <xsl:param name="verbose" select="'false'"/>
    <xsl:param name="lastPage" select="'false'"/>
    <xsl:param name="cantonLangFile" select="'./CantonLangMap-all-fr.xml'"/>
    <xsl:param name="standardRemarksFile" select="'./StandardRemarks.xml'"/>
    <xsl:param name="labelTexteFile" select="'./TaxLabelTexte.xml'"/>
    <xsl:param name="labelTxt_it" select="'true'"/>

    <!-- Images -->
    <!-- no default values because the default-images are placed inside a Jar-Archive -->
    <xsl:param name="backgroundImage" select="'./images/empty.jpg'"/>
    <xsl:param name="Arrow" select="'./images/pfeil_8.jpg'"/>
    <xsl:param name="SigOK"/>
    <xsl:param name="SigBroken"/>
    <xsl:param name="SigNotChecked" select="'./images/SigNoCheck.jpg'"/>
    <xsl:param name="SignatureMissing"/>
    <xsl:param name="Generator" select="'Viewgen'"/>
    <xsl:param name="Version" select="''"/>

    <xsl:param name="BarcodePrefix" select="'bcdImage'"/>
    <xsl:param name="BarcodeFormat" select="'png'"/>
    <xsl:param name="CantonOnly" select="''"/>
    <xsl:param name="showBarcode" select="'false'"/>
    <xsl:param name="language" select="'fr'"/>

    <!-- VERSION TaxAccountingForm -->
    <xsl:variable name="TaxAccountingFormXslVersion" select="20211101"/>

    <!-- switches true or false -->
    <xsl:variable name="checkTotals" select="'false'"/>

    <xsl:key name="stdr-key" match="sr:stdr" use="sr:ziffer"/>
    <xsl:variable name="stdr-var" select="document($standardRemarksFile)//sr:StandardRemarks"/>

    <!-- Labeltexte -->
    <xsl:key name="ltxt-key" match="ltxt" use="ziffer"/>
    <xsl:variable name="ltxt-var" select="document($labelTexteFile)//LabelTexte"/>

<!--    <xsl:if test="$Generator = 'Viewgen.NET'">-->
<!--        <xsl:include href="Xsl/exslt/str.split.template.xsl"/>-->
<!--    </xsl:if>-->
    <xsl:include href="str.split.template.xsl"/>

    <!-- Formatting Attributes -->
    <xsl:attribute-set name="inputCell">
        <xsl:attribute name="text-indent">1mm</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-color">#888888</xsl:attribute>
        <xsl:attribute name="border-width">0.1mm</xsl:attribute>
        <xsl:attribute name="display-align">center</xsl:attribute>
        <xsl:attribute name="font-family">Courier</xsl:attribute>
        <xsl:attribute name="font-size">3mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="inputCellSmall">
        <xsl:attribute name="text-indent">1mm</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-color">#888888</xsl:attribute>
        <xsl:attribute name="border-width">0.1mm</xsl:attribute>
        <xsl:attribute name="display-align">center</xsl:attribute>
        <xsl:attribute name="font-family">Courier</xsl:attribute>
        <xsl:attribute name="font-size">2mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="normalText">
        <xsl:attribute name="font-family">Arial</xsl:attribute>
        <xsl:attribute name="font-weight">normal</xsl:attribute>
        <xsl:attribute name="font-style">normal</xsl:attribute>
        <xsl:attribute name="text-decoration">none</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="CHFValue">
        <xsl:attribute name="text-indent">1mm</xsl:attribute>
        <xsl:attribute name="text-align">right</xsl:attribute>
        <xsl:attribute name="end-indent">3mm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:decimal-format name="decFrm1_verbose" decimal-separator="." grouping-separator="&#180;" NaN="(no tag)"/>
    <xsl:decimal-format name="decFrm1" decimal-separator="." grouping-separator="&#180;" NaN=" "/>

    <xsl:variable name="frmPttrn1" select="string('###&#180;###&#180;###&#180;##0.00')"/>

    <xsl:variable name="inputCellHeight" select="'4.5mm'"/>

    <!-- length in ziffer 2 -->
    <xsl:variable name="lengthZ2" select="'83'"/>
    <!-- length in ziffer 3 -->
    <xsl:variable name="lengthZ3" select="'145'"/>
    <!-- length in ziffer 4 -->
    <xsl:variable name="lengthZ4" select="'64'"/>
    <!-- length in ziffer 7 -->
    <xsl:variable name="lengthZ7" select="'110'"/>
    <!-- length in ziffer 13 -->
    <xsl:variable name="lengthZ13" select="'75'"/>
    <!-- length in ziffer 14 -->
    <xsl:variable name="lengthZ14" select="'122'"/>
    <!-- length in ziffer 15 -->
    <xsl:variable name="lengthZ15" select="'162'"/>

    <xsl:variable name="fontProportion" select="'1.82'"/>

    <xsl:variable name="niceformatting" select="'true'"/>

    <xsl:key name="canton-lang" match="sr:canton" use="sr:abbrev"/>

    <xsl:variable name="SignatureCheckInfoImage">
        <xsl:choose>
            <xsl:when test="contains($sigValue, 'correct'  )">
                <xsl:value-of select="$SigOK"/>
            </xsl:when>
            <xsl:when test="contains($sigValue, 'broken'  )">
                <xsl:value-of select="$SigBroken"/>
            </xsl:when>
            <xsl:when test="contains($sigValue, 'noCheck'  )">
                <xsl:value-of select="$SigNotChecked"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$SignatureMissing"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <!--
    Main template that starts the process
    -->
    <xsl:template match="/">

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'[TaxAccountingForm.xsl:Info] start template / ...'"/>
        </xsl:call-template>

        <xsl:apply-templates
                select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration'] | //*[local-name()='DeclareSalaryDeferred']/*[local-name()='SalaryDeclaration']"/>

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'[Info] ... end template /'"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="//*[local-name()='SalaryDeclaration']">
        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'[Info] start template SalaryDeclaration ...'"/>
        </xsl:call-template>
        <fo:root xsl:use-attribute-sets="normalText">
            <fo:layout-master-set>
                <!--Definition der uebrigen Seiten -->
                <fo:simple-page-master master-name="TaxAccountingForm"
                                       page-width="21cm"
                                       page-height="29.7cm"
                                       margin-top="4mm"
                                       margin-bottom="5mm"
                                       margin-left="19.9mm"
                                       margin-right="11.5mm">
                    <!--margin-right="11.8mm">-->

                    <fo:region-body>
                        <xsl:attribute name="margin-top">
                            <xsl:value-of select="'0cm'"/>
                        </xsl:attribute>

                        <xsl:attribute name="margin-bottom">
                            <xsl:value-of select="'0cm'"/>
                        </xsl:attribute>

                        <xsl:attribute name="background-image">
                          <xsl:choose>
                            <xsl:when test="$Generator='Viewgen'">
                              <xsl:value-of select="$backgroundImage"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="concat('file:/',$backgroundImage)"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:attribute>

                        <xsl:attribute name="background-repeat">
                            <xsl:value-of select="'no-repeat'"/>
                        </xsl:attribute>

                        <!--<xsl:attribute name="background-position">-->
                        <!--<xsl:value-of select="'center'"/>-->
                        <!--</xsl:attribute>-->
                    </fo:region-body>
                    <fo:region-before region-name="Corner" extent="0mm"/>
                </fo:simple-page-master>
            </fo:layout-master-set>

            <xsl:apply-templates select="*[local-name()='Company']/*[local-name()='Staff']/*[local-name()='Person']">
                <xsl:with-param name="AccountingPeriod">
                    <xsl:value-of
                            select="*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='AccountingPeriod']"/>
                </xsl:with-param>
                <xsl:with-param name="posi">
                    <xsl:value-of select="position()"/>
                </xsl:with-param>
            </xsl:apply-templates>

            <xsl:if test="$lastPage='true'">
                <xsl:call-template name="endPage"/>
            </xsl:if>

        </fo:root>
    </xsl:template>

    <xsl:template match="sr:StandardRemarks">
        <xsl:param name="lang"/>
        <xsl:param name="key"/>
        <xsl:value-of select="key('stdr-key', $key)/sr:value[@lang=$lang]"/>
    </xsl:template>

    <xsl:template match="sr:cantonlang">
        <xsl:param name="canton"/>
        <xsl:value-of select="key('canton-lang', $canton)/sr:language"/>
    </xsl:template>

    <xsl:template match="LabelTexte">
        <xsl:param name="lang"/>
        <xsl:param name="key"/>
        <xsl:value-of select="key('ltxt-key', $key)/value[@lang=$lang]"/>
    </xsl:template>

    <!--
    ****************************************************************************************************************
    steuerung der verarbeitung ueber person
    ****************************************************************************************************************
    -->
    <xsl:template match="*[local-name()='Person']">
        <xsl:param name="AccountingPeriod"/>

        <!-- Sprachauswahl -->
        <xsl:variable name="lang">
            <xsl:choose>
                <xsl:when test="*[local-name()='Particulars']/*[local-name()='LanguageCode'] != ''">
                    <xsl:value-of select="*[local-name()='Particulars']/*[local-name()='LanguageCode']"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="cantons" select="document($cantonLangFile)//sr:cantonlang"/>
                    <xsl:apply-templates select="$cantons">
                        <xsl:with-param name="canton"
                                        select="*[local-name()='Particulars']/*[local-name()='ResidenceCanton']"/>
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="language">
            <xsl:choose>
                <xsl:when test="$lang='de' or $lang='fr' or $lang='it' or $lang='en'">
                    <xsl:value-of select="$lang"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="'de'"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="SignatureCheckInfo">
            <xsl:call-template name="getSignatureCheckResult">
                <xsl:with-param name="language" select="$language"/>
            </xsl:call-template>
            <!--            </xsl:if> -->
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="string-length($CantonOnly) &gt; 0">
                <xsl:if test="(position() &gt;= number($fromPerson)) and ( position() &lt;= number($toPerson)) and (count(child::*[local-name()='TaxSalaries']/*[local-name()='TaxSalary']) > 0 or count(child::*[local-name()='TaxSalaries']/*[local-name()='TaxAnnuity']) > 0) and (*[local-name()='Particulars']/*[local-name()='ResidenceCanton']=$CantonOnly)">

                    <!--<xsl:variable name="counter" select="number($fromPerson + position() - 1)"/>-->
                    <xsl:variable name="counter" select="position()"/>

                    <xsl:variable name="TaxAnnuityIsLast"
                                  select="count(*[local-name()='TaxSalaries']/*[local-name()='TaxSalary'])=0"/>
                    <xsl:apply-templates select="*[local-name()='TaxSalaries']/*[local-name()='TaxAnnuity']">
                        <xsl:with-param name="AccountingPeriod">
                            <xsl:value-of select="$AccountingPeriod"/>
                        </xsl:with-param>
                        <xsl:with-param name="IsLastPerson" select="position()=last() and $TaxAnnuityIsLast"/>
                        <xsl:with-param name="TaxSalaryAnnuityID">
                            <xsl:value-of select="concat('TaxAnnuity',position())"/>
                        </xsl:with-param>
                        <xsl:with-param name="counter" select="$counter"/>
                        <xsl:with-param name="language" select="$language"/>
                        <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
                        <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
                        <xsl:with-param name="ResidenceCanton" select="*[local-name()='Particulars']/*[local-name()='ResidenceCanton']"/>
                    </xsl:apply-templates>
                    <xsl:apply-templates select="*[local-name()='TaxSalaries']/*[local-name()='TaxSalary']">
                        <xsl:with-param name="AccountingPeriod">
                            <xsl:value-of select="$AccountingPeriod"/>
                        </xsl:with-param>
                        <xsl:with-param name="IsLastPerson" select="position()=last()"/>
                        <xsl:with-param name="TaxSalaryAnnuityID">
                            <xsl:value-of select="concat('TaxSalary',position())"/>
                        </xsl:with-param>
                        <xsl:with-param name="counter" select="$counter"/>
                        <xsl:with-param name="language" select="$language"/>
                        <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
                        <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
                        <xsl:with-param name="ResidenceCanton" select="*[local-name()='Particulars']/*[local-name()='ResidenceCanton']"/>
                    </xsl:apply-templates>

                </xsl:if>

            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="(position() &gt;= number($fromPerson)) and ( position() &lt;= number($toPerson)) and (count(child::*[local-name()='TaxSalaries']/*[local-name()='TaxSalary']) > 0 or count(child::*[local-name()='TaxSalaries']/*[local-name()='TaxAnnuity']) > 0)">

                    <!--<xsl:variable name="counter" select="number($fromPerson + position() - 1)"/>-->
                    <xsl:variable name="counter" select="position()"/>

                    <xsl:variable name="TaxAnnuityIsLast"
                                  select="count(*[local-name()='TaxSalaries']/*[local-name()='TaxSalary'])=0"/>
                    <xsl:apply-templates select="*[local-name()='TaxSalaries']/*[local-name()='TaxAnnuity']">
                        <xsl:with-param name="AccountingPeriod">
                            <xsl:value-of select="$AccountingPeriod"/>
                        </xsl:with-param>
                        <xsl:with-param name="IsLastPerson" select="position()=last() and $TaxAnnuityIsLast"/>
                        <xsl:with-param name="TaxSalaryAnnuityID">
                            <xsl:value-of select="concat('TaxAnnuity',position())"/>
                        </xsl:with-param>
                        <xsl:with-param name="counter" select="$counter"/>
                        <xsl:with-param name="language" select="$language"/>
                        <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
                        <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
                        <xsl:with-param name="ResidenceCanton" select="*[local-name()='Particulars']/*[local-name()='ResidenceCanton']"/>
                    </xsl:apply-templates>
                    <xsl:apply-templates select="*[local-name()='TaxSalaries']/*[local-name()='TaxSalary']">
                        <xsl:with-param name="AccountingPeriod">
                            <xsl:value-of select="$AccountingPeriod"/>
                        </xsl:with-param>
                        <xsl:with-param name="IsLastPerson" select="position()=last()"/>
                        <xsl:with-param name="TaxSalaryAnnuityID">
                            <xsl:value-of select="concat('TaxSalary',position())"/>
                        </xsl:with-param>
                        <xsl:with-param name="counter" select="$counter"/>
                        <xsl:with-param name="language" select="$language"/>
                        <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
                        <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
                        <xsl:with-param name="ResidenceCanton" select="*[local-name()='Particulars']/*[local-name()='ResidenceCanton']"/>
                    </xsl:apply-templates>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!--
    ****************************************************************************************************************
    eigentliche aufbereitung
    ****************************************************************************************************************
    -->

    <xsl:template match="*[local-name()='TaxSalary']">
        <xsl:param name="AccountingPeriod"/>
        <xsl:param name="IsLastPerson"/>
        <xsl:param name="TaxSalaryAnnuityID"/>
        <xsl:param name="counter"/>
        <xsl:param name="language"/>
        <xsl:param name="SignatureCheckInfo"/>
        <xsl:param name="SignatureCheckInfoImage"/>
        <xsl:param name="ResidenceCanton"/>

        <fo:page-sequence master-reference="TaxAccountingForm" force-page-count="no-force">
            <fo:static-content flow-name="Corner">
                <xsl:call-template name="getCorner"/>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body" font-size="8pt">

                <xsl:variable name="taxCounter" select="number(position())"/>

                <xsl:call-template name="processing">
                    <xsl:with-param name="AccountingPeriod" select="$AccountingPeriod"/>
                    <xsl:with-param name="IsLastPerson" select="$IsLastPerson"/>
                    <xsl:with-param name="TaxSalaryAnnuityID" select="$TaxSalaryAnnuityID"/>
                    <xsl:with-param name="counter" select="$counter"/>
                    <xsl:with-param name="taxCounter" select="$taxCounter"/>
                    <xsl:with-param name="language" select="$language"/>
                    <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
                    <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
                    <xsl:with-param name="ResidenceCanton" select="$ResidenceCanton"/>
                </xsl:call-template>
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>

    <xsl:template match="*[local-name()='TaxAnnuity']">
        <xsl:param name="AccountingPeriod"/>
        <xsl:param name="IsLastPerson"/>
        <xsl:param name="TaxSalaryAnnuityID"/>
        <xsl:param name="counter"/>
        <xsl:param name="language"/>
        <xsl:param name="SignatureCheckInfo"/>
        <xsl:param name="SignatureCheckInfoImage"/>
        <xsl:param name="ResidenceCanton"/>

        <fo:page-sequence master-reference="TaxAccountingForm" force-page-count="no-force">
            <fo:static-content flow-name="Corner">
                <xsl:call-template name="getCorner"/>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body" font-size="8pt">

                <xsl:variable name="annuityCounter" select="number(position())"/>

                <xsl:call-template name="processing">
                    <xsl:with-param name="AccountingPeriod" select="$AccountingPeriod"/>
                    <xsl:with-param name="IsLastPerson" select="$IsLastPerson"/>
                    <xsl:with-param name="TaxSalaryAnnuityID" select="$TaxSalaryAnnuityID"/>
                    <xsl:with-param name="counter" select="$counter"/>
                    <xsl:with-param name="annuityCounter" select="$annuityCounter"/>
                    <xsl:with-param name="language" select="$language"/>
                    <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
                    <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
                    <xsl:with-param name="ResidenceCanton" select="$ResidenceCanton"/>
                </xsl:call-template>
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>

    <xsl:template name="processing">
        <xsl:param name="AccountingPeriod"/>
        <xsl:param name="IsLastPerson"/>
        <xsl:param name="TaxSalaryAnnuityID"/>
        <xsl:param name="counter"/>
        <xsl:param name="taxCounter" select="0"/>
        <xsl:param name="annuityCounter" select="0"/>
        <xsl:param name="language" select="de"/>
        <xsl:param name="SignatureCheckInfo"/>
        <xsl:param name="SignatureCheckInfoImage"/>
        <xsl:param name="ResidenceCanton"/>

        <!-- TaxDisclosure/ChargesRule/WithRegulation -->
        <xsl:variable name="txtRz65T1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz65T1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtRz65T2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz65T2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtRz65T3">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz65T3"/>
            </xsl:apply-templates>
        </xsl:variable>

        <xsl:variable name="txtRz66ST1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz66ST1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtRz66ST2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz66ST2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtRz66AT1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz66AT1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtRz66AT2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz66AT2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <!-- Staff/Person/ActivityRate -->
        <xsl:variable name="txtRz67T1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz67T1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtRz67T2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz67T2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <!-- TaxDisclosure/StaffShareMarketValue -->
        <xsl:variable name="txtRz68T1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz68T1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <!-- TaxDisclosure/StaffShareWithoutTaxableIncome -->
        <xsl:variable name="txtRz69T1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtRz69T1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <!-- TaxSalary/Standardremark  -->
        <xsl:variable name="txtZ15StdStaffShareThirdCompanyV1T1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdStaffShareThirdCompanyV1T1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdStaffShareThirdCompanyV1T2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdStaffShareThirdCompanyV1T2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdStaffShareThirdCompanyV2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdStaffShareThirdCompanyV2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdChildAllowancePerAHV-AVS">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdChildAllowancePerAHV-AVS"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdRelocationCostsT1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdRelocationCostsT1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdRelocationCostsT2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdRelocationCostsT2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdStaffShareMarketValueT1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdStaffShareMarketValueT1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdStaffShareMarketValueT2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdStaffShareMarketValueT2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdStaffShareMarketValueT3">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdStaffShareMarketValueT3"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdStaffShareWithoutTaxableIncome">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdStaffShareWithoutTaxableIncome"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdPrivatePartCompanyCarT1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdPrivatePartCompanyCarT1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdPrivatePartCompanyCarT2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdPrivatePartCompanyCarT2"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdPrivatePartCompanyCarT3">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdPrivatePartCompanyCarT3"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15StdCompanyCarClarify">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15StdCompanyCarClarify"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15MinimalEmployeeCarPartPercentage">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15MinimalEmployeeCarPartPercentage"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15TaxAtSourcePeriodForObjection_1">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15TaxAtSourcePeriodForObjection_1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtZ15TaxAtSourcePeriodForObjection_2">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="txtZ15TaxAtSourcePeriodForObjection_2"/>
            </xsl:apply-templates>
        </xsl:variable>


        <!--****************************************************************************************************************-->
        <!--calculate  varaiables-->
        <!--****************************************************************************************************************-->

        <xsl:variable name="ziffer1Path" select="./*[local-name()='Income']"/>
        <xsl:variable name="ziffer1">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer1Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer1Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer1_n" select="number($ziffer1Path)"/>

        <xsl:variable name="ziffer2.1Path" select="./*[local-name()='FringeBenefits']/*[local-name()='FoodLodging']"/>
        <xsl:variable name="ziffer2.1">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer2.1Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer2.1Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer2.1_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer2.1Path"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer2.2Path" select="./*[local-name()='FringeBenefits']/*[local-name()='CompanyCar']"/>
        <xsl:variable name="ziffer2.2">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer2.2Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer2.2Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer2.2_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer2.2Path"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer2.3Path"
                      select="./*[local-name()='FringeBenefits']/*[local-name()='Other']/*[local-name()='Sum']"/>
        <xsl:variable name="ziffer2.3">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer2.3Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer2.3Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer2.3_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer2.3Path"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="ziffer2.3Txt"
                      select="./*[local-name()='FringeBenefits']/*[local-name()='Other']/*[local-name()='Text']"/>
        <xsl:variable name="ziffer2.3Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer2.3Txt) &lt;= floor($lengthZ2 div $fontProportion)">
                    <xsl:value-of select="$ziffer2.3Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer2.3Txt, 1, floor($lengthZ2 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer2.3Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer2.3Txt) &lt;= floor($lengthZ2 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                    <xsl:value-of
                        select="concat('...',substring($ziffer2.3Txt, floor($lengthZ2 div $fontProportion)-2))"/>
                    -->
                    <xsl:value-of select="$ziffer2.3Txt"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="ziffer3Path" select="./*[local-name()='SporadicBenefits']/*[local-name()='Sum']"/>
        <xsl:variable name="ziffer3">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer3Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer3Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer3_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer3Path"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="ziffer3Txt" select="./*[local-name()='SporadicBenefits']/*[local-name()='Text']"/>
        <xsl:variable name="ziffer3Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer3Txt) &lt;= floor($lengthZ3 div $fontProportion)">
                    <xsl:value-of select="$ziffer3Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer3Txt, 1, floor($lengthZ3 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer3Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer3Txt) &lt;= floor($lengthZ3 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                    <xsl:value-of
                            select="concat('...',substring($ziffer3Txt, floor($lengthZ3 div $fontProportion)-2))"/>
                    -->
                    <xsl:value-of select="$ziffer3Txt"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="ziffer4Path" select="./*[local-name()='CapitalPayment']/*[local-name()='Sum']"/>
        <xsl:variable name="ziffer4">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer4Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer4Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer4_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer4Path"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="ziffer4Txt" select="./*[local-name()='CapitalPayment']/*[local-name()='Text']"/>
        <xsl:variable name="ziffer4Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer4Txt) &lt;= floor($lengthZ4 div $fontProportion)">
                    <xsl:value-of select="$ziffer4Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer4Txt, 1, floor($lengthZ4 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer4Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer4Txt) &lt;= floor($lengthZ4 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>

                    <!--
                    <xsl:value-of
                            select="concat('...',substring($ziffer4Txt, floor($lengthZ4 div $fontProportion)-2))"/>
                    -->
                    <xsl:value-of select="$ziffer4Txt"/>
                </xsl:otherwise>

            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="ziffer5Path" select="./*[local-name()='OwnershipRight']"/>
        <xsl:variable name="ziffer5">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer5Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer5Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer5_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer5Path"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer6Path" select="./*[local-name()='BoardOfDirectorsRemuneration']"/>
        <xsl:variable name="ziffer6">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer6Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer6Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer6_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer6Path"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer7Path" select="./*[local-name()='OtherBenefits']/*[local-name()='Sum']"/>
        <xsl:variable name="ziffer7">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer7Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer7Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer7_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer7Path"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="ziffer7Txt" select="./*[local-name()='OtherBenefits']/*[local-name()='Text']"/>
        <xsl:variable name="ziffer7Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer7Txt) &lt;= floor($lengthZ7 div $fontProportion)">
                    <xsl:value-of select="$ziffer7Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer7Txt, 1, floor($lengthZ7 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer7Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer7Txt) &lt;= floor($lengthZ7 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                    <xsl:value-of
                            select="concat('...',substring($ziffer7Txt, floor($lengthZ7 div $fontProportion)-2))"/>
                    -->
                    <xsl:value-of select="$ziffer7Txt"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!-- neu aus instanzdokument -->

        <xsl:variable name="ziffer8Path" select="./*[local-name()='GrossIncome']"/>
        <xsl:variable name="ziffer8_n" select="number($ziffer8Path)"/>
        <xsl:variable name="ziffer8_n_ctrl" select="number(
        $ziffer1_n
        +$ziffer2.1_n
        +$ziffer2.2_n
        +$ziffer2.3_n
        +$ziffer3_n
        +$ziffer4_n
        +$ziffer5_n
        +$ziffer6_n
        +$ziffer7_n
        )"/>
        <xsl:variable name="ziffer8ctrlMsg">
            <xsl:call-template name="getCheckSum">
                <xsl:with-param name="ValueInstance" select="$ziffer8_n"/>
                <xsl:with-param name="ValueCalculate" select="$ziffer8_n_ctrl"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="ziffer8">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="concat(
        format-number($ziffer8Path, $frmPttrn1, 'decFrm1_verbose'), $ziffer8ctrlMsg)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat(
        format-number($ziffer8Path, $frmPttrn1, 'decFrm1'), $ziffer8ctrlMsg)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="ziffer9Path" select="./*[local-name()='AHV-ALV-NBUV-AVS-AC-AANP-Contribution']"/>
        <xsl:variable name="ziffer9">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer9Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer9Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer9_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer9Path"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer10.1Path"
                      select="./*[local-name()='BVG-LPP-Contribution']/*[local-name()='Regular']"/>
        <xsl:variable name="ziffer10.1">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer10.1Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer10.1Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer10.1_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer10.1Path"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer10.2Path"
                      select="./*[local-name()='BVG-LPP-Contribution']/*[local-name()='Purchase']"/>
        <xsl:variable name="ziffer10.2">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="format-number($ziffer10.2Path, $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number($ziffer10.2Path, $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer10.2_n">
            <xsl:call-template name="getNumberValue">
                <xsl:with-param name="zifferPath" select="$ziffer10.2Path"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer11Path" select="./*[local-name()='NetIncome']"/>
        <xsl:variable name="ziffer11_n" select="number($ziffer11Path)"/>
        <xsl:variable name="ziffer11_n_ctrl" select="number(
        $ziffer8_n
        -$ziffer9_n
        -$ziffer10.1_n
        -$ziffer10.2_n
        )"/>
        <xsl:variable name="ziffer11ctrlMsg">
            <xsl:call-template name="getCheckSum">
                <xsl:with-param name="ValueInstance" select="$ziffer11_n"/>
                <xsl:with-param name="ValueCalculate" select="$ziffer11_n_ctrl"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="ziffer11">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of select="concat(
        format-number(number($ziffer11_n), $frmPttrn1, 'decFrm1_verbose'), $ziffer11ctrlMsg )"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat(
        format-number(number($ziffer11_n), $frmPttrn1, 'decFrm1'), $ziffer11ctrlMsg )"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="ziffer12">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of
                            select="format-number(./*[local-name()='DeductionAtSource'], $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number(./*[local-name()='DeductionAtSource'], $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.1.1">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='Effective']/*[local-name()='TravelFoodAccommodation'], $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='Effective']/*[local-name()='TravelFoodAccommodation'], $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.1.2">
            <xsl:choose>
                <!-- mod by mgi 27.7.06 -->
                <xsl:when
                        test="$verbose='true' and count(./*[local-name()='ChargesRule']/*[local-name()='WithRegulation'])=1">
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='Effective']/*[local-name()='Other']/*[local-name()='Sum'], $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='Effective']/*[local-name()='Other']/*[local-name()='Sum'], $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.1.2Txt"
                      select="./*[local-name()='Charges']/*[local-name()='Effective']/*[local-name()='Other']/*[local-name()='Text']"/>
        <xsl:variable name="ziffer13.1.2Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer13.1.2Txt) &lt;= floor($lengthZ13 div $fontProportion)">
                    <xsl:value-of select="$ziffer13.1.2Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer13.1.2Txt, 1, floor($lengthZ13 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.1.2Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer13.1.2Txt) &lt;= floor($lengthZ13 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                    <xsl:value-of
                            select="concat('...',substring($ziffer13.1.2Txt, floor($lengthZ13 div $fontProportion)-2))"/>
                    -->
                    <xsl:value-of select="$ziffer13.1.2Txt"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="ziffer13.2.1">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='LumpSum']/*[local-name()='Representation'], $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='LumpSum']/*[local-name()='Representation'], $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.2.2">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='LumpSum']/*[local-name()='Car'], $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='LumpSum']/*[local-name()='Car'], $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.2.3">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='LumpSum']/*[local-name()='Other']/*[local-name()='Sum'], $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='LumpSum']/*[local-name()='Other']/*[local-name()='Sum'], $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.2.3Txt"
                      select="./*[local-name()='Charges']/*[local-name()='LumpSum']/*[local-name()='Other']/*[local-name()='Text']"/>
        <xsl:variable name="ziffer13.2.3Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer13.2.3Txt) &lt;= floor($lengthZ13 div $fontProportion)">
                    <xsl:value-of select="$ziffer13.2.3Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer13.2.3Txt, 1, floor($lengthZ13 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer13.2.3Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer13.2.3Txt) &lt;= floor($lengthZ13 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                    <xsl:value-of
                            select="concat('...',substring($ziffer13.2.3Txt, floor($lengthZ13 div $fontProportion)-2))"/>
                    -->
                    <xsl:value-of select="$ziffer13.2.3Txt"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="ziffer13.3">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='Education'], $frmPttrn1, 'decFrm1_verbose')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of
                            select="format-number(./*[local-name()='Charges']/*[local-name()='Education'], $frmPttrn1, 'decFrm1')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!-- ziffer 14 -->
        <xsl:variable name="ziffer14Txt" select="normalize-space(./*[local-name()='OtherFringeBenefits'])"/>

        <xsl:variable name="ziffer14Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer14Txt) &lt;= floor($lengthZ14 div $fontProportion)">
                    <xsl:value-of select="$ziffer14Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer14Txt, 1, floor($lengthZ14 div $fontProportion))"/>
                    <xsl:call-template name="printLine2">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer14Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer14Txt) &lt;= floor($lengthZ14 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:when
                        test="string-length(substring($ziffer14Txt, string-length($ziffer14Txt_1)+1)) &lt; floor($lengthZ14 div $fontProportion)">
                    <xsl:value-of select="substring($ziffer14Txt, string-length($ziffer14Txt_1)+1)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer14Txt, string-length($ziffer14Txt_1)+1, floor($lengthZ14 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer14Txt_3">
            <xsl:choose>
                <xsl:when test="string-length($ziffer14Txt) &lt;= floor($lengthZ14 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:when
                        test="string-length(substring($ziffer14Txt, string-length($ziffer14Txt_1)+1)) &lt; floor($lengthZ14 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                    <xsl:value-of
                            select="concat('...',substring($ziffer14Txt, 2*floor($lengthZ14 div $fontProportion)-8))"/>
                    -->
                    <xsl:value-of select="$ziffer14Txt"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!-- ziffer 15 -->
        <xsl:variable name="z15Sep" select="','"/>

        <xsl:variable name="ziffer15T1">
            <xsl:if test="( count(./*[local-name()='ChargesRule']/*[local-name()='WithRegulation'])=1 )">
                <xsl:variable name="ziffer15Tmp1">
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="date"
                                        select="./*[local-name()='ChargesRule']/*[local-name()='WithRegulation']/*[local-name()='Allowed']"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:variable name="ziffer15Tmp2"
                              select="./*[local-name()='ChargesRule']/*[local-name()='WithRegulation']/*[local-name()='Canton']"/>
                <xsl:choose>
                    <xsl:when test="$txtRz65T3 = '.'">     <!-- Bei einem Punkt brauchen wir keinen Abstand -->
                        <xsl:value-of select="concat($txtRz65T1, ' ', $ziffer15Tmp2, ' ', $txtRz65T2, ' ', $ziffer15Tmp1, $txtRz65T3)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($txtRz65T1, ' ', $ziffer15Tmp2, ' ', $txtRz65T2, ' ', $ziffer15Tmp1, ' ', $txtRz65T3)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T2">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='StaffShareMarketValue'])=1 )">
                <xsl:variable name="ziffer15Tmp1">
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="date"
                                        select="./*[local-name()='StandardRemark']/*[local-name()='StaffShareMarketValue']/*[local-name()='Allowed']"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:variable name="ziffer15Tmp2"
                              select="./*[local-name()='StandardRemark']/*[local-name()='StaffShareMarketValue']/*[local-name()='Canton']"/>
                <xsl:choose>
                    <xsl:when test="$txtZ15StdStaffShareMarketValueT3 = '.'">
                        <xsl:value-of select="concat($txtZ15StdStaffShareMarketValueT1, ' ', $ziffer15Tmp2, ' ',
                                    $txtZ15StdStaffShareMarketValueT2, ' ', $ziffer15Tmp1, $txtZ15StdStaffShareMarketValueT3)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($txtZ15StdStaffShareMarketValueT1, ' ', $ziffer15Tmp2, ' ',
                                    $txtZ15StdStaffShareMarketValueT2, ' ', $ziffer15Tmp1,' ', $txtZ15StdStaffShareMarketValueT3)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T3">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='StaffShareWithoutTaxableIncome'])=1 )">
                <xsl:value-of select="concat(
                    $txtZ15StdStaffShareWithoutTaxableIncome, ' ', ./*[local-name()='StandardRemark']/*[local-name()='StaffShareWithoutTaxableIncome'], ' ')"/>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T5">
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    &lt;REMARK&gt;
                    <xsl:value-of select="concat(./*[local-name()='Remark'], ' ')"/>
                    &lt;REMARK&gt;
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat(./*[local-name()='Remark'], ' ')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer15T6">
            <xsl:choose>
                <xsl:when test="( $taxCounter &gt; 0 and count(../*[local-name()='TaxSalary']) &gt; 1 )">
                    <xsl:value-of select="concat($txtRz66ST1, ' ', position(), ' ', $txtRz66ST2, ' ', last(), '. ')"/>
                </xsl:when>
                <xsl:when test="( $annuityCounter &gt; 0 and count(../*[local-name()='TaxAnnuity']) &gt; 1 )">
                    <xsl:value-of select="concat($txtRz66AT1, ' ', position(), ' ', $txtRz66AT2, ' ', last(), '. ')"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer15T7">
            <xsl:if test="( count(./../../*[local-name()='Work']/*[local-name()='ActivityRate'])=1 )
            and ( number(./../../*[local-name()='Work']/*[local-name()='ActivityRate']) &lt; 100) ">
                <xsl:variable name="ziffer15Tmp1"
                              select="./../../*[local-name()='Work']/*[local-name()='ActivityRate']"/>
                <xsl:choose>
                    <xsl:when test="string-length($txtRz67T1) > 0">
                        <xsl:value-of select="concat($txtRz67T1, ' ', $ziffer15Tmp1, $txtRz67T2)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($txtRz67T1, $ziffer15Tmp1, $txtRz67T2)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T8">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='StaffShareThirdCompany'])=1 )">
                <xsl:choose>
                    <xsl:when
                            test="string-length(./*[local-name()='StandardRemark']/*[local-name()='StaffShareThirdCompany']) > 0">
                        <xsl:value-of select="concat(
                            $txtZ15StdStaffShareThirdCompanyV1T1, ' ', ./*[local-name()='StandardRemark']/*[local-name()='StaffShareThirdCompany'], ' ', $txtZ15StdStaffShareThirdCompanyV1T2)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($txtZ15StdStaffShareThirdCompanyV2, '')"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T9">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='ChildAllowancePerAHV-AVS'])=1 )">
                <xsl:choose>
                    <xsl:when test="( count(./*[local-name()='StandardRemark']/*[local-name()='ChildAllowancePerAHV-AVS']/*[local-name()='FamilyIncome'])=1 )">
                        <xsl:value-of select="concat(
                            $txtZ15StdChildAllowancePerAHV-AVS, ': ', ./*[local-name()='StandardRemark']/*[local-name()='ChildAllowancePerAHV-AVS'], ' CHF. ')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat(
                             $txtZ15StdChildAllowancePerAHV-AVS, '. ', ./*[local-name()='StandardRemark']/*[local-name()='ChildAllowancePerAHV-AVS'],' ')"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T10">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='RelocationCosts'])=1 )">
                <xsl:value-of select="concat(
                    $txtZ15StdRelocationCostsT1, ' ', ./*[local-name()='StandardRemark']/*[local-name()='RelocationCosts'],' ', $txtZ15StdRelocationCostsT2)"/>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T11">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='PrivatePartCompanyCar'])=1 )">
                <xsl:variable name="date">
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="date"
                                        select="./*[local-name()='StandardRemark']/*[local-name()='PrivatePartCompanyCar']/*[local-name()='Allowed']"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="$txtZ15StdPrivatePartCompanyCarT3 = '.'">
                        <xsl:value-of select="concat($txtZ15StdPrivatePartCompanyCarT1, ' ',
                            ./*[local-name()='StandardRemark']/*[local-name()='PrivatePartCompanyCar']/*[local-name()='Canton'],
                            ' ', $txtZ15StdPrivatePartCompanyCarT2, ' ', $date, $txtZ15StdPrivatePartCompanyCarT3)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($txtZ15StdPrivatePartCompanyCarT1, ' ',
                            ./*[local-name()='StandardRemark']/*[local-name()='PrivatePartCompanyCar']/*[local-name()='Canton'],
                            ' ', $txtZ15StdPrivatePartCompanyCarT2, ' ', $date, ' ', $txtZ15StdPrivatePartCompanyCarT3)"/>
                    </xsl:otherwise>
                </xsl:choose>

            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T12">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='CompanyCarClarify'])=1 )">
                <xsl:value-of select="concat(
                    $txtZ15StdCompanyCarClarify, ' ', ./*[local-name()='StandardRemark']/*[local-name()='CompanyCarClarify'], ' ')"/>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T13">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='MinimalEmployeeCarPartPercentage'])=1 )">
                <xsl:value-of select="concat(
                    $txtZ15MinimalEmployeeCarPartPercentage, ' ', ./*[local-name()='StandardRemark']/*[local-name()='MinimalEmployeeCarPartPercentage'], ' ')"/>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="ziffer15T14">
            <xsl:if test="( count(./*[local-name()='StandardRemark']/*[local-name()='TaxAtSourcePeriodForObjection'])=1 )">
                <xsl:value-of select="concat($txtZ15TaxAtSourcePeriodForObjection_1, ' ', $AccountingPeriod + 1, ' ', $txtZ15TaxAtSourcePeriodForObjection_2 )"/>
            </xsl:if>
        </xsl:variable>

        <xsl:variable name="ziffer15Txt" select="normalize-space(
            concat($ziffer15T6, ' ', $ziffer15T1, ' ', $ziffer15T2, ' ', $ziffer15T3, ' ', $ziffer15T7, ' ', $ziffer15T8, ' ', $ziffer15T9, ' ', $ziffer15T10, ' ', $ziffer15T11, ' ', $ziffer15T12, ' ', $ziffer15T13, ' ', $ziffer15T14, ' ', $ziffer15T5))"/>

        <xsl:variable name="ziffer15Txt_1">
            <xsl:choose>
                <xsl:when test="string-length($ziffer15Txt) &lt;= floor($lengthZ15 div $fontProportion)">
                    <xsl:value-of select="$ziffer15Txt"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer15Txt, 1, floor($lengthZ15 div $fontProportion))"/>
                    <xsl:call-template name="printLine2">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer15Txt_2">
            <xsl:choose>
                <xsl:when test="string-length($ziffer15Txt) &lt;= floor($lengthZ15 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:when
                        test="string-length(substring($ziffer15Txt, string-length($ziffer15Txt_1)+1)) &lt; floor($lengthZ15 div $fontProportion)">
                    <xsl:value-of select="substring($ziffer15Txt, string-length($ziffer15Txt_1)+1)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="str"
                                  select="substring($ziffer15Txt, string-length($ziffer15Txt_1)+1, floor($lengthZ15 div $fontProportion)-2)"/>
                    <xsl:call-template name="printLine">
                        <xsl:with-param name="string" select="$str"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ziffer15Txt_3">
            <xsl:choose>
                <xsl:when test="string-length($ziffer15Txt) &lt;= floor($lengthZ15 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:when
                        test="string-length(substring($ziffer15Txt, string-length($ziffer15Txt_1)+1)) &lt; floor($lengthZ15 div $fontProportion)">
                    <xsl:value-of select="' '"/>
                </xsl:when>
                <xsl:otherwise>
                    <!--
                    <xsl:value-of
                            select="concat('...',substring($ziffer15Txt, 2*floor($lengthZ15 div $fontProportion)-8))"/>
                    -->
                    <xsl:value-of select="$ziffer15Txt"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!--****************************************************************************************************************-->
        <!--signatur-->
        <!--****************************************************************************************************************-->

        <xsl:variable name="BiSecToken" select="//wsse:BinarySecurityToken"/>

        <xsl:variable name="PageCount">
            <xsl:choose>
                <xsl:when test="string-length($ziffer2.3Txt_2) &gt; 1 or string-length($ziffer3Txt_2) &gt; 1
                      or string-length($ziffer4Txt_2) &gt; 1 or string-length($ziffer13.1.2Txt_2) &gt; 1
                      or string-length($ziffer7Txt_2) &gt; 1
                      or string-length($ziffer13.2.3Txt_2) &gt; 1
                      or string-length($ziffer15Txt_3) &gt; 1 or string-length($ziffer14Txt_3) &gt; 1
                      ">

                    <xsl:value-of select="2"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="1"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!--****************************************************************************************************************-->
        <!--aufbereiten der zeilen-->
        <!--****************************************************************************************************************-->

        <xsl:call-template name="header">
            <xsl:with-param name="AccountingPeriod" select="$AccountingPeriod"/>
            <xsl:with-param name="counter" select="$counter"/>
            <xsl:with-param name="taxCounter" select="$taxCounter"/>
            <xsl:with-param name="annuityCounter" select="$annuityCounter"/>
            <xsl:with-param name="pageCounter" select="1"/>
            <xsl:with-param name="language" select="$language"/>
        </xsl:call-template>

        <!--        <xsl:variable name="xmlSrcVersionMajor" select="namespace-uri(../../../../../*[local-name()='SalaryDeclaration'])"/>
                <xsl:variable name="xmlSrcVersionMinor" select="../../../../../*[local-name()='SalaryDeclaration']/@schemaVersion"/>
        -->
        <xsl:call-template name="getSingleLineFooter">
            <!--            <xsl:with-param name="xmlSrcVersionMajor" select="$xmlSrcVersionMajor"/>
                        <xsl:with-param name="xmlSrcVersionMinor" select="$xmlSrcVersionMinor"/>
            -->
            <xsl:with-param name="PageCount" select="$PageCount"/>
            <xsl:with-param name="PageNr" select="1"/>
        </xsl:call-template>

        <!-- zeile 6 -->
        <!-- fix position -->
        <fo:block-container width="175mm"
                            left="0mm"
                            position="absolute">
            <xsl:attribute name="height">
                <xsl:choose>
                    <xsl:when test="$Generator='Viewgen'">
                        <xsl:value-of select="'170mm'"/>
                    </xsl:when>
                    <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                        <xsl:value-of select="'180mm'"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:choose>
                    <xsl:when test="$Generator='Viewgen'">
                        <xsl:value-of select="'93mm'"/>
                    </xsl:when>
                    <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                        <xsl:value-of select="'70mm'"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>

            <fo:table table-layout="fixed" width="100%" space-before="9.5mm">
                <fo:table-column column-width="3mm"/>
                <!-- Ziffern Lohnausweis: 1. - 15. -->
                <fo:table-column column-width="2.0mm"/>
                <!-- Leerspalte für Abstand -->
                <fo:table-column column-width="138.5mm"/>
                <!-- Text/Inhalt -->
                <fo:table-column column-width="4.0mm"/>
                <!-- "+", "-", "=" für Ziffern 2. - 11. -->
                <fo:table-column column-width="31.0mm"/>
                <!-- Beträge -->
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell display-align="before">
                            <fo:block text-align="right">1.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:table table-layout="fixed" width="100%" border-bottom-style="solid"
                                      border-bottom-color="#000000" border-bottom-width="0.5px">
                                <fo:table-column column-width="9.3mm"/>
                                <fo:table-column column-width="48.3mm"/>
                                <fo:table-column column-width="80.8mm"/>
                                <!--<fo:table-column column-width="81.0mm"/>-->
                                <fo:table-body>
                                    <fo:table-row>
                                        <fo:table-cell display-align="after">
                                            <fo:block><!--Lohn-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_a</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block font-size="6pt"><!--soweit nicht unter Ziffer 2-7 aufzuführen-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_b</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block><!--/ Rente-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_c</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell display-align="after">
                                            <fo:block><!--Salaire-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_a</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block
                                                    font-size="6pt"><!--qui ne concerne pas les chiffres 2 à 7 ci-dessous-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_b</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block><!--/ Rente-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_c</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell display-align="after">
                                            <fo:block><!--Salario-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_a</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block
                                                    font-size="6pt"><!--se non da indicare sotto cifre da 2 a 7 più sotto-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_b</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block><!--/ Rendita-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt1_c</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="before">
                            <fo:table table-layout="fixed" width="100%">
                                <fo:table-column column-width="31.0mm"/>
                                <fo:table-body>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block text-align="right" space-before="1mm" space-after="1.5mm"
                                                      font-size="6pt">
                                                CHF
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer1"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 7 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="173.5mm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block text-align="right">2.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:table table-layout="fixed" width="100%">
                                <fo:table-column column-width="26.5mm"/>
                                <fo:table-column column-width="5.0mm"/>
                                <fo:table-column column-width="28.0mm"/>
                                <!-- 27.0mm -->
                                <fo:table-column column-width="79.0mm"/>
                                <!-- 80.0mm -->
                                <fo:table-column column-width="4.0mm"/>
                                <fo:table-column column-width="31.0mm"/>
                                <fo:table-body>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell number-rows-spanned="5" font-size="7pt">
                                            <fo:block><!--Gehaltsnebenleistungen-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block><!--Prestations salariales accessoires-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block><!--Prestazioni accessorie al salario-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block>2.1</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-columns-spanned="2" display-align="after">
                                            <fo:block font-size="7pt" border-bottom-style="solid"
                                                      border-bottom-color="#000000" border-bottom-width="0.5px">
                                                <!--Verpflegung, Unterkunft - Pension, logement - Vitto, alloggio-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_1</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_1</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_1</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="center">
                                            <fo:block text-align="center">+</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell" display-align="center">
                                            <fo:block xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer2.1"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="1mm">
                                        <fo:table-cell number-columns-spanned="5">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell display-align="after">
                                            <fo:block>2.2</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-columns-spanned="2" display-align="after">
                                            <fo:block font-size="6.5pt" border-bottom-style="solid"
                                                      border-bottom-color="#000000" border-bottom-width="0.5px">
                                                <!--Privatanteil Geschäftsfahrzeug - Part privée voiture de service - Quota privata automobile di servizio-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_2</xsl:with-param>
                                                </xsl:call-template>
                                                -<!--&#160;-&#160;-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_2</xsl:with-param>
                                                </xsl:call-template>
                                                -<!--&#160;-&#160;-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="center">
                                            <fo:block text-align="center">+</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer2.2"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="1mm">
                                        <fo:table-cell number-columns-spanned="5">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell display-align="before">
                                            <fo:block>2.3</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="before">
                                            <fo:block font-size="7pt"><!--Andere - Autres - Altre-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_3</xsl:with-param>
                                                </xsl:call-template>
                                                -<!--&#160;-&#160;-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_3</xsl:with-param>
                                                </xsl:call-template>
                                                -<!--&#160;-&#160;-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt2_3</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block font-size="6pt"><!--Art - Genre - Genere-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm">
                                                <fo:inline font-size="8pt">
                                                    <xsl:value-of select="$ziffer2.3Txt_1"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="center">
                                            <fo:block text-align="center">+</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer2.3"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 8 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2mm"/>
                <fo:table-column column-width="99.3mm"/>
                <fo:table-column column-width="39.2mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell number-rows-spanned="2" display-align="before">
                            <fo:block text-align="right">3.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="2">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block font-size="7pt">
                                <!--Unregelmässige Leistungen - Prestations non périodiques - Prestazioni aperiodiche-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt3</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt3</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt3</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block font-size="6pt"><!--Art - Genre - Genere-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm">
                                <fo:inline font-size="8pt">
                                    <xsl:value-of select="$ziffer3Txt_1"/>
                                </fo:inline>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">+</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer3"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 9 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="75.5mm"/>
                <fo:table-column column-width="63.0mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell number-rows-spanned="2" display-align="before">
                            <fo:block text-align="right">4.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="2">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="2" display-align="before">
                            <fo:block
                                    font-size="7pt"><!--Kapitalleistungen - Prestations en capital - Prestazioni in capitale-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt4</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt4</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt4</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="6pt"><!--Art - Genre - Genere-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm">
                                <fo:inline font-size="8pt">
                                    <xsl:value-of select="$ziffer4Txt_1"/>
                                </fo:inline>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">+</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer4"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 10 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="138.5mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell display-align="after">
                            <fo:block text-align="right">5.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-bottom-width="0.5px"
                                       border-bottom-color="black">
                            <fo:block
                                    font-size="7pt"><!--Beteiligungsrechte gemäss Beiblatt - Droits de participation selon annexe - Diritti di partecipazione secondo allegato-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt5</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt5</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt5</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">+</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer5"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 11 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="138.5mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell display-align="after">
                            <fo:block text-align="right">6.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="after">
                            <fo:block font-size="6.5pt" border-after-style="solid" border-after-width="0.5px"
                                      border-after-color="black"><!--Verwaltungsratsentschädigungen - Indemnités des membres de l'administration - Indennità dei membri di consigli d'amministrazione-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt6</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt6</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt6</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">+</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer6"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 12 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="32.5mm"/>
                <fo:table-column column-width="106.0mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell number-rows-spanned="2" display-align="before">
                            <fo:block text-align="right">7.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="2">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="2">
                            <fo:table table-layout="fixed" width="100%"
                                      display-align="before">        <!-- 100% = 32.5mm -->
                                <fo:table-column column-width="23.0mm"/>
                                <fo:table-column column-width="9.5mm"/>
                                <fo:table-body>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Andere Leistungen-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt7</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6pt"><!--Art-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Autres prestations-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt7</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6pt"><!--Genre-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Altre prestazioni-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt7</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6pt"><!--Genere-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm">
                                <fo:inline font-size="8pt">
                                    <xsl:value-of select="$ziffer7Txt_1"/>
                                </fo:inline>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">+</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer7"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 13 -->
            <fo:table table-layout="fixed" width="100%" space-before="-1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="138.5mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell display-align="after">
                            <fo:block text-align="right">8.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-bottom-color="#000000"
                                       border-bottom-width="0.5px">
                            <fo:block
                                    font-size="7pt"><!--Bruttolohn total / Rente - Salaire brut total / Rente - Salario lordo totale / Rendita-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt8</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt8</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt8</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">=</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer8"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 14 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="138.5mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell display-align="after">
                            <fo:block text-align="right">9.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-bottom-color="#000000"
                                       border-bottom-width="0.5px">
                            <fo:block
                                    font-size="7pt"><!--Beiträge AHV/IV/EO/ALV/NBUV - Cotisations AVS/AI/APG/AC/AANP - Contributi AVS/AI/IPG/AD/AINP-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt9</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt9</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt9</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">-</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer9"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 15 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="42.4mm"/>
                <fo:table-column column-width="6.1mm"/>
                <fo:table-column column-width="90.0mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell number-rows-spanned="3">
                            <fo:block text-align="right">10.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="3">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="3">
                            <fo:table table-layout="fixed" width="100%">  <!-- 100% = 42.4mm -->
                                <fo:table-column column-width="31.0mm"/>
                                <fo:table-column column-width="11.4mm"/>
                                <fo:table-body>
                                    <fo:table-row>
                                        <fo:table-cell font-size="7pt">
                                            <fo:block><!--Berufliche Vorsorge-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt10_a</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="5.5pt"><!--2. Säule-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt10_b</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Prévoyance professionnelle-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt10_a</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="5.5pt">
                                                2
                                                <fo:inline font-size="4pt">e</fo:inline>
                                                pilier
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Previdenza professionale-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt10_a</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="5.5pt">
                                                <xsl:choose>
                                                    <xsl:when test="$labelTxt_it='true'">
                                                        2
                                                        <fo:inline font-size="4pt">o</fo:inline>
                                                        pilastro
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        2
                                                        <fo:inline font-size="4pt">nd</fo:inline>
                                                        pillar
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </fo:table-cell>
                        <fo:table-cell display-align="after">
                            <fo:block>10.1</fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-bottom-color="#000000"
                                       border-bottom-width="0.5px">
                            <fo:block
                                    font-size="7pt"><!--Ordentliche Beiträge - Cotisations ordinaires - Contributi ordinari-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt10_1</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt10_1</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt10_1</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">-</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer10.1"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row height="1mm">
                        <fo:table-cell number-columns-spanned="4">
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell display-align="after">
                            <fo:block>10.2</fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-bottom-color="#000000"
                                       border-bottom-width="0.5px">
                            <fo:block font-size="7pt"
                                      space-before="1mm"><!--Beiträge für den Einkauf - Cotisations pour le rachat - Contributi per il riscatto-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt10_2</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt10_2</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt10_2</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">-</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer10.2"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 16 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="124.5mm"/>
                <fo:table-column column-width="14.0mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell display-align="after">
                            <fo:block text-align="right">11.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-bottom-color="#000000"
                                       border-bottom-width="0.5px">
                            <fo:block font-weight="bold"
                                      font-size="6.5pt"><!--Nettolohn / Rente - Salaire net / Rente - Salario netto / Rendita-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt11</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt11</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt11</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-color="#000000"
                                       border-bottom-width="0.5px">
                            <fo:block font-size="6pt" font-weight="bold" text-align="right">
                                <xsl:choose>
                                    <xsl:when test="$Generator='Viewgen'">
                                        <fo:external-graphic src="{$Arrow}"/>
                                    </xsl:when>
                                    <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                                        <fo:external-graphic src="url({concat('file:/',$Arrow)})"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center">
                            <fo:block text-align="center">=</fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block xsl:use-attribute-sets="CHFValue" font-weight="bold">
                                <xsl:value-of select="$ziffer11"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell number-columns-spanned="2">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell number-columns-spanned="2">
                            <fo:block font-size="6pt" font-weight="bold" space-before="1mm">
                                <!--In die Steuererklärung übertragen - A reporter sur la déclaration d'impôt - Da riportare nella dichiarazione d'imposta-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt11_b</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt11_b</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt11_b</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-columns-spanned="2">
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 17        -->
            <fo:table table-layout="fixed" width="100%" space-before="0mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="138.5mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell display-align="after">
                            <fo:block text-align="right">12.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="after" border-bottom-style="solid" border-bottom-color="#000000"
                                       border-bottom-width="0.5px">
                            <fo:block
                                    font-size="7pt"><!--Quellensteuerabzug - Retenue de l'impôt à la source - Ritenuta d'imposta alla fonte-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt12</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt12</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt12</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm" xsl:use-attribute-sets="CHFValue">
                                <xsl:value-of select="$ziffer12"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile 18 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="138.5mm"/>
                <fo:table-column column-width="4.0mm"/>
                <fo:table-column column-width="31.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell number-rows-spanned="2">
                            <fo:block text-align="right">13.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="2">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block font-size="7pt">
                                <!--Spesenvergütungen - Allocations pour frais - Indennità per spese-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt13_a</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt13_a</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt13_a</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="5pt">
                                <!--Nicht im Bruttolohn (gemäss Ziffer 8) enthalten - Non comprises dans le salaire brut (au chiffre 8) - Non comprese nel salario lordo (sotto cifra 8)-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt13_b</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt13_b</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt13_b</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-columns-spanned="2">
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell number-columns-spanned="3" space-before="1mm">
                            <fo:table table-layout="fixed" width="100%"
                                      space-before="0mm">       <!-- 100% = 138.5 + 4 + 31 -->
                                <fo:table-column column-width="7mm"/>
                                <fo:table-column column-width="21.5mm"/>
                                <fo:table-column column-width="7mm"/>
                                <fo:table-column column-width="31.0mm"/>
                                <fo:table-column column-width="64.5mm"/>
                                <fo:table-column column-width="2.5mm"/>
                                <fo:table-column column-width="5.0mm"/>
                                <fo:table-column column-width="4.0mm"/>
                                <fo:table-column column-width="31.0mm"/>
                                <fo:table-body>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell number-rows-spanned="4">
                                            <fo:block font-size="7pt">13.1</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-rows-spanned="4">
                                            <fo:block font-size="7pt"><!--Effektive Spesen-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block font-size="7pt"><!--Frais effectifs-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block font-size="7pt"><!--Spese effettive-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block font-size="6.5pt">13.1.1</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after" number-columns-spanned="2">
                                            <fo:block font-size="6.5pt" border-bottom-style="solid"
                                                      border-bottom-color="#000000" border-bottom-width="0.5px">
                                                <!--Reise, Verpflegung, Übernachtung - Voyage, repas, nuitées - Viaggio, vitto, alloggio-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_1</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_1</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_1</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm" font-weight="bold">
                                                <xsl:if test="count(*[local-name()='ChargesRule']/*[local-name()='Guidance'])=1">
                                                    X
                                                </xsl:if>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm" xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer13.1.1"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="1mm">
                                        <fo:table-cell number-columns-spanned="7">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell display-align="before">
                                            <fo:block font-size="6.5pt" space-before="1mm">13.1.2</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6.5pt"><!--Übrige - Autres - Altre-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block font-size="5.5pt"><!--Art - Genre - Genere-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell" number-columns-spanned="3">
                                            <fo:block text-indent="1mm">
                                                <fo:inline font-size="8pt">
                                                    <xsl:value-of select="$ziffer13.1.2Txt_1"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm" xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer13.1.2"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="1mm">
                                        <fo:table-cell number-columns-spanned="7">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell number-rows-spanned="5">
                                            <fo:block font-size="7pt">13.2</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-rows-spanned="5">
                                            <fo:block font-size="7pt"><!--Pauschalspesen-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block font-size="7pt"><!--Frais forfaitaires-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block font-size="7pt"><!--Spese forfettarie-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after">
                                            <fo:block font-size="6.5pt">13.2.1</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after" number-columns-spanned="4">
                                            <fo:block font-size="6.5pt" border-bottom-style="solid"
                                                      border-bottom-color="#000000" border-bottom-width="0.5px">
                                                <!--Repräsentation - Représentation - Rappresentanza-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2_1</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2_1</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2_1</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm" xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer13.2.1"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="1mm">
                                        <fo:table-cell number-columns-spanned="7">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell display-align="after">
                                            <fo:block font-size="6.5pt">13.2.2</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after" number-columns-spanned="4">
                                            <fo:block font-size="6.5pt" border-bottom-style="solid"
                                                      border-bottom-color="#000000" border-bottom-width="0.5px">
                                                <!--Auto - Voiture - Automobiles-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2_2</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2_2</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_2_2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm" xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer13.2.2"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="1mm">
                                        <fo:table-cell number-columns-spanned="7">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell display-align="before">
                                            <fo:block font-size="6.5pt">13.2.3</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6.5pt"><!--Übrige - Autres - Altre-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                            <fo:block font-size="5.5pt"><!--Art - Genre - Genere-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell number-columns-spanned="3" xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm">
                                                <fo:inline font-size="8pt">
                                                    <xsl:value-of select="$ziffer13.2.3Txt_1"/>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm" xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer13.2.3"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="1mm">
                                        <fo:table-cell number-columns-spanned="7">
                                            <fo:block/>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row height="{$inputCellHeight}">
                                        <fo:table-cell display-align="after">
                                            <fo:block font-size="7pt">13.3</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell display-align="after" number-columns-spanned="6">
                                            <fo:block font-size="7pt" border-bottom-style="solid"
                                                      border-bottom-color="#000000" border-bottom-width="0.5px">
                                                <!--Beiträge an die Weiterbildung - contributions au perfectionnement - contributi per il perfezionamento-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_3</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_3</xsl:with-param>
                                                </xsl:call-template>
                                                &#160;-&#160;
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt13_3</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block/>
                                        </fo:table-cell>
                                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                                            <fo:block text-indent="1mm" xsl:use-attribute-sets="CHFValue">
                                                <xsl:value-of select="$ziffer13.3"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile  19 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="57.5mm"/>
                <fo:table-column column-width="116.0mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell number-rows-spanned="3">
                            <fo:block text-align="right">14.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="3">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="3">
                            <fo:table table-layout="fixed" width="100%">      <!-- 100% = 57.5mm -->
                                <fo:table-column column-width="48.5mm"/>
                                <fo:table-column column-width="9.0mm"/>
                                <fo:table-body>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Weitere Gehaltsnebenleistungen-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt14</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6pt"><!--Art-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Autres prestations salariales accessoires-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt14</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6pt"><!--Genre-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block font-size="7pt"><!--Altre prestazioni accessorie al salario-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblPkt14</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block font-size="6pt"><!--Genere-->
                                                <xsl:call-template name="getLabel">
                                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                                    <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                                </xsl:call-template>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm">
                                <fo:inline font-size="8pt">
                                    <xsl:value-of select="$ziffer14Txt_1"/>
                                </fo:inline>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row height="1mm">
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm">
                                <fo:inline font-size="8pt">
                                    <xsl:value-of select="$ziffer14Txt_2"/>
                                </fo:inline>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

            <!-- zeile  20 -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="20.0mm"/>
                <fo:table-column column-width="153.5mm"/>
                <fo:table-body>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell number-rows-spanned="3">
                            <fo:block text-align="right">15.</fo:block>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="3">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="3">
                            <fo:block font-size="7pt"><!--Bemerkungen-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt15</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="7pt"><!--Observations-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt15</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="7pt"><!--Observazioni-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblPkt15</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm">
                                <fo:inline font-size="8pt">
                                    <xsl:value-of select="$ziffer15Txt_1"/>
                                </fo:inline>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row height="1mm">
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row height="{$inputCellHeight}">
                        <fo:table-cell xsl:use-attribute-sets="inputCell">
                            <fo:block text-indent="1mm">
                                <fo:inline font-size="8pt">
                                    <xsl:value-of select="$ziffer15Txt_2"/>
                                </fo:inline>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>

        </fo:block-container>

        <xsl:call-template name="footer">
            <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
            <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
            <xsl:with-param name="CompanySig" select="$companySig"/>
            <xsl:with-param name="IssuerSig" select="$issuerSig"/>
            <xsl:with-param name="language" select="$language"/>
        </xsl:call-template>

        <xsl:choose>
            <!--<xsl:when test="( (position()!=last() or $IsLastPerson=false()) or $PageCount=2)">-->
            <xsl:when test="$PageCount=2">
                <fo:block break-after="page"/>
            </xsl:when>
        </xsl:choose>

        <xsl:choose>
            <xsl:when test="$PageCount=2">
                <xsl:call-template name="secondPage">
                    <xsl:with-param name="AccountingPeriod" select="$AccountingPeriod"/>
                    <xsl:with-param name="counter" select="$counter"/>
                    <xsl:with-param name="taxCounter" select="$taxCounter"/>
                    <xsl:with-param name="annuityCounter" select="$annuityCounter"/>
                    <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
                    <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
                    <xsl:with-param name="CompanySig" select="$companySig"/>
                    <xsl:with-param name="IssuerSig" select="$issuerSig"/>
                    <xsl:with-param name="ziffer2.3_2" select="$ziffer2.3Txt"/>
                    <xsl:with-param name="ziffer3_2" select="$ziffer3Txt"/>
                    <xsl:with-param name="ziffer4_2" select="$ziffer4Txt"/>
                    <xsl:with-param name="ziffer7_2" select="$ziffer7Txt"/>
                    <xsl:with-param name="ziffer13.1.2_2" select="$ziffer13.1.2Txt"/>
                    <xsl:with-param name="ziffer13.2.3_2" select="$ziffer13.2.3Txt"/>
                    <xsl:with-param name="ziffer14_3" select="$ziffer14Txt"/>
                    <xsl:with-param name="ziffer15_3" select="$ziffer15Txt"/>
                    <xsl:with-param name="PageCount" select="$PageCount"/>
                    <xsl:with-param name="language" select="$language"/>
                </xsl:call-template>

                <!--
                        <xsl:choose>
                          <xsl:when test="( position()!=last() or $IsLastPerson=false())">
                            <fo:block break-after="page"/>
                          </xsl:when>
                        </xsl:choose>
                -->
            </xsl:when>
        </xsl:choose>

        <!--
        <xsl:choose>
          <xsl:when test="( (position()=last()) and $IsLastPerson and $lastPage='true')">
            <fo:block break-after="page"/>
            <xsl:call-template name="endPage"/>
          </xsl:when>
        </xsl:choose>
        -->
    </xsl:template>

    <!--
    ********************************************************************************************************************
    ********************************************************************************************************************
    sub templates
    ********************************************************************************************************************
    -->

    <xsl:template name="getNumberValue">
        <xsl:param name="zifferPath"/>
        <xsl:choose>
            <xsl:when test="count($zifferPath)=1">
                <xsl:value-of select="number($zifferPath)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="number('0')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getSV-Number">
        <xsl:choose>
            <xsl:when
                    test="count(./../../*[local-name()='Particulars']/*[local-name()='Social-InsuranceIdentification']/*[local-name()='SV-AS-Number'])=1">
                <xsl:value-of
                        select="./../../*[local-name()='Particulars']/*[local-name()='Social-InsuranceIdentification']/*[local-name()='SV-AS-Number']"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$verbose='true'">
                        (no tag)
                    </xsl:when>
                    <xsl:otherwise>

                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getGeburtsdatum">
        <xsl:choose>
            <xsl:when test="count(./../../*[local-name()='Particulars']/*[local-name()='DateOfBirth'])=1">
                <xsl:call-template name="format-date">
                    <xsl:with-param name="date"
                                    select="./../../*[local-name()='Particulars']/*[local-name()='DateOfBirth']"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getCheckSum">
        <xsl:param name="ValueInstance"/>
        <xsl:param name="ValueCalculate"/>
        <xsl:choose>
            <xsl:when test="$checkTotals = 'false'">
                <xsl:value-of select="''"/>
            </xsl:when>
            <xsl:when test=" ($ValueInstance != $ValueCalculate) and ($checkTotals = 'true') ">
                <xsl:value-of select="concat('?', number($ValueCalculate))"/>
            </xsl:when>
            <xsl:when test=" ($ValueInstance = $ValueCalculate) and ($checkTotals = 'true') ">
                <xsl:value-of select="'  |:)'"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="'getCheckSum ERROR !!'"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getCorner">
        <!-- rechte obere Ecke zeichnen-->
        <fo:block-container height="5mm" width="5mm" top="0mm" left="178mm" position="absolute" border-style="solid"
                            border-color="#000000" border-top-width="0.05mm" border-right-width="0.05mm"
                            border-bottom-width="0.00mm" border-left-width="0.00mm">
            <fo:block/>
        </fo:block-container>

        <!-- linke untere Ecke zeichnen -->
        <fo:block-container height="5mm" width="5mm" top="277.1mm" left="0mm" position="absolute" border-style="solid"
                            border-color="#000000" border-top-width="0.00mm" border-right-width="0.00mm"
                            border-bottom-width="0.05mm" border-left-width="0.05mm">
            <fo:block/>
        </fo:block-container>

        <!-- Quadrat rechts unten -->
        <fo:block-container height="2.5mm" width="2.5mm" top="278.1mm" left="180.5mm" position="absolute"
                            border-style="solid"
                            border-color="000000" border-top-width="0.05mm" border-right-width="0.05mm"
                            border-bottom-width="0.05mm" border-left-width="0.05mm">
            <fo:block/>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="getSingleLineFooter">
        <xsl:param name="PageCount" select="''"/>
        <xsl:param name="PageNr" select="''"/>

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'start template getSingleLineFooter'"/>
        </xsl:call-template>

        <xsl:variable name="xmlFile">
            <xsl:call-template name="substring-after-last">
                <xsl:with-param name="string" select="$filename"/>
                <xsl:with-param name="delimiter" select="'/'"/>
            </xsl:call-template>
        </xsl:variable>

        <fo:block-container height="5mm" width="200mm" top="283.0mm" left="0mm" position="absolute">
            <fo:block>
                <fo:table>
                    <fo:table-column column-width="30mm"/>
                    <fo:table-column column-width="135mm"/>
                    <fo:table-column column-width="25mm"/>
                    <fo:table-body>
                        <fo:table-row>
                            <fo:table-cell>
                                <fo:block>
                                    <fo:inline font-weight="bold" font-size="7pt">Form. 11 df</fo:inline>
                                    <xsl:choose>
                                        <xsl:when test="$labelTxt_it='true'">
                                            <fo:inline font-weight="bold" font-size="7pt">i</fo:inline>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <fo:inline font-weight="bold" font-size="7pt">e</fo:inline>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <fo:inline>&#160;&#160;01.21</fo:inline>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell>
                                <fo:block font-size="5.5pt">
                                    [ swissdec / TaxAccountingForm.xsl
                                    <!--<fo:inline font-weight="lighter" font-size="5.5pt">[ swissdec / TaxAccountingForm.xsl-->
                                    <xsl:value-of select="$TaxAccountingFormXslVersion"/>
                                    /
                                    <xsl:value-of select="$xmlFile"/>
                                    ;&#160;Src:&#160;<xsl:value-of select="namespace-uri()"/>,
                                    <!--                    <xsl:value-of select="namespace-uri(../../../../../*[local-name()='SalaryDeclaration'])"/>
                                    -->
                                    <xsl:value-of select="../../../../../@schemaVersion"/>
                                    ;&#160;<xsl:value-of select="$Generator"/>&#160;<xsl:value-of select="$Version"/>
                                    ]
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell>
                                <fo:block>
                                    <xsl:if test="$PageNr!='' and $PageCount!=''">
                                        <fo:inline text-align-last="justify">
                                            &#160;&#160;&#160;&#160;&#160;
                                            <xsl:apply-templates select="$ltxt-var">
                                                <xsl:with-param name="lang" select="$language"/>
                                                <xsl:with-param name="key" select="'page'"/>
                                            </xsl:apply-templates>
                                            &#160;
                                            <xsl:value-of select="$PageNr"/>
                                            /
                                            <xsl:value-of select="$PageCount"/>
                                        </fo:inline>
                                    </xsl:if>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="getLabel">
        <xsl:param name="langNr"/>
        <xsl:param name="key"/>

        <xsl:choose>
            <xsl:when test="$langNr=1">
                <xsl:apply-templates select="$ltxt-var">
                    <xsl:with-param name="lang" select="'de'"/>
                    <xsl:with-param name="key" select="$key"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="$langNr=2">
                <xsl:apply-templates select="$ltxt-var">
                    <xsl:with-param name="lang" select="'fr'"/>
                    <xsl:with-param name="key" select="$key"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="$langNr=3">
                <xsl:choose>
                    <xsl:when test="$labelTxt_it='true'">
                        <xsl:apply-templates select="$ltxt-var">
                            <xsl:with-param name="lang" select="'it'"/>
                            <xsl:with-param name="key" select="$key"/>
                        </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="$ltxt-var">
                            <xsl:with-param name="lang" select="'en'"/>
                            <xsl:with-param name="key" select="$key"/>
                        </xsl:apply-templates>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$langNr=4">
                <xsl:apply-templates select="$ltxt-var">
                    <xsl:with-param name="lang" select="'en'"/>
                    <xsl:with-param name="key" select="$key"/>
                </xsl:apply-templates>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="header">

        <xsl:param name="AccountingPeriod"/>
        <xsl:param name="counter"/>
        <xsl:param name="taxCounter"/>
        <xsl:param name="annuityCounter"/>
        <xsl:param name="pageCounter"/>
        <xsl:param name="language"/>

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'[TaxAccountingForm.xsl:Info] start template header ...'"/>
        </xsl:call-template>

        <xsl:variable name="BarcodeImageName">
            <xsl:choose>
                <xsl:when test="$Generator='Viewgen'">
                    <xsl:value-of select="concat($tempDir,'/',$BarcodePrefix,'_',$counter,'_',$annuityCounter,'_', $taxCounter, '_p', $pageCounter, '.',$BarcodeFormat)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('file:/',$tempDir,'/',$BarcodePrefix,'_',$counter,'_',$annuityCounter,'_', $taxCounter, '_p', $pageCounter, '.',$BarcodeFormat)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <!-- ******************************************************************************************************** -->

        <!--zeile 1 / Ziffer A -->
        <fo:table table-layout="fixed" width="100%">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2mm"/>
            <fo:table-column column-width="9.5mm"/>
            <fo:table-column column-width="163.5mm"/>
            <!--<fo:table-column column-width="164.5mm"/>-->
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}">
                    <fo:table-cell display-align="center">
                        <fo:block>A</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm" font-weight="bold">
                            <xsl:if test="local-name(.)='TaxSalary'">X</xsl:if>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell display-align="after">
                        <fo:block font-size="12pt" font-weight="bold" text-indent="2mm">
                            <!-- Lohnausweis - Certificat de salaire - Salary certificate -->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblHeader_1</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblHeader_1</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblHeader_1</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <!-- zeile 2 / Ziffer B -->
        <fo:table table-layout="fixed" width="100%" space-before="1mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2mm"/>
            <fo:table-column column-width="9.5mm"/>
            <fo:table-column column-width="163.5mm"/>
            <!--<fo:table-column column-width="164.5mm"/>-->
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}">
                    <fo:table-cell display-align="center">
                        <fo:block>B</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm" font-weight="bold">
                            <xsl:if test="local-name(.)='TaxAnnuity'">X</xsl:if>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell display-align="after">
                        <fo:block font-size="12pt" font-weight="bold" text-indent="2mm">
                            <!-- Rentenbescheinigung - Attestation de rentes - Attestazione delle rendite -->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblHeader_2</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblHeader_2</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblHeader_2</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <!-- zeile 3 / Ziffern C, F -->
        <fo:table table-layout="fixed" width="100%" space-before="2.9mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2mm"/>
            <fo:table-column column-width="43.0mm"/>
            <fo:table-column column-width="2.5mm"/>
            <fo:table-column column-width="43.0mm"/>
            <fo:table-column column-width="8.1mm"/>
            <fo:table-column column-width="4.0mm"/>
            <fo:table-column column-width="9.8mm"/>
            <fo:table-column column-width="60mm"/>
            <!--<fo:table-column column-width="63.6mm"/>-->
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}">
                    <fo:table-cell display-align="center">
                        <fo:block>C</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm">
                            <xsl:call-template name="getSV-Number"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm">
                            <xsl:call-template name="getGeburtsdatum"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell display-align="center">
                        <fo:block>F</fo:block>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm" font-weight="bold">
                            <xsl:if test="count(./*[local-name()='FreeTransport'])=1">X</xsl:if>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell number-rows-spanned="2" font-size="6pt">
                        <fo:block text-indent="1.5mm">
                            <!--Unentgeltliche Beförderung zwischen Wohn- und Arbeitsort-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblF</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block text-indent="1.5mm">
                            <!--Transport gratuit entre le domicile et le lieu de
                            travail -->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblF</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block text-indent="1.5mm"><!--Trasporto gratuito dal domicilio al luogo di lavoro-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblF</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <!--<fo:table-row height="{$inputCellHeight}">-->
                <fo:table-row height="4mm">
                    <fo:table-cell number-columns-spanned="2">
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell number-columns-spanned="2">
                        <fo:block font-size="6pt" space-before="1mm"><!--AHV-Nr. - No AVS - N. AVS-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblC1</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblC1</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblC1</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell number-columns-spanned="2">
                        <fo:block font-size="6pt" space-before="1mm">
                            <!-- Geburtsdatum – Date de naissance – Data di nascita -->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblC2</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblC2</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblC2</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <!-- zeile 4 / Ziffern D, E, G -->
        <fo:table table-layout="fixed" width="100%" space-before="0mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2.0mm"/>
            <fo:table-column column-width="21.1mm"/>
            <fo:table-column column-width="8.6mm"/>
            <fo:table-column column-width="4.0mm"/>
            <fo:table-column column-width="21.1mm"/>
            <fo:table-column column-width="4.0mm"/>
            <fo:table-column column-width="21.1mm"/>
            <fo:table-column column-width="16.7mm"/>
            <fo:table-column column-width="4.0mm"/>
            <fo:table-column column-width="9.8mm"/>
            <fo:table-column column-width="60mm"/>
            <!--<fo:table-column column-width="63.6mm"/>-->
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}">
                    <fo:table-cell display-align="center">
                        <fo:block>D</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm">
                            <xsl:value-of select="$AccountingPeriod"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell display-align="center">
                        <fo:block>E</fo:block>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm">
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="date" select="./*[local-name()='Period']/*[local-name()='from']"/>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm">
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="date"
                                                select="./*[local-name()='Period']/*[local-name()='until']"/>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell display-align="center">
                        <fo:block>G</fo:block>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-indent="1mm" font-weight="bold">
                            <xsl:if test="count(./*[local-name()='CanteenLunchCheck'])=1">X</xsl:if>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell font-size="6pt" number-rows-spanned="2">
                        <fo:block text-indent="1.5mm"><!--Kantinenverpflegung / Lunch-Checks-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblG</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block text-indent="1.5mm"><!--Repas à la cantine / chèques-repas-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblG</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block text-indent="1.5mm"><!--Pasti alla mensa / buoni pasto-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblG</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell number-columns-spanned="2">
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell number-columns-spanned="3">
                        <fo:block font-size="6pt" space-before="1mm"><!--Jahr - Année - Anno-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblD</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblD</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblD</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell number-columns-spanned="2">
                        <fo:block font-size="6pt" space-before="1mm"><!--von - du - dal-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblE1</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblE1</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblE1</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell number-columns-spanned="4">
                        <fo:block font-size="6pt" space-before="1mm"><!--bis - au - al-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblE2</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblE2</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblE2</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <!-- zeile 5 / Ziffer H-->
        <fo:table table-layout="fixed" width="100%">
            <xsl:attribute name="space-before">
                <xsl:choose>
                    <xsl:when test="$Generator='Viewgen'">
                        <xsl:value-of select="'13mm'"/>
                    </xsl:when>
                    <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                        <xsl:value-of select="'5mm'"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2mm"/>
            <!-- Anforderung der Post: Es darf nichts vom Barcode oder sonst etwas, das nichts mit der Adresse zu tun
               hat, im Fensterfeld sichtbar sein. -->

            <xsl:choose>
                <xsl:when test="$alignment='right'">
                    <fo:table-column column-width="75mm"/>
                    <!-- Spalte für Barcode  -->
                    <fo:table-column column-width="26mm"/><!--<fo:table-column column-width="10mm"/>-->
                    <fo:table-column column-width="88mm"/>
                    <!-- Spalte für Adresse -->
                </xsl:when>
                <xsl:otherwise>
                    <fo:table-column column-width="86mm"/>
                    <!-- Spalte für Adresse -->
                    <fo:table-column column-width="7mm"/>
                    <fo:table-column column-width="75mm"/>
                    <!-- Spalte für Barcode  -->
                    <fo:table-column column-width="2mm"/>
                    <fo:table-column column-width="3mm"/>
                </xsl:otherwise>
            </xsl:choose>

            <fo:table-body>
                <fo:table-row height="40.3mm">
                    <xsl:choose>
                        <xsl:when test="$alignment='right'">
                            <fo:table-cell>
                                <fo:block space-before="1mm">H</fo:block>
                            </fo:table-cell>
                            <fo:table-cell>
                                <fo:block/>
                            </fo:table-cell>
                            <xsl:call-template name="PrintBarcode">
                                <xsl:with-param name="BarcodeImageName" select="$BarcodeImageName"/>
                                <xsl:with-param name="Generator" select="$Generator"/>
                                <xsl:with-param name="showBarcode" select="$showBarcode"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <fo:table-cell number-columns-spanned="2" space-before="1mm">
                                <fo:block/>
                            </fo:table-cell>
                            <xsl:call-template name="Adressierung">
                                <xsl:with-param name="counter" select="$counter"/>
                                <xsl:with-param name="BarcodeImageName" select="$BarcodeImageName"/>
                                <xsl:with-param name="language" select="$language" />
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>

                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>

                    <xsl:choose>
                        <xsl:when test="$alignment='left'">
                            <xsl:call-template name="PrintBarcode">
                                <xsl:with-param name="BarcodeImageName" select="$BarcodeImageName"/>
                                <xsl:with-param name="Generator" select="$Generator"/>
                                <xsl:with-param name="showBarcode" select="$showBarcode"/>
                            </xsl:call-template>
                            <fo:table-cell>
                                <fo:block/>
                            </fo:table-cell>
                            <fo:table-cell>
                                <fo:block>H</fo:block>
                            </fo:table-cell>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="Adressierung">
                                <xsl:with-param name="counter" select="$counter"/>
                                <xsl:with-param name="BarcodeImageName" select="$BarcodeImageName"/>
                                <xsl:with-param name="language" select="$language" />
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>

                </fo:table-row>
                <fo:table-row height="1mm">
                    <fo:table-cell number-columns-spanned="5">
                        <fo:block/>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>

        </fo:table>

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'end template header'"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="PrintBarcode">
        <xsl:param name="BarcodeImageName"/>
        <xsl:param name="Generator"/>
        <xsl:param name="showBarcode"/>

        <fo:table-cell>
            <fo:block space-before="1mm">
                <xsl:if test="$showBarcode='true'">
                    <xsl:choose>
                        <xsl:when test="$Generator='Viewgen'">
                            <fo:external-graphic src="{$BarcodeImageName}" width="70mm" height="60mm"
                                                 content-width="scale-to-fit" content-height="scale-to-fit"/>
                        </xsl:when>
                        <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                            <fo:external-graphic src="url('{$BarcodeImageName}')" width="70mm" height="30mm"  />
                                                 <!--content-width="100%" content-height="100%" scaling="uniform" scaling-method="auto"/>-->
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="Adressierung">
        <xsl:param name="counter"/>
        <xsl:param name="BarcodeImageName"/>
        <xsl:param name="language"/>

        <xsl:variable name="AdrFontSize">8pt</xsl:variable>

        <fo:table-cell>
            <!--Eine Postadresse darf keine Leerzeilen enthalten => optionale Adressfelder mit <xsl:if> -->
            <fo:block space-before="1mm" font-size="{$AdrFontSize}">
                <xsl:value-of
                        select="../../*[local-name()='Particulars']/*[local-name()='Firstname']"/>&#160;<xsl:value-of
                        select="../../*[local-name()='Particulars']/*[local-name()='Lastname']"/>
            </fo:block>
            <xsl:if test="count(../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='ComplementaryLine'])=1">
                <fo:block space-before="1mm" font-size="{$AdrFontSize}">
                    <xsl:value-of
                            select="substring(../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='ComplementaryLine'],1,32)"/>
                </fo:block>
            </xsl:if>
            <xsl:if test="count(../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Street'])=1">
                <fo:block space-before="1.2mm" font-size="{$AdrFontSize}">
                    <xsl:value-of
                            select="../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Street']"/>
                </fo:block>
            </xsl:if>
            <xsl:if test="count(../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Locality'])=1">
                <fo:block space-before="1.2mm" font-size="{$AdrFontSize}">
                    <xsl:value-of
                            select="substring(../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Locality'],1,32)"/>
                </fo:block>
            </xsl:if>
            <xsl:if test="count(../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Postbox'])=1">
                <fo:block space-before="1.2mm" font-size="{$AdrFontSize}">
                    <!--Postfach/boîte postale-->
                    <xsl:call-template name="postfachStr">
                        <xsl:with-param name="postfach" select="../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Postbox']"/>
                        <xsl:with-param name="language" select="$language"/>
                    </xsl:call-template>
                </fo:block>
            </xsl:if>
            <fo:block space-before="1.2mm" font-size="{$AdrFontSize}">
                <xsl:value-of
                        select="../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='ZIP-Code']"/>&#160;<xsl:value-of
                        select="../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='City']"/>
            </fo:block>
            <fo:block space-before="1.2mm" font-size="{$AdrFontSize}">
                <xsl:value-of
                        select="../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Country']"/>
            </fo:block>
            <xsl:choose>
                <xsl:when test="$verbose='true'">
                    <fo:block space-before="10.0mm">
                        <fo:inline font-size="5.5pt">
                            [
                            <xsl:value-of select="$counter"/>
                            :
                            File:
                            <xsl:value-of select="$BarcodeImageName"/>
                            ]
                        </fo:inline>
                    </fo:block>
                </xsl:when>
                <xsl:otherwise>
                    <fo:block space-before="10.0mm">
                        <fo:inline font-size="5.5pt"/>
                    </fo:block>
                </xsl:otherwise>
            </xsl:choose>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="footer">

        <xsl:param name="SignatureCheckInfo"/>
        <xsl:param name="SignatureCheckInfoImage"/>
        <xsl:param name="CompanySig"/>
        <xsl:param name="IssuerSig"/>
        <xsl:param name="language"/>

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'[TaxAccountingForm.xsl:Info] start template footer ...'"/>
        </xsl:call-template>

        <fo:block-container width="178.5mm" top="255.0mm" left="0mm" position="absolute">
        <!--<fo:block-container height="25mm" width="178.5mm" top="256.0mm" left="0mm" position="absolute">-->
            <xsl:attribute name="height">
                <xsl:choose>
                    <xsl:when test="$Generator='Viewgen'">
                        <xsl:value-of select="'25mm'"/>
                    </xsl:when>
                    <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                        <xsl:value-of select="'40mm'"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>

            <!-- zeile   21 oder bereich I -->
            <fo:table table-layout="fixed" width="100%" space-before="1mm">
                <fo:table-column column-width="3mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="12.0mm"/>
                <fo:table-column column-width="50.0mm"/>
                <fo:table-column column-width="2.0mm"/>
                <fo:table-column column-width="53mm"/>
                <fo:table-column column-width="5.0mm"/>
                <fo:table-column column-width="56.4mm"/>
                <!--<fo:table-column column-width="65mm"/>-->
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell display-align="before">
                            <fo:block text-align="center">I</fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="before" number-columns-spanned="2">
                            <fo:block font-size="6.5pt"><!--Ort und Datum - Lieu et date - Luogo e data-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblI1</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblI1</xsl:with-param>
                                </xsl:call-template>
                                &#160;-&#160;
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblI1</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="8pt">
                                <xsl:value-of
                                        select="../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='City']"/>,&#160;<xsl:call-template name="format-date">
                                    <xsl:with-param name="date"
                                                    select="substring(../../../../../*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='CreationDate'], 1, 10)"/>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="6.5pt" font-weight="bold"
                                      padding-top="5.5mm">
                                <!-- background-color="lemonchiffon"-->
                                <xsl:value-of select="$SignatureCheckInfo"/>
                                <!--<xsl:value-of select="$SignatureCheckInfoImage"/>-->

                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="before">
                            <fo:block font-size="6.5pt"><!--Die Richtigkeit und Vollständigkeit bestätigt-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblI2</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="5pt"><!--inkl. genauer Anschrift und Telefonnummer des Arbeitgebers-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">1</xsl:with-param>
                                    <xsl:with-param name="key">lblI3</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="6.5pt"><!--Certifié exact et complet-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblI2</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="5pt"><!--y.c. adresse et numéro de téléphone exacts de l'employeur-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">2</xsl:with-param>
                                    <xsl:with-param name="key">lblI3</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block font-size="6.5pt"><!--Certificato esatto e completo-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblI2</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <fo:block
                                    font-size="5pt"><!--compresi indirizzo e numero di telefono esatti del datore di lavoro-->
                                <xsl:call-template name="getLabel">
                                    <xsl:with-param name="langNr">3</xsl:with-param>
                                    <xsl:with-param name="key">lblI3</xsl:with-param>
                                </xsl:call-template>
                            </fo:block>
                            <!--                        </fo:table-cell>
                                                    <fo:table-cell display-align="before">
                            -->
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell number-rows-spanned="2">
                            <xsl:choose>
                                <xsl:when
                                        test="string-length(../../../../*[local-name()='CompanyDescription']/*[local-name()='UID-BFS']) &gt; 0">
                                    <fo:block font-size="6.5pt">
                                        UID:&#160;
                                        <xsl:value-of
                                                select="../../../../*[local-name()='CompanyDescription']/*[local-name()='UID-BFS']"/>
                                    </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:if test="string-length(../../../../*[local-name()='CompanyDescription']/*[local-name()='UID-EHRA']) &gt; 0">
                                        <fo:block font-size="6.5pt">
                                            UID:&#160;
                                            <xsl:value-of
                                                    select="../../../../*[local-name()='CompanyDescription']/*[local-name()='UID-EHRA']"/>
                                        </fo:block>
                                    </xsl:if>
                                </xsl:otherwise>
                            </xsl:choose>
                            <fo:block font-size="6.5pt">
                            </fo:block>

                            <xsl:choose>
                                <!--Fall eine spezifische Adresse angegeben wurde, wird diese verwendet. Sonst die allgemeine Adresse der Firma.-->
                                <xsl:when test="count(./*[local-name()='Contact']/*[local-name()='HR-RC-Name'])=1">
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="./*[local-name()='Contact']/*[local-name()='HR-RC-Name']"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="./*[local-name()='Contact']/*[local-name()='Person']"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:if test="string-length(./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='ComplementaryLine']) &gt; 0">
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='ComplementaryLine']"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:if test="string-length(./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Street']) &gt; 0">
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Street']"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:if test="string-length(./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Postbox']) &gt; 0">
                                        <xsl:variable name="postbox">
                                            <xsl:call-template name="postfachStr">
                                                <xsl:with-param name="postfach" select="./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Postbox']"/>
                                                <xsl:with-param name="language" select="$language"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="$postbox"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:if test="string-length(./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Locality']) &gt; 0">
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Locality']"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="concat(./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='ZIP-Code'],' ',./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='City'])"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:if test="string-length(./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Country']) &gt; 0">
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="./*[local-name()='Contact']/*[local-name()='Address']/*[local-name()='Country']"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="concat('Tel: ',./*[local-name()='Contact']/*[local-name()='PhoneNumber'])"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="../../../../*[local-name()='CompanyDescription']/*[local-name()='Name']/*[local-name()='HR-RC-Name']"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="../../../../../*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='ContactPerson']/*[local-name()='Name']"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='ComplementaryLine']"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='Street']"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:if test="string-length(../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='Postbox']) &gt; 0">
                                        <xsl:variable name="postbox">
                                            <xsl:call-template name="postfachStr">
                                                <xsl:with-param name="postfach" select="../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='Postbox']"/>
                                                <xsl:with-param name="language" select="$language"/>
                                            </xsl:call-template>
                                        </xsl:variable>
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="$postbox"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='Locality']"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:call-template name="writeBlockWidthLimit">
                                        <xsl:with-param name="textStr" select="concat(../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='ZIP-Code'],' ',../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='City'])"/>
                                        <xsl:with-param name="initFontGroesse" select="6.5"/>
                                        <xsl:with-param name="limit" select="30"/>
                                    </xsl:call-template>
                                    <xsl:if test="string-length(../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='Country']) &gt; 0">
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="../../../../*[local-name()='CompanyDescription']/*[local-name()='Address']/*[local-name()='Country']"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                    <xsl:if test="string-length(../../../../../*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='ContactPerson']/*[local-name()='PhoneNumber']) &gt; 0">
                                        <xsl:call-template name="writeBlockWidthLimit">
                                            <xsl:with-param name="textStr" select="concat('Tel: ',../../../../../*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='ContactPerson']/*[local-name()='PhoneNumber'])"/>
                                            <xsl:with-param name="initFontGroesse" select="6.5"/>
                                            <xsl:with-param name="limit" select="30"/>
                                        </xsl:call-template>
                                    </xsl:if>
                                </xsl:otherwise>
                            </xsl:choose>
                        </fo:table-cell>
                    </fo:table-row>
                    <fo:table-row>
                        <fo:table-cell display-align="before">
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell display-align="before">
                            <fo:block font-size="6.5pt">
                                <xsl:choose>
                                    <xsl:when test="$Generator='Viewgen'">
                                        <fo:external-graphic src="{$SignatureCheckInfoImage}" height="10mm"
                                                             content-height="10mm"/>
                                    </xsl:when>
                                    <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                                        <fo:external-graphic src="url({concat('file:/',$SignatureCheckInfoImage)})" height="10mm"
                                                             content-height="10mm"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell display-align="center" number-columns-spanned="3">
                            <fo:block font-size="6.5pt" background-color="lemonchiffon">
                                <xsl:value-of select="$CompanySig"/>
                            </fo:block>
                            <fo:block font-size="5.0pt" background-color="lemonchiffon">
                                <xsl:value-of select="$IssuerSig"/>
                            </fo:block>
                        </fo:table-cell>

                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:block-container>

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'end template footer'"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="writeBlockWidthLimit">
        <xsl:param name="textStr"/>
        <xsl:param name="limit"/>
        <xsl:param name="initFontGroesse"/>

        <xsl:variable name="fontSize">
            <xsl:choose>
                <xsl:when test="string-length($textStr) &gt; $limit">
                    <xsl:variable name="fontGroesse" select="$initFontGroesse - (string-length($textStr) - $limit)*0.5"/>
                    <xsl:choose>
                        <xsl:when test="$fontGroesse &gt; 3">
                            <xsl:value-of select="concat($fontGroesse,'pt')"/>
                        </xsl:when>
                        <xsl:otherwise>4pt</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($initFontGroesse,'pt')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <fo:block font-size="{$fontSize}">
            <xsl:value-of select="$textStr"/>
        </fo:block>
    </xsl:template>

    <xsl:template name="postfachStr">
        <xsl:param name="postfach"/>
        <xsl:param name="language"/>

        <xsl:variable name="lblPostfach">
            <xsl:choose>
                <xsl:when test="$language = 'de'">
                    <xsl:call-template name="getLabel">
                        <xsl:with-param name="langNr">1</xsl:with-param>
                        <xsl:with-param name="key">lblPostfach</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$language = 'fr'">
                    <xsl:call-template name="getLabel">
                        <xsl:with-param name="langNr">2</xsl:with-param>
                        <xsl:with-param name="key">lblPostfach</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$language = 'it'">
                    <xsl:call-template name="getLabel">
                        <xsl:with-param name="langNr">3</xsl:with-param>
                        <xsl:with-param name="key">lblPostfach</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$language = 'en'">
                    <xsl:call-template name="getLabel">
                        <xsl:with-param name="langNr">4</xsl:with-param>
                        <xsl:with-param name="key">lblPostfach</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        <!--<xsl:variable name="postfach"-->
                      <!--select="../../*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Postbox']"/>-->
        <xsl:choose>
            <xsl:when test="contains($postfach,$lblPostfach)">
                <xsl:value-of select="$postfach"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$lblPostfach"/>&#160;<xsl:value-of select="$postfach"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="secondPage">
        <xsl:param name="AccountingPeriod"/>
        <xsl:param name="counter"/>
        <xsl:param name="taxCounter"/>
        <xsl:param name="annuityCounter"/>
        <xsl:param name="SignatureCheckInfo"/>
        <xsl:param name="SignatureCheckInfoImage"/>
        <xsl:param name="CompanySig"/>
        <xsl:param name="IssuerSig"/>
        <xsl:param name="ziffer2.3_2"/>
        <xsl:param name="ziffer3_2"/>
        <xsl:param name="ziffer4_2"/>
        <xsl:param name="ziffer7_2"/>
        <xsl:param name="ziffer13.1.2_2"/>
        <xsl:param name="ziffer13.2.3_2"/>
        <xsl:param name="ziffer14_3"/>
        <xsl:param name="ziffer15_3"/>
        <xsl:param name="PageCount"/>
        <xsl:param name="language"/>

        <xsl:call-template name="printMessage">
            <xsl:with-param name="message" select="'[TaxAccountingForm.xsl:Info] start template secondPage ...'"/>
        </xsl:call-template>

        <xsl:call-template name="header">
            <xsl:with-param name="AccountingPeriod" select="$AccountingPeriod"/>
            <!--<xsl:with-param name="TaxSalaryAnnuityID" select="$TaxSalaryAnnuityID"/>-->
            <xsl:with-param name="counter" select="$counter"/>
            <xsl:with-param name="taxCounter" select="$taxCounter"/>
            <xsl:with-param name="annuityCounter" select="$annuityCounter"/>
            <xsl:with-param name="pageCounter" select="2"/>
            <xsl:with-param name="language" select="$language"/>
        </xsl:call-template>


        <fo:table table-layout="fixed" width="100%" space-before="4mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2.0mm"/>
            <fo:table-column column-width="178.5mm"/>
            <!-- 173.5mm -->
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block text-align="right">2.</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:table table-layout="fixed" width="100%">
                            <fo:table-column column-width="27.5mm"/>
                            <fo:table-column column-width="5.0mm"/>
                            <fo:table-column column-width="28.0mm"/>
                            <!-- 27.0mm -->
                            <fo:table-column column-width="114.0mm"/>
                            <!-- 115.0mm -->
                            <fo:table-body>
                                <fo:table-row height="{$inputCellHeight}">
                                    <fo:table-cell font-size="7pt">
                                        <fo:block><!--Gehaltsnebenleistungen-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block><!--Prestations salariales accessoires-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block><!--Prestazioni accessorie al salario-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell display-align="before">
                                        <fo:block>2.3</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell display-align="before">
                                        <fo:block font-size="7pt"><!--Andere - Autres - Altre-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2_3</xsl:with-param>
                                            </xsl:call-template>
                                            -<!--&#160;-&#160;-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2_3</xsl:with-param>
                                            </xsl:call-template>
                                            -<!--&#160;-&#160;-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2_3</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block font-size="6pt"><!--Art - Genre - Genere-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                                        <fo:block text-align="start" text-indent="0mm" padding-top="1mm"
                                                  padding-bottom="1mm" start-indent="1mm" end-indent="1mm">
                                            <xsl:value-of select="$ziffer2.3_2"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>


        <fo:table table-layout="fixed" width="100%" space-before="1mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2mm"/>
            <fo:table-column column-width="99.3mm"/>
            <fo:table-column column-width="74.2mm"/>
            <fo:table-body>
                <fo:table-row keep-together.within-page="always">
                    <fo:table-cell number-rows-spanned="2" display-align="before">
                        <fo:block text-align="right">3.</fo:block>
                    </fo:table-cell>
                    <fo:table-cell number-rows-spanned="2">
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block
                                font-size="7pt"><!--Unregelmässige Leistungen - Prestations non périodiques - Prestazioni aperiodiche-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblPkt3</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblPkt3</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblPkt3</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block font-size="6pt"><!--Art - Genre - Genere-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row height="{$inputCellHeight}">
                    <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="inputCell">
                        <fo:block text-align="start" text-indent="0mm" padding-top="1mm" padding-bottom="1mm"
                                  start-indent="1mm" end-indent="1mm">
                            <xsl:value-of select="$ziffer3_2"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <fo:table table-layout="fixed" width="100%" space-before="1mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2.0mm"/>
            <fo:table-column column-width="75.5mm"/>
            <fo:table-column column-width="98.0mm"/>
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}" keep-together.within-page="always">
                    <fo:table-cell display-align="before">
                        <fo:block text-align="right">4.</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell display-align="before">
                        <fo:block
                                font-size="7pt"><!--Kapitalleistungen - Prestations en capital - Prestazioni in capitale-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblPkt4</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblPkt4</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblPkt4</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block font-size="6pt"><!--Art - Genre - Genere-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-align="start" text-indent="0mm" padding-top="1mm" padding-bottom="1mm"
                                  start-indent="1mm" end-indent="1mm">
                            <xsl:value-of select="$ziffer4_2"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <fo:table table-layout="fixed" width="100%" space-before="1mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2.0mm"/>
            <fo:table-column column-width="32.5mm"/>
            <fo:table-column column-width="141.0mm"/>
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}" keep-together.within-page="always">
                    <fo:table-cell display-align="before">
                        <fo:block text-align="right">7.</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:table table-layout="fixed" width="100%" display-align="before">
                            <fo:table-column column-width="23.0mm"/>
                            <fo:table-column column-width="9.5mm"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Andere Leistungen-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt7</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6pt"><!--Art-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Autres prestations-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt7</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6pt"><!--Genre-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Altre prestazioni-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt7</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6pt"><!--Genere-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-align="start" text-indent="0mm" padding-top="1mm" padding-bottom="1mm"
                                  start-indent="1mm" end-indent="1mm">
                            <xsl:value-of select="$ziffer7_2"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <fo:table table-layout="fixed" width="100%" space-before="1mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2.0mm"/>
            <fo:table-column column-width="173.5mm"/>
            <fo:table-body>
                <fo:table-row keep-together.within-page="always">
                    <fo:table-cell number-rows-spanned="2">
                        <fo:block text-align="right">13.</fo:block>
                    </fo:table-cell>
                    <fo:table-cell number-rows-spanned="2">
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block
                                font-size="7pt"><!--Spesenvergütungen - Allocations pour frais - Indennità per spese-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblPkt13_a</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblPkt13_a</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblPkt13_a</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block font-size="5pt"><!--Nicht im Bruttolohn (gemäss Ziffer 8) enthalten - Non comprises dans
                            le salaire brut (au chiffre 8) - Non comprese nel salario lordo (sotto cifra 8)-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblPkt13_b</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblPkt13_b</xsl:with-param>
                            </xsl:call-template>
                            &#160;-&#160;
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblPkt13_b</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row keep-together.within-page="always">
                    <fo:table-cell space-before="1mm">
                        <fo:table table-layout="fixed" width="100%" space-before="1mm">      <!-- 100% = 173.5mm -->
                            <fo:table-column column-width="7mm"/>
                            <fo:table-column column-width="21.5mm"/>
                            <fo:table-column column-width="7mm"/>
                            <fo:table-column column-width="31.0mm"/>
                            <fo:table-column column-width="107.0mm"/>
                            <fo:table-body>
                                <fo:table-row height="{$inputCellHeight}"  keep-together.within-page="always">
                                    <fo:table-cell>
                                        <fo:block font-size="7pt">13.1</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Effektive Spesen-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block font-size="7pt"><!--Frais effectifs-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block font-size="7pt"><!--Spese effettive-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell display-align="before">
                                        <fo:block font-size="6.5pt" space-before="1mm">13.1.2</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6.5pt"><!--Übrige - Autres - Altre-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block font-size="5.5pt"><!--Art - Genre - Genere-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                                        <fo:block text-align="start" text-indent="0mm" padding-top="1mm"
                                                  padding-bottom="1mm" start-indent="1mm" end-indent="1mm">
                                            <xsl:value-of select="$ziffer13.1.2_2"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row height="1mm">
                                    <fo:table-cell number-columns-spanned="5">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row height="{$inputCellHeight}">
                                    <fo:table-cell>
                                        <fo:block font-size="7pt">13.2</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Pauschalspesen-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block font-size="7pt"><!--Frais forfaitaires-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block font-size="7pt"><!--Spese forfettarie-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell display-align="before">
                                        <fo:block font-size="6.5pt">13.2.3</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6.5pt"><!--Übrige - Autres - Altre-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt13_1_2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                        <fo:block font-size="5.5pt"><!--Art - Genre - Genere-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                            &#160;-&#160;
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                                        <fo:block text-align="start" text-indent="0mm" padding-top="1mm"
                                                  padding-bottom="1mm" start-indent="1mm" end-indent="1mm">
                                            <xsl:value-of select="$ziffer13.2.3_2"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <fo:table table-layout="fixed" width="100%" space-before="1mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2.0mm"/>
            <fo:table-column column-width="47.5mm"/>
            <fo:table-column column-width="126.0mm"/>
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}"  keep-together.within-page="always">
                    <fo:table-cell>
                        <fo:block text-align="right">14.</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:table table-layout="fixed" width="100%">
                            <fo:table-column column-width="38.5mm"/>
                            <fo:table-column column-width="9.0mm"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Gehaltsnebenleistungen-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6pt"><!--Art-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">1</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Prestations salariales accessoires-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6pt"><!--Genre-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">2</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block font-size="7pt"><!--Prestazioni accessorie al salario-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblPkt2</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block font-size="6pt"><!--Genere-->
                                            <xsl:call-template name="getLabel">
                                                <xsl:with-param name="langNr">3</xsl:with-param>
                                                <xsl:with-param name="key">lblArt_Genre_Genere</xsl:with-param>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="inputCell">
                        <fo:block text-align="start" text-indent="0mm" padding-top="1mm" padding-bottom="1mm"
                                  start-indent="1mm" end-indent="1mm">
                            <xsl:value-of select="$ziffer14_3"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row height="1mm">
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <fo:table table-layout="fixed" width="100%" space-before="1mm">
            <fo:table-column column-width="3mm"/>
            <fo:table-column column-width="2.0mm"/>
            <fo:table-column column-width="20.0mm"/>
            <fo:table-column column-width="153.5mm"/>
            <fo:table-body>
                <fo:table-row height="{$inputCellHeight}" keep-together.within-page="always">
                    <fo:table-cell>
                        <fo:block text-align="right">15.</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block font-size="7pt"><!--Bemerkungen-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">1</xsl:with-param>
                                <xsl:with-param name="key">lblPkt15</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block font-size="7pt"><!--Observations-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">2</xsl:with-param>
                                <xsl:with-param name="key">lblPkt15</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                        <fo:block font-size="7pt"><!--Observazioni-->
                            <xsl:call-template name="getLabel">
                                <xsl:with-param name="langNr">3</xsl:with-param>
                                <xsl:with-param name="key">lblPkt15</xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>

                    <xsl:choose>
                        <xsl:when test="string-length($ziffer15_3) &gt; 3000">
                            <fo:table-cell xsl:use-attribute-sets="inputCellSmall">
                                <fo:block text-align="start" text-indent="0mm" padding-top="1mm" padding-bottom="1mm"
                                          start-indent="1mm" end-indent="1mm">
                                    <xsl:variable name="ziffer15max" select="concat(substring($ziffer15_3, 1, 3000), '...')"/>
                                    <xsl:for-each select="exslt:split($ziffer15max, '#')">
                                        <fo:block>
                                            <xsl:value-of select="."/>
                                        </fo:block>
                                    </xsl:for-each>
                                </fo:block>
                            </fo:table-cell>
                        </xsl:when>
                        <xsl:when test="string-length($ziffer15_3) &gt; 2000">
                            <fo:table-cell xsl:use-attribute-sets="inputCellSmall">
                                <xsl:call-template name="printZiffer15secondPage">
                                    <xsl:with-param name="ziffer15_3" select="$ziffer15_3"/>
                                </xsl:call-template>
                            </fo:table-cell>
                        </xsl:when>
                        <xsl:otherwise>
                            <fo:table-cell xsl:use-attribute-sets="inputCell">
                                <xsl:call-template name="printZiffer15secondPage">
                                    <xsl:with-param name="ziffer15_3" select="$ziffer15_3"/>
                                </xsl:call-template>
                            </fo:table-cell>
                        </xsl:otherwise>
                    </xsl:choose>

                </fo:table-row>
            </fo:table-body>
        </fo:table>

        <!--        <xsl:variable name="xmlSrcVersionMajor" select="namespace-uri(//*[local-name()='SalaryDeclaration'])"/>
                <xsl:variable name="xmlSrcVersionMinor" select="//*[local-name()='SalaryDeclarations']/@schemaVersion"/>
        -->
        <xsl:call-template name="getSingleLineFooter">
            <!--            <xsl:with-param name="xmlSrcVersionMajor" select="$xmlSrcVersionMajor"/>
                        <xsl:with-param name="xmlSrcVersionMinor" select="//*[local-name()='SalaryDeclarations']/@schemaVersion"/>
            -->
            <xsl:with-param name="PageCount" select="$PageCount"/>
            <xsl:with-param name="PageNr" select="2"/>
        </xsl:call-template>

        <xsl:call-template name="footer">
            <xsl:with-param name="SignatureCheckInfo" select="$SignatureCheckInfo"/>
            <xsl:with-param name="SignatureCheckInfoImage" select="$SignatureCheckInfoImage"/>
            <xsl:with-param name="CompanySig" select="$CompanySig"/>
            <xsl:with-param name="IssuerSig" select="$IssuerSig"/>
            <xsl:with-param name="language" select="$language"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="printZiffer15secondPage">
        <xsl:param name="ziffer15_3"/>
        <fo:block text-align="start" text-indent="0mm" padding-top="1mm" padding-bottom="1mm"
                  start-indent="1mm" end-indent="1mm">
            <xsl:choose>
                <xsl:when test="$Generator='Viewgen'">
                    <xsl:for-each select="exslt:split($ziffer15_3, '#')">
                        <fo:block>
                            <xsl:value-of select="."/>
                        </fo:block>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>  <!-- Die Variante für .NET => $Generator == 'Viewgen.NET' ! -->
                    <xsl:variable name="splitZ15">
                        <xsl:call-template name="strSplit">
                            <xsl:with-param name="string" select="$ziffer15_3"/>
                            <xsl:with-param name="pattern" select="'#'"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:for-each select="msxsl:node-set($splitZ15)">
                        <fo:block>
                            <xsl:value-of select="."/>
                        </fo:block>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
        </fo:block>
    </xsl:template>

    <xsl:template name="endPage">

        <fo:page-sequence master-reference="TaxAccountingForm" force-page-count="no-force">
            <fo:static-content flow-name="Corner">
                <xsl:call-template name="getCorner"/>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body" font-size="8pt">

                <xsl:variable name="xmlFile">
                    <xsl:call-template name="substring-after-last">
                        <xsl:with-param name="string" select="$filename"/>
                        <xsl:with-param name="delimiter" select="'/'"/>
                    </xsl:call-template>
                </xsl:variable>

                <xsl:call-template name="printMessage">
                    <xsl:with-param name="message" select="'[TaxAccountingForm.xsl:Info] start template endPage ...'"/>
                </xsl:call-template>

                <fo:block font-weight="bold" font-size="20.5pt">*************** END-PAGE ***************</fo:block>
                <fo:block font-size="18.5pt">SalaryDeclaration Information:</fo:block>
                <fo:block font-size="16.5pt">
                    count: Person =
                    <xsl:value-of select="count(//*[local-name()='Person'])"/>
                </fo:block>
                <fo:block font-size="16.5pt">
                    count: TaxSalaries =
                    <xsl:value-of select="count(//*[local-name()='TaxSalaries'])"/>
                </fo:block>
                <fo:block font-size="16.5pt">
                    count: TaxAnnuity =
                    <xsl:value-of select="count(//*[local-name()='TaxAnnuity'])"/>
                </fo:block>
                <fo:block font-size="16.5pt">
                    count: TaxSalary =
                    <xsl:value-of select="count(//*[local-name()='TaxSalary'])"/>
                </fo:block>
                <fo:block font-size="16.5pt">
                    count: TaxSalary|TaxAnnuity =
                    <xsl:value-of select="count(//*[local-name()='TaxSalary']|//*[local-name()='TaxAnnuity'])"/>
                </fo:block>
                <fo:block font-size="18.5pt">Additional Information:</fo:block>
                <fo:block font-size="16.5pt">
                    Info: Stylesheet used = TaxAccountingForm.xsl
                </fo:block>
                <fo:block font-size="16.5pt">
                    Info: File used for transformation =
                    <xsl:value-of select="$xmlFile"/>
                </fo:block>
                <fo:block font-size="16.5pt">
                    Info xsl:version =
                    <xsl:value-of select="system-property('xsl:version')"/>
                </fo:block>
                <fo:block font-size="16.5pt">
                    Info xsl:vendor =
                    <xsl:value-of select="system-property('xsl:vendor')"/>
                </fo:block>
                <fo:block font-size="16.5pt">
                    Info xsl:vendor-url =
                    <xsl:value-of select="system-property('xsl:vendor-url')"/>
                </fo:block>
                <fo:block font-size="16.5pt">itServe ag</fo:block>

                <!--        <xsl:variable name="xmlSrcVersionMajor" select="namespace-uri(//*[local-name()='SalaryDeclaration'])"/>
                        <xsl:variable name="xmlSrcVersionMinor" select="//*[local-name()='SalaryDeclarations']/@schemaVersion"/>
                -->
                <xsl:call-template name="getSingleLineFooter">
                    <!--            <xsl:with-param name="xmlSrcVersionMajor" select="$xmlSrcVersionMajor"/>
                                <xsl:with-param name="xmlSrcVersionMinor" select="//*[local-name()='SalaryDeclarations']/@schemaVersion"/>
                    -->
                    <xsl:with-param name="PageCount" select="''"/>
                </xsl:call-template>
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>

    <!--<xsl:template name="nodeInfoText">-->
    <!--<xsl:param name="aNode"/>-->
    <!--!nodeInfo!name:&#160;-->
    <!--<xsl:value-of select="name($aNode)"/>-->
    <!--            !position:&#160;-->
    <!--            <xsl:value-of select="position()"/>-->
    <!--            !last:&#160;-->
    <!--            <xsl:value-of select="last()"/>-->
    <!--            !count:&#160;-->
    <!--            <xsl:value-of select="count($aNode)"/>-->
    <!--&#160;!!-->
    <!--</xsl:template>-->

    <!--<xsl:template name="getSignature">-->
    <!--<xsl:param name="aData"/>-->
    <!--<xsl:value-of select="$ownerSig">-->
    <!--</xsl:value-of>-->
    <!--<xsl:fallback>-->
    <!--<xsl:value-of select="'error xjTst nicht verfuegbar'"/>-->
    <!--</xsl:fallback>-->
    <!--</xsl:template>-->

    <xsl:template name="getSignatureCheckResult">
        <xsl:param name="language"/>

        <xsl:variable name="txtSigValid">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="'txtSigValid'"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtNoSig">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="'txtNoSig'"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtSigBroken">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="'txtSigBroken'"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtSigNoCheck">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="'txtSigNoCheck'"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="txtSigError">
            <xsl:apply-templates select="$stdr-var">
                <xsl:with-param name="lang" select="$language"/>
                <xsl:with-param name="key" select="'txtSigError'"/>
            </xsl:apply-templates>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="contains($sigValue, 'correct')">
                <xsl:value-of select="$txtSigValid"/>
            </xsl:when>
            <xsl:when test="contains($sigValue, 'broken')">
                <xsl:value-of select="$txtSigBroken"/>
            </xsl:when>
            <xsl:when test="contains($sigValue, 'noCheck')">
                <xsl:value-of select="$txtSigNoCheck"/>
            </xsl:when>
            <xsl:when test="contains($sigValue, 'noSig')">
                <xsl:value-of select="$txtNoSig"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$txtSigError"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="substring-after-last">
        <xsl:param name="string"/>
        <xsl:param name="delimiter"/>
        <xsl:choose>
            <xsl:when test="contains($string, $delimiter)">
                <xsl:call-template name="substring-after-last">
                    <xsl:with-param name="string"
                                    select="substring-after($string, $delimiter)"/>
                    <xsl:with-param name="delimiter" select="$delimiter"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$string"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="format-date">
        <xsl:param name="date"/>
        <xsl:value-of select="substring($date, 9, 2)"/>
        <xsl:text>.</xsl:text>
        <xsl:value-of select="substring($date, 6, 2)"/>
        <xsl:text>.</xsl:text>
        <xsl:value-of select="substring($date, 1, 4)"/>
    </xsl:template>

    <xsl:template name="lastIndexOf">
        <xsl:param name="string"/>
        <xsl:param name="char"/>
        <xsl:param name="index" select="0"/>
        <xsl:choose>
            <!-- if the string contains the character... -->
            <xsl:when test="contains($string, $char)">
                <!-- call the template recursively... -->
                <xsl:call-template name="lastIndexOf">
                    <!-- with the string being the string after the character -->
                    <xsl:with-param name="string" select="substring-after($string, $char)"/>
                    <!-- and the character being the same as before -->
                    <xsl:with-param name="char" select="$char"/>
                    <xsl:with-param name="index" select="$index + string-length(substring-before($string, $char)) + 1"/>
                </xsl:call-template>
            </xsl:when>
            <!-- otherwise, return the value of the string -->
            <xsl:otherwise>
                <xsl:value-of select="$index"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="printLine">
        <xsl:param name="string"/>
        <xsl:choose>
            <xsl:when test="$niceformatting='true'">
                <xsl:variable name="index">
                    <xsl:call-template name="lastIndexOf">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="char" select="' '"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="$index &gt; 0">
                        <xsl:value-of select="concat(substring($string, 1, $index), ' &#187;')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($string, ' &#187;')"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat($string, ' &#187;')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="printLine2">
        <xsl:param name="string"/>
        <xsl:choose>
            <xsl:when test="$niceformatting='true'">
                <xsl:variable name="index">
                    <xsl:call-template name="lastIndexOf">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="char" select="' '"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="$index &gt; 0">
                        <xsl:value-of select="substring($string, 1, $index)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$string"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$string"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="printMessage">
        <xsl:param name="message"/>
        <xsl:if test="$verbose='true'">
            <xsl:message>
                <xsl:value-of select="$message"/>
            </xsl:message>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
