<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	 xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/4" xmlns:eahv-iv-2469-common="http://www.eahv-iv.ch/xmlns/eahv-iv-2469-common/1"
	 xmlns:eCH-0058="http://www.ech.ch/xmlns/eCH-0058/5" xmlns:common="http://www.eahv-iv.ch/xmlns/eahv-iv-2469-common/1"
	 xmlns:eahv-iv-2469-000501="http://www.eahv-iv.ch/xmlns/eahv-iv-2469-000501/1">
	<xsl:import href="../../eahv-iv-common/4/eahv-iv-common-4-0_fr.xsl"/>
	<xsl:import href="2469-000501-language-1-0_fr.xsl"/>
	<!-- Parameter receipt date to be passed in when creating the message layout. This must be a valid xs:date -->
	<xsl:param name="dateOfReceipt"/>
	<!-- override the description-column-table-width variable so that the list of the attachments won't be positioned too right. -->
	<xsl:variable name="description-column-table-width">		52mm</xsl:variable>
	<!-- The main template, defining page masters, sequence masters and page sequence -->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2469-000501:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2469-000501:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2469-000501:header" mode="message-header-block"/>
					<xsl:apply-templates select="//eahv-iv-2469-000501:header" mode="special-message"/>
					<xsl:apply-templates select="//eahv-iv-2469-000501:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2469-000501:header"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!-- Fixed header block on page one -->
	<xsl:template match="eahv-iv-2469-000501:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-2469-000501"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->

								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.senderId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id">
																<xsl:value-of select="eahv-iv-2469-common:senderId"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.recipientId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="eahv-iv-2469-common:recipientId">
															<xsl:if test="position() != 1">
																<xsl:text>, </xsl:text>
															</xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id">
																	<xsl:value-of select="."/>
																</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2469-000501.messageDate"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value">
																<xsl:value-of select="eahv-iv-2469-common:messageDate"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2469-000501.action"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="eahv-iv-2469-common:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2469-000501.messageId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="eahv-iv-2469-common:messageId"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2469-000501.messageType"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="eahv-iv-2469-common:messageType"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eCH-0058.manufacturer"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="eahv-iv-2469-common:sendingApplication/eCH-0058:manufacturer"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eCH-0058.product"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="eahv-iv-2469-common:sendingApplication/eCH-0058:product"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eCH-0058.productVersion"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="eahv-iv-2469-common:sendingApplication/eCH-0058:productVersion"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.pages"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<fo:page-number-citation ref-id="pageCounter"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.attachment"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(eahv-iv-2469-000501:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!-- Conditional "Alert" if there is something special about this message -->
	<xsl:template match="eahv-iv-2469-000501:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2469-000501:testDeliveryFlag = '1') or (eahv-iv-2469-000501:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="eahv-iv-2469-000501:action != 1 and eahv-iv-2469-000501:action != 5 and eahv-iv-2469-000501:action != 6"/>
		<xsl:variable name="is-priority" select="eahv-iv-2469-000501:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}"
				 space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2469-000501:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2469-000501.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- Cover sheet: further information from the header part of the message -->
	<xsl:template match="eahv-iv-2469-000501:header">
		<xsl:apply-templates select="../eahv-iv-2469-000501:content"/>
	</xsl:template>
	<!-- Cover sheet: extension from the message header 
			There is !unfortunatly! a tag of different type also named content!!, so we have to filter the one we want here -->
	<xsl:template match="eahv-iv-2469-000501:content[eahv-iv-2469-000501:businessCaseIdRPC]">
		<xsl:apply-templates select="eahv-iv-2469-000501:businessCaseIdRPC"/>
		<!-- foreach eahv-iv-2469-000501:decisionReturned -->
		<xsl:for-each select="eahv-iv-2469-000501:decisionReturned">
			<xsl:call-template name="title-item">
				<xsl:with-param name="pos" select="position()"/>
			</xsl:call-template>
			<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
				<fo:table-column column-width="{$title-column-width}" column-number="1"/>
				<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2469-000501:decisionId"/>
					<xsl:apply-templates select="eahv-iv-2469-000501:vn"/>
					<xsl:apply-templates select="eahv-iv-2469-000501:deliveryOffice/common:elOffice"/>
					<xsl:apply-templates select="eahv-iv-2469-000501:deliveryOffice/common:elAgency"/>
					<xsl:apply-templates select="eahv-iv-2469-000501:receiptMonth"/>
				</fo:table-body>
			</fo:table>
			<xsl:apply-templates select="eahv-iv-2469-000501:violatedPlausibilityGeneral"/>
			<xsl:apply-templates select="eahv-iv-2469-000501:violatedPlausibilityPerson"/>
			<xsl:apply-templates select="eahv-iv-2469-000501:overlapInformation"/>
		</xsl:for-each>
		<!-- END foreach eahv-iv-2469-000501:decisionReturned -->
	</xsl:template>
	<!-- Page header, shows the message subject in a bar on first page and as header in subsequent pages. -->
	<xsl:template mode="page-header" match="eahv-iv-2469-000501:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-family="{$font-family}" font-weight="bold">
							<xsl:value-of select="$eahv-iv-2469-000501.businessCaseIdRPC"/>
							<xsl:value-of select="../eahv-iv-2469-000501:content/eahv-iv-2469-000501:businessCaseIdRPC"/>
							<xsl:if test="count(common:subject) > 0">								| 
								<xsl:value-of select="common:subject"/>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Page footer, shows page numbers and some info from message header. -->
	<xsl:template mode="page-footer" match="eahv-iv-2469-000501:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="common:messageType"/>
							<xsl:value-of select="eahv-iv-2469-000501:subMessageType"/>
							<xsl:value-of select="concat($eahv-iv-2469-000501.messageId, ' ')"/>
							<xsl:value-of select="common:messageId"/>
							<xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/>
							<xsl:call-template name="format-date">
								<xsl:with-param name="value">
									<xsl:value-of select="$dateOfReceipt"/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>
							<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, businessCaseIdRPC
	-->
	<xsl:template match="eahv-iv-2469-000501:businessCaseIdRPC">
		<xsl:call-template name="single-string-block">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.businessCaseId"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	<!-- 
		Message content, decisionId
	-->
	<xsl:template match="eahv-iv-2469-000501:decisionId">
		<xsl:call-template name="simple-table-row">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.decisionId"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	<!-- 
		Message content, vn
	-->
	<xsl:template match="eahv-iv-2469-000501:vn">
		<xsl:variable name="formatted">
			<xsl:call-template name="format-vnType">
				<xsl:with-param name="value" select="."/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="simple-table-row">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.vn"/>
			<xsl:with-param name="value" select="$formatted"/>
		</xsl:call-template>
	</xsl:template>
	<!-- 
		Message content, elOffice
	-->
	<xsl:template match="common:elOffice">
		<xsl:call-template name="simple-table-row">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.elOffice"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	<!-- 
		Message content, elAgency
	-->
	<xsl:template match="common:elAgency">
		<xsl:call-template name="simple-table-row">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.elAgency"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	<!-- 
		Message content, receiptMonth
	-->
	<xsl:template match="eahv-iv-2469-000501:receiptMonth">
		<xsl:call-template name="simple-table-row">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.receiptMonth"/>
			<xsl:with-param name="value">
				<xsl:call-template name="format-datePartiallyKnownType">
					<xsl:with-param name="value" select="."/>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- 
		Message content, violatedPlausibilityGeneral 
		Generate the violatedPlausibilityGeneral block.
	-->
	<xsl:template match="eahv-iv-2469-000501:violatedPlausibilityGeneral">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}"
			 border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2469-000501.violatedPlausibilityGeneral"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2469-000501:content">
									<xsl:with-param name="blank-line-first" select="'false'"/>
								</xsl:apply-templates>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, violatedPlausibilityPerson 
		Generate the violatedPlausibilityPerson block.
	-->
	<xsl:template match="eahv-iv-2469-000501:violatedPlausibilityPerson">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}"
			 border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2469-000501.violatedPlausibiltityPerson"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="second-level-with-value">
									<xsl:with-param name="title" select="$eahv-iv-2469-000501.vn"/>
									<xsl:with-param name="value">
										<xsl:call-template name="format-vnType">
											<xsl:with-param name="value" select="eahv-iv-2469-000501:vn"/>
										</xsl:call-template>
									</xsl:with-param>
								</xsl:call-template>
								<xsl:apply-templates select="eahv-iv-2469-000501:content"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, overlapInformation 
		Generate the overlapInformation block.
	-->
	<xsl:template match="eahv-iv-2469-000501:overlapInformation">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}"
			 border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2469-000501.overlapInformation"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="second-level-with-value">
									<xsl:with-param name="title" select="$eahv-iv-2469-000501.businessCaseId"/>
									<xsl:with-param name="value" select="eahv-iv-2469-000501:businessCaseIdRPC"/>
								</xsl:call-template>
								<xsl:call-template name="second-level-with-value">
									<xsl:with-param name="title" select="$eahv-iv-2469-000501.decisionId"/>
									<xsl:with-param name="value" select="eahv-iv-2469-000501:decisionId"/>
								</xsl:call-template>
								<xsl:call-template name="second-level-with-value">
									<xsl:with-param name="title" select="$eahv-iv-2469-000501.elOffice"/>
									<xsl:with-param name="value" select="eahv-iv-2469-000501:deliveryOffice/common:elOffice"/>
								</xsl:call-template>
								<xsl:if test="count(eahv-iv-2469-000501:deliveryOffice/common:elAgency) > 0">
									<xsl:call-template name="second-level-with-value">
										<xsl:with-param name="title" select="$eahv-iv-2469-000501.elAgency"/>
										<xsl:with-param name="value" select="eahv-iv-2469-000501:deliveryOffice/common:elAgency"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:call-template name="second-level-with-value">
									<xsl:with-param name="title" select="$eahv-iv-2469-000501.validFrom"/>
									<xsl:with-param name="value">
										<xsl:call-template name="format-datePartiallyKnownType">
											<xsl:with-param name="value" select="eahv-iv-2469-000501:validFrom"/>
										</xsl:call-template>
									</xsl:with-param>
								</xsl:call-template>
								<xsl:if test="count(eahv-iv-2469-000501:validTo) > 0">
									<xsl:call-template name="second-level-with-value">
										<xsl:with-param name="title" select="$eahv-iv-2469-000501.validTo"/>
										<xsl:with-param name="value">
											<xsl:call-template name="format-datePartiallyKnownType">
												<xsl:with-param name="value" select="eahv-iv-2469-000501:validTo"/>
											</xsl:call-template>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:if>
								<xsl:apply-templates select="eahv-iv-2469-000501:violatedPlausibility"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- template for plausabilityContentType -->
	<xsl:template match="eahv-iv-2469-000501:content[eahv-iv-2469-000501:PlausibilityCode] | eahv-iv-2469-000501:violatedPlausibility">
		<xsl:param name="blank-line-first" select="'true'"/>
		<xsl:if test="$blank-line-first = 'true'">
			<xsl:call-template name="second-level-with-value">
				<xsl:with-param name="title" select="' '"/>
				<xsl:with-param name="value" select="' '"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:call-template name="second-level-with-value">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.PlausibilityCode"/>
			<xsl:with-param name="value" select="eahv-iv-2469-000501:PlausibilityCode"/>
		</xsl:call-template>
		<xsl:call-template name="second-level-with-value">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.PlausibilityCategory"/>
			<xsl:with-param name="value" select="eahv-iv-2469-000501:PlausibilityCategory"/>
		</xsl:call-template>
		<xsl:call-template name="second-level-with-value">
			<xsl:with-param name="title" select="$eahv-iv-2469-000501.PlausibilityType"/>
			<xsl:with-param name="value" select="eahv-iv-2469-000501:PlausibilityType"/>
		</xsl:call-template>
	</xsl:template>
	<!-- template to create the decisionReturned title -->
	<xsl:template name="title-item">
		<xsl:param name="pos"/>
		<xsl:variable name="break">
			<xsl:choose>
				<xsl:when test="$pos=1">auto</xsl:when>
				<xsl:otherwise>always</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<fo:block margin-left="0mm" padding="1mm" padding-left="0mm" padding-right="0mm" space-after="1mm"
			 font-family="{$font-family}" font-weight="bold" page-break-before="{$break}">
			<xsl:value-of select="$eahv-iv-2469-000501.decisionReturned"/>
		</fo:block>
	</xsl:template>
	<!-- helper template for formatting second-level stuff -->
	<xsl:template name="second-level-with-value">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$title"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="$value"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template name="simple-table-row">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
				<fo:block>
					<xsl:value-of select="$title"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="$value"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
</xsl:stylesheet>
