<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/4"
                xmlns:eahv-iv-2402-common="http://www.eahv-iv.ch/xmlns/eahv-iv-2402-common/4"
                xmlns:sl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:import href="../../eahv-iv-common/4/eahv-iv-common-4-0_de.xsl"/>
	<xsl:import href="eahv-iv-2402-common-language-4-0_de.xsl"/>
	
	
	<xsl:template match="eahv-iv-2402-common:contactInformation" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:email"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:other"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>

    <xsl:template match="eahv-iv-2402-common:id">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.compensationFundId"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:citizenshipCountry">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.country"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:affiliateID">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.compensationFundAffiliateId"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:organisationName">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.organisationName"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:nameDe">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.compensationFundName"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>


    <xsl:template match="eahv-iv-2402-common:titleDe">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.country"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:startDate">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.startDate"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:endDate">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.endDate"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:decisionVerdict">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.decisionVerdict"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                    <xsl:call-template name="decode-VerdictDecision">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
        
    <xsl:template match="eahv-iv-2402-common:article">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.decisionArticle"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="eahv-iv-2402-common:titleDe"/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="decode-VerdictDecision">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:text> (</xsl:text>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2402-common.open"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2402-common.accepted"/></xsl:when>
            <xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2402-common.partiallyAccepted"/></xsl:when>
            <xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2402-common.declined"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
    	<xsl:text>)</xsl:text>
	</xsl:template>
    
    <xsl:template name="decode-documentType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '01.01.12'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.01.12"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.10.01'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.01"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.10.02'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.02"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.10.03'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.03"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.10.04'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.04"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.10.05'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.05"/></xsl:when>
            <xsl:when test="$trimmed-value = '01.13.10.06'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.06"/></xsl:when>
            <xsl:when test="$trimmed-value = '01.13.10.07'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.07"/></xsl:when>
            <xsl:when test="$trimmed-value = '01.13.10.08'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.08"/></xsl:when>
            <xsl:when test="$trimmed-value = '01.13.10.09'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.10.09"/></xsl:when>
            <xsl:when test="$trimmed-value = '01.01.16.02'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.01.16.02"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
 	</xsl:template>

    <!-- helper template for formatting eahv-iv-2402-common.officialName -->
    <xsl:template match="eahv-iv-2402-common:officialName">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-common.officialName"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    <!-- helper template for formatting eahv-iv-2402-common.name -->
    <xsl:template match="eahv-iv-2402-common:name">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-common.name"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    <!-- helper template for formatting eahv-iv-2402-common.firstName -->
    <xsl:template match="eahv-iv-2402-common:firstName">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-common.firstName"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    <!-- helper template for formatting eahv-iv-2402-common.sex -->
    <xsl:template match="eahv-iv-2402-common:sex">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-common.sex"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="decode-sexType">
                        <xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    <!-- helper template for formatting eahv-iv-2402-common.dateOfBirth -->
    <xsl:template match="eahv-iv-2402-common:dateOfBirth">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-common.dateOfBirth"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="format-datePartiallyKnownType">
                        <xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:compensationFund">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.compensationFund"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="eahv-iv-2402-common:id"/>
                    <xsl:if test="eahv-iv-2402-common:nameDe">
                        <xsl:text> - </xsl:text>
                        <xsl:value-of select="eahv-iv-2402-common:nameDe" />
                    </xsl:if>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:organisationUID">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.organisationUID"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="eahv-iv-2402-common:UID"/>
                    <xsl:if test="eahv-iv-2402-common:UIDType">
                        <xsl:text> - </xsl:text>
                        <xsl:value-of select="eahv-iv-2402-common:UIDType"/>
                    </xsl:if>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:caseType">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.caseType"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:memberStateWhichLegislationApplies">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.memberStateWhichLegislationApplies"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:alpsId">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.alpsID"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:relatedAlpsId">
        <xsl:for-each select=".">
            <fo:table-row>
                <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                    <fo:block>
                        <xsl:if test="count(preceding-sibling::eahv-iv-2402-common:relatedAlpsId) = 0">
                            <xsl:value-of select="$eahv-iv-2402-common.relatedAlpsID" />
                        </xsl:if>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                    <fo:block>
                        <xsl:value-of select="."/>
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
        </xsl:for-each>
    </xsl:template>


    <xsl:template match="eahv-iv-2402-common:roleOfCH">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.roleOfCH"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:variable name="value" select="."/>
                    <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
                    <xsl:choose>
                        <xsl:when test="$trimmed-value = 'CO'"><xsl:value-of select="$eahv-iv-2402-common.roleofch.CO"/></xsl:when>
                        <xsl:when test="$trimmed-value = 'CP'"><xsl:value-of select="$eahv-iv-2402-common.roleofch.CP"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
                    </xsl:choose>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:occupationKind">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.occupationKind"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:variable name="value" select="."/>
                    <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
                    <xsl:choose>
                        <xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.1"/></xsl:when>
                        <xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.2"/></xsl:when>
                        <xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.3"/></xsl:when>
                        <xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.4"/></xsl:when>
                        <xsl:when test="$trimmed-value = '5'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.5"/></xsl:when>
                        <xsl:when test="$trimmed-value = '6'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.6"/></xsl:when>
                        <xsl:when test="$trimmed-value = '7'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.7"/></xsl:when>
                        <xsl:when test="$trimmed-value = '8'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.8"/></xsl:when>
                        <xsl:when test="$trimmed-value = '99'"><xsl:value-of select="$eahv-iv-2402-common.occupationKind.99"/>
                            <xsl:if test="count(../eahv-iv-2402-common:occupationKindFreeText) = 1">
                                <xsl:text> (</xsl:text>
                                <xsl:value-of select="../eahv-iv-2402-common:occupationKindFreeText"/>
                                <xsl:text>)</xsl:text>
                            </xsl:if>
                        </xsl:when>
                        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
                    </xsl:choose>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:citizenshipCountry">
        <xsl:for-each select=".">
            <fo:table-row>
                <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                    <fo:block>
                        <xsl:if test="count(preceding-sibling::eahv-iv-2402-common:citizenshipCountry) = 0">
                            <xsl:value-of select="$eahv-iv-2402-common.citizenshipCountry" />
                        </xsl:if>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                    <fo:block>
                        <xsl:value-of select="." />
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:pin">
        <xsl:for-each select=".">
            <fo:table-row>
                <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                    <fo:block>
                        <xsl:if test="count(preceding-sibling::eahv-iv-2402-common:pin) = 0">
                            <xsl:value-of select="$eahv-iv-2402-common.pin" />
                        </xsl:if>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                    <fo:block>
                        <xsl:if test="count(eahv-iv-2402-common:vn) = 1">
                            <xsl:value-of select="eahv-iv-2402-common:vn" />
                            <xsl:text> (CH)</xsl:text>
                        </xsl:if>
                        <xsl:if test="count(eahv-iv-2402-common:extVn) = 1">
                            <xsl:value-of select="eahv-iv-2402-common:extVn" />
                            <xsl:text> (</xsl:text>
                            <xsl:value-of select="eahv-iv-2402-common:countryCode"/>
                            <xsl:text>)</xsl:text>
                        </xsl:if>
                    </fo:block>
                </fo:table-cell>
            </fo:table-row>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:address">
        <xsl:for-each select=".">

        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.address" />
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <xsl:if test="eahv-iv-2402-common:additionalAddressInfoOrPostbox">
                    <fo:block>
                        <xsl:value-of select="eahv-iv-2402-common:additionalAddressInfoOrPostbox" />
                    </fo:block>
                </xsl:if>
                <xsl:if test="eahv-iv-2402-common:streetWithNr">
                    <fo:block>
                        <xsl:value-of select="eahv-iv-2402-common:streetWithNr" />
                    </fo:block>
                </xsl:if>
                <xsl:if test="eahv-iv-2402-common:zipCode">
                    <fo:block>
                        <xsl:value-of select="eahv-iv-2402-common:zipCode" />
                    </fo:block>
                </xsl:if>
                <xsl:if test="eahv-iv-2402-common:town">
                    <fo:block>
                        <xsl:value-of select="eahv-iv-2402-common:town" />
                    </fo:block>
                </xsl:if>
                <xsl:if test="eahv-iv-2402-common:countryCode">
                    <fo:block>
                        <xsl:value-of select="eahv-iv-2402-common:countryCode" />
                    </fo:block>
                </xsl:if>
            </fo:table-cell>
        </fo:table-row>
        </xsl:for-each>
    </xsl:template>

    <!-- Decode a sex code to a human readable string. @param value the sex
    to be decoded (as defined in eCH0044-sexType and 2402) -->
    <xsl:template name="decode-sexType">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="$trimmed-value = '1' or $trimmed-value = 'M'"><xsl:value-of select="$eahv-iv-common.sex.1"/></xsl:when>
            <xsl:when test="$trimmed-value = '2' or $trimmed-value = 'F'"><xsl:value-of select="$eahv-iv-common.sex.2"/></xsl:when>
            <xsl:when test="$trimmed-value = 'unknown'"><xsl:value-of select="$eahv-iv-2402-common.sex.unknown"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
