<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/4"
	xmlns:common="http://www.eahv-iv.ch/xmlns/eahv-iv-2015-common/3"
	xmlns:eCH-0044f="http://www.ech.ch/xmlns/eCH-0044/2"
	xmlns:eahv-iv-2015-000401="http://www.eahv-iv.ch/xmlns/eahv-iv-2015-000401/3">
<!--	xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/3"  -->

	<xsl:import href="../../eahv-iv-2015-common/3/eahv-iv-2015-common-3-0_fr.xsl"/>
	<xsl:import href="../../eahv-iv-common/3/eahv-iv-common-3-0_fr.xsl"/>
	<xsl:import href="../../eahv-iv-common/3/ech-0010-4-0_fr.xsl"/>
	<xsl:import href="../../eahv-iv-common/3/sedex-id-1-0.xsl"/>
	<xsl:import href="eahv-iv-2015-000401-language-3-0_fr.xsl"/>
	
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2015-000401:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2015-000401:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2015-000401:header" mode="message-header-block"/>
					<xsl:apply-templates select="//eahv-iv-2015-000401:header" mode="special-message"/>
					<xsl:apply-templates select="//eahv-iv-2015-000401:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2015-000401:header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm" font-family="{$font-family}">
							<xsl:apply-templates select="//eahv-iv-2015-000401:content"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="eahv-iv-2015-000401:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-common"/> | <xsl:value-of select="$eahv-iv-2015-000401"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000401.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="eahv-iv-2015-000401:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000401.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="eahv-iv-2015-000401:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000401.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2015-000401:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000401.businessProcessId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-string">
															<xsl:with-param name="value" select="eahv-iv-2015-000401:businessProcessId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000401.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="eahv-iv-2015-000401:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000401.eventDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2015-000401:eventDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000401.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(eahv-iv-2015-000401:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="eahv-iv-2015-000401:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2015-000401:testDeliveryFlag = '1') or (eahv-iv-2015-000401:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="eahv-iv-2015-000401:action != 1 and eahv-iv-2015-000401:action != 5 and eahv-iv-2015-000401:action != 6"/>
		<xsl:variable name="is-priority" select="eahv-iv-2015-000401:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2015-000401:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($eahv-iv-2015-000401.messagePriority, ': ')"/>
					<xsl:value-of select="eahv-iv-2015-000401:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2015-000401.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="eahv-iv-2015-000401:header">
		<xsl:apply-templates select="eahv-iv-2015-000401:object"/>
		<xsl:apply-templates select="eahv-iv-2015-000401:comment"/>
		<xsl:if test="count(eahv-iv-2015-000401:attachment) > 0">
			<fo:table table-layout="fixed" width="100%" border-collapse="separate">
				<fo:table-column column-width="{$title-column-width}" column-number="1"/>
				<fo:table-column column-width="{$description-column-table-width}" column-number="2"/>
				<fo:table-column column-width="{$docpath-column-width}" column-number="3"/>
				<fo:table-column column-width="{$doctype-column-width}" column-number="4"/>
				<fo:table-header>
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
							<fo:block><xsl:value-of select="$eahv-iv-2015-000401.attachment"/></fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="table-denom-column">
							<fo:block/>
						</fo:table-cell>
						<fo:table-cell column-number="3" xsl:use-attribute-sets="table-title-column">
							<fo:block><xsl:value-of select="$eahv-iv-2015-000401.pathFileName"/></fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="4" xsl:use-attribute-sets="table-title-column">
							<fo:block><xsl:value-of select="$eahv-iv-2015-000401.documentFormat"/></fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-header>
				<fo:table-body>
					<xsl:for-each select="eahv-iv-2015-000401:attachment">
						<xsl:sort data-type="number" select="eahv-iv-2015-000401:sortOrder"/>
						<xsl:apply-templates select="."/>
					</xsl:for-each>
				</fo:table-body>
			</fo:table>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="eahv-iv-2015-000401:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-000401.comment"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!--
		Cover sheet: attachment list from the message header
	-->
	<xsl:template match="eahv-iv-2015-000401:attachment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
				<fo:block/>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="first-value-column">
				<fo:block>
					<xsl:value-of select="eahv-iv-2015-000401:title"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
				<xsl:for-each select="eahv-iv-2015-000401:file">
					<xsl:sort data-type="number" select="eahv-iv-2015-000401:sortOrder"/>
					<fo:block>
						<xsl:value-of select="substring-after(eahv-iv-2015-000401:pathFileName, '/')"/>
					</fo:block>
				</xsl:for-each>
			</fo:table-cell>
			<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-mime">
						<xsl:with-param name="value" select="eahv-iv-2015-000401:documentFormat"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="eahv-iv-2015-000401:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2015-000401:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="eahv-iv-2015-000401:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2015-000401:messageType"/>/<xsl:value-of select="eahv-iv-2015-000401:subMessageType"/>
							| <xsl:value-of select="concat($eahv-iv-2015-000401.messageId, ' ')"/>
							<xsl:value-of select="eahv-iv-2015-000401:messageId"/>
							<xsl:if test="eahv-iv-2015-000401:referenceMessageId">
								| <xsl:value-of select="concat($eahv-iv-2015-000401.referenceMessageId, ' ')"/>
								<xsl:value-of select="eahv-iv-2015-000401:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="eahv-iv-2015-000401:uniqueIdBusinessTransaction">
								| <xsl:value-of select="concat($eahv-iv-2015-000401.uniqueIdBusinessTransaction, ' ')"/>
								<xsl:value-of select="eahv-iv-2015-000401:uniqueIdBusinessTransaction"/>
							</xsl:if>
							| <xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		****************  Message content starts here ***************
	 -->
	
	<!-- 
		"Main" template for the message content; shows all relevant content blocks
	-->
	<xsl:template match="eahv-iv-2015-000401:content">
		<xsl:apply-templates select="eahv-iv-2015-000401:timeStamp"/>
		<xsl:apply-templates select="eahv-iv-2015-000401:deliveryOffice"/>
		<xsl:apply-templates select="eahv-iv-2015-000401:insurant"/>
		<xsl:apply-templates select="eahv-iv-2015-000401:insurantMaritalStatus"/>
		<xsl:if test="eahv-iv-2015-000401:insurantDomicile">
			<xsl:apply-templates select="eahv-iv-2015-000401:insurantDomicile"/>
		</xsl:if>
		<xsl:call-template name="other"/>
	</xsl:template>
	
	<!-- Meldende Kasse -->
	<xsl:template match="eahv-iv-2015-000401:deliveryOffice">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-common.deliveryOffice"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-common.officeIdentifier"/>
									<xsl:with-param name="value" select="common:officeIdentifier"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-common.branch"/>
									<xsl:with-param name="value" select="common:branch"/>
								</xsl:call-template>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- Insurant -->
	<xsl:template match="eahv-iv-2015-000401:insurant">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-000401.insurant"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.officialName"/>
									<xsl:with-param name="value" select="eCH-0044f:officialName"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.firstName"/>
									<xsl:with-param name="value" select="eCH-0044f:firstName"/>
								</xsl:call-template>
								<xsl:apply-templates select="eCH-0044f:firstName"/>
								<xsl:apply-templates select="eCH-0044f:sex"/>
								<xsl:apply-templates select="eCH-0044f:dateOfBirth"/>
								<xsl:apply-templates select="eCH-0044f:vn"/>
								<xsl:apply-templates select="eCH-0044f:localPersonId"/>
								<xsl:apply-templates select="eCH-0044f:otherPersonId"/>
								<xsl:apply-templates select="eCH-0044f:euPersonId"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- helper template for formatting ssk-common.sex -->
	<xsl:template match="eCH-0044f:sex">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-000401.sex"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-sexType">
						<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- helper template for formatting ssk-common.dateOfBirth -->
	<xsl:template match="eCH-0044f:dateOfBirth">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-000401.dateOfBirth"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-datePartiallyKnownType">
						<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- helper template for formatting ssk-common.vn -->
	<xsl:template match="eCH-0044f:vn">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-000401.vn"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-vnType">
						<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0044:namedPersonIdType on multiple lines -->
	<xsl:template match="eCH-0044f:localPersonId | eCH-0044f:otherPersonId | eCH-0044f:euPersonId">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:call-template name="decode-personIdCategory">
						<xsl:with-param name="value"><xsl:value-of select="eCH-0044f:personIdCategory"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-personId">
						<xsl:with-param name="id-category"><xsl:value-of select="eCH-0044f:personIdCategory"/></xsl:with-param>
						<xsl:with-param name="id"><xsl:value-of select="eCH-0044f:personId"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

	<!-- Timestamp -->
	<xsl:template match="eahv-iv-2015-000401:timeStamp">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-000401.timeStamp"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column-regular">
						<fo:block>
							<xsl:call-template name="format-timestamp">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!-- Zivilstand -->
	<xsl:template match="eahv-iv-2015-000401:insurantMaritalStatus">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column-regular">
						<fo:block>
							<xsl:call-template name="decode-maritalStatus">
								<xsl:with-param name="value" select="."/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- Domizil -->
	<xsl:template match="eahv-iv-2015-000401:insurantDomicile">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-000401.insurantDomicile"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="common:canton"/>
								<xsl:apply-templates select="common:country"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template match="common:canton">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-common.canton"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-canton">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>	
	
	<xsl:template match="common:country">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-common.country"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-country">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>	
	
	<!-- Other fields -->
	<xsl:template name="other">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-000401.eoCompensation"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.numberOfChildren"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:numberOfChildren"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.accountingMonth"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:accountingMonth"/>
								</xsl:call-template>
								<xsl:apply-templates select="eahv-iv-2015-000401:serviceType"/>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.referenceNumber"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:referenceNumber"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.controlNumber"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:controlNumber"/>
								</xsl:call-template>
								<xsl:apply-templates select="eahv-iv-2015-000401:activityBeforeService"/>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.averageDailyIncome"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:averageDailyIncome"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.startOfPeriod"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:startOfPeriod"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.endOfPeriod"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:endOfPeriod"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.numberOfDays"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:numberOfDays"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.basicDailyAmount"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:basicDailyAmount"/>
								</xsl:call-template>
								<xsl:call-template name="boolean-field">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.dailyIndemnityGuaranteeAI"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:dailyIndemnityGuaranteeAI"/>
								</xsl:call-template>
								<xsl:call-template name="boolean-field">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.allowanceFarm"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:allowanceFarm"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.allowanceCareExpenses"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:allowanceCareExpenses"/>
								</xsl:call-template>
								<xsl:call-template name="default">
									<xsl:with-param name="title" select="$eahv-iv-2015-000401.totalAPG"/>
									<xsl:with-param name="value" select="eahv-iv-2015-000401:totalAPG"/>
								</xsl:call-template>
								<xsl:apply-templates select="eahv-iv-2015-000401:paymentMethod"/>
								<xsl:if test="eahv-iv-2015-000401:breakRules">
									<xsl:apply-templates select="eahv-iv-2015-000401:breakRules"/>
								</xsl:if>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>	
	
	<xsl:template match="eahv-iv-2015-000401:serviceType">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-000401.serviceType"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-serviceType">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>	
	
	<xsl:template match="eahv-iv-2015-000401:activityBeforeService">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-000401.activityBeforeService"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-activityBeforeService">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>	
	
	<xsl:template match="eahv-iv-2015-000401:paymentMethod">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-000401.paymentMethod"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-paymentMethod">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>	
	
	<xsl:template match="eahv-iv-2015-000401:breakRules">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2015-000401.breakRules"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:apply-templates select="common:breakRuleCode" mode="inline"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="common:breakRuleCode" mode="inline">
		<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
		<xsl:value-of select="."/>
	</xsl:template>
	
	
	<!-- ************* Helper named templates *************** -->
	
	<!-- helper template for outputting an a title-value pair -->
	<xsl:template name="default">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<xsl:if test="$title and $value">
			<fo:table-row>
				<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
					<fo:block><xsl:value-of select="$title"/></fo:block>
				</fo:table-cell>
				<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
					<fo:block>
						<xsl:value-of select="$value"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:if>
	</xsl:template>	
	
	<!-- helper template for outputting an a title-value pair (with value to decode from a boolean)  -->
	<xsl:template name="boolean-field">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<xsl:if test="$title and $value">
			<fo:table-row>
				<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
					<fo:block><xsl:value-of select="$title"/></fo:block>
				</fo:table-cell>
				<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
					<fo:block>
						<xsl:call-template name="decode-boolean">
							<xsl:with-param name="value" select="$value"/>
						</xsl:call-template>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:if>
	</xsl:template>	

	<!-- ************* Decodings templates *************** -->
	
	<!--
		Decode a marital status code to a human readable string. 
		@param value the status to be decoded (as defined in common:maritalStatusType)
	-->
	<xsl:template name="decode-maritalStatus">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus.3"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus.4"/></xsl:when>
			<xsl:when test="$trimmed-value = '6'"><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus.6"/></xsl:when>
			<xsl:when test="$trimmed-value = '7'"><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus.7"/></xsl:when>
			<xsl:when test="$trimmed-value = '8'"><xsl:value-of select="$eahv-iv-2015-000401.insurantMaritalStatus.8"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>	

	<!--
		Decode a sex code to a human readable string. 
		@param value the sex to be decoded (as defined in eCH0044-sexType)
	-->
	<xsl:template name="decode-sexType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-000401.sex.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2015-000401.sex.2"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<!--
		Decode an personIdCategory to a human readable string.
		@param value the personIdCategory to be decoded (as defined in eCH-0044)
	-->
	<xsl:template name="decode-personIdCategory">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'CH.AHV'"><xsl:value-of select="$eCH-0044.personIdCategory.CH.AHV"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
		Decode an action to a human readable string.
		@param value the action to be decoded (as defined in ssk/eahv-iv)
	-->
	<xsl:template name="decode-action">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-000401.action.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2015-000401.action.3"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2015-000401.action.4"/></xsl:when>
			<xsl:when test="$trimmed-value = '7'"><xsl:value-of select="$eahv-iv-2015-000401.action.7"/></xsl:when>
			<xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eahv-iv-2015-000401.action.10"/></xsl:when>
			<xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eahv-iv-2015-000401.action.12"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
		Decode a MIME type to a human readable string.
		@param value the type to be decoded
	-->
	<xsl:template name="decode-mime">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'image/tiff'">TIFF</xsl:when>
			<xsl:when test="$trimmed-value = 'application/pdf'">PDF</xsl:when>
			<xsl:when test="$trimmed-value = 'application/zip'">ZIP</xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-activityBeforeService">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-000401.activityBeforeService.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2015-000401.activityBeforeService.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2015-000401.activityBeforeService.3"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2015-000401.activityBeforeService.4"/></xsl:when>
			<xsl:when test="$trimmed-value = '5'"><xsl:value-of select="$eahv-iv-2015-000401.activityBeforeService.5"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-serviceType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.10"/></xsl:when>
			<xsl:when test="$trimmed-value = '11'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.11"/></xsl:when>
			<xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.12"/></xsl:when>
			<xsl:when test="$trimmed-value = '13'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.13"/></xsl:when>
			<xsl:when test="$trimmed-value = '14'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.14"/></xsl:when>
			<xsl:when test="$trimmed-value = '20'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.20"/></xsl:when>
			<xsl:when test="$trimmed-value = '21'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.21"/></xsl:when>
			<xsl:when test="$trimmed-value = '22'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.22"/></xsl:when>
			<xsl:when test="$trimmed-value = '30'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.30"/></xsl:when>
			<xsl:when test="$trimmed-value = '40'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.40"/></xsl:when>
			<xsl:when test="$trimmed-value = '41'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.41"/></xsl:when>
			<xsl:when test="$trimmed-value = '50'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.50"/></xsl:when>
			<xsl:when test="$trimmed-value = '90'"><xsl:value-of select="$eahv-iv-2015-000401.serviceType.90"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-paymentMethod">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-000401.paymentMethod.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2015-000401.paymentMethod.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2015-000401.paymentMethod.3"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>