<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/3"
	xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044/1"
	xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/1"
	xmlns:eahv-iv-2010-000101="http://www.eahv-iv.ch/xmlns/eahv-iv-2010-000101/5">
	
	<xsl:import href="../../eahv-iv-common/1/eahv-iv-common-1-2_fr.xsl"/>
	<xsl:import href="2010-000101-language-5-0_fr.xsl"/>
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2010-000101:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2010-000101:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2010-000101:header" mode="message-header-block"/>
					<xsl:apply-templates select="//eahv-iv-2010-000101:header" mode="special-message"/>
					<xsl:apply-templates select="//eahv-iv-2010-000101:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<xsl:if test="count(eahv-iv-2010-000101:message) > 0">
							<xsl:attribute name="page-break-after">always</xsl:attribute>
						</xsl:if>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2010-000101:header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2010-000101:content"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="eahv-iv-2010-000101:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-common"/> | <xsl:value-of select="$eahv-iv-2010-000101"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1" />
						<fo:table-column column-width="{$header-right-column-width}" column-number="2" />
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="eahv-iv-2010-000101:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="eahv-iv-2010-000101:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2010-000101:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.declarationLocalReference"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="eahv-iv-2010-000101:declarationLocalReference" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="eahv-iv-2010-000101:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.originalSenderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id" select="eahv-iv-2010-000101:originalSenderId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.initialMessageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2010-000101:initialMessageDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2010-000101:ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2010-000101:yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.eventDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2010-000101:eventDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.eventPeriod"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-string">
															<xsl:with-param name="value" select="eahv-iv-2010-000101:eventPeriod"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2010-000101.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(eahv-iv-2010-000101:attachment)"/>
													</fo:block>
													</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="eahv-iv-2010-000101:declarationLocalReference" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:email"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="eahv-iv-2010-000101:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2010-000101:testDeliveryFlag = '1') or (eahv-iv-2010-000101:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="eahv-iv-2010-000101:action != 1 and eahv-iv-2010-000101:action != 5 and eahv-iv-2010-000101:action != 6"/>
		<xsl:variable name="is-priority" select="eahv-iv-2010-000101:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2010-000101:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($eahv-iv-2010-000101.messagePriority, ': ')"/>
					<xsl:value-of select="eahv-iv-2010-000101:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2010-000101.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="eahv-iv-2010-000101:header">
		<xsl:apply-templates select="eahv-iv-2010-000101:comment"/>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="eahv-iv-2010-000101:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.comment"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="eahv-iv-2010-000101:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2010-000101:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block />
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="eahv-iv-2010-000101:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2010-000101:messageType"/>/<xsl:value-of select="eahv-iv-2010-000101:subMessageType"/>
							| <xsl:value-of select="concat($eahv-iv-2010-000101.messageId, ' ')"/>
							<xsl:value-of select="eahv-iv-2010-000101:messageId"/>
							<xsl:if test="eahv-iv-2010-000101:referenceMessageId">
								| <xsl:value-of select="concat($eahv-iv-2010-000101.referenceMessageId, ' ')"/>
								<xsl:value-of select="eahv-iv-2010-000101:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="eahv-iv-2010-000101:businessProcessId">
								| <xsl:value-of select="concat($eahv-iv-2010-000101.businessProcessId, ' ')"/>
								<xsl:value-of select="eahv-iv-2010-000101:businessProcessId"/>
							</xsl:if>
							| <xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!-- 
		****************  Message content starts here ***************
	 -->
	
	<!-- 
		"Main" template for the message content; shows all relevant content blocks
	-->
	<xsl:template match="eahv-iv-2010-000101:content">
		<xsl:apply-templates select="eahv-iv-2010-000101:mutation" />
	</xsl:template>

	<xsl:template match="eahv-iv-2010-000101:mutation">
		<fo:block>
			<xsl:if test="position() != last()">
				<xsl:attribute name="page-break-after">always</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="eahv-iv-2010-000101:reason"/>
			<xsl:call-template name="single-string-block" >
				<xsl:with-param name="title" select="$eahv-iv-2010-000101.accountNumber" />	
				<xsl:with-param name="value" select="eahv-iv-2010-000101:accountNumber" />
			</xsl:call-template>
			<xsl:call-template name="otherOrganisationId" />
			<xsl:apply-templates select="eahv-iv-2010-000101:legalForm"/>
			<xsl:call-template name="naturalPerson" />
			<xsl:call-template name="organisationName" />
			<xsl:call-template name="single-string-block" >
				<xsl:with-param name="title" select="$eahv-iv-2010-000101.kindOfActivity" />	
				<xsl:with-param name="value" select="eahv-iv-2010-000101:kindOfActivity" />
			</xsl:call-template>
			<xsl:apply-templates select="eahv-iv-2010-000101:address" />	
			<xsl:call-template name="single-date-block" >
				<xsl:with-param name="title" select="$eahv-iv-2010-000101.dateOfValidity" />	
				<xsl:with-param name="value" select="eahv-iv-2010-000101:dateOfValidity" />
			</xsl:call-template>
			<xsl:call-template name="oasi" />
			<xsl:call-template name="fao" />
			<xsl:call-template name="returnAddressSection" />
			<xsl:call-template name="additionalObservations"/>
		</fo:block>	
	</xsl:template>

	<!-- standard template for a block containing only title and one string -->
	<xsl:template name="single-string-block">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column" >
						<fo:block><xsl:value-of select="$title"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="offset-right-column" >
						<fo:block>
							<xsl:value-of select="$value"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- standard template for a block containing only title and one date -->
	<xsl:template name="single-date-block">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$title"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="offset-right-column">
						<fo:block>
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="$value"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- Template zur Darstellung compensation office -->
	<xsl:template name="compensation-office">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$title"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:choose>
						<xsl:when test="string-length($value) = 6">
							<xsl:value-of select="concat(substring($value, 1, 3), '.', substring($value, 4, 3))"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$value"/>
						</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- Template zur Darstellung eines unformatierten Text- oder Zahlenwertes -->
	<xsl:template name="default">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$title"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="$value"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- Template zur Darstellung eines normalen Datums -->
	<xsl:template name="date">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$title"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block> 
					<xsl:call-template name="format-date">
						<xsl:with-param name="value"><xsl:value-of select="$value"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2010-000101:legalForm">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.legalForm"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="offset-right-column">
						<fo:block>
							<xsl:call-template name="decode-legalFormType">
								<xsl:with-param name="value" select="."/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Decode a legal form code to a human readable string. Unknown values are shown untranslated.
		Empty values are shown as dash.
		@param value the legal form to be decoded (as defined in eCH0097-legalFormType)
	-->
	<xsl:template name="decode-legalFormType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'A'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.A"/></xsl:when>
			<xsl:when test="$trimmed-value = 'B'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.B"/></xsl:when>
			<xsl:when test="$trimmed-value = 'C'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.C"/></xsl:when>
			<xsl:when test="$trimmed-value = 'D'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.D"/></xsl:when>
			<xsl:when test="$trimmed-value = 'E'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.E"/></xsl:when>
			<xsl:when test="$trimmed-value = 'F'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.F"/></xsl:when>
			<xsl:when test="$trimmed-value = 'G'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.G"/></xsl:when>
			<xsl:when test="$trimmed-value = 'H'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.H"/></xsl:when>
			<xsl:when test="$trimmed-value = 'I'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.I"/></xsl:when>
			<xsl:when test="$trimmed-value = 'K'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.K"/></xsl:when>
			<xsl:when test="$trimmed-value = 'L'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.L"/></xsl:when>
			<xsl:when test="$trimmed-value = 'M'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.M"/></xsl:when>
			<xsl:when test="$trimmed-value = 'N'"><xsl:value-of select="$eahv-iv-2010-000101.legalForm.N"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- 
		Generate the naturalPerson block.
	-->
	<xsl:template name="naturalPerson">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.naturalPerson"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="title"/>
								<xsl:call-template name="vn"/>
								<xsl:call-template name="dateOfBirth"/>
								<xsl:call-template name="sex"/>
								<xsl:call-template name="default" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.officialName" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:officialName" />
								</xsl:call-template>
								<xsl:call-template name="default" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.firstName" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:firstName" />
								</xsl:call-template>					
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	
	<xsl:template name="title">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2010-000101.title"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-titleCode">
						<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2010-000101:title"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>		
	<!--
		Decode a legal form code to a human readable string. Unknown values are shown untranslated.
		Empty values are shown as dash.
		@param value the legal form to be decoded (as defined in eCH0097-legalFormType)
	-->
	<xsl:template name="decode-titleCode">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2010-000101.title.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2010-000101.title.2"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="vn">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2010-000101.vn"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-vnType">
						<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2010-000101:vn"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template name="dateOfBirth">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2010-000101.dateOfBirth"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-datePartiallyKnownType">
						<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2010-000101:dateOfBirth"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template name="sex">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2010-000101.sex"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-sexType">
						<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2010-000101:sex"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

	<xsl:template name="organisationName">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.organisationName"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="default" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.organisationName1" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:organisationName1" />
								</xsl:call-template>
								<xsl:call-template name="default" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.organisationName2" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:organisationName2" />
								</xsl:call-template>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
 	
	<xsl:template name="communication">
		<xsl:param name="title"/>
		<xsl:param name="value"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$title"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-communicationCode">
						<xsl:with-param name="value" select="$value"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template name="decode-communicationCode">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'D'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.D"/></xsl:when>
			<xsl:when test="$trimmed-value = 'E'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.E"/></xsl:when>
			<xsl:when test="$trimmed-value = 'F'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.F"/></xsl:when>
			<xsl:when test="$trimmed-value = 'H'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.H"/></xsl:when>
			<xsl:when test="$trimmed-value = 'K'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.K"/></xsl:when>
			<xsl:when test="$trimmed-value = 'N'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.N"/></xsl:when>
			<xsl:when test="$trimmed-value = 'P'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.P"/></xsl:when>
			<xsl:when test="$trimmed-value = 'Q'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.Q"/></xsl:when>
			<xsl:when test="$trimmed-value = 'R'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.R"/></xsl:when>
			<xsl:when test="$trimmed-value = 'T'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.T"/></xsl:when>
			<xsl:when test="$trimmed-value = 'X'"><xsl:value-of select="$eahv-iv-2010-000101.oasiCommunication.X"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="eahv-iv-2010-000101:reason">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.reason"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-reasonCode">
								<xsl:with-param name="value" select="."/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>		
	

	<xsl:template name="decode-reasonCode">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '11'"><xsl:value-of select="$eahv-iv-2010-000101.reason.11"/></xsl:when>
			<xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eahv-iv-2010-000101.reason.12"/></xsl:when>
			<xsl:when test="$trimmed-value = '13'"><xsl:value-of select="$eahv-iv-2010-000101.reason.13"/></xsl:when>
			<xsl:when test="$trimmed-value = '14'"><xsl:value-of select="$eahv-iv-2010-000101.reason.14"/></xsl:when>
			<xsl:when test="$trimmed-value = '15'"><xsl:value-of select="$eahv-iv-2010-000101.reason.15"/></xsl:when>
			<xsl:when test="$trimmed-value = '20'"><xsl:value-of select="$eahv-iv-2010-000101.reason.20"/></xsl:when>
			<xsl:when test="$trimmed-value = '21'"><xsl:value-of select="$eahv-iv-2010-000101.reason.21"/></xsl:when>
			<xsl:when test="$trimmed-value = '22'"><xsl:value-of select="$eahv-iv-2010-000101.reason.22"/></xsl:when>
			<xsl:when test="$trimmed-value = '23'"><xsl:value-of select="$eahv-iv-2010-000101.reason.23"/></xsl:when>
			<xsl:when test="$trimmed-value = '24'"><xsl:value-of select="$eahv-iv-2010-000101.reason.24"/></xsl:when>
			<xsl:when test="$trimmed-value = '25'"><xsl:value-of select="$eahv-iv-2010-000101.reason.25"/></xsl:when>
			<xsl:when test="$trimmed-value = '31'"><xsl:value-of select="$eahv-iv-2010-000101.reason.31"/></xsl:when>
			<xsl:when test="$trimmed-value = '32'"><xsl:value-of select="$eahv-iv-2010-000101.reason.32"/></xsl:when>
			<xsl:when test="$trimmed-value = '33'"><xsl:value-of select="$eahv-iv-2010-000101.reason.33"/></xsl:when>
			<xsl:when test="$trimmed-value = '34'"><xsl:value-of select="$eahv-iv-2010-000101.reason.34"/></xsl:when>
			<xsl:when test="$trimmed-value = '35'"><xsl:value-of select="$eahv-iv-2010-000101.reason.35"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	

	<xsl:template match="eahv-iv-2010-000101:address">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.address"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="offset-right-column">
						<fo:block>
							<xsl:apply-templates select="*" mode="inline"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the oasi block.
	-->
	<xsl:template name="oasi">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.oasi"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="date" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.oasiDateOfAcceptance" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:oasiDateOfAcceptance" />
								</xsl:call-template>
								<xsl:call-template name="date" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.oasiDateOfDeletion" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:oasiDateOfDeletion" />
								</xsl:call-template>
								<xsl:call-template name="compensation-office" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.oasiCompensationOffice" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:oasiCompensationOffice" />
								</xsl:call-template>
								<xsl:call-template name="communication">
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.oasiCommunication" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:oasiCommunication" />
								</xsl:call-template>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	
	<!-- 
		Generate the oasi block.
	-->
	<xsl:template name="fao">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.fao"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="date" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.faoDateOfAcceptance" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:faoDateOfAcceptance" />
								</xsl:call-template>
								<xsl:call-template name="date" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.faoDateOfDeletion" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:faoDateOfDeletion" />
								</xsl:call-template>
								<xsl:call-template name="compensation-office" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.faoCompensationOffice" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:faoCompensationOffice" />
								</xsl:call-template>
								<xsl:call-template name="communication">
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.faoCommunication" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:faoCommunication" />
								</xsl:call-template>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template name="returnAddressSection">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.returnAddressSection"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="default" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.nameReturnAddress1" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:nameReturnAddress1" />
								</xsl:call-template>
								<xsl:call-template name="default" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.nameReturnAddress2" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:nameReturnAddress2" />
								</xsl:call-template>
								<xsl:call-template name="default" >
									<xsl:with-param name="title" select="$eahv-iv-2010-000101.nameReturnAddress3" />	
									<xsl:with-param name="value" select="eahv-iv-2010-000101:nameReturnAddress3" />
								</xsl:call-template>
								<xsl:call-template name="returnAddress" />
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template name="returnAddress">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2010-000101.returnAddress"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:apply-templates select="eahv-iv-2010-000101:returnAddress/*" mode="inline"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>	

	<xsl:template name="otherOrganisationId">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.otherOrganisationId"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:choose>
									<xsl:when test="eahv-iv-2010-000101:otherOrganisationId">
										<xsl:apply-templates select="eahv-iv-2010-000101:otherOrganisationId"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
												<fo:block/>												
											</fo:table-cell>
											<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2010-000101:otherOrganisationId">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>												
					<xsl:call-template name="decode-organisationIdCategory">
						<xsl:with-param name="value"><xsl:value-of select="eahv-iv-common:organisationIdCategory"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-organisationId">
						<xsl:with-param name="id-category"><xsl:value-of select="eahv-iv-common:organisationIdCategory"/></xsl:with-param>
						<xsl:with-param name="id"><xsl:value-of select="eahv-iv-common:OrganisationId"/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- 
		Message content, remarks
	-->
	<xsl:template name="additionalObservations">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2010-000101.additionalObservations"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="offset-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="eahv-iv-2010-000101:additionalObservations"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!-- attribute set for information block right column (block contents of fixed size blocks) -->
	<xsl:attribute-set name="offset-right-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-left">53mm</xsl:attribute>
		<xsl:attribute name="border-left-color">black</xsl:attribute>
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	
</xsl:stylesheet>