<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl" xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/4" xmlns:eahv-iv-2005-000101="http://www.eahv-iv.ch/xmlns/eahv-iv-2005-000101/6" xmlns:eCH-0058="http://www.ech.ch/xmlns/eCH-0058/5" xmlns:eCH-0097="http://www.ech.ch/xmlns/eCH-0097/6" xmlns:eahv-iv-2014-000101="http://www.eahv-iv.ch/xmlns/eahv-iv-2014-000101/1" xmlns:common-2005="http://www.eahv-iv.ch/xmlns/eahv-iv-2005-common/6" xmlns:common="http://www.eahv-iv.ch/xmlns/eahv-iv-napg-common/3">
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"/>
	<!--
		override the description-column-table-width variable so that the list of the attachments won't be positioned too right.
	-->
	<xsl:variable name="description-column-table-width">
			52mm
	</xsl:variable>
	<!--
		grey background, attribute-sets
	-->
	<xsl:variable name="greyBackground">#D3D3D3</xsl:variable>
	<xsl:attribute-set name="headingGrey">
		<xsl:attribute name="background-color">#D3D3D3</xsl:attribute>
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="padding-top">10pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="headingNormal">
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="margin-top">20pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="tableRow">
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="start-indent">1pt</xsl:attribute>
		<xsl:attribute name="text-indent">1pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="tableLine">
		<xsl:attribute name="border-bottom">1pt solid black</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="standardIndent">
		<xsl:attribute name="start-indent">0pt</xsl:attribute>
		<xsl:attribute name="text-indent">0pt</xsl:attribute>
	</xsl:attribute-set>
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2005-000101:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2005-000101:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2005-000101:header" mode="message-header-block"/>
					<xsl:apply-templates select="//eahv-iv-2005-000101:header" mode="special-message"/>
					<xsl:apply-templates select="//eahv-iv-2005-000101:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2005-000101:header"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="eahv-iv-2005-000101:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-common"/> | <xsl:value-of select="$eahv-iv-2005-000101"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2005-000101.messageDate"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value">
																<xsl:value-of select="common:messageDate"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.senderId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id">
																<xsl:value-of select="common:senderId"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.recipientId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="common:recipientId">
															<xsl:if test="position() != 1">
																<xsl:text>, </xsl:text>
															</xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id">
																	<xsl:value-of select="."/>
																</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2005-000101.contactInformation"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="eahv-iv-2005-000101:extension/eahv-iv-2005-000101:contactInformation" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2005-000101.action"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="common:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2005-000101.businessProcessId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="common:businessProcessId"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.pages"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<fo:page-number-citation ref-id="pageCounter"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2005-000101.attachment"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(common-2005:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="eahv-iv-2005-000101:contactInformation" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:email"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:other"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="eahv-iv-2005-000101:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2005-000101:testDeliveryFlag = '1') or (eahv-iv-2005-000101:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="eahv-iv-2005-000101:action != 1 and eahv-iv-2005-000101:action != 5 and eahv-iv-2005-000101:action != 6"/>
		<xsl:variable name="is-priority" select="eahv-iv-2005-000101:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2005-000101:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($eahv-iv-2005-000101.messagePriority, ': ')"/>
					<xsl:value-of select="eahv-iv-2005-000101:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2005-000101.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="eahv-iv-2005-000101:header">
		<xsl:apply-templates select="eahv-iv-2005-000101:extension"/>
		<xsl:apply-templates select="//eahv-iv-2005-000101:content"/>
		<xsl:if test="count(common-2005:attachment) > 0">
			<fo:table table-layout="fixed" width="100%" border-collapse="separate">
				<fo:table-column column-width="{$title-column-width}" column-number="1"/>
				<fo:table-column column-width="{$description-column-table-width}" column-number="2"/>
				<fo:table-column column-width="{$docpath-column-width}" column-number="3"/>
				<fo:table-column column-width="{$doctype-column-width}" column-number="4"/>
				<fo:table-header>
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
							<fo:block>
								<xsl:value-of select="$eahv-iv-2005-000101.attachment"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="table-denom-column">
							<fo:block/>
						</fo:table-cell>
						<fo:table-cell column-number="3" xsl:use-attribute-sets="table-title-column">
							<fo:block>
								<xsl:value-of select="$eahv-iv-2005-000101.pathFileName"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="4" xsl:use-attribute-sets="table-title-column">
							<fo:block>
								<xsl:value-of select="$eahv-iv-2005-000101.documentFormat"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-header>
				<fo:table-body>
					<xsl:for-each select="common-2005:attachment">
						<xsl:sort data-type="number" select="common-2005:sortOrder"/>
						<xsl:apply-templates select="."/>
					</xsl:for-each>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		<xsl:apply-templates select="eahv-iv-2005-000101:comment"/>
	</xsl:template>
	<!--
		Cover sheet: extension from the message header
	
	<xsl:template match="eahv-iv-2005-000101:content">
		<xsl:apply-templates select="eahv-iv-2005-000101:insuredPerson"/>
	</xsl:template>
	
	-->
	<!--
		Cover sheet: object field from the message header
	-->
	<xsl:template match="eahv-iv-2005-000101:insuredPerson">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2005-000101.insuredPerson"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-common:officialName"/>
								<xsl:apply-templates select="eahv-iv-common:firstName"/>
								<xsl:apply-templates select="eahv-iv-common:sex"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfBirth"/>
								<xsl:apply-templates select="eahv-iv-common:vn"/>
								<xsl:apply-templates select="eahv-iv-common:otherPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:euPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:address"/>
								<xsl:apply-templates select="eahv-iv-common:taxMunicipality"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="eahv-iv-2005-000101:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2005-000101.comment"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Cover sheet: attachment list from the message header
	-->
	<xsl:template match="common-2005:attachment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
				<fo:block/>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="first-value-column">
				<fo:block>
					<xsl:value-of select="common-2005:title"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
				<xsl:for-each select="common-2005:file">
					<xsl:sort data-type="number" select="common-2005:sortOrder"/>
					<fo:block>
						<xsl:value-of select="substring-after(common-2005:pathFileName, '/')"/>
					</fo:block>
				</xsl:for-each>
			</fo:table-cell>
			<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-mime">
						<xsl:with-param name="value" select="common-2005:documentFormat"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="eahv-iv-2005-000101:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-family="{$font-family}" font-weight="bold">
							<xsl:value-of select="eahv-iv-2005-000101:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="eahv-iv-2005-000101:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="common:messageType"/>/<xsl:value-of select="common:subMessageType"/>
							| <xsl:value-of select="concat($eahv-iv-2005-000101.messageId, ' ')"/>
							<xsl:value-of select="common:messageId"/>
							<xsl:if test="count(common:referenceMessageId) != 0">
								| <xsl:value-of select="concat($eahv-iv-2005-000101.referenceMessageId, ' ')"/>
								<xsl:value-of select="common:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="common:businessProcessId">
								| <xsl:value-of select="concat($eahv-iv-2005-000101.businessProcessId, ' ')"/>
								<xsl:value-of select="common:businessProcessId"/>
							</xsl:if>
							| <xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/>
							<xsl:call-template name="format-date">
								<xsl:with-param name="value">
									<xsl:value-of select="$dateOfReceipt"/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:content">
		<!-- Personal Information -->
		<fo:block xsl:use-attribute-sets="tableLine"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.detailsPerson"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="30pt" xsl:use-attribute-sets="tableLine"/>
		<fo:block xsl:use-attribute-sets="tableLine"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:servicePeriod"/>
<!--		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.language"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="eahv-iv-2005-000101:language"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>-->
		<xsl:apply-templates select="eahv-iv-2005-000101:servicePeriodId"/>
		<!--<xsl:apply-templates select="eahv-iv-2005-000101:compensationOfficeChoiceRule"/>-->

		<fo:block xsl:use-attribute-sets="tableLine"/>
		<fo:block xsl:use-attribute-sets="headingNormal">
			<xsl:value-of select="$eahv-iv-2005-000101.overlapServicePeriod"/>
		</fo:block>
		<fo:block xsl:use-attribute-sets="tableLine"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:overlapServicePeriod"/>
		<fo:block xsl:use-attribute-sets="headingNormal">
			<xsl:value-of select="$eahv-iv-2005-000101.assignmentsHistory"/>
		</fo:block>
		<fo:block xsl:use-attribute-sets="tableLine"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:assignmentsHistory"/>
		<fo:block margin-top="30pt" xsl:use-attribute-sets="tableLine"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.furtherDetailsPerson"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="20pt" xsl:use-attribute-sets="tableLine"/>
		<fo:block xsl:use-attribute-sets="headingNormal">
			<xsl:value-of select="$eahv-iv-2005-000101.detailsFamily"/>
		</fo:block>
		<fo:block xsl:use-attribute-sets="tableLine"/>
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.numberChildren"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:call-template name="count-children"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:if test="eahv-iv-2005-000101:form">
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:child"/>
				</xsl:if>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.additionalChildcareExpenses"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:if test="eahv-iv-2005-000101:form">
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:additionalChildcareExpenses = 'true'">
										<xsl:value-of select="$eahv-iv-2005-000101.yes"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$eahv-iv-2005-000101.no"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<!--<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.phoneNumber"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:if test="eahv-iv-2005-000101:form">
								<xsl:for-each select="eahv-iv-2005-000101:form">
									<fo:block>
										<xsl:call-template name="format-phoneNumber">
											<xsl:with-param name="value">
												<xsl:value-of select="eahv-iv-2005-000101:contactDetails/eahv-iv-2005-000101:mobilePhone"/>
											</xsl:with-param>
										</xsl:call-template>
									</fo:block>
								</xsl:for-each>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.email"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:if test="eahv-iv-2005-000101:form">
								<xsl:for-each select="eahv-iv-2005-000101:form">
									<fo:block>
										<xsl:value-of select="eahv-iv-2005-000101:contactDetails/eahv-iv-2005-000101:emailAddress"/>
									</fo:block>
								</xsl:for-each>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>-->
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.bankDetails"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:if test="eahv-iv-2005-000101:form">
								<fo:table width="100%" margin-top="5pt">
									<fo:table-column column-width="40%"/>
									<fo:table-column column-width="60%"/>
									<fo:table-body>
										<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:bankAccountDetails"/>
									</fo:table-body>
								</fo:table>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
		
		<!-- Employment Details NEW-->
		<fo:block xsl:use-attribute-sets="headingNormal">
			<xsl:value-of select="$eahv-iv-2005-000101.detailsPreviousActivity"/>
		</fo:block>
		<fo:block xsl:use-attribute-sets="tableLine"/>
		
		<fo:block margin-top="30pt"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.typeEmployee"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:employee">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:employee"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:freelance">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:freelance" mode="employee"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		
		<fo:block margin-top="30pt"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.typeStudent"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:student">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:student"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		
		<fo:block margin-top="30pt"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.typeUnemployed"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:unemployed">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:unemployed"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		
		<fo:block margin-top="30pt"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.typeApprentice"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:apprentice">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:apprentice"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		
		<fo:block margin-top="30pt"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.typeFreelance"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:freelance">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:freelance"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		
		<fo:block margin-top="30pt"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.typeNotGainfullyEmployed"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:notGainfullyEmployed">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:notGainfullyEmployed"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		
		<fo:block margin-top="30pt"/>
		<fo:block xsl:use-attribute-sets="headingGrey">
			<xsl:value-of select="$eahv-iv-2005-000101.typeOtherEmployee"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:if test="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:otherEmployee">
			<fo:table width="100%" margin-top="5pt">
				<fo:table-column column-width="40%"/>
				<fo:table-column column-width="60%"/>
				<fo:table-body>
					<xsl:apply-templates select="eahv-iv-2005-000101:form/eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:otherEmployee"/>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		
		<!-- Compensation office rule -->
		<fo:block xsl:use-attribute-sets="headingNormal">
			<xsl:value-of select="$eahv-iv-2005-000101.compensationOfficeChoiceRule"/>
		</fo:block>
		<fo:block margin-top="2pt" margin-bottom="10pt" xsl:use-attribute-sets="tableLine"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:compensationOfficeChoiceRule" mode="details"/>
 
		<!-- Attachments -->
		<fo:block font-size="12pt" text-align="left" font-weight="bold" margin-top="20pt">
			<xsl:value-of select="$eahv-iv-2005-000101.attachments"/>
		</fo:block>
		<fo:block xsl:use-attribute-sets="tableLine"/>
	</xsl:template>
	<!-- Match and process the form element -->
	<xsl:template match="eahv-iv-2005-000101:form">
		<xsl:apply-templates select="eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:employee"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:unemployed"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:freelance"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:apprentice"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:otherEmployee"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:notGainfullyEmployed"/>
		<xsl:apply-templates select="eahv-iv-2005-000101:preServiceActivity/eahv-iv-2005-000101:student"/>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:child">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.child"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<fo:table width="100%" margin-top="5pt">
						<fo:table-column column-width="40%"/>
						<fo:table-column column-width="60%"/>
						<fo:table-body>
							<fo:table-row xsl:use-attribute-sets="tableLine">
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="tableRow">
										<xsl:value-of select="$eahv-iv-2005-000101.name_firstName"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="tableRow">
										<xsl:value-of select="concat(eahv-iv-2005-000101:name, ' ',eahv-iv-2005-000101:firstName)"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row xsl:use-attribute-sets="tableLine">
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="tableRow">
										<xsl:value-of select="$eahv-iv-2005-000101.dateOfBirth"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="tableRow">
										<xsl:call-template name="format-date">
											<xsl:with-param name="value" select="eahv-iv-2005-000101:dateOfBirth"/>
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:apply-templates select="eahv-iv-2005-000101:schoolChildrenEndDate"/>
							<fo:table-row xsl:use-attribute-sets="tableLine">
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="tableRow">
										<xsl:value-of select="$eahv-iv-2005-000101.AHVNr"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="tableRow">
										<xsl:call-template name="format-vnType">
											<xsl:with-param name="value" select="eahv-iv-2005-000101:vn"/>
										</xsl:call-template>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:schoolChildrenEndDate">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.schoolChildrenEndDate"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:vn">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.AHVNr"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:call-template name="format-vnType">
						<xsl:with-param name="value" select="eahv-iv-2005-000101:vn"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Match and process the student element -->
	<xsl:template match="eahv-iv-2005-000101:student" mode="details">
		<fo:table-row>
			<!-- Name of the employer in the first column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat($eahv-iv-2005-000101.nameAndAddress,':')"/>
				</fo:block>
			</fo:table-cell>
			<!-- Concatenated address and canton in the second column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat(eahv-iv-2005-000101:school/eahv-iv-2005-000101:name, eahv-iv-2005-000101:school/eahv-iv-2005-000101:canton)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat($eahv-iv-2005-000101.graduationDate,':')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="eahv-iv-2005-000101:school/eahv-iv-2005-000101:endDate"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Match and process the freelance element -->
	<xsl:template match="eahv-iv-2005-000101:freelance" mode="details">
		<xsl:choose>
			<xsl:when test="eahv-iv-2005-000101:compensationOfficeAccountNumber">
				<xsl:apply-templates select="eahv-iv-2005-000101:compensationOfficeAccountNumber"/>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-row>
					<fo:table-cell>
						<fo:block>&#160;</fo:block>
						<!-- Non-breaking space to keep cell empty -->
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>&#160;</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:freelance" mode="employee">
		<xsl:apply-templates select="eahv-iv-2005-000101:employer"/>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:notGainfullyEmployed" mode="details">
		<xsl:choose>
			<xsl:when test="eahv-iv-2005-000101:compensationOfficeAccountNumber">
				<xsl:apply-templates select="eahv-iv-2005-000101:compensationOfficeAccountNumber"/>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-row>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<xsl:value-of select="concat($eahv-iv-2005-000101.costAccountNumber,':')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<xsl:value-of select="$eahv-iv-2005-000101.unknown"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:compensationOfficeAccountNumber">
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat($eahv-iv-2005-000101.costAccountNumber,':')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Match and process the employee element -->
	<xsl:template match="eahv-iv-2005-000101:employee">
			<xsl:apply-templates select="eahv-iv-2005-000101:mainEmployer | eahv-iv-2005-000101:otherEmployer"/>
	</xsl:template>
	<!-- Match and process the unemployed element -->
	<xsl:template match="eahv-iv-2005-000101:unemployed">
	<xsl:choose>
			<xsl:when test="eahv-iv-2005-000101:employer">
				<xsl:apply-templates select="eahv-iv-2005-000101:employer"/>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-row>
					<fo:table-cell>
						<fo:block>&#160;</fo:block>
						<!-- Non-breaking space to keep cell empty -->
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>&#160;</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Match and process the freelance element -->
	<xsl:template match="eahv-iv-2005-000101:freelance">
	<xsl:choose>
			<xsl:when test="eahv-iv-2005-000101:compensationOfficeAccountNumber">
				<xsl:apply-templates select="eahv-iv-2005-000101:compensationOfficeAccountNumber"/>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-row>
					<fo:table-cell>
						<fo:block>&#160;</fo:block>
						<!-- Non-breaking space to keep cell empty -->
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>&#160;</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:otherwise>
	</xsl:choose>
		<xsl:apply-templates select="eahv-iv-2005-000101:ownCompany"/>
	</xsl:template>
	<!-- Match and process the apprentice element -->
	<xsl:template match="eahv-iv-2005-000101:apprentice">
		<xsl:apply-templates select="eahv-iv-2005-000101:employer | eahv-iv-2005-000101:otherEmployer"/>
	</xsl:template>
	<!-- Match and process the notGainfullyEmployed element -->
	<xsl:template match="eahv-iv-2005-000101:notGainfullyEmployed">
		<xsl:choose>
			<xsl:when test="eahv-iv-2005-000101:compensationOfficeAccountNumber">
				<xsl:apply-templates select="eahv-iv-2005-000101:compensationOfficeAccountNumber"/>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-row>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<xsl:value-of select="concat($eahv-iv-2005-000101.costAccountNumber,':')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<xsl:value-of select="$eahv-iv-2005-000101.unknown"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Match and process the student element -->
	<xsl:template match="eahv-iv-2005-000101:student">
		<fo:table-row>
			<!-- Name of the employer in the first column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat($eahv-iv-2005-000101.nameAndAddress,':')"/>
				</fo:block>
			</fo:table-cell>
			<!-- Concatenated address and canton in the second column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat(eahv-iv-2005-000101:school/eahv-iv-2005-000101:name, ' ', eahv-iv-2005-000101:school/eahv-iv-2005-000101:canton)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat($eahv-iv-2005-000101.graduationDate,':')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="eahv-iv-2005-000101:school/eahv-iv-2005-000101:endDate"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Match and process the otherEmployee element -->
	<xsl:template match="eahv-iv-2005-000101:otherEmployee">
		<xsl:apply-templates select="eahv-iv-2005-000101:employer"/>
	</xsl:template>
	<!-- Template to process each employer -->
	<xsl:template match="eahv-iv-2005-000101:employer">
		<fo:table-row>
			<!-- Name of the employer in the first column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="eahv-iv-2005-000101:name"/>
				</fo:block>
			</fo:table-cell>
			<!-- Concatenated address and canton in the second column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat(eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationIdCategory,'-',eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationId, ', ', eahv-iv-2005-000101:address, ', ', eahv-iv-2005-000101:canton)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Template to process each employer and otherEmployer -->
	<xsl:template match="eahv-iv-2005-000101:employer | eahv-iv-2005-000101:otherEmployer">
		<fo:table-row>
			<!-- Name of the employer in the first column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="eahv-iv-2005-000101:name"/>
				</fo:block>
			</fo:table-cell>
			<!-- Concatenated address and canton in the second column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat(eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationIdCategory,'-',eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationId, ', ', eahv-iv-2005-000101:address, ', ', eahv-iv-2005-000101:canton)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Template to process each ownCompany and otherEmployer -->
	<xsl:template match="eahv-iv-2005-000101:ownCompany | eahv-iv-2005-000101:employer">
		<fo:table-row>
			<!-- Name of the employer in the first column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="eahv-iv-2005-000101:name"/>
				</fo:block>
			</fo:table-cell>
			<!-- Concatenated address and canton in the second column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat(eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationIdCategory,'-',eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationId, ', ', eahv-iv-2005-000101:address, ', ', eahv-iv-2005-000101:canton)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Template to process each mainEmployer and otherEmployer -->
	<xsl:template match="eahv-iv-2005-000101:mainEmployer | eahv-iv-2005-000101:otherEmployer">
		<fo:table-row>
			<!-- Name of the employer in the first column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="eahv-iv-2005-000101:name"/>
				</fo:block>
			</fo:table-cell>
			<!-- Concatenated address and canton in the second column -->
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat(eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationIdCategory,'-',eahv-iv-2005-000101:uid/eCH-0097:uidOrganisationId, ', ', eahv-iv-2005-000101:address, ', ', eahv-iv-2005-000101:canton)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:bankAccountDetails">
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="$eahv-iv-2005-000101.accountHolderName"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="eahv-iv-2005-000101:accountHolderName"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="$eahv-iv-2005-000101.accountHolderAddress"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="eahv-iv-2005-000101:accountHolderAddress"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<xsl:if test="eahv-iv-2005-000101:iban">
			<fo:table-row>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="standardIndent">
						<xsl:value-of select="$eahv-iv-2005-000101.iban"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="standardIndent">
						<xsl:value-of select="eahv-iv-2005-000101:iban"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:if>
		<xsl:apply-templates select="eahv-iv-2005-000101:nonIbanAccountDetails"/>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:nonIbanAccountDetails">
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="$eahv-iv-2005-000101.nonIbanAccountDetails"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="standardIndent">
					<xsl:value-of select="concat(eahv-iv-2005-000101:bankName, ', ',eahv-iv-2005-000101:bankAddress, ', ',eahv-iv-2005-000101:accountNumber, ', ',eahv-iv-2005-000101:swiftCode)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template name="format-vnType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="string-length($trimmed-value) = 13">
				<xsl:value-of select="substring($trimmed-value, 1, 3)"/>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring($trimmed-value, 4, 4)"/>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring($trimmed-value, 8, 4)"/>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring($trimmed-value, 12, 2)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="format-phoneNumber">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="string-length($trimmed-value) = 10">
				<xsl:value-of select="substring($trimmed-value, 1, 3)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 4, 3)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 7, 2)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 9, 2)"/>
			</xsl:when>
			<xsl:when test="string-length($trimmed-value) = 13">
				<xsl:value-of select="substring($trimmed-value, 1, 4)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 5, 2)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 7, 3)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 10, 2)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 12, 2)"/>
			</xsl:when>
			<xsl:when test="string-length($trimmed-value) = 12">
				<xsl:value-of select="substring($trimmed-value, 1, 3)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 4, 2)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 6, 3)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 9, 2)"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="substring($trimmed-value, 11, 3)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:address">
		<fo:block>
			<xsl:value-of select="eahv-iv-2014-000101:addressLine1"/>
			<xsl:if test="eahv-iv-2014-000101:addressLine2">
				<xsl:text>, </xsl:text>
				<xsl:value-of select="eahv-iv-2014-000101:addressLine2"/>
			</xsl:if>
			<xsl:if test="eahv-iv-2014-000101:addressLine3">
				<xsl:text>, </xsl:text>
				<xsl:value-of select="eahv-iv-2014-000101:addressLine3"/>
			</xsl:if>
		</fo:block>
		<fo:block>
			<xsl:value-of select="concat(eahv-iv-2014-000101:zipCode, ' ', eahv-iv-2014-000101:town)"/>
		</fo:block>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:overlapServicePeriod">
		<xsl:apply-templates select="eahv-iv-2005-000101:servicePeriodId"/>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:assignmentsHistory">
		<!-- Table for personal details -->
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.initialAssignment"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:apply-templates select="common:initialAssignment"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.transfer"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:apply-templates select="common:transfer"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.closing"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:apply-templates select="common:closing"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="common:initialAssignment">
		<!-- Table for personal details -->
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.compensationOffice"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="concat(common:compensationOffice/eCH-0097:uidOrganisationIdCategory,'-',common:compensationOffice/eCH-0097:uidOrganisationId)"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.compensationOfficeChoiceRule"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="common:compensationOfficeChoiceRule"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.eventDate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="common:eventDate"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="common:transfer">
		<!-- Table for personal details -->
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.sourceCompensationOffice"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="concat(common:sourceCompensationOffice/eCH-0097:uidOrganisationIdCategory,'-',common:sourceCompensationOffice/eCH-0097:uidOrganisationId)"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.destinationCompensationOffice"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="concat(common:destinationCompensationOffice/eCH-0097:uidOrganisationIdCategory,'-',common:destinationCompensationOffice/eCH-0097:uidOrganisationId)"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.reason"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="common:reason"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.eventDate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="common:eventDate"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="common:closing">
		<!-- Table for personal details -->
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.compensationOffice"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="concat(common:compensationOffice/eCH-0097:uidOrganisationIdCategory,'-',common:compensationOffice/eCH-0097:uidOrganisationId)"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.eventDate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="common:eventDate"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:servicePeriodId">
		<!-- Table for personal details -->
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.businessProcessId"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="eahv-iv-2005-000101:businessProcessId"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.version"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="eahv-iv-2005-000101:version"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:compensationOfficeChoiceRule">
		<!-- Table for personal details -->
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.compensationOfficeChoiceRule"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:compensationOfficeChoiceRule" mode="details">
		<xsl:variable name="choiceRule" select="."/>		
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$choiceRule"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="exsl:node-set($eahv-iv-2005-000101.compensationOfficeChoiceRuleWithText)/entry[@key = $choiceRule]"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:servicePeriod">
		<!-- Table for personal details -->
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.AHVNr"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:call-template name="format-vnType">
								<xsl:with-param name="value">
									<xsl:value-of select="eahv-iv-2014-000101:insurant/eahv-iv-2014-000101:vn"/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.name_firstName"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="concat(eahv-iv-2014-000101:insurant/eahv-iv-2014-000101:officialName, ', ',eahv-iv-2014-000101:insurant/eahv-iv-2014-000101:firstName)"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.townAddress"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:apply-templates select="eahv-iv-2014-000101:address"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.sex"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:apply-templates select="eahv-iv-2014-000101:insurant/eahv-iv-2014-000101:sex"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.dateOfBirth"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="eahv-iv-2014-000101:insurant/eahv-iv-2014-000101:dateOfBirth"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.insurantDomicile"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="normalize-space(concat(eahv-iv-2014-000101:address/eahv-iv-2014-000101:zipCode, ' ',eahv-iv-2014-000101:insurantDomicile/eahv-iv-2014-000101:canton))"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<!--<xsl:apply-templates select="eahv-iv-2014-000101:departmentId"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:controlNumber"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:personalNumber"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:serviceEntryDate"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:annotation"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:userId"/>-->
				<xsl:apply-templates select="eahv-iv-2014-000101:mobilePhone"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:emailAddress"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:iban"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:language"/>
			</fo:table-body>
		</fo:table>
		<fo:block xsl:use-attribute-sets="headingNormal">
			<xsl:value-of select="$eahv-iv-2005-000101.detailsService"/>
		</fo:block>
		<fo:block xsl:use-attribute-sets="tableLine"/>
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="40%"/>
			<fo:table-column column-width="60%"/>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.serviceType"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="eahv-iv-2014-000101:serviceType"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:apply-templates select="eahv-iv-2014-000101:departmentId"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:controlNumber"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:personalNumber"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:serviceEntryDate"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:annotation"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:userId"/>
				<xsl:apply-templates select="eahv-iv-2014-000101:referenceNumber"/>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.servicePeriod"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:table width="90%" margin-top="10pt">
							<fo:table-column column-width="50%"/>
							<fo:table-column column-width="50%"/>
							<fo:table-body>
								<!-- Header row with grey background -->
								<fo:table-row border-top="1pt solid black">
									<fo:table-cell>
										<fo:block background-color="{$greyBackground}" text-align="center" font-weight="bold" xsl:use-attribute-sets="standardIndent">
											<xsl:value-of select="$eahv-iv-2005-000101.from"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block text-align="center" font-weight="bold" xsl:use-attribute-sets="standardIndent">
											<xsl:value-of select="$eahv-iv-2005-000101.to"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- Data row -->
								<fo:table-row xsl:use-attribute-sets="tableLine">
									<fo:table-cell>
										<fo:block text-align="center">
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="eahv-iv-2014-000101:startOfPeriod"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block text-align="center">
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="eahv-iv-2014-000101:endOfPeriod"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="tableLine">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="$eahv-iv-2005-000101.numberOfServiceDays"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="tableRow">
							<xsl:value-of select="eahv-iv-2014-000101:numberOfDays"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:departmentId">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.departmentId"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:controlNumber">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.controlNumber"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:personalNumber">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.personalNumber"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:referenceNumber">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.referenceNumber"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:serviceEntryDate">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.serviceEntryDate"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:annotation">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.annotation"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:userId">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.userId"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:mobilePhone">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.phoneNumber"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:call-template name="format-phoneNumber">
						<xsl:with-param name="value">
							<xsl:value-of select="."/>
						</xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:emailAddress">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.email"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:iban">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.iban"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:language">
		<fo:table-row xsl:use-attribute-sets="tableLine">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="$eahv-iv-2005-000101.language"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="tableRow">
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="eahv-iv-2005-000101:preServiceActivity">
		<fo:table width="100%" margin-top="5pt">
			<fo:table-column column-width="22%"/>
			<fo:table-column column-width="30%"/>
			<fo:table-column column-width="45%"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Arbeitnehmer(in)" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:employee">x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeEmployee"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Schüler(in) / Student(in)" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:student">x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeStudent"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Nicht erwerbstätig" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:unemployed">x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeUnemployed"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Lehrling" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:apprentice">x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeApprentice"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Selbständig erwerbend" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:freelance">x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeFreelance"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Arbeitslos mit Taggeld der ALV" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:notGainfullyEmployed">x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeNotGainfullyEmployed"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Bei mehreren Arbeitgebern" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:employee and eahv-iv-2005-000101:employee/eahv-iv-2005-000101:otherEmployer">
        x </xsl:when>
									<xsl:when test="eahv-iv-2005-000101:apprentice and eahv-iv-2005-000101:apprentice/eahv-iv-2005-000101:otherEmployer">
        x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeWithMultipleEmployers"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Gleichzeitig Arbeitnehmer und SE" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:freelance and eahv-iv-2005-000101:freelance/eahv-iv-2005-000101:employer">
        x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeFreelanceWithEmployment"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="standardIndent">
							<!-- "Gleichzeitig Arbeitnehmer und SE" option -->
							<fo:inline>
								<xsl:choose>
									<xsl:when test="eahv-iv-2005-000101:freelance and eahv-iv-2005-000101:freelance/eahv-iv-2005-000101:otherEmployee">
        x </xsl:when>
									<xsl:otherwise>o </xsl:otherwise>
								</xsl:choose>
							</fo:inline>
							<xsl:value-of select="$eahv-iv-2005-000101.typeOtherEmployee"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="eahv-iv-2014-000101:sex">
		<xsl:choose>
			<xsl:when test=". = '1'">
				<xsl:value-of select="$eahv-iv-2005-000101.sex_male"/>
			</xsl:when>
			<xsl:when test=". = '2'">
				<xsl:value-of select="$eahv-iv-2005-000101.sex_female"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$eahv-iv-2005-000101.sex_undefined"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="format-date">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="string-length($trimmed-value) > 0">
                <xsl:variable name="year" select="substring($trimmed-value, 1, 4)"/>
				<xsl:variable name="month" select="substring($trimmed-value, 6, 2)"/>
				<xsl:variable name="day" select="substring($trimmed-value, 9, 2)"/>
				<xsl:value-of select="$day"/>-<xsl:value-of select="$month"/>-<xsl:value-of select="$year"/>
            </xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="count-children">
		<xsl:variable name="childCount">
			<xsl:choose>
				<xsl:when test="eahv-iv-2005-000101:form">
					<xsl:for-each select="eahv-iv-2005-000101:form">
						<xsl:choose>
							<xsl:when test="count(eahv-iv-2005-000101:child) > 0">
								<xsl:value-of select="count(eahv-iv-2005-000101:child)"/>
								<xsl:text> </xsl:text>
								<!--
                                Space-separated numbers -->
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>0 </xsl:text>
								<!-- Ensure empty forms contribute "0" -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>0 </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Sum the counts using recursion -->
		<xsl:call-template name="sum-numbers">
			<xsl:with-param name="values" select="normalize-space($childCount)"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="sum-numbers">
		<xsl:param name="values"/>
		<xsl:param name="sum" select="0"/>
		<xsl:choose>
			<xsl:when test="contains($values, ' ')">
				<xsl:call-template name="sum-numbers">
					<xsl:with-param name="values" select="substring-after($values, ' ')"/>
					<xsl:with-param name="sum" select="$sum + number(substring-before($values, ' '))"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sum + number($values)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>