<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/4">
	
	<xsl:import href="ech-0010-language-4-0_it.xsl"/>
	
	<!--Decode mrMrsType -->
	
	<xsl:template name="decode-mrMrs">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eCH-0010.mrMrs.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eCH-0010.mrMrs.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eCH-0010.mrMrs.3"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- output organisationName, organisationNameAddOn1 and organisationNameAddOn2 on one line, but only if a organisationName is there -->
	
	<xsl:template match="eCH-0010:organisationName" mode="inline">
		<xsl:value-of select="."/>
		<xsl:if test="../eCH-0010:organisationNameAddOn1">
			<xsl:value-of select="concat(', ', ../eCH-0010:organisationNameAddOn1)"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:organisationNameAddOn2">
			<xsl:value-of select="concat(', ', ../eCH-0010:organisationNameAddOn2)"/>
		</xsl:if>
	</xsl:template>

	<!-- output mrMrs, title, firstName and lastName on one line, but only if a lastName is there -->
	
	<xsl:template match="eCH-0010:lastName" mode="inline">
		<xsl:if test="../eCH-0010:mrMrs">
			<xsl:call-template name="decode-mrMrs">
				<xsl:with-param name="value"><xsl:value-of select="../eCH-0010:mrMrs"/></xsl:with-param>
			</xsl:call-template>
			<xsl:value-of select="' '"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:title">
			<xsl:value-of select="concat(../eCH-0010:title, ' ')"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:firstName">
			<xsl:value-of select="concat(../eCH-0010:firstName, ' ')"/>
		</xsl:if>
		<xsl:value-of select="."/>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType on one line-->
	<xsl:template match="eCH-0010:addressLine1" mode="inline">
		<xsl:value-of select="."/>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType on one line-->
	<xsl:template match="eCH-0010:addressLine2" mode="inline">
		<xsl:if test="position() != 1">, </xsl:if>
		<xsl:value-of select="."/>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType on one line-->
	<xsl:template match="eCH-0010:street" mode="inline">
		<xsl:if test="position() != 1">, </xsl:if>
		<xsl:value-of select="."/>
		<xsl:if test="../eCH-0010:houseNumber">
			<xsl:value-of select="concat(' ', ../eCH-0010:houseNumber)"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:dwellingNumber">
			<xsl:value-of select="concat('/', ../eCH-0010:dwellingNumber)"/>
		</xsl:if>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType on one line-->
	<xsl:template match="eCH-0010:postOfficeBoxText" mode="inline">
		<xsl:if test="position() != 1">, </xsl:if>
		<xsl:value-of select="concat(' ', text())"/>
		<xsl:if test="../eCH-0010:postOfficeBoxNumber">
			<xsl:value-of select="concat(' ', ../eCH-0010:postOfficeBoxNumber)"/>
		</xsl:if>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType on one line -->
	<xsl:template match="eCH-0010:locality" mode="inline">
		<xsl:if test="position() != 1">, </xsl:if>
		<xsl:value-of select="concat(' ', text())"/>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType on one line -->
	<xsl:template match="eCH-0010:town" mode="inline">
		<xsl:if test="position() != 1">, </xsl:if>
		<xsl:if test="../eCH-0010:country">
			<xsl:value-of select="concat(../eCH-0010:country, '-')"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:swissZipCode">
			<xsl:value-of select="concat(../eCH-0010:swissZipCode, ' ')"/>
		</xsl:if>
		<xsl:if test="../eCH-0010:foreignZipCode">
			<xsl:value-of select="concat(../eCH-0010:foreignZipCode, ' ')"/>
		</xsl:if>
		<xsl:value-of select="."/>
		<xsl:if test="../eCH-0010:swissZipCodeAddOn">
			<xsl:value-of select="concat(' ', ../eCH-0010:swissZipCodeAddOn)"/>
		</xsl:if>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType on one line -->
	<xsl:template match="*" mode="inline">
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType as a block -->
	<xsl:template match="eCH-0010:addressLine1" mode="block">
		<fo:block>
			<xsl:value-of select="."/>
		</fo:block>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType as a block -->
	<xsl:template match="eCH-0010:addressLine2" mode="block">
		<fo:block>
			<xsl:value-of select="."/>
		</fo:block>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType as a block -->
	<xsl:template match="eCH-0010:street" mode="block">
		<fo:block>
			<xsl:value-of select="."/>
			<xsl:if test="../eCH-0010:houseNumber">
				<xsl:value-of select="concat(' ', ../eCH-0010:houseNumber)"/>
			</xsl:if>
			<xsl:if test="../eCH-0010:dwellingNumber">
				<xsl:value-of select="concat('/', ../eCH-0010:dwellingNumber)"/>
			</xsl:if>
		</fo:block>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType as a block -->
	<xsl:template match="eCH-0010:postOfficeBoxText" mode="block">
		<fo:block>
			<xsl:value-of select="."/>
			<xsl:if test="../eCH-0010:postOfficeBoxNumber">
				<xsl:value-of select="concat(' ', ../eCH-0010:postOfficeBoxNumber)"/>
			</xsl:if>
		</fo:block>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType as a block -->
	<xsl:template match="eCH-0010:locality" mode="block">
		<fo:block>
			<xsl:value-of select="."/>
		</fo:block>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType as a block -->
	<xsl:template match="eCH-0010:town" mode="block">
		<fo:block>
			<xsl:if test="../eCH-0010:country">
				<xsl:value-of select="concat(../eCH-0010:country, '-')"/>
			</xsl:if>
			<xsl:if test="../eCH-0010:swissZipCode">
				<xsl:value-of select="concat(../eCH-0010:swissZipCode, ' ')"/>
			</xsl:if>
			<xsl:if test="../eCH-0010:foreignZipCode">
				<xsl:value-of select="concat(../eCH-0010:foreignZipCode, ' ')"/>
			</xsl:if>
			<xsl:value-of select="."/>
			<xsl:if test="../eCH-0010:swissZipCodeAddOn">
				<xsl:value-of select="concat(' ', ../eCH-0010:swissZipCodeAddOn)"/>
			</xsl:if>
		</fo:block>
	</xsl:template>
	
	<!-- helper template for outputting an eCH-0010:addressInfoType as a block -->
	<xsl:template match="*" mode="block">
	</xsl:template>
	
</xsl:stylesheet>