<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007-f/5" xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010-f/5" xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044-f/4" xmlns:eCH-0097="http://www.ech.ch/xmlns/eCH-0097/1" xmlns:ssk-common="http://www.steuerkonferenz.ch/xmlns/ssk-common/2" xmlns:ssk-3105-000001="http://www.steuerkonferenz.ch/xmlns/ssk-3105-000001/1">
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"/>
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//ssk-3105-000001:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//ssk-3105-000001:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//ssk-3105-000001:header" mode="message-header-block"/>
					<xsl:apply-templates select="//ssk-3105-000001:header" mode="special-message"/>
					<fo:block background-color="{$grey-background}" space-after="8mm" font-family="{$font-family}">
						<xsl:apply-templates select="//ssk-3105-000001:header" mode="section-header">
							<xsl:with-param name="header-code" select="1"/>
						</xsl:apply-templates>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3105-000001:content" mode="page-header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}" space-after="8mm" font-family="{$font-family}">
						<xsl:apply-templates select="//ssk-3105-000001:header" mode="section-header">
							<xsl:with-param name="header-code" select="2"/>
						</xsl:apply-templates>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3105-000001:content" mode="page-content-2"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}" space-after="8mm" font-family="{$font-family}">
						<xsl:apply-templates select="//ssk-3105-000001:header" mode="section-header">
							<xsl:with-param name="header-code" select="3"/>
						</xsl:apply-templates>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3105-000001:content" mode="page-content-3"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="ssk-3105-000001:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$ssk-common"/> | <xsl:value-of select="$ssk-3105-000001"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.chm-steuern.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.senderId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id">
																<xsl:value-of select="ssk-3105-000001:senderId"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.recipientId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="ssk-3105-000001:recipientId">
															<xsl:if test="position() != 1">
																<xsl:text>, </xsl:text>
															</xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id">
																	<xsl:value-of select="."/>
																</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-3105-000001.messageDate"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value">
																<xsl:value-of select="ssk-3105-000001:messageDate"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.contactInformation"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="ssk-3105-000001:extension/ssk-3105-000001:contactInformation" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-3105-000001.action"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="ssk-3105-000001:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.businessCaseClosed"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-boolean">
															<xsl:with-param name="value" select="ssk-3105-000001:businessCaseClosed"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.pages"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<fo:page-number-citation ref-id="pageCounter"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-3105-000001.attachment"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(ssk-3105-000001:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="ssk-3105-000001:contactInformation" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:email"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="ssk-3105-000001:header" mode="special-message">
		<xsl:variable name="is-test" select="(ssk-3105-000001:testDeliveryFlag = '1') or (ssk-3105-000001:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="ssk-3105-000001:action != 1 and ssk-3105-000001:action != 5 and ssk-3105-000001:action != 6"/>
		<xsl:variable name="is-priority" select="ssk-3105-000001:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="ssk-3105-000001:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($ssk-3105-000001.messagePriority, ': ')"/>
					<xsl:value-of select="ssk-3105-000001:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $ssk-3105-000001.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!--
		Cover sheet: comment
	-->
	<!--
		Cover sheet: object field from the message header
	-->
	<xsl:template match="ssk-3105-000001:content" mode="page-header">
		<xsl:apply-templates select="ssk-3105-000001:taxpayer"/>
		<xsl:apply-templates select="ssk-3105-000001:spouse"/>
		<xsl:apply-templates select="ssk-3105-000001:removalDate"/>
		<xsl:apply-templates select="ssk-3105-000001:taxLiability"/>
	</xsl:template>
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="ssk-3105-000001:content" mode="page-content-2">
		<xsl:apply-templates select="ssk-3105-000001:regularTax"/>
	</xsl:template>
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="ssk-3105-000001:content" mode="page-content-3">
		<xsl:apply-templates select="ssk-3105-000001:taxAtSource"/>
	</xsl:template>
	<!--
		Empty page header for subsequent pages.
	-->
	<xsl:template mode="page-header" match="ssk-3105-000001:header">
		<fo:table background-color="white" table-layout="fixed" width="100%">
			<fo:table-column column-width="0mm" column-number="1"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="0mm" column-number="1" display-align="center">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Section header
	-->
	<xsl:template mode="section-header" match="ssk-3105-000001:header">
		<xsl:param name="header-code" select="1"/>
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}">
							<xsl:if test="$header-code = '1'">
								<xsl:value-of select="ssk-3105-000001:subject"/>
							</xsl:if>
							<xsl:if test="$header-code = '2'">
								<xsl:value-of select="$ssk-3105-000001.regularTax"/>
							</xsl:if>
							<xsl:if test="$header-code = '3'">
								<xsl:value-of select="$ssk-3105-000001.taxAtSource"/>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="ssk-3105-000001:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="ssk-3105-000001:messageType"/>/<xsl:value-of select="ssk-3105-000001:subMessageType"/>
							| <xsl:value-of select="concat($ssk-3105-000001.messageId, ' ')"/>
							<xsl:value-of select="ssk-3105-000001:messageId"/>
							<xsl:if test="count(ssk-3105-000001:referenceMessageId) != 0">
								| <xsl:value-of select="concat($ssk-3105-000001.referenceMessageId, ' ')"/>
								<xsl:value-of select="ssk-3105-000001:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="ssk-3105-000001:businessProcessId">
								| <xsl:value-of select="concat($ssk-common.businessProcessId, ' ')"/>
								<xsl:value-of select="ssk-3105-000001:businessProcessId"/>
							</xsl:if>
							| <xsl:value-of select="concat($ssk-common.dateOfReceipt, ' ')"/>
							<xsl:call-template name="format-date">
								<xsl:with-param name="value">
									<xsl:value-of select="$dateOfReceipt"/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		****************  Message content starts here ***************
	 -->
	<!-- 
		Generate the taxpayer block. This is identical to the object block on cover sheet.
	-->
	<xsl:template match="ssk-3105-000001:taxpayer">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.taxpayer"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-common:officialName"/>
								<xsl:apply-templates select="ssk-common:firstName"/>
								<xsl:apply-templates select="ssk-common:sex"/>
								<xsl:apply-templates select="ssk-common:dateOfBirth"/>
								<xsl:apply-templates select="ssk-common:vn"/>
								<xsl:apply-templates select="ssk-common:oldVn"/>
								<xsl:apply-templates select="ssk-common:address"/>
								<xsl:apply-templates select="ssk-common:taxMunicipality"/>
								<xsl:apply-templates select="ssk-common:religion"/>
								<xsl:apply-templates select="ssk-common:maritalStatus"/>
								<xsl:apply-templates select="ssk-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="ssk-common:nbrOfChildren"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Generate the spouse block. This is identical to the object block on cover sheet.
	-->
	<xsl:template match="ssk-3105-000001:spouse">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.spouse"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-common:officialName"/>
								<xsl:apply-templates select="ssk-common:firstName"/>
								<xsl:apply-templates select="ssk-common:sex"/>
								<xsl:apply-templates select="ssk-common:dateOfBirth"/>
								<xsl:apply-templates select="ssk-common:vn"/>
								<xsl:apply-templates select="ssk-common:oldVn"/>
								<xsl:apply-templates select="ssk-common:address"/>
								<xsl:apply-templates select="ssk-common:taxMunicipality"/>
								<xsl:apply-templates select="ssk-common:religion"/>
								<xsl:apply-templates select="ssk-common:maritalStatus"/>
								<xsl:apply-templates select="ssk-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="ssk-common:nbrOfChildren"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, removalDate
	-->
	<xsl:template match="ssk-3105-000001:removalDate">
		<xsl:call-template name="single-date-block">
			<xsl:with-param name="title" select="$ssk-3105-000001.removalDate"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	<!-- 
		Message content, taxLiability
	-->
	<xsl:template match="ssk-3105-000001:taxLiability">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.taxLiability"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="taxLiability">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes taxLiability -->
	<xsl:template name="taxLiability">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.taxLiability.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3105-000001.taxLiability.2"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '3'">
				<xsl:value-of select="$ssk-3105-000001.taxLiability.3"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="ssk-3105-000001:regularTax">
		<xsl:apply-templates select="ssk-3105-000001:taxationState"/>
		<xsl:apply-templates select="ssk-3105-000001:stateMunicipalityEarningTax"/>
		<xsl:apply-templates select="ssk-3105-000001:stateMunicipalityAssetTax"/>
		<xsl:apply-templates select="ssk-3105-000001:stateMunicipalityScaleTax"/>
		<xsl:apply-templates select="ssk-3105-000001:stateMunicipalityDate"/>
		<xsl:apply-templates select="ssk-3105-000001:federalEarningTax"/>
		<xsl:apply-templates select="ssk-3105-000001:federalScaleTax"/>
		<xsl:apply-templates select="ssk-3105-000001:federalDate"/>
		<xsl:apply-templates select="ssk-3105-000001:interkantonal"/>
		<xsl:apply-templates select="ssk-3105-000001:international"/>
		<xsl:apply-templates select="ssk-3105-000001:localRealEstate"/>
		<xsl:apply-templates select="ssk-3105-000001:localBusiness"/>
		<xsl:apply-templates select="ssk-3105-000001:localPartnership"/>
		<xsl:apply-templates select="ssk-3105-000001:estimatedAssessment"/>
		<xsl:apply-templates select="ssk-3105-000001:changeTaxAtSourceToRegular"/>
	</xsl:template>
	<!-- 
		Message content, taxationState
	-->
	<xsl:template match="ssk-3105-000001:taxationState">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.taxationState"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="taxationState">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes taxationState -->
	<xsl:template name="taxationState">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.taxationState.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.taxationState.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, taxPeriod
	-->
	<xsl:template match="ssk-3105-000001:taxPeriod">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3105-000001.taxPeriod"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- 
		Message content, amount
	-->
	<xsl:template match="ssk-3105-000001:amount">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3105-000001.amount"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					CHF <xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- 
		Message content, stateMunicipalityEarningTax
	-->
	<xsl:template match="ssk-3105-000001:stateMunicipalityEarningTax">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.stateMunicipalityEarningTax"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-3105-000001:taxPeriod"/>
								<xsl:apply-templates select="ssk-3105-000001:amount"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, stateMunicipalityAssetTax
	-->
	<xsl:template match="ssk-3105-000001:stateMunicipalityAssetTax">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.stateMunicipalityAssetTax"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-3105-000001:taxPeriod"/>
								<xsl:apply-templates select="ssk-3105-000001:amount"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, stateMunicipalityScaleTax
	-->
	<xsl:template match="ssk-3105-000001:stateMunicipalityScaleTax">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.stateMunicipalityScaleTax"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="stateMunicipalityScaleTax">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes stateMunicipalityScaleTax -->
	<xsl:template name="stateMunicipalityScaleTax">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.stateMunicipalityScaleTax.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.stateMunicipalityScaleTax.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, stateMunicipalityDate
	-->
	<xsl:template match="ssk-3105-000001:stateMunicipalityDate">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.stateMunicipalityDate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="format-date">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, federalEarningTax
	-->
	<xsl:template match="ssk-3105-000001:federalEarningTax">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.federalEarningTax"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-3105-000001:taxPeriod"/>
								<xsl:apply-templates select="ssk-3105-000001:amount"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, federalScaleTax
	-->
	<xsl:template match="ssk-3105-000001:federalScaleTax">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.federalScaleTax"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="federalScaleTax">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes federal -->
	<xsl:template name="federalScaleTax">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.stateMunicipalityScaleTax.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.stateMunicipalityScaleTax.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, federalDate
	-->
	<xsl:template match="ssk-3105-000001:federalDate">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.federalDate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="format-date">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- 
		Message content, interkantonal
	-->
	<xsl:template match="ssk-3105-000001:interkantonal">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.interkantonal"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="interkantonal">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes interkantonal -->
	<xsl:template name="interkantonal">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.interkantonal.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.interkantonal.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, international
	-->
	<xsl:template match="ssk-3105-000001:international">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.international"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="international">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes international -->
	<xsl:template name="international">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.international.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.international.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, localRealEstate
	-->
	<xsl:template match="ssk-3105-000001:localRealEstate">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.localRealEstate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="localRealEstate">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes localRealEstate -->
	<xsl:template name="localRealEstate">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.localRealEstate.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.localRealEstate.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, localBusiness
	-->
	<xsl:template match="ssk-3105-000001:localBusiness">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.localBusiness"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="localBusiness">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes localBusiness -->
	<xsl:template name="localBusiness">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.localBusiness.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.localBusiness.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, localPartnership
	-->
	<xsl:template match="ssk-3105-000001:localPartnership">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.localPartnership"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="localPartnership">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes localPartnership -->
	<xsl:template name="localPartnership">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.localPartnership.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.localPartnership.1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, estimatedAssessment
	-->
	<xsl:template match="ssk-3105-000001:estimatedAssessment">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.estimatedAssessment"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="estimatedAssessment">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes estimatedAssessment -->
	<xsl:template name="estimatedAssessment">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.estimatedAssessment.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.estimatedAssessment.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3105-000001.estimatedAssessment.2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, changeTaxAtSourceToRegular
	-->
	<xsl:template match="ssk-3105-000001:changeTaxAtSourceToRegular">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.changeTaxAtSourceToRegular.title"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.changeTaxAtSourceToRegular"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="changeTaxAtSourceToRegular">
												<xsl:with-param name="value">
													<xsl:value-of select="."/>
												</xsl:with-param>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.reasonChangeTaxAtSourceToRegular"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="../*[local-name()='reasonChangeTaxAtSourceToRegular']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.dateChangeTaxAtSourceToRegular"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="../*[local-name()='dateChangeTaxAtSourceToRegular']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes changeTaxAtSourceToRegular -->
	<xsl:template name="changeTaxAtSourceToRegular">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.changeTaxAtSourceToRegular.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.changeTaxAtSourceToRegular.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3105-000001.changeTaxAtSourceToRegular.2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="ssk-3105-000001:taxAtSource">
		<xsl:apply-templates select="ssk-3105-000001:taxpayerStatus"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.employer"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
						</fo:block>
						<xsl:for-each select="ssk-3105-000001:employerAndTASCategory">
							<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate" space-after="1em">
								<fo:table-column column-width="{$description-column-width}" column-number="1"/>
								<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
								<fo:table-body>
									<xsl:apply-templates select="ssk-3105-000001:employer/ssk-common:organisationName"/>
									<xsl:apply-templates select="ssk-3105-000001:employer/ssk-common:uid"/>
									<xsl:apply-templates select="ssk-3105-000001:employer/ssk-common:legalForm"/>
									<xsl:apply-templates select="ssk-3105-000001:employer/ssk-common:address"/>
									<xsl:apply-templates select="ssk-3105-000001:TaxAtSourceCategory"/>
									<xsl:apply-templates select="ssk-3105-000001:CategoryOpen"/>
								</fo:table-body>
							</fo:table>
						</xsl:for-each>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
		<xsl:apply-templates select="ssk-3105-000001:movingIntoDepartureCanton"/>
		<xsl:apply-templates select="ssk-3105-000001:changeRegularToTaxAtSource"/>
	</xsl:template>
	<!-- helper template for formatting ssk-common.uid-->
	<xsl:template match="ssk-common:uid">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3105-000001.uid"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="concat(./eCH-0097:uidOrganisationIdCategorie, ./eCH-0097:uidOrganisationId)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- 
		Message content, TaxAtSourceCategory
	-->
	<xsl:template match="ssk-3105-000001:TaxAtSourceCategory">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3105-000001.TaxAtSourceCategory"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- 
		Message content, CategoryOpen
	-->
	<xsl:template match="ssk-3105-000001:CategoryOpen">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3105-000001.CategoryOpen"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="."/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- 
		Message content, taxpayerStatus
	-->
	<xsl:template match="ssk-3105-000001:taxpayerStatus">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.taxpayerStatus"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="taxpayerStatus">
								<xsl:with-param name="value">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes taxpayerStatus -->
	<xsl:template name="taxpayerStatus">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.taxpayerStatus.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3105-000001.taxpayerStatus.2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, movingIntoDepartureCanton
	-->
	<xsl:template match="ssk-3105-000001:movingIntoDepartureCanton">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.movingIntoDepartureCanton.title"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.movingIntoDepartureCanton"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="movingIntoDepartureCanton">
												<xsl:with-param name="value">
													<xsl:value-of select="."/>
												</xsl:with-param>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.dateMovingIntoDepartureCanton"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="../*[local-name()='dateMovingIntoDepartureCanton']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.previousResidenceCanton"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="../*[local-name()='previousResidenceCanton']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.previousResidenceCountry"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="../*[local-name()='previousResidenceCountry']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes movingIntoDepartureCanton -->
	<xsl:template name="movingIntoDepartureCanton">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.movingIntoDepartureCanton.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.movingIntoDepartureCanton.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3105-000001.movingIntoDepartureCanton.2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
		Message content, changeRegularToTaxAtSource
	-->
	<xsl:template match="ssk-3105-000001:changeRegularToTaxAtSource">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3105-000001.changeRegularToTaxAtSource.title"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.changeRegularToTaxAtSource"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="changeRegularToTaxAtSource">
												<xsl:with-param name="value">
													<xsl:value-of select="."/>
												</xsl:with-param>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.reasonChangeRegularToTaxAtSource"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="../*[local-name()='reasonChangeRegularToTaxAtSource']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3105-000001.dateChangeRegularToTaxAtSource"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="../*[local-name()='dateChangeRegularToTaxAtSource']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Decodes changeRegularToTaxAtSource -->
	<xsl:template name="changeRegularToTaxAtSource">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'">
				<xsl:value-of select="$ssk-3105-000001.changeRegularToTaxAtSource.0"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3105-000001.changeRegularToTaxAtSource.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3105-000001.changeRegularToTaxAtSource.2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
