<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:tns ="http://www.swissdec.ch/schema/sd/20130115/SalaryDeclarationConsumerServiceTypes" 
		xmlns="http://www.swissdec.ch/schema/sd/20130115/SalaryDeclarationConsumerContainer"
		>
	<xsl:import href="elm-qst-1-3-language_fr.xsl"/>
	<xsl:import href="elm-qst-common-1-2_fr.xsl"/>

	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="yes"/>

	<xsl:variable name="sep1" select="'&#09;'" />
    <xsl:variable name="sep" select="';'" />
    <xsl:variable name="eol" select="'&#10;'" />
    <xsl:variable name="sslNumber" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='Institutions']/*[local-name()='TaxAtSource']/*[local-name()='CustomerIdentity']"/>
  
	
	<xsl:template match="/">
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="concat($elm-qst, ' | ', $elm-qst.taxAtSource)"/>
		</xsl:call-template>  
		<xsl:value-of select="$eol"/>
		<xsl:value-of select="$eol"/>
		
		<xsl:if test="//*[local-name()='TestCase']">
			<xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="concat(' ** ', $elm-qst.testDeliveryFlag, ' ** ')"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$eol"/>
		<xsl:value-of select="$eol"/>
		
		<!-- Section Company -->
		<xsl:call-template name="company-section"/>
		<xsl:value-of select="$eol"/>		
		
		<!-- Section Contact Person -->
		<xsl:call-template name="contactperson-section"/>
		<xsl:value-of select="$eol"/>
		
		<!-- Section Representation-->
		<xsl:if test="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']/*[local-name()='Delegate']">
			<xsl:call-template name="delegate-section"/>
			<xsl:value-of select="$eol"/>
		</xsl:if>
		
		<xsl:variable name="taxAtSourceTotal" select="(//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='SalaryTotals']/*[local-name()='TaxAtSourceTotals'])"/>
		
		<!-- Section QST Current Month-->
		<xsl:if test="$taxAtSourceTotal">
			<xsl:call-template name="overviewqst-month-section">
				<xsl:with-param name="month" select="$taxAtSourceTotal/*[local-name()='TotalMonth']"/>
			</xsl:call-template>
			<xsl:value-of select="$eol"/>
		</xsl:if>
		
		<!-- Section QST Corrections -->
		<xsl:for-each select="$taxAtSourceTotal/*[local-name()='CorrectionMonth']">
			<xsl:call-template name="overviewqst-month-section">
				<xsl:with-param name="month" select="."/>
			</xsl:call-template>
			<xsl:value-of select="$eol"/>
		</xsl:for-each>
		
		<!-- Section QST Total -->
		<xsl:if test="$taxAtSourceTotal">
			<xsl:call-template name="overviewqst-total-section">
					<xsl:with-param name="taxAtSourceTotals" select="$taxAtSourceTotal"/>
				</xsl:call-template>
			<xsl:value-of select="$eol"/>
		</xsl:if>
		
		<!-- Section ELM -->
		<xsl:call-template name="elm-section"/>
		<xsl:value-of select="$eol"/>
		
		<!-- Section Substitution -->
		<xsl:if test="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']">
			<xsl:call-template name="substitution-section"/>
			<xsl:value-of select="$eol"/>
		</xsl:if>
		
		<xsl:value-of select="$eol"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.tablecolumnexplanation1"/>
		</xsl:call-template>  
		<xsl:value-of select="$eol"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.tablecolumnentryreason"/>
		</xsl:call-template>  
		<xsl:value-of select="$eol"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.tablecolumnwithdrawalreason"/>
		</xsl:call-template>  
		<xsl:value-of select="$eol"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.tablecolumnmutationreason"/>
		</xsl:call-template>  
		<xsl:value-of select="$eol"/>
		<xsl:value-of select="$eol"/>
		
	<!-- Section table-->
	<!-- table header-->
	<xsl:if test="//*[local-name()='TestCase']">
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.testData"/>
		</xsl:call-template>  
		<xsl:value-of select="$sep"/>
	</xsl:if>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.ahvNumber"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.name"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.firstName"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.dateOfBirth"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.zipCode"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.city"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.cantonAbr"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.countryAbr"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.correctionAbr"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.ema"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.in"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.out"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.month"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.tarif"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.qstL"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.sbL"/>
	</xsl:call-template>  
	<xsl:value-of select="$sep"/>
	<xsl:call-template name="cvs-value">
		<xsl:with-param name="value" select="$elm-qst.qstB"/>
	</xsl:call-template>  
	<xsl:value-of select="$eol"/>

	<!-- table body-->
	<xsl:for-each select="//*[local-name()='Staff']/*[local-name()='Person']">
		<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
		<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>
		<xsl:variable name="person" select="."/>
		<xsl:for-each select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']">
			<xsl:sort select="./*[local-name()='CurrentMonth']" />
			<xsl:variable name="taxatsource" select="."/>
			<xsl:for-each select="./*[local-name()='Correction']">
				<xsl:sort select="./*[local-name()='Month']" />
				<xsl:if test="./*[local-name()='Old']">
					<xsl:call-template name="taxatsource-first-part">
						<xsl:with-param name="taxatsource" select="$taxatsource"/>
					</xsl:call-template>
					<xsl:call-template name="tax-at-source">
						<xsl:with-param name="person" select="$person"/>
						<xsl:with-param name="taxatsource" select="./*[local-name()='Old']"/>
						<xsl:with-param name="correctiontype" select="concat('', 'CorrectionOld')"/>
					</xsl:call-template>
					<xsl:value-of select="$eol"/>	
				</xsl:if>
				<xsl:if test="./*[local-name()='New']">
					<xsl:call-template name="taxatsource-first-part">
						<xsl:with-param name="taxatsource" select="$taxatsource"/>
					</xsl:call-template>
					<xsl:call-template name="tax-at-source">
						<xsl:with-param name="person" select="$person"/>
						<xsl:with-param name="taxatsource" select="./*[local-name()='New']"/>
						<xsl:with-param name="correctiontype" select="concat('', 'CorrectionNew')"/>
					</xsl:call-template>
					<xsl:value-of select="$eol"/>	
				</xsl:if>
				<xsl:if test="./*[local-name()='Difference']">
					<xsl:call-template name="taxatsource-first-part">
						<xsl:with-param name="taxatsource" select="$taxatsource"/>
					</xsl:call-template>
					<xsl:call-template name="tax-at-source">
						<xsl:with-param name="person" select="$person"/>
						<xsl:with-param name="taxatsource" select="./*[local-name()='Difference']"/>
						<xsl:with-param name="correctiontype" select="concat('', 'Difference')"/>
					</xsl:call-template>
					<xsl:value-of select="$eol"/>	
				</xsl:if>
				</xsl:for-each>
							<xsl:if test="./*[local-name()='Current']">
						<xsl:call-template name="taxatsource-first-part">
							<xsl:with-param name="taxatsource" select="$taxatsource"/>
						</xsl:call-template>
						<xsl:call-template name="tax-at-source">
							<xsl:with-param name="person" select="$person"/>
							<xsl:with-param name="taxatsource" select="./*[local-name()='Current']"/>
							<xsl:with-param name="correctiontype" select="concat('', 'Current')"/>
						</xsl:call-template>
						<xsl:value-of select="$eol"/>	
				</xsl:if>
		</xsl:for-each>	
	</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="taxatsource-first-part">
		<xsl:param name="taxatsource"/>
			<xsl:if test="//*[local-name()='TestCase']">
				<xsl:call-template name="cvs-value">
					<xsl:with-param name="value" select="$elm-qst.testData"/>
				</xsl:call-template>
				<xsl:value-of select="$sep"/>
			</xsl:if>
			<xsl:call-template name="personal-info">
				<xsl:with-param name="paticulars" select="$taxatsource/../../*[local-name()='Particulars']"/>
			</xsl:call-template>
			<xsl:call-template name="taxatsource-general">
				<xsl:with-param name="taxatsourcegeneral" select="$taxatsource"/>
			</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="elm-section">
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.elm"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.creationDate"/>
		</xsl:call-template><xsl:value-of select="$sep"/>"<xsl:call-template name="format-datetime"><xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='CreationDate']"/></xsl:call-template>"<xsl:value-of select="$eol"/>

		<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.transmissionDate"/>
		</xsl:call-template><xsl:value-of select="$sep"/>"<xsl:call-template name="format-datetime"><xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='TransmissionDate']"/></xsl:call-template>"<xsl:value-of select="$eol"/>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.declarationId"/>
			<xsl:with-param name="value" select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='DeclarationID']"/>
		</xsl:call-template>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.requestId"/>
			<xsl:with-param name="value" select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='DistributorRequestID']"/>
		</xsl:call-template>
		
	</xsl:template>
	
	<xsl:template name="substitution-section">
		<xsl:variable name="substitutionMapping" select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.substitution"/>
		</xsl:call-template><xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.reference"/>
			<xsl:with-param name="value" select="$elm-qst.referencetext"/>
		</xsl:call-template>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.requestId"/>
			<xsl:with-param name="value" select="$substitutionMapping/*[local-name()='MappedPredecessorDistributorRequestID']"/>
		</xsl:call-template>

		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.responseId"/>
			<xsl:with-param name="value" select="$substitutionMapping/*[local-name()='MappedPredecessorConsumerResponseID']"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="overviewqst-month-section">
		<xsl:param name="month"/>
		<xsl:variable name="monthLabel">
			<xsl:choose>
				<xsl:when test="local-name($month) = 'TotalMonth'">
					<xsl:value-of select="$elm-qst.totalMonth"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$elm-qst.totalCorrection"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="periodLabel">
			<xsl:choose>
				<xsl:when test="local-name($month) = 'TotalMonth'">
					<xsl:value-of select="$elm-qst.accountPeriod"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$elm-qst.monthPeriod"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="currentMonth">
			<xsl:choose>
				<xsl:when test="local-name($month) = 'TotalMonth'">
					<xsl:value-of select="$month/*[local-name()='CurrentMonth']"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$month/*[local-name()='Month']"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$monthLabel"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$periodLabel"/>
		</xsl:call-template><xsl:value-of select="$sep"/>"<xsl:call-template name="format-month"><xsl:with-param name="value" select="$currentMonth"/><xsl:with-param name="delimiter" select="'-'"/><xsl:with-param name="yearDigits" select="4"/></xsl:call-template>"<xsl:value-of select="$eol"/>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="concat('', $elm-qst.totalTaxableEarning)"/>
			<xsl:with-param name="value" select="concat('CHF ', format-number($month/*[local-name()='TotalTaxableEarning'], $cents-format))"/>
		</xsl:call-template>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="concat('', $elm-qst.totalTaxAtSource)"/>
			<xsl:with-param name="value" select="concat('CHF ', format-number($month/*[local-name()='TotalTaxAtSource'], $cents-format))"/>
		</xsl:call-template>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="concat('', $elm-qst.totalCommission)"/>
			<xsl:with-param name="value" select="concat('CHF ', format-number($month/*[local-name()='TotalCommission'], $cents-format))"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="overviewqst-total-section">
		<xsl:param name="taxAtSourceTotals"/>
		
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.total"/>
		</xsl:call-template>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="concat('', $elm-qst.totalTaxableEarning)"/>
			<xsl:with-param name="value" select="concat('CHF ', format-number(sum($taxAtSourceTotals/*[local-name()='TotalMonth' or local-name()='CorrectionMonth']/*[local-name()='TotalTaxableEarning']), $cents-format))"/>
		</xsl:call-template>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="concat('', $elm-qst.totalTaxAtSource)"/>
			<xsl:with-param name="value" select="concat('CHF ', format-number(sum($taxAtSourceTotals/*[local-name()='TotalMonth' or local-name()='CorrectionMonth']/*[local-name()='TotalTaxAtSource']), $cents-format))"/>
		</xsl:call-template>
		
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="concat('', $elm-qst.totalCommission)"/>
			<xsl:with-param name="value" select="concat('CHF ', format-number(sum($taxAtSourceTotals/*[local-name()='TotalMonth' or local-name()='CorrectionMonth']/*[local-name()='TotalCommission']), $cents-format))"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="contactperson-section">
		<xsl:variable name="contact" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='ContactPerson']"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.contactPerson"/>
		</xsl:call-template><xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.name"/>
			<xsl:with-param name="value" select="$contact/*[local-name()='Name']"/>
		</xsl:call-template>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.email"/>
			<xsl:with-param name="value" select="$contact/*[local-name()='EmailAddress']"/>
		</xsl:call-template>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.telefon"/>
			<xsl:with-param name="value" select="$contact/*[local-name()='PhoneNumber']"/>
		</xsl:call-template>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.mobil"/>
			<xsl:with-param name="value" select="$contact/*[local-name()='MobilePhoneNumber']"/>
		</xsl:call-template>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.comment"/>
			<xsl:with-param name="value" select="$contact/../*[local-name()='Comment']"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="company-section">
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.company"/>
		</xsl:call-template><xsl:call-template name="company-info">
			<xsl:with-param name="company" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']"/>
			<xsl:with-param name="sslNumber" select="$sslNumber"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="delegate-section">
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.delegate"/>
		</xsl:call-template><xsl:call-template name="company-info">
			<xsl:with-param name="company" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']/*[local-name()='Delegate']"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="company-info">
		<xsl:param name="sslNumber"/>
		<xsl:param name="company"/>
		<xsl:if test="$sslNumber">
			<xsl:call-template name="intro-line">
				<xsl:with-param name="name" select="$elm-qst.sslNumber"/>
				<xsl:with-param name="value" select="$sslNumber"/>	
			</xsl:call-template>
		</xsl:if>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.name"/>
			<xsl:with-param name="value" select="$company/*[local-name()='Name']/*[local-name()='HR-RC-Name']"/>
		</xsl:call-template>
		<xsl:if test="$company/*[local-name()='Owner']">
			<xsl:call-template name="intro-line">
				<xsl:with-param name="name" select="$elm-qst.owner"/>
				<xsl:with-param name="value" select="concat($company/*[local-name()='Owner']/*[local-name()='Lastname'], ', ', $company/*[local-name()='Owner']/*[local-name()='Firstname'])"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.uidbfs"/>
			<xsl:with-param name="value" select="$company/*[local-name()='UID-BFS']"/>
		</xsl:call-template>
		<xsl:call-template name="intro-line">
			<xsl:with-param name="name" select="$elm-qst.uiderha"/>
			<xsl:with-param name="value" select="$company/*[local-name()='UID-EHRA']"/>
		</xsl:call-template>
		<xsl:call-template name="address">
			<xsl:with-param name="address" select="$company/*[local-name()='Address']"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="address">
		<xsl:param name="address"/>
		<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$elm-qst.address"/>
		</xsl:call-template>
		<xsl:if test="$address/*[local-name()='ComplementaryLine']">
			<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="$address/*[local-name()='ComplementaryLine']"/>
			</xsl:call-template>
			<xsl:value-of select="$eol"/>
			<xsl:value-of select="$sep"/>
		</xsl:if>
		<xsl:if test="$address/*[local-name()='Street']">
			<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="$address/*[local-name()='Street']"/>
			</xsl:call-template>
			<xsl:value-of select="$eol"/>
			<xsl:value-of select="$sep"/>
		</xsl:if>	
		<xsl:if test="$address/*[local-name()='Postbox']">
			<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="$address/*[local-name()='Postbox']"/>
			</xsl:call-template>
			<xsl:value-of select="$eol"/>
			<xsl:value-of select="$sep"/>
		</xsl:if>
		<xsl:if test="$address/*[local-name()='Locality']">
			<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="$address/*[local-name()='Locality']"/>
			</xsl:call-template>
			<xsl:value-of select="$eol"/>
			<xsl:value-of select="$sep"/>
		</xsl:if>
		<xsl:variable name="concatAddr">
			<xsl:choose>
				<xsl:when test="$address/*[local-name()='Country']"><xsl:value-of select="concat(concat($address/*[local-name()='ZIP-Code'], ' ', $address/*[local-name()='City']), ', ', $address/*[local-name()='Country'])"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="concat($address/*[local-name()='ZIP-Code'], ' ', $address/*[local-name()='City'])"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$concatAddr"/>
		</xsl:call-template>
		<xsl:value-of select="$eol"/>
	</xsl:template>
	
	<xsl:template name="intro-line">
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:value-of select="$sep"/><xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$name"/>
		</xsl:call-template><xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$value"/>
		</xsl:call-template>
		<xsl:value-of select="$eol"/>
	</xsl:template>
	
	
	<xsl:template name="ahv-number">
		<xsl:param name="insurance-identification"/>
		<xsl:if test="$insurance-identification/*[local-name()='SV-AS-Number']">
			<xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="$insurance-identification/*[local-name()='SV-AS-Number']"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="personal-info">
		<xsl:param name="paticulars"/>
		<xsl:call-template name="ahv-number">
			<xsl:with-param name="insurance-identification" select="$paticulars/*[local-name()='Social-InsuranceIdentification']"/>
		</xsl:call-template> 
		<xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$paticulars/*[local-name()='Lastname']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$paticulars/*[local-name()='Firstname']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:variable name="birthdate">
			<xsl:call-template name="format-date">
				<xsl:with-param name="value" select="$paticulars/*[local-name()='DateOfBirth']"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$birthdate"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$paticulars/*[local-name()='Address']/*[local-name()='ZIP-Code']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$paticulars/*[local-name()='Address']/*[local-name()='City']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
	</xsl:template>
	
	<xsl:template name="taxatsource-general">
		<xsl:param name="taxatsourcegeneral"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$taxatsourcegeneral/*[local-name()='TaxAtSourceCanton']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
	</xsl:template>
	
	<xsl:template name="tax-at-source">
		<xsl:param name="person"/>
		<xsl:param name="taxatsource"/>
		<xsl:param name="correctiontype"/>
		<xsl:variable name="entryDate">
			<xsl:call-template name="format-date">
				<xsl:with-param name="value" select="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']"/>
				<xsl:with-param name="yearDigits" select="2"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="withdrawalDate">
			<xsl:choose>
				<xsl:when test="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']">
					<xsl:call-template name="format-date">
							<xsl:with-param name="value" select="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']"/>
							<xsl:with-param name="yearDigits" select="2"/>
						</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$person/*[local-name()='Work']/*[local-name()='WithdrawalDate']">
						<xsl:call-template name="format-date">
							<xsl:with-param name="value" select="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']"/>
							<xsl:with-param name="yearDigits" select="2"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>		
		</xsl:variable>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$taxatsource/*[local-name()='Residence']/*[local-name()='AbroadCountry']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:text>"</xsl:text><xsl:call-template name="correction-type">
			<xsl:with-param name="value" select="$correctiontype"/>
		</xsl:call-template><xsl:text>"</xsl:text>
		<xsl:value-of select="$sep"/>
		<xsl:text>"</xsl:text><xsl:call-template name="ema">
			<xsl:with-param name="taxatsource" select="$taxatsource"/>
		</xsl:call-template><xsl:text>"</xsl:text>
		<xsl:value-of select="$sep"/>
		<xsl:if test="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Entry']">
			<xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="$entryDate"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$sep"/>
		<xsl:if test="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']">
			<xsl:call-template name="cvs-value">
				<xsl:with-param name="value" select="$withdrawalDate"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:value-of select="$sep"/>
		<!-- TODO: Month-->
		<xsl:call-template name="taxmonth">
			<xsl:with-param name="correctiontype" select="$correctiontype"/>
			<xsl:with-param name="taxatsource" select="$taxatsource"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:variable name="taxatsourcecat">
			<xsl:call-template name="decode-taxatsource-category">
				<xsl:with-param name="value" select="$taxatsource/*[local-name()='TaxAtSourceCategory']"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$taxatsourcecat"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$taxatsource/*[local-name()='TaxableEarning']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$taxatsource/*[local-name()='AscertainedTaxableEarning']"/>
		</xsl:call-template>
		<xsl:value-of select="$sep"/>
		<xsl:call-template name="cvs-value">
			<xsl:with-param name="value" select="$taxatsource/*[local-name()='TaxAtSource']"/>
		</xsl:call-template>
	</xsl:template>
		
	<xsl:template name="taxmonth">
		<xsl:param name="correctiontype"/>
		<xsl:param name="taxatsource"/>
		<xsl:variable name="trimmed-value" select="normalize-space($correctiontype)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'Current'">
				<xsl:call-template name="cvs-value">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='CurrentMonth']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'CorrectionOld'">
				<xsl:call-template name="cvs-value">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='Month']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'CorrectionNew'">
				<xsl:call-template name="cvs-value">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='Month']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'Difference'">
				<xsl:call-template name="cvs-value">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='Month']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
		
	<!-- Function to add quates to the values (and escape them if needed) -->
	<xsl:template name="cvs-value">
		<xsl:param name="value" />
		<xsl:text>"</xsl:text>
			<xsl:call-template name="search-and-replace">
				<xsl:with-param name="input" select="$value"/>
				<xsl:with-param name="search-string" select="concat('', '&quot;')"/>
				<xsl:with-param name="replace-string" select="concat('', '&quot;&quot;')"/>
			</xsl:call-template>
		<xsl:text>"</xsl:text>
	</xsl:template>    
	
	<!-- Replace function, used to escape quates -->
	<xsl:template name="search-and-replace">
		 <xsl:param name="input"/>
		 <xsl:param name="search-string"/>
		 <xsl:param name="replace-string"/>
		 <xsl:choose>
			  <!-- See if the input contains the search string -->
			  <xsl:when test="$search-string and 
							   contains($input,$search-string)">
			  <!-- If so, then concatenate the substring before the search
			  string to the replacement string and to the result of
			  recursively applying this template to the remaining substring.
			  -->
				   <xsl:value-of 
						select="substring-before($input,$search-string)"/>
				   <xsl:value-of select="$replace-string"/>
				   <xsl:call-template name="search-and-replace">
						<xsl:with-param name="input"
						select="substring-after($input,$search-string)"/>
						<xsl:with-param name="search-string" 
						select="$search-string"/>
						<xsl:with-param name="replace-string" 
							select="$replace-string"/>
				   </xsl:call-template>
			  </xsl:when>
			  <xsl:otherwise>
				   <!-- There are no more occurences of the search string so 
				   just return the current input string -->
				   <xsl:value-of select="$input"/>
			  </xsl:otherwise>
		 </xsl:choose>
	</xsl:template>

</xsl:stylesheet>


