<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/4"
	xmlns:eahv-iv-2015-000501="http://www.eahv-iv.ch/xmlns/eahv-iv-2015-000501/7"
    xmlns:eahv-iv-2015-common="http://www.eahv-iv.ch/xmlns/eahv-iv-2015-common/7">

	<!--
	<xsl:import href="../../eahv-iv-common/3/eahv-iv-common-3-0_fr.xsl"/>
	<xsl:import href="../../eahv-iv-common/3/ech-0010-4-0_fr.xsl"/>
	-->
	<xsl:import href="../../eahv-iv-2015-common/7/eahv-iv-2015-common-7-0_fr.xsl"/>
	<xsl:import href="../../eahv-iv-common/4/eahv-iv-common-4-0_fr.xsl"/>
	<xsl:import href="../../eahv-iv-common/3/ech-0010-4-0_fr.xsl"/>
	<xsl:import href="../../eahv-iv-common/4/sedex-id-2-0.xsl"/>
	<xsl:import href="2015-000501-language-7-0_fr.xsl"/>
	
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2015-000501:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2015-000501:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2015-000501:header" mode="message-header-block"/>
					<xsl:apply-templates select="//eahv-iv-2015-000501:header" mode="special-message"/>
					<xsl:apply-templates select="//eahv-iv-2015-000501:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2015-000501:header"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="eahv-iv-2015-000501:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-common"/> | <xsl:value-of select="$eahv-iv-2015-000501"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-common.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="eahv-iv-2015-common:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-common.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="eahv-iv-2015-common:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-common.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2015-common:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.declarationLocalReference"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="eahv-iv-2015-000501:declarationLocalReference" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="eahv-iv-2015-000501:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.originalSenderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id" select="eahv-iv-2015-000501:originalSenderId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.initialMessageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2015-000501:initialMessageDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.ourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2015-000501:ourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2015-000501:yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-common.eventDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2015-common:eventDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.eventPeriod"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-string">
															<xsl:with-param name="value" select="eahv-iv-2015-000501:eventPeriod"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2015-000501.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(eahv-iv-2015-000501:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="eahv-iv-2015-000501:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2015-common:testDeliveryFlag = '1') or (eahv-iv-2015-common:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="eahv-iv-2015-000501:action != 1 and eahv-iv-2015-000501:action != 5 and eahv-iv-2015-000501:action != 6"/>
		<xsl:variable name="is-priority" select="eahv-iv-2015-000501:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2015-000501:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($eahv-iv-2015-000501.messagePriority, ': ')"/>
					<xsl:value-of select="eahv-iv-2015-000501:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2015-common.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="eahv-iv-2015-000501:header">
		<xsl:apply-templates select="eahv-iv-2015-000501:object"/>
		<xsl:apply-templates select="eahv-iv-2015-000501:comment"/>
		<xsl:if test="count(eahv-iv-2015-000501:attachment) > 0">
			<fo:table table-layout="fixed" width="100%" border-collapse="separate">
				<fo:table-column column-width="{$title-column-width}" column-number="1"/>
				<fo:table-column column-width="{$description-column-table-width}" column-number="2"/>
				<fo:table-column column-width="{$docpath-column-width}" column-number="3"/>
				<fo:table-column column-width="{$doctype-column-width}" column-number="4"/>
				<fo:table-header>
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
							<fo:block><xsl:value-of select="$eahv-iv-2015-000501.attachment"/></fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="table-denom-column">
							<fo:block/>
						</fo:table-cell>
						<fo:table-cell column-number="3" xsl:use-attribute-sets="table-title-column">
							<fo:block><xsl:value-of select="$eahv-iv-2015-000501.pathFileName"/></fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="4" xsl:use-attribute-sets="table-title-column">
							<fo:block><xsl:value-of select="$eahv-iv-2015-000501.documentFormat"/></fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-header>
				<fo:table-body>
					<xsl:for-each select="eahv-iv-2015-000501:attachment">
						<xsl:sort data-type="number" select="eahv-iv-2015-000501:sortOrder"/>
						<xsl:apply-templates select="."/>
					</xsl:for-each>
				</fo:table-body>
			</fo:table>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="eahv-iv-2015-000501:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2015-000501.comment"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!--
		Cover sheet: attachment list from the message header
	-->
	<xsl:template match="eahv-iv-2015-000501:attachment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
				<fo:block/>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="first-value-column">
				<fo:block>
					<xsl:value-of select="eahv-iv-2015-000501:title"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
				<xsl:for-each select="eahv-iv-2015-000501:file">
					<xsl:sort data-type="number" select="eahv-iv-2015-000501:sortOrder"/>
					<fo:block>
						<xsl:value-of select="substring-after(eahv-iv-2015-000501:pathFileName, '/')"/>
					</fo:block>
				</xsl:for-each>
			</fo:table-cell>
			<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-mime">
						<xsl:with-param name="value" select="eahv-iv-2015-000501:documentFormat"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="eahv-iv-2015-000501:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2015-000501:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="eahv-iv-2015-000501:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2015-common:messageType"/>/<xsl:value-of select="eahv-iv-2015-000501:subMessageType"/>
							| <xsl:value-of select="concat($eahv-iv-2015-common.messageId, ' ')"/>
							<xsl:value-of select="eahv-iv-2015-common:messageId"/>
							<xsl:if test="eahv-iv-2015-000501:referenceMessageId">
								| <xsl:value-of select="concat($eahv-iv-2015-000501.referenceMessageId, ' ')"/>
								<xsl:value-of select="eahv-iv-2015-000501:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="eahv-iv-2015-000501:uniqueIdBusinessTransaction">
								| <xsl:value-of select="concat($eahv-iv-2015-000501.uniqueIdBusinessTransaction, ' ')"/>
								<xsl:value-of select="eahv-iv-2015-000501:uniqueIdBusinessTransaction"/>
							</xsl:if>
							| <xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>


	<!-- ************* Decodings templates *************** -->
	
	<!--
		Decode an action to a human readable string.
		@param value the action to be decoded (as defined in ssk/eahv-iv)
	-->
	<xsl:template name="decode-action">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-000501.action.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2015-000501.action.3"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2015-000501.action.4"/></xsl:when>
			<xsl:when test="$trimmed-value = '7'"><xsl:value-of select="$eahv-iv-2015-000501.action.7"/></xsl:when>
			<xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eahv-iv-2015-000501.action.10"/></xsl:when>
			<xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eahv-iv-2015-000501.action.12"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
		Decode a MIME type to a human readable string.
		@param value the type to be decoded
	-->
	<xsl:template name="decode-mime">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'image/tiff'">TIFF</xsl:when>
			<xsl:when test="$trimmed-value = 'application/pdf'">PDF</xsl:when>
			<xsl:when test="$trimmed-value = 'application/zip'">ZIP</xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- ************* Formatting variables and templates *************** -->
	
	<!-- Page margins -->
	<xsl:variable name="page-margins">13mm 13mm 8mm 13mm</xsl:variable>
	<xsl:variable name="first-header-height">0mm</xsl:variable>
	<xsl:variable name="header-height">11mm</xsl:variable>
	<xsl:variable name="footer-height">8mm</xsl:variable>
	<xsl:variable name="first-body-top-margin">0mm</xsl:variable>
	<xsl:variable name="body-top-margin">11mm</xsl:variable>
	<xsl:variable name="body-bottom-margin">12mm</xsl:variable>
	
	<!-- Some standard definitions for the layout of data blocks in PDF message layout -->
	<!-- White space between data blocks -->
	<xsl:variable name="space-after-blocks">6mm</xsl:variable>
	<!-- Font to use -->
	<xsl:variable name="font-family">Liberation Sans</xsl:variable>
	
	<!-- Width of the left header column on first page -->
	<xsl:variable name="header-left-column-width">92mm</xsl:variable>
	<!-- Width of the right header column on first page -->
	<xsl:variable name="header-right-column-width">proportional-column-width(1)</xsl:variable>
	<!-- Width of the title column (leftmost column of a data block) -->
	<xsl:variable name="title-column-width">38mm</xsl:variable>
	<!-- Width of the description column (second column of a data block) -->
	<xsl:variable name="description-column-width">50mm</xsl:variable>
	<!-- Width of the description column (second column of a data block), when in a table -->
	<xsl:variable name="description-column-table-width">proportional-column-width(1)</xsl:variable>
	<!-- Width of an interest column (showing interest rate) -->
	<xsl:variable name="interest-column-width">13mm</xsl:variable>
	<!-- Width of value column (showing amounts) -->
	<xsl:variable name="value-column-width">25mm</xsl:variable>
	<!-- Width of doctype column (showing amounts) -->
	<xsl:variable name="docpath-column-width">50mm</xsl:variable>
	<!-- Width of doctype column (showing amounts) -->
	<xsl:variable name="doctype-column-width">26mm</xsl:variable>
	
	<!-- Colordefinition for grey background -->
	<xsl:variable name="grey-background">#cdcdcd</xsl:variable>
	
	<xsl:variable name="lower-case">abcdefghijklmnopqrstuvwxyzäöüàéè</xsl:variable>
	<xsl:variable name="upper-case">ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÀÉÈ</xsl:variable>
	
	<!--
		Format a date for display in PDF.
		@param value the date to be formatted (as defined in xs:date)
	-->
	<xsl:template name="format-date">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="string-length($trimmed-value) > 0">
				<xsl:variable name="year" select="substring($trimmed-value, 1, 4)"/>
				<xsl:variable name="month" select="substring($trimmed-value, 6, 2)"/>
				<xsl:variable name="day" select="substring($trimmed-value, 9, 2)"/>
				<xsl:value-of select="$day"/>.<xsl:value-of select="$month"/>.<xsl:value-of select="$year"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!--
		Format a string, i.e. output the string
		@param value string to format
	-->
	<xsl:template name="format-string">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
				<xsl:value-of select="$trimmed-value"/>
	</xsl:template>
	
	<!-- ************* Templates specific to PDF message formatting *************** -->
	
	<!-- attribute set for fixed message header block (denomination column) -->
	<xsl:attribute-set name="header-denom-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="border-top-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="padding-bottom">3mm</xsl:attribute>
		<xsl:attribute name="margin-left">0mm</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for fixed message header block (value column) -->
	<xsl:attribute-set name="header-value-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="padding-bottom">3mm</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for for the footer -->
	<xsl:attribute-set name="footer">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block left column (block title) -->
	<xsl:attribute-set name="main-left-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="margin-left">0mm</xsl:attribute>
		<xsl:attribute name="border-top-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block right column (block contents of fixed size blocks) -->
	<xsl:attribute-set name="main-right-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
		<xsl:attribute name="border-left-color">black</xsl:attribute>
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block (first column, non-first rows of dynamic size blocks) -->
	<xsl:attribute-set name="table-left-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="margin-left">0mm</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block (description column for fixed size blocks) -->
	<xsl:attribute-set name="denom-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="margin-left">0mm</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block (table column title for dynamic size blocks) -->
	<xsl:attribute-set name="table-title-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
		<xsl:attribute name="border-top-color">black</xsl:attribute>
		<xsl:attribute name="border-top-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block (description column for dynamic size blocks) -->
	<xsl:attribute-set name="table-denom-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
		<xsl:attribute name="border-left-color">black</xsl:attribute>
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block (value column) -->
	<xsl:attribute-set name="value-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- attribute set for information block (value-like description column for dynamic size blocks) -->
	<xsl:attribute-set name="first-value-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
		<xsl:attribute name="border-left-color">black</xsl:attribute>
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<!-- ****************  Message content starts here *************** -->
	
</xsl:stylesheet>