<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : 0104-68-2-1_de.xsl
    Created on : September 23, 2010, 1:57 PM
    Author     : sberthouzoz
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
                xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/3"
                xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044/1"
                xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/1"
                xmlns:eCH-0104="http://www.ech.ch/xmlns/eCH-0104/2"
                xmlns:eCH-0104-68="http://www.ech.ch/xmlns/eCH-0104-68/2">

    <xsl:import href="../../eahv-iv-common/1/eahv-iv-common-1-2_de.xsl"/>
    <xsl:import href="eCH-0104-68-language-2-1_de.xsl"/>
    <!--
                Parameter receipt date to be passed in when creating the message layout.
                This must be a valid xs:date
        -->
    <xsl:param name="dateOfReceipt"></xsl:param>

    <!--
                The main template, defining page masters, sequence masters and page sequence
        -->
    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master margin="{$page-margins}" master-name="first-page">
                    <xsl:attribute name="page-height">297mm</xsl:attribute>
                    <xsl:attribute name="page-width">210mm</xsl:attribute>
                    <fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
                    <fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
                    <fo:region-after region-name="page-footer" extent="{$footer-height}"/>
                </fo:simple-page-master>
                <fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
                    <xsl:attribute name="page-height">297mm</xsl:attribute>
                    <xsl:attribute name="page-width">210mm</xsl:attribute>
                    <fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
                    <fo:region-before region-name="page-header" extent="{$header-height}"/>
                    <fo:region-after region-name="page-footer" extent="{$footer-height}"/>
                </fo:simple-page-master>
                <fo:page-sequence-master master-name="pages-content">
                    <fo:single-page-master-reference master-reference="first-page"/>
                    <fo:repeatable-page-master-reference master-reference="other-pages"/>
                </fo:page-sequence-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="pages-content">
                <fo:static-content flow-name="page-header">
                    <xsl:apply-templates select="//eCH-0104-68:header" mode="page-header"/>
                </fo:static-content>
                <fo:static-content flow-name="page-footer">
                    <xsl:apply-templates select="//eCH-0104-68:header" mode="page-footer"/>
                </fo:static-content>
                <fo:flow flow-name="page-body">
                    <xsl:apply-templates select="//eCH-0104-68:header" mode="message-header-block"/>
                    <xsl:apply-templates select="//eCH-0104-68:header" mode="special-message"/>
                    <xsl:apply-templates select="//eCH-0104-68:header" mode="page-header"/>
                    <fo:block background-color="{$grey-background}" font-family="{$font-family}">
                        <xsl:if test="count(eCH-0104-68:message) > 0">
                            <xsl:attribute name="page-break-after">always</xsl:attribute>
                        </xsl:if>
                        <fo:block background-color="white" margin-left="3mm" padding-left="4mm">
                            <xsl:apply-templates select="//eCH-0104-68:header"/>
                        </fo:block>
                    </fo:block>
                    <xsl:apply-templates select="//eCH-0104-68:newBenefit | //eCH-0104-68:benefitMutation | //eCH-0104-68:benefitCancellation"/>
                    <fo:block id="pageCounter" keep-with-previous="always"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template match="eCH-0104-68:header" mode="message-header-block">
        <fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
            <fo:table table-layout="fixed" width="100%">
                <fo:table-column column-width="100%" column-number="1"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell column-number="1" display-align="center">
                            <fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
                                <xsl:value-of select="$eahv-iv-common"/> | <xsl:value-of select="$eCH-0104-68"/>
                            </fo:block>
                            <fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
            <fo:block background-color="white" margin-top="3mm" margin-left="3mm">
                <fo:block margin-top="4mm" margin-left="4mm">
                    <fo:table table-layout="fixed" width="100%">
                        <fo:table-column column-width="{$header-left-column-width}" column-number="1" />
                        <fo:table-column column-width="{$header-right-column-width}" column-number="2" />
                        <fo:table-body>
                            <fo:table-row>
                                <!-- left column, show sender, recipient and local reference -->
                                <fo:table-cell column-number="1" margin-left="0mm">
                                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                                        <fo:table-column column-width="38mm" column-number="1"/>
                                        <fo:table-column column-width="47mm" column-number="2"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.senderId"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:call-template name="decode-sedex-id">
                                                            <xsl:with-param name="id"><xsl:value-of select="eCH-0104-68:senderId"/></xsl:with-param>
                                                        </xsl:call-template>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.recipientId"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:for-each select="eCH-0104-68:recipientId">
                                                            <xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
                                                            <xsl:call-template name="decode-sedex-id">
                                                                <xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
                                                            </xsl:call-template>
                                                        </xsl:for-each>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.messageDate"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:call-template name="format-date">
                                                            <xsl:with-param name="value"><xsl:value-of select="eCH-0104-68:messageDate"/></xsl:with-param>
                                                        </xsl:call-template>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.declarationLocalReference"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:apply-templates select="eCH-0104-68:declarationLocalReference" mode="block"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                                <!-- right column, shows other header details -->
                                <fo:table-cell column-number="2" margin-left="0mm">
                                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                                        <fo:table-column column-width="38mm" column-number="1"/>
                                        <fo:table-column column-width="47mm" column-number="2"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.action"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:call-template name="decode-action">
                                                            <xsl:with-param name="value" select="eCH-0104-68:action"/>
                                                        </xsl:call-template>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.originalSenderId"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:call-template name="decode-sedex-id">
                                                            <xsl:with-param name="id" select="eCH-0104-68:originalSenderId"/>
                                                        </xsl:call-template>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.initialMessageDate"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:call-template name="format-date">
                                                            <xsl:with-param name="value" select="eCH-0104-68:initialMessageDate"/>
                                                        </xsl:call-template>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.ourBusinessReferenceID"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block><xsl:value-of select="eCH-0104-68:ourBusinessReferenceID"/></fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.yourBusinessReferenceId"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block><xsl:value-of select="eCH-0104-68:yourBusinessReferenceId"/></fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.eventDate"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:call-template name="format-date">
                                                            <xsl:with-param name="value" select="eCH-0104-68:eventDate"/>
                                                        </xsl:call-template>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eahv-iv-common.pages"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
                                                    <fo:block><xsl:value-of select="$eCH-0104-68.attachment"/></fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
                                                    <fo:block>
                                                        <xsl:value-of select="count(eCH-0104-68:attachment)"/>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </fo:block>
        </fo:block>
    </xsl:template>

    <!--
                Collaborator block within message header block
        -->
    <xsl:template match="eCH-0104-68:declarationLocalReference" mode="block">
        <fo:block>
            <xsl:call-template name="format-string">
                <xsl:with-param name="value" select="eahv-iv-common:name"/>
            </xsl:call-template>
        </fo:block>
        <fo:block>
            <xsl:call-template name="format-string">
                <xsl:with-param name="value" select="eahv-iv-common:department"/>
            </xsl:call-template>
        </fo:block>
        <fo:block>T:
            <xsl:call-template name="format-string">
                <xsl:with-param name="value" select="eahv-iv-common:phone"/>
            </xsl:call-template>
        </fo:block>
        <fo:block>
            <xsl:call-template name="format-string">
                <xsl:with-param name="value" select="eahv-iv-common:email"/>
            </xsl:call-template>
        </fo:block>
    </xsl:template>

    <!--
                Conditional "Alert" if there is something special about this message
        -->
    <xsl:template match="eCH-0104-68:header" mode="special-message">
        <xsl:variable name="is-test" select="(eCH-0104-68:testDeliveryFlag = '1') or (eCH-0104-68:testDeliveryFlag = 'true')"/>
        <xsl:variable name="is-special" select="eCH-0104-68:action != 1 and eCH-0104-68:action != 5 and eCH-0104-68:action != 6"/>
        <xsl:variable name="is-priority" select="eCH-0104-68:messagePriority > 0"/>
        <xsl:if test="$is-test or $is-special or $is-priority">
            <fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
                <xsl:if test="$is-special">
                    <xsl:call-template name="decode-action">
                        <xsl:with-param name="value" select="eCH-0104-68:action"/>
                    </xsl:call-template>
                </xsl:if>
            </fo:block>
        </xsl:if>
    </xsl:template>

    <!--
                Cover sheet: further information from the header part of the message
        -->
    <xsl:template match="eCH-0104-68:header">
        <xsl:apply-templates select="eCH-0104-68:comment"/>
    </xsl:template>

    <!--
                Cover sheet: comment
        -->
    <xsl:template match="eCH-0104-68:comment">
        <fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$eCH-0104-68.comment"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:block linefeed-treatment="preserve">
                            <xsl:value-of select="."/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="header">
        <xsl:param name="value"/>
        <fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
            <fo:table-column column-width="3mm" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell height="7mm" column-number="2" display-align="center">
                        <fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}">
                            <xsl:value-of select="$value"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell height="4mm" background-color="white" column-number="2">
                        <fo:block />
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>
    
    <!--
        Page header, shows the message subject in a bar on first page and as header in subsequent pages.
    -->
    <xsl:template mode="page-header" match="eCH-0104-68:header">
        <fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
            <fo:table-column column-width="3mm" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell height="7mm" column-number="2" display-align="center">
                        <fo:block margin-left="4mm" font-family="{$font-family}" font-weight="bold" >
                            <xsl:choose>
                                <xsl:when test="eCH-0104-68:subject">
                                    <xsl:value-of select="eCH-0104-68:subject"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$eCH-0104-68.title"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell height="4mm" background-color="white" column-number="2">
                        <fo:block/>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>
    <!--
                Page footer, shows page numbers and some info from message header.
        -->
    <xsl:template mode="page-footer" match="eCH-0104-68:header">
        <fo:table table-layout="fixed" width="100%">
            <fo:table-column column-width="170mm" column-number="1"/>
            <fo:table-column column-width="15mm" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
                        <fo:block font-family="{$font-family}">
                            <xsl:value-of select="eCH-0104-68:messageType"/>/<xsl:value-of select="eCH-0104-68:subMessageType"/>
                            | <xsl:value-of select="concat($eCH-0104-68.messageId, ' ')"/>
                            <xsl:value-of select="eCH-0104-68:messageId"/>
                            <xsl:if test="count(eCH-0104-68:referenceMessageId) != 0">
                                | <xsl:value-of select="concat($eCH-0104-68.referenceMessageId, ' ')"/>
                                <xsl:value-of select="eCH-0104-68:referenceMessageId"/>
                            </xsl:if>
                            | <xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/>
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
                        <fo:block font-family="{$font-family}">
                            <fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <!--
                ****************  Message content starts here ***************
         -->

        <!--
                "Main" template for the message content; shows all relevant content blocks
        -->

    <xsl:template match="eCH-0104-68:newBenefit | eCH-0104-68:benefitMutation | eCH-0104-68:benefitCancellation">
        <fo:block background-color="{$grey-background}" font-family="{$font-family}">
            <fo:block background-color="white" margin-left="3mm" padding-left="4mm">
                <fo:block>
                    <xsl:if test="position() != last()">
                        <xsl:attribute name="page-break-after">always</xsl:attribute>
                    </xsl:if>
                    <xsl:call-template name="double-string-block" >
                        <xsl:with-param name="title1" select="$eCH-0104.deliveryOffice" />
                        <xsl:with-param name="value1" select="eCH-0104:deliveryOffice/eCH-0104:officeIdentifier" />
                        <xsl:with-param name="title2" select="$recordNumber" />
                        <xsl:with-param name="value2" select="eCH-0104:recordNumber" />
                    </xsl:call-template>
                    <xsl:call-template name="double-string-block" >
                        <xsl:with-param name="title1" select="$vn" />
                        <xsl:with-param name="value1" select="eCH-0104-68:child/eCH-0104:vn" />
                        <xsl:with-param name="title2" select="$eCH-0104.familyAllowanceType" />
                        <xsl:with-param name="value2">
                            <xsl:call-template name="decode-familyAllowanceType">
                                <xsl:with-param name="value" select="eCH-0104:familyAllowanceType"/>
                            </xsl:call-template>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:block>
        </fo:block>
        <fo:block space-after="1mm"></fo:block>
        <xsl:call-template name="header">
            <xsl:with-param name="value">
                <xsl:choose>
                    <xsl:when test="local-name()='newBenefit'">
                        <xsl:value-of select="$eCH-0104-68.newBenefit"/>
                    </xsl:when>
                    <xsl:when test="local-name()='benefitMutation'">
                        <xsl:value-of select="$eCH-0104-68.benefitMutation"/>
                    </xsl:when>
                    <xsl:when test="local-name()='benefitCancellation'">
                        <xsl:value-of select="$eCH-0104-68.benefitCancellation"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
        <fo:block background-color="{$grey-background}" font-family="{$font-family}">
            <fo:block background-color="white" margin-left="3mm" padding-left="4mm">
                <xsl:call-template name="double-prefix-string-block">
                    <xsl:with-param name="title1" select="$eCH-0104.legalOffice"/>
                    <xsl:with-param name="title2" select="$eCH-0104.officeIdentifier"/>
                    <xsl:with-param name="value" select="eCH-0104:legalOffice/eCH-0104:officeIdentifier"/>
                </xsl:call-template>
                <xsl:if test="local-name()!='benefitCancellation'">
                    <xsl:if test="eCH-0104:contact">
                        <xsl:call-template name="contact"/>
                    </xsl:if>
                    <xsl:call-template name="allowance"/>
                    <xsl:call-template name="beneficiary"/>
                </xsl:if>
                <xsl:if test="eCH-0104:comment">
                    <xsl:call-template name="comment"/>
                </xsl:if>
                <xsl:if test="eCH-0104:specialTreatment">
                    <xsl:call-template name="specialTreatment"/>
                </xsl:if>
            </fo:block>
        </fo:block>
    </xsl:template>

    <xsl:template name="decode-familyAllowanceType">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="$trimmed-value = '01'"><xsl:value-of select="$eCH-0104.familyAllowanceType.01"/></xsl:when>
            <xsl:when test="$trimmed-value = '02'"><xsl:value-of select="$eCH-0104.familyAllowanceType.02"/></xsl:when>
            <xsl:when test="$trimmed-value = '03'"><xsl:value-of select="$eCH-0104.familyAllowanceType.03"/></xsl:when>
            <xsl:when test="$trimmed-value = '04'"><xsl:value-of select="$eCH-0104.familyAllowanceType.04"/></xsl:when>
            <xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eCH-0104.familyAllowanceType.10"/></xsl:when>
            <xsl:when test="$trimmed-value = '11'"><xsl:value-of select="$eCH-0104.familyAllowanceType.11"/></xsl:when>
            <xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eCH-0104.familyAllowanceType.12"/></xsl:when>
            <xsl:when test="$trimmed-value = '13'"><xsl:value-of select="$eCH-0104.familyAllowanceType.13"/></xsl:when>
            <xsl:when test="$trimmed-value = '20'"><xsl:value-of select="$eCH-0104.familyAllowanceType.20"/></xsl:when>
            <xsl:when test="$trimmed-value = '21'"><xsl:value-of select="$eCH-0104.familyAllowanceType.21"/></xsl:when>
            <xsl:when test="$trimmed-value = '22'"><xsl:value-of select="$eCH-0104.familyAllowanceType.22"/></xsl:when>
            <xsl:when test="$trimmed-value = '23'"><xsl:value-of select="$eCH-0104.familyAllowanceType.23"/></xsl:when>
            <xsl:when test="$trimmed-value = '30'"><xsl:value-of select="$eCH-0104.familyAllowanceType.30"/></xsl:when>
            <xsl:when test="$trimmed-value = '31'"><xsl:value-of select="$eCH-0104.familyAllowanceType.31"/></xsl:when>
            <xsl:when test="$trimmed-value = '32'"><xsl:value-of select="$eCH-0104.familyAllowanceType.32"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- standard template for a block containing only title and one string -->
    <xsl:template name="single-string-block">
        <xsl:param name="title"/>
        <xsl:param name="value"/>
        <fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$title"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:block>
                            <xsl:value-of select="$value"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="double-string-block">
        <xsl:param name="title1"/>
        <xsl:param name="value1"/>
        <xsl:param name="title2"/>
        <xsl:param name="value2"/>
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-column column-width="{$title-column-width}" column-number="3"/>
            <fo:table-column column-width="proportional-column-width(3)" column-number="4"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$title1"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:block>
                            <xsl:value-of select="$value1"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="3" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$title2"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="4" xsl:use-attribute-sets="main-right-column">
                        <fo:block>
                            <xsl:value-of select="$value2"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="double-prefix-string-block">
        <xsl:param name="title1"/>
        <xsl:param name="title2"/>
        <xsl:param name="value"/>
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$title1"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
                            <fo:table-column column-width="{$description-column-width}" column-number="1"/>
                            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
                                        <fo:block><xsl:value-of select="$title2"/></fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                                        <fo:block>
                                            <xsl:value-of select="$value"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="contact">
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$eCH-0104.contact"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
                            <fo:table-column column-width="{$description-column-width}" column-number="1"/>
                            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
                            <fo:table-body>
                                <xsl:apply-templates select="eCH-0104:contact/eCH-0104:employer/*"/>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>


    <xsl:template match="eCH-0104:name">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.name"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eCH-0104:webSite">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.webSite"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eCH-0104:contactInformation">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.contactInformation"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template name="allowance">
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$eCH-0104-68.allowance.title"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
                            <fo:table-column column-width="{$description-column-width}" column-number="1"/>
                            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
                            <fo:table-body>
                                <xsl:apply-templates select="eCH-0104:legalBasis/eCH-0104:law"/>
                                <xsl:apply-templates select="eCH-0104:validityPeriod"/>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template match="eCH-0104:law">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.law"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:value-of select="."/>,
                    <xsl:call-template name="decode-lawCode">
                        <xsl:with-param name="value" select="."/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template name="decode-lawCode">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="$trimmed-value = '01'"><xsl:value-of select="$eCH-0104.law.01"/></xsl:when>
            <xsl:when test="$trimmed-value = '02'"><xsl:value-of select="$eCH-0104.law.02"/></xsl:when>
            <xsl:when test="$trimmed-value = '03'"><xsl:value-of select="$eCH-0104.law.03"/></xsl:when>
            <xsl:when test="$trimmed-value = '04'"><xsl:value-of select="$eCH-0104.law.04"/></xsl:when>
            <xsl:when test="$trimmed-value = '05'"><xsl:value-of select="$eCH-0104.law.05"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="eCH-0104:validityPeriod">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.start"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="value" select="eCH-0104:start"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.end"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="value" select="eCH-0104:end"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$controlMonth"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:call-template name="format-datePartiallyKnownType">
                        <xsl:with-param name="value" select="eCH-0104:controlMonth"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$numberOfWorkdays"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:value-of select="eCH-0104:numberOfWorkdays"/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template name="beneficiary">
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$eCH-0104-68.beneficiary"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
                            <fo:table-column column-width="{$description-column-width}" column-number="1"/>
                            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
                            <fo:table-body>
                                <xsl:apply-templates select="eCH-0104-68:beneficiary/eCH-0104:*"/>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template match="eCH-0104:vn">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.vn"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eCH-0104:occupationStatus">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.occupationStatus"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:call-template name="decode-occupationCode">
                        <xsl:with-param name="value" select="."/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eCH-0104:familialStatus">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block><xsl:value-of select="$eCH-0104.familialStatus"/></fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:call-template name="decode-familialStatusCode">
                        <xsl:with-param name="value" select="."/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template name="decode-familialStatusCode">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eCH-0104.familialStatus.10"/></xsl:when>
            <xsl:when test="$trimmed-value = '11'"><xsl:value-of select="$eCH-0104.familialStatus.11"/></xsl:when>
            <xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eCH-0104.familialStatus.12"/></xsl:when>
            <xsl:when test="$trimmed-value = '13'"><xsl:value-of select="$eCH-0104.familialStatus.13"/></xsl:when>
            <xsl:when test="$trimmed-value = '14'"><xsl:value-of select="$eCH-0104.familialStatus.14"/></xsl:when>
            <xsl:when test="$trimmed-value = '20'"><xsl:value-of select="$eCH-0104.familialStatus.20"/></xsl:when>
            <xsl:when test="$trimmed-value = '21'"><xsl:value-of select="$eCH-0104.familialStatus.21"/></xsl:when>
            <xsl:when test="$trimmed-value = '22'"><xsl:value-of select="$eCH-0104.familialStatus.22"/></xsl:when>
            <xsl:when test="$trimmed-value = '23'"><xsl:value-of select="$eCH-0104.familialStatus.23"/></xsl:when>
            <xsl:when test="$trimmed-value = '24'"><xsl:value-of select="$eCH-0104.familialStatus.24"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="decode-occupationCode">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="$trimmed-value = '01'"><xsl:value-of select="$eCH-0104.occupationStatus.01"/></xsl:when>
            <xsl:when test="$trimmed-value = '02'"><xsl:value-of select="$eCH-0104.occupationStatus.02"/></xsl:when>
            <xsl:when test="$trimmed-value = '03'"><xsl:value-of select="$eCH-0104.occupationStatus.03"/></xsl:when>
            <xsl:when test="$trimmed-value = '04'"><xsl:value-of select="$eCH-0104.occupationStatus.04"/></xsl:when>
            <xsl:when test="$trimmed-value = '05'"><xsl:value-of select="$eCH-0104.occupationStatus.05"/></xsl:when>
            <xsl:when test="$trimmed-value = '06'"><xsl:value-of select="$eCH-0104.occupationStatus.06"/></xsl:when>
            <xsl:when test="$trimmed-value = '07'"><xsl:value-of select="$eCH-0104.occupationStatus.07"/></xsl:when>
            <xsl:when test="$trimmed-value = '08'"><xsl:value-of select="$eCH-0104.occupationStatus.08"/></xsl:when>
            <xsl:when test="$trimmed-value = '09'"><xsl:value-of select="$eCH-0104.occupationStatus.09"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="comment">
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$eCH-0104.comment"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
                            <fo:table-column column-width="proportional-column-width(1)" column-number="1"/>
                            <fo:table-body>
                                <xsl:apply-templates select="eCH-0104:comment"/>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template match="eCH-0104:comment">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
                <fo:block>
                    <xsl:call-template name="decode-comment">
                        <xsl:with-param name="value" select="."/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="decode-comment">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="$trimmed-value = '01'"><xsl:value-of select="$eCH-0104.comment.01"/></xsl:when>
            <xsl:when test="$trimmed-value = '02'"><xsl:value-of select="$eCH-0104.comment.02"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="specialTreatment">
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block><xsl:value-of select="$eCH-0104.specialTreatment"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
                            <fo:table-column column-width="proportional-column-width(1)" column-number="1"/>
                            <fo:table-body>
                                <xsl:apply-templates select="eCH-0104:specialTreatment"/>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template match="eCH-0104:specialTreatment">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
                <xsl:call-template name="decode-specialTreatment">
                        <xsl:with-param name="value" select="."/>
                    </xsl:call-template>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="decode-specialTreatment">
        <xsl:param name="value"/>
        <xsl:variable name="trimmed-value" select="normalize-space($value)"/>
        <xsl:choose>
            <xsl:when test="$trimmed-value = 'A'"><xsl:value-of select="$eCH-0104.specialTreatment.A"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>