<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2022 rel. 2 (x64) (http://www.altova.com) by Lars Steffen (AWK Group AG) -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:ssk-common="http://www.steuerkonferenz.ch/xmlns/ssk-common/2" xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010-f/5" xmlns:eCH-0097="http://www.ech.ch/xmlns/eCH-0097/1" xmlns:ssk-3207-000001="http://www.steuerkonferenz.ch/xmlns/ssk-3207-000001/2">
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"/>
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">210mm</xsl:attribute>
					<xsl:attribute name="page-width">297mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer-wide" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference master-reference="first-page" page-position="first"/>
						<fo:conditional-page-master-reference master-reference="other-pages" page-position="rest"/>
					</fo:repeatable-page-master-alternatives>
					<!--<fo:single-page-master-reference master-reference=""/>
					<fo:repeatable-page-master-reference master-reference=""/>-->
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="first-page-header">
					<xsl:apply-templates select="//ssk-3207-000001:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//ssk-3207-000001:header" mode="page-header-2"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<!--<fo:block>
						<xsl:call-template name="page-footer">
							<xsl:with-param name="col1Width">
								<xsl:text>170mm</xsl:text>
							</xsl:with-param>
							<xsl:with-param name="col2Width">
								<xsl:text>15mm</xsl:text>
							</xsl:with-param>
						</xsl:call-template>
					</fo:block>-->
					<xsl:apply-templates select="//ssk-3207-000001:header" mode="page-footer">
						<xsl:with-param name="col1Width">
							<xsl:text>170mm</xsl:text>
						</xsl:with-param>
						<xsl:with-param name="col2Width">
							<xsl:text>15mm</xsl:text>
						</xsl:with-param>
					</xsl:apply-templates>
				</fo:static-content>
				<fo:static-content flow-name="page-footer-wide">
					<!--<fo:block>
						<xsl:call-template name="page-footer">
							<xsl:with-param name="col1Width">
								<xsl:text>256mm</xsl:text>
							</xsl:with-param>
							<xsl:with-param name="col2Width">
								<xsl:text>15mm</xsl:text>
							</xsl:with-param>
						</xsl:call-template>
					</fo:block>-->
					<xsl:apply-templates select="//ssk-3207-000001:header" mode="page-footer">
						<xsl:with-param name="col1Width">
							<xsl:text>256mm</xsl:text>
						</xsl:with-param>
						<xsl:with-param name="col2Width">
							<xsl:text>15mm</xsl:text>
						</xsl:with-param>
					</xsl:apply-templates>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//ssk-3207-000001:header" mode="message-header-block"/>
					<xsl:apply-templates select="//ssk-3207-000001:header" mode="special-message"/>
					<xsl:apply-templates select="//ssk-3207-000001:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3207-000001:header"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="ssk-3207-000001:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold"><xsl:value-of select="$ssk-common"/> | <xsl:value-of select="$ssk-3207-000001"/></fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.chm-steuern.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-3207-000001.senderId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id">
																<xsl:value-of select="ssk-3207-000001:senderId"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-3207-000001.recipientId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="ssk-3207-000001:recipientId">
															<xsl:if test="position() != 1">
																<xsl:text>, </xsl:text>
															</xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id">
																	<xsl:value-of select="."/>
																</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-3207-000001.messageDate"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value">
																<xsl:value-of select="ssk-3207-000001:messageDate"/>
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.contactInformation"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="ssk-3207-000001:extension/ssk-3207-000001:contactInformation" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.action"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="ssk-3207-000001:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.businessProcessId"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="ssk-3207-000001:businessProcessId"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.businessCaseClosed"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-boolean">
															<xsl:with-param name="value" select="ssk-3207-000001:businessCaseClosed"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.pages"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<fo:page-number-citation ref-id="pageCounter"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!--
		Collaborator block within message header block
	-->
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="ssk-3207-000001:header" mode="special-message">
		<xsl:variable name="is-test" select="(ssk-3207-000001:testDeliveryFlag = '1') or (ssk-3207-000001:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="ssk-3207-000001:action != 1 and ssk-3207-000001:action != 5 and ssk-3207-000001:action != 6"/>
		<xsl:variable name="is-priority" select="ssk-3207-000001:messagePriority &gt; 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="ssk-3207-000001:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($ssk-3207-000001.messagePriority, ': ')"/>
					<xsl:value-of select="ssk-3207-000001:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $ssk-3207-000001.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="ssk-3207-000001:header">
		<xsl:apply-templates select="//ssk-3207-000001:content"/>
	</xsl:template>
	<!--
		Cover sheet: object field from the message header
	-->
	<xsl:template match="ssk-3207-000001:content">
		<xsl:apply-templates select="ssk-3207-000001:providerMonetaryBenefit"/>
		<xsl:apply-templates select="ssk-3207-000001:remark"/>
		<fo:block page-break-before="always">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="proportional-column-width(0.3)" column-number="1"/>
				<fo:table-column column-width="proportional-column-width(3)" column-number="2"/>
				<fo:table-column column-width="proportional-column-width(3)" column-number="3"/>
				<fo:table-column column-width="proportional-column-width(1)" column-number="4"/>
				<fo:table-column column-width="proportional-column-width(3)" column-number="5"/>
				<fo:table-column column-width="proportional-column-width(1.5)" column-number="6"/>
				<fo:table-column column-width="proportional-column-width(3)" column-number="7"/>
				<fo:table-column column-width="proportional-column-width(2)" column-number="8"/>
				<fo:table-column column-width="proportional-column-width(2)" column-number="9"/>
				<fo:table-column column-width="proportional-column-width(2)" column-number="10"/>
				<fo:table-column column-width="proportional-column-width(2)" column-number="11"/>
				<fo:table-column column-width="proportional-column-width(2)" column-number="12"/>
				<fo:table-column column-width="proportional-column-width(2)" column-number="13"/>
				<fo:table-header xsl:use-attribute-sets="table-header-row">
					<fo:table-cell margin-left="0mm">
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.kindOfPerson"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.nameUid"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.address"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.address.locality"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.typeOfBenefit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.fiscalYear"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.grossAmountOriginalCurrency"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.exchangeRate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.grossAmount"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.withholdingTax"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.netAmount"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.constitutionTaxClaim"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.status"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-header>
				<fo:table-body>
					<xsl:for-each select="ssk-3207-000001:beneficiary">
						<!--<xsl:sort select="./*[local-name()='taxpayer']/*[local-name()='officialName']"/>
						<xsl:sort select="./*[local-name()='taxpayer']/*[local-name()='firstName']"/>-->
						<fo:table-row xsl:use-attribute-sets="table-main-row">
							<xsl:call-template name="beneficiary">
								<xsl:with-param name="person" select="."/>
							</xsl:call-template>
						</fo:table-row>
					</xsl:for-each>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<xsl:template name="beneficiary">
		<xsl:param name="person"/>
		<fo:table-cell margin-left="0mm">
			<fo:block>
				<xsl:call-template name="decode-npjp">
					<xsl:with-param name="value" select="$person/*[local-name()='kindOfPerson']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='name']"/>
			<xsl:if test="$person/*[local-name()='firstName'] != ''">
					<xsl:text> </xsl:text>
					<xsl:value-of select="$person/*[local-name()='firstName']"/>
			</xsl:if>
			<xsl:if test="$person/*[local-name()='uid']/*[local-name()='uidOrganisationId'] != ''">
					<xsl:text>, </xsl:text>
					<xsl:value-of select="$person/*[local-name()='uid']/*[local-name()='uidOrganisationIdCategorie']"/>
					<xsl:value-of select="$person/*[local-name()='uid']/*[local-name()='uidOrganisationId']"/>
			</xsl:if>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='address']/*[local-name()='street']"/>
				<xsl:if test="$person/*[local-name()='address']/*[local-name()='houseNumber']">
					<xsl:value-of select="concat(' ', $person/*[local-name()='address']/*[local-name()='houseNumber'])"/>
				</xsl:if>
				<xsl:text>, </xsl:text>
				<xsl:if test="$person/*[local-name()='address']/*[local-name()='country']">
					<xsl:value-of select="concat($person/*[local-name()='address']/*[local-name()='country'], '-')"/>
				</xsl:if>
				<xsl:if test="$person/*[local-name()='address']/*[local-name()='swissZipCode']">
					<xsl:value-of select="concat($person/*[local-name()='address']/*[local-name()='swissZipCode'], ' ')"/>
				</xsl:if>
				<xsl:if test="$person/*[local-name()='address']/*[local-name()='swissZipCodeId']">
					<xsl:value-of select="concat($person/*[local-name()='address']/*[local-name()='swissZipCodeId'], ' ')"/>
				</xsl:if>
				<xsl:if test="$person/*[local-name()='address']/*[local-name()='foreignZipCode']">
					<xsl:value-of select="concat($person/*[local-name()='address']/*[local-name()='foreignZipCode'], ' ')"/>
				</xsl:if>
				<xsl:if test="$person/*[local-name()='address']/*[local-name()='swissZipCodeAddOn']">
					<xsl:value-of select="concat($person/*[local-name()='address']/*[local-name()='swissZipCodeAddOn'], ' ')"/>
				</xsl:if>
				<xsl:value-of select="$person/*[local-name()='address']/*[local-name()='town']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='address']/*[local-name()='locality']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="decode-typeOfBenefit">
					<xsl:with-param name="value" select="$person/*[local-name()='typeOfBenefit']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='fiscalYear']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="concat($person/*[local-name()='currencyISO'],' ',format-number($person/*[local-name()='grossAmountOriginalCurrency'], $cents-format))"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='exchangeRate']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="format-number($person/*[local-name()='grossAmount'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="format-number($person/*[local-name()='withholdingTax'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="format-number($person/*[local-name()='netAmount'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="format-date">
					<xsl:with-param name="value">
						<xsl:value-of select="$person/*[local-name()='constitutionTaxClaim']"/>
					</xsl:with-param>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="decode-status">
					<xsl:with-param name="value" select="ssk-3207-000001:status"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<!-- Cover sheet: providerMonetaryBenefit -->
	<xsl:template match="ssk-3207-000001:providerMonetaryBenefit">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.providerMonetaryBenefit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3207-000001.providerMonetaryBenefit.organisationName"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="ssk-common:organisationName"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<xsl:apply-templates select="ssk-common:uid"/>
								<xsl:apply-templates select="ssk-common:otherOrganisationId"/>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3207-000001.providerMonetaryBenefit.address"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="./*[local-name()='address']/*[local-name()='street']"/>
											<xsl:if test="./*[local-name()='address']/*[local-name()='houseNumber']">
												<xsl:value-of select="concat(' ', ./*[local-name()='address']/*[local-name()='houseNumber'])"/>
											</xsl:if>
											<xsl:text>, </xsl:text>
											<xsl:if test="./*[local-name()='address']/*[local-name()='country']">
												<xsl:value-of select="concat(./*[local-name()='address']/*[local-name()='country'], '-')"/>
											</xsl:if>
											<xsl:if test="./*[local-name()='address']/*[local-name()='swissZipCode']">
												<xsl:value-of select="concat(./*[local-name()='address']/*[local-name()='swissZipCode'], ' ')"/>
											</xsl:if>
											<xsl:if test="./*[local-name()='address']/*[local-name()='swissZipCodeId']">
												<xsl:value-of select="concat(./*[local-name()='address']/*[local-name()='swissZipCodeId'], ' ')"/>
											</xsl:if>
											<xsl:if test="./*[local-name()='address']/*[local-name()='foreignZipCode']">
												<xsl:value-of select="concat(./*[local-name()='address']/*[local-name()='foreignZipCode'], ' ')"/>
											</xsl:if>
											<xsl:if test="./*[local-name()='address']/*[local-name()='swissZipCodeAddOn']">
												<xsl:value-of select="concat(' ', ./*[local-name()='address']/*[local-name()='swissZipCodeAddOn'])"/>
											</xsl:if>
											<xsl:value-of select="./*[local-name()='address']/*[local-name()='town']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$ssk-3207-000001.providerMonetaryBenefit.address.locality"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="./*[local-name()='address']/*[local-name()='locality']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Cover sheet: remark -->
	<xsl:template match="ssk-3207-000001:remark">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$ssk-3207-000001.remark"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Cover sheet: attachment list from the message header
	-->
	<xsl:template match="ssk-3207-000001:attachment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
				<fo:block/>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="first-value-column">
				<fo:block>
					<xsl:value-of select="ssk-common:title"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
				<xsl:for-each select="ssk-common:file">
					<xsl:sort data-type="number" select="ssk-common:sortOrder"/>
					<fo:block>
						<xsl:value-of select="substring-after(ssk-common:pathFileName, '/')"/>
					</fo:block>
				</xsl:for-each>
			</fo:table-cell>
			<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-mime">
						<xsl:with-param name="value" select="ssk-common:documentFormat"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<xsl:template match="ssk-3207-000001:contactInformation" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:phone"/>
			</xsl:call-template></fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:email"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:other"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	<!-- helper template for formatting ssk-common.uid-->
	<xsl:template match="ssk-common:uid">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3207-000001.providerMonetaryBenefit.uid"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="concat(./eCH-0097:uidOrganisationIdCategorie, ./eCH-0097:uidOrganisationId)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- helper template for formatting ssk-common.otherOrganisationId-->
	<xsl:template match="ssk-common:otherOrganisationId">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3207-000001.providerMonetaryBenefit.otherOrganisationId"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="eCH-0097:organisationId"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- helper template for formatting ssk-common.address-->
	<xsl:template match="ssk-common:address">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$ssk-3207-000001.providerMonetaryBenefit.address"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<!--<fo:block>
					<xsl:value-of select="eCH-0010:street"/>
					<xsl:if test="eCH-0010:houseNumber">
						<xsl:value-of select="concat(' ', eCH-0010:houseNumber)"/>
					</xsl:if>
					<xsl:if test="../eCH-0010:dwellingNumber">
						<xsl:value-of select="concat('/', ../eCH-0010:dwellingNumber)"/>
					</xsl:if>
					<xsl:text>, </xsl:text>
					<xsl:if test="../eCH-0010:country">
						<xsl:value-of select="concat(../eCH-0010:country, '-')"/>
					</xsl:if>
					<xsl:if test="../eCH-0010:swissZipCode">
						<xsl:value-of select="concat(../eCH-0010:swissZipCode, ' ')"/>
					</xsl:if>
					<xsl:if test="../eCH-0010:foreignZipCode">
						<xsl:value-of select="concat(../eCH-0010:foreignZipCode, ' ')"/>
					</xsl:if>
					<xsl:value-of select="."/>
					<xsl:if test="../eCH-0010:swissZipCodeAddOn">
						<xsl:value-of select="concat(' ', ../eCH-0010:swissZipCodeAddOn)"/>
					</xsl:if>
					<xsl:value-of select="eCH-0010:town"/>
				</fo:block>-->
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- ************* Decodings templates *************** -->
	<!-- Decode NP/JP -->
	<xsl:template name="decode-npjp">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3207-000001.kindOfPerson.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3207-000001.kindOfPerson.2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Decode typeOfBenefit -->
	<xsl:template name="decode-typeOfBenefit">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3207-000001.typeOfBenefit.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3207-000001.typeOfBenefit.2"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '3'">
				<xsl:value-of select="$ssk-3207-000001.typeOfBenefit.3"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '4'">
				<xsl:value-of select="$ssk-3207-000001.typeOfBenefit.4"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '5'">
				<xsl:value-of select="$ssk-3207-000001.typeOfBenefit.5"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '6'">
				<xsl:value-of select="$ssk-3207-000001.typeOfBenefit.6"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '7'">
				<xsl:value-of select="$ssk-3207-000001.typeOfBenefit.7"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Decode status -->
	<xsl:template name="decode-status">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'">
				<xsl:value-of select="$ssk-3207-000001.status.1"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '2'">
				<xsl:value-of select="$ssk-3207-000001.status.2"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = '3'">
				<xsl:value-of select="$ssk-3207-000001.status.3"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="ssk-3207-000001:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-family="{$font-family}" font-weight="bold">
							<xsl:value-of select="ssk-3207-000001:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header-2" match="ssk-3207-000001:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-family="{$font-family}" font-weight="bold">
							<xsl:value-of select="$ssk-3207-000001.beneficiary"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="ssk-3207-000001:header">
		<xsl:param name="col1Width"/>
		<xsl:param name="col2Width"/>
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="{$col1Width}" column-number="1"/>
			<fo:table-column column-width="{$col2Width}" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}"><xsl:value-of select="ssk-3207-000001:messageType"/>/<xsl:value-of select="ssk-3207-000001:subMessageType"/>
							| <xsl:value-of select="concat($ssk-3207-000001.messageId, ' ')"/><xsl:value-of select="ssk-3207-000001:messageId"/><xsl:if test="count(ssk-3207-000001:referenceMessageId) != 0">
								| <xsl:value-of select="concat($ssk-3207-000001.referenceMessageId, ' ')"/><xsl:value-of select="ssk-3207-000001:referenceMessageId"/></xsl:if><xsl:if test="count(ssk-3207-000001:businessProcessId) != 0">
								| <xsl:value-of select="concat($ssk-3207-000001.businessProcessId, ' ')"/><xsl:value-of select="ssk-3207-000001:businessProcessId"/></xsl:if>
							| <xsl:value-of select="concat($ssk-common.dateOfReceipt, ' ')"/><xsl:call-template name="format-date">
								<xsl:with-param name="value">
									<xsl:value-of select="$dateOfReceipt"/>
								</xsl:with-param>
							</xsl:call-template></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}"><fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/></fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template match="ssk-common:address">
		<fo:block>
			<xsl:apply-templates select="*" mode="inline"/>
		</fo:block>
	</xsl:template>
	<!-- attribute set for table header-->
	<xsl:attribute-set name="table-header-row">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	</xsl:attribute-set>
	<!-- attribute set for table row -->
	<xsl:attribute-set name="table-main-row">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="border-bottom-color">black</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	</xsl:attribute-set>
</xsl:stylesheet>