<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007-f/5"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010-f/5"
	xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044-f/4"
	xmlns:ssk-common="http://www.steuerkonferenz.ch/xmlns/ssk-common/2"
	xmlns:ssk-3205-000001="http://www.steuerkonferenz.ch/xmlns/ssk-3205-000001/1">
	
	<xsl:import href="../../ssk-common/2/ssk-common-2-0_fr.xsl"/>
	<xsl:import href="3205-000001-language-1-1_fr.xsl"/>
	
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//ssk-3205-000001:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//ssk-3205-000001:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//ssk-3205-000001:header" mode="message-header-block"/>
					<xsl:apply-templates select="//ssk-3205-000001:header" mode="special-message"/>
					<xsl:apply-templates select="//ssk-3205-000001:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<xsl:if test="count(ssk-3205-000001:message) > 0">
							<xsl:attribute name="page-break-after">always</xsl:attribute>
						</xsl:if>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3205-000001:header"/>
							<xsl:apply-templates select="//ssk-3205-000001:content" mode="page-header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3205-000001:content" mode="page-2"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="ssk-3205-000001:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$ssk-common"/> | <xsl:value-of select="$ssk-3205-000001"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.chm-steuern.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="ssk-3205-000001:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="ssk-3205-000001:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3205-000001.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="ssk-3205-000001:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.contactInformation"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="ssk-3205-000001:extension/ssk-3205-000001:contactInformation" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3205-000001.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="ssk-3205-000001:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$ssk-common.businessCaseClosed"/>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-boolean">
															<xsl:with-param name="value" select="ssk-3205-000001:businessCaseClosed"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3205-000001.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(ssk-3205-000001:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="ssk-3205-000001:contactInformation" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:email"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="ssk-3205-000001:header" mode="special-message">
		<xsl:variable name="is-test" select="(ssk-3205-000001:testDeliveryFlag = '1') or (ssk-3205-000001:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="ssk-3205-000001:action != 1 and ssk-3205-000001:action != 5 and ssk-3205-000001:action != 6"/>
		<xsl:variable name="is-priority" select="ssk-3205-000001:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="ssk-3205-000001:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($ssk-3205-000001.messagePriority, ': ')"/>
					<xsl:value-of select="ssk-3205-000001:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $ssk-3205-000001.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="ssk-3205-000001:additionalInformation">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3205-000001.additionalInformation"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="ssk-3205-000001:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}" >
							<xsl:value-of select="ssk-3205-000001:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="ssk-3205-000001:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="ssk-3205-000001:messageType"/>/<xsl:value-of select="ssk-3205-000001:subMessageType"/>
							| <xsl:value-of select="concat($ssk-3205-000001.messageId, ' ')"/>
							<xsl:value-of select="ssk-3205-000001:messageId"/>
							<xsl:if test="count(ssk-3205-000001:referenceMessageId) != 0">
								| <xsl:value-of select="concat($ssk-3205-000001.referenceMessageId, ' ')"/>
								<xsl:value-of select="ssk-3205-000001:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="ssk-3205-000001:businessProcessId">
								| <xsl:value-of select="concat($ssk-common.businessProcessId, ' ')"/>
								<xsl:value-of select="ssk-3205-000001:businessProcessId"/>
							</xsl:if>
							| <xsl:value-of select="concat($ssk-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		****************  Message content starts here ***************
	 -->
	 
	 <!--
		Part of the content that goes in the header page
	-->
	<xsl:template match="ssk-3205-000001:content" mode="page-header">
		<xsl:apply-templates select="ssk-3205-000001:insurant"/>
		<xsl:apply-templates select="ssk-3205-000001:datePriorDelivery"/>
	</xsl:template>
	
	<!-- 
		"Main" template for the message content; shows all relevant content blocks (this goes in the second page)
	-->
	<xsl:template match="ssk-3205-000001:content" mode="page-2">
		<xsl:apply-templates select="ssk-3205-000001:insurant"/>
		<xsl:apply-templates select="ssk-3205-000001:preferredLanguage"/>
		<xsl:apply-templates select="ssk-3205-000001:amountPriorDelivery"/>
		<xsl:apply-templates select="ssk-3205-000001:datePriorDelivery"/>
		<xsl:apply-templates select="ssk-3205-000001:accountForm"/>
		<xsl:apply-templates select="ssk-3205-000001:canton"/>
		<xsl:apply-templates select="ssk-3205-000001:sourceTax"/>
		<xsl:apply-templates select="ssk-3205-000001:organisation"/>
		<xsl:apply-templates select="ssk-3205-000001:organisationId"/>
		<xsl:apply-templates select="ssk-3205-000001:signatureLocation"/>
		<xsl:apply-templates select="ssk-3205-000001:signatureDate"/>
		<xsl:apply-templates select="ssk-3205-000001:signatureName"/>
		<xsl:apply-templates select="ssk-3205-000001:additionalInformation"/>
	</xsl:template>


	<!-- 
		Generate the insurant block. This is identical to the object block on cover sheet.
	-->
	<xsl:template match="ssk-3205-000001:insurant">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3205-000001.insurant"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-common:officialName"/>
								<xsl:apply-templates select="ssk-common:firstName"/>
								<xsl:apply-templates select="ssk-common:sex"/>
								<xsl:apply-templates select="ssk-common:dateOfBirth"/>
								<xsl:apply-templates select="ssk-common:vn"/>
								<xsl:apply-templates select="ssk-common:oldVn"/>
								<xsl:apply-templates select="ssk-common:address"/>
								<xsl:apply-templates select="ssk-common:taxMunicipality"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the preferredLanguage block.
	-->
	<xsl:template match="ssk-3205-000001:preferredLanguage">	
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3205-000001.preferredLanguage"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-preferredLanguage">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--Decodes preferredLanguage -->
	<xsl:template name="decode-preferredLanguage">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$ssk-3205-000001.preferredLanguage.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$ssk-3205-000001.preferredLanguage.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$ssk-3205-000001.preferredLanguage.3"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 
		Message content, amountBackPayment
	-->
	<xsl:template match="ssk-3205-000001:amountPriorDelivery">
		<xsl:call-template name="single-cents-block">
			<xsl:with-param name="title" select="$ssk-3205-000001.amountPriorDelivery"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Message content, dateBackPayment
	-->
	<xsl:template match="ssk-3205-000001:datePriorDelivery">
		<xsl:call-template name="single-date-block">
			<xsl:with-param name="title" select="$ssk-3205-000001.datePriorDelivery"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>
	

	<!-- 
		Generate the accountForm block.
	-->
	<xsl:template match="ssk-3205-000001:accountForm">	
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3205-000001.accountForm"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-accountForm">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--Decodes accountForm -->
	<xsl:template name="decode-accountForm">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$ssk-3205-000001.accountForm.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$ssk-3205-000001.accountForm.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$ssk-3205-000001.accountForm.3"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 
		Message content, canton
	-->
	<xsl:template match="ssk-3205-000001:canton">
		<xsl:call-template name="single-string-block">
			<xsl:with-param name="title" select="$ssk-3205-000001.canton"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Generate the accountForm block.
	-->
	<xsl:template match="ssk-3205-000001:sourceTax">	
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3205-000001.sourceTax"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-sourceTax">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--Decodes sourceTax -->
	<xsl:template name="decode-sourceTax">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'"><xsl:value-of select="$ssk-3205-000001.sourceTax.0"/></xsl:when>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$ssk-3205-000001.sourceTax.1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 
		Generate the organisation block.
	-->
	<xsl:template match="ssk-3205-000001:organisation">	
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3205-000001.organisation"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:apply-templates select="eCH-0010:organisation"/>
						</fo:block>
						<fo:block>
							<xsl:apply-templates select="eCH-0010:addressInformation"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template match="eCH-0010:organisation">
		<xsl:value-of select="eCH-0010:organisationName"/>
	</xsl:template>
	
	<xsl:template match="eCH-0010:addressInformation">
		<xsl:apply-templates select="*" mode="inline"/>
	</xsl:template>
	
	<xsl:template match="ssk-3205-000001:organisationId">
		<xsl:call-template name="single-string-block">
			<xsl:with-param name="title" select="$ssk-3205-000001.organisationId"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Message content, signatureLocation
	-->
	<xsl:template match="ssk-3205-000001:signatureLocation">
		<xsl:call-template name="single-string-block">
			<xsl:with-param name="title" select="$ssk-3205-000001.signatureLocation"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Message content, signatureDate
	-->
	<xsl:template match="ssk-3205-000001:signatureDate">
		<xsl:call-template name="single-date-block">
			<xsl:with-param name="title" select="$ssk-3205-000001.signatureDate"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Message content, signatureName
	-->
	<xsl:template match="ssk-3205-000001:signatureName">
		<xsl:call-template name="single-string-block">
			<xsl:with-param name="title" select="$ssk-3205-000001.signatureName"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

		
</xsl:stylesheet>