<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/4"
	xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044/1"
	xmlns:ssk-common="http://www.steuerkonferenz.ch/xmlns/ssk-common/1"
	xmlns:ssk-3001-000703="http://www.steuerkonferenz.ch/xmlns/ssk-3001-000703/2">
	
	<xsl:import href="../../ssk-common/1/ssk-common-1-1_it.xsl"/>
	<xsl:import href="3001-000703-language-2-1_it.xsl"/>
	
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	<xsl:variable name="mill-format">###'###'###'##0.000</xsl:variable>
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//ssk-3001-000703:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//ssk-3001-000703:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//ssk-3001-000703:header" mode="message-header-block"/>
					<xsl:apply-templates select="//ssk-3001-000703:header" mode="special-message"/>
					<xsl:apply-templates select="//ssk-3001-000703:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<xsl:if test="count(ssk-3001-000703:message) > 0">
							<xsl:attribute name="page-break-after">always</xsl:attribute>
						</xsl:if>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3001-000703:header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//ssk-3001-000703:content"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="ssk-3001-000703:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$ssk-common"/> | <xsl:value-of select="$ssk-3001-000703"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.chm-steuern.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="ssk-3001-000703:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="ssk-3001-000703:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="ssk-3001-000703:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.declarationLocalReference"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="ssk-3001-000703:declarationLocalReference" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="ssk-3001-000703:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.originalSenderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id" select="ssk-3001-000703:originalSenderId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.initialMessageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="ssk-3001-000703:initialMessageDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="ssk-3001-000703:ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="ssk-3001-000703:yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.eventDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="ssk-3001-000703:eventDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.eventPeriod"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-string">
															<xsl:with-param name="value" select="ssk-3001-000703:eventPeriod"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$ssk-3001-000703.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(ssk-3001-000703:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="ssk-3001-000703:declarationLocalReference" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="ssk-common:email"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="ssk-3001-000703:header" mode="special-message">
		<xsl:variable name="is-test" select="(ssk-3001-000703:testDeliveryFlag = '1') or (ssk-3001-000703:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="ssk-3001-000703:action != 1 and ssk-3001-000703:action != 5 and ssk-3001-000703:action != 6"/>
		<xsl:variable name="is-priority" select="ssk-3001-000703:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="ssk-3001-000703:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($ssk-3001-000703.messagePriority, ': ')"/>
					<xsl:value-of select="ssk-3001-000703:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $ssk-3001-000703.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="ssk-3001-000703:header">
		<xsl:apply-templates select="ssk-3001-000703:object"/>
		<xsl:apply-templates select="ssk-3001-000703:comment"/>
	</xsl:template>
	
	<!--
		Cover sheet: object field from the message header
	-->
	<xsl:template match="ssk-3001-000703:object[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000703.object"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-common:organisationName"/>
								<xsl:apply-templates select="ssk-common:legalForm"/>
								<xsl:apply-templates select="ssk-common:dateFounded"/>
								<xsl:apply-templates select="ssk-common:localOrganisationId"/>
								<xsl:apply-templates select="ssk-common:OtherOrganisationId"/>
								<xsl:apply-templates select="ssk-common:EuOrganisationId"/>
								<xsl:apply-templates select="ssk-common:address"/>
								<xsl:apply-templates select="ssk-common:taxMunicipality"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="ssk-3001-000703:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000703.comment"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	
	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="ssk-3001-000703:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}" >
							<xsl:value-of select="ssk-3001-000703:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="ssk-3001-000703:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="ssk-3001-000703:messageType"/>/<xsl:value-of select="ssk-3001-000703:subMessageType"/>
							| <xsl:value-of select="concat($ssk-3001-000703.messageId, ' ')"/>
							<xsl:value-of select="ssk-3001-000703:messageId"/>
							<xsl:if test="count(ssk-3001-000703:referenceMessageId) != 0">
								| <xsl:value-of select="concat($ssk-3001-000703.referenceMessageId, ' ')"/>
								<xsl:value-of select="ssk-3001-000703:referenceMessageId"/>
							</xsl:if>
							| <xsl:value-of select="concat($ssk-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		****************  Message content starts here ***************
	 -->
	
	<!-- 
		"Main" template for the message content; shows all relevant content blocks
	-->
	<xsl:template match="ssk-3001-000703:content">
		<xsl:apply-templates select="ssk-3001-000703:taxPeriod"/>
		<xsl:apply-templates select="ssk-3001-000703:taxpayer"/>
		<xsl:call-template name="taxAmounts" />
		<xsl:call-template name="repartitionCompilations" />
	</xsl:template>


	<xsl:template match="ssk-3001-000703:eventPeriod">
		<xsl:call-template name="single-string-block">
			<xsl:with-param name="title" select="$ssk-3001-000703.taxPeriod"/>
			<xsl:with-param name="value" select="."/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Generate the taxpayer block.
	-->
	<xsl:template match="ssk-3001-000703:taxpayer[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000703.taxpayer"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="ssk-common:organisationName"/>
								<xsl:apply-templates select="ssk-common:legalForm"/>
								<xsl:apply-templates select="ssk-common:dateFounded"/>
								<xsl:apply-templates select="ssk-common:localOrganisationId"/>
								<xsl:apply-templates select="ssk-common:OtherOrganisationId"/>
								<xsl:apply-templates select="ssk-common:EuOrganisationId"/>
								<xsl:apply-templates select="ssk-common:address"/>
								<xsl:apply-templates select="ssk-common:taxMunicipality"/>							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template name="taxAmounts">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000703.taxAmounts"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:call-template name="taxAmountRow">
									<xsl:with-param name="description" select="$ssk-3001-000703.totalProfit"/>
									<xsl:with-param name="value" select="ssk-3001-000703:totalProfit"/>
									<xsl:with-param name="format" select="$cents-format"/>
								</xsl:call-template>
								<xsl:call-template name="taxAmountRow">
									<xsl:with-param name="description" select="$ssk-3001-000703.participationReduction"/>
									<xsl:with-param name="value" select="ssk-3001-000703:participationReduction"/>
									<xsl:with-param name="format" select="$mill-format"/>
								</xsl:call-template>
								<xsl:call-template name="taxAmountRow">
									<xsl:with-param name="description" select="$ssk-3001-000703.totalTaxAmount"/>
									<xsl:with-param name="value" select="ssk-3001-000703:totalTaxAmount"/>
									<xsl:with-param name="format" select="$cents-format"/>
								</xsl:call-template>
								<xsl:call-template name="taxAmountRow">
									<xsl:with-param name="description" select="$ssk-3001-000703.totalRepartitionAmount"/>
									<xsl:with-param name="value" select="ssk-3001-000703:totalRepartitionAmount"/>
									<xsl:with-param name="format" select="$cents-format"/>
								</xsl:call-template>
								<xsl:call-template name="taxAmountRow">
									<xsl:with-param name="description" select="$ssk-3001-000703.compensation"/>
									<xsl:with-param name="value" select="ssk-3001-000703:compensation"/>
									<xsl:with-param name="format" select="$cents-format"/>
								</xsl:call-template>
								<xsl:call-template name="taxAmountRow">
									<xsl:with-param name="description" select="$ssk-3001-000703.repartitionAmount"/>
									<xsl:with-param name="value" select="ssk-3001-000703:repartitionAmount"/>
									<xsl:with-param name="format" select="$cents-format"/>
								</xsl:call-template>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template name="taxAmountRow">
		<xsl:param name="description"/>
		<xsl:param name="value"/>
		<xsl:param name="format"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$description"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<fo:block><xsl:value-of select="format-number($value, $format)"/></fo:block>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
		
		<!-- attribute set for the repartition table -->
	<xsl:attribute-set name="repartition-column">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-top">1.5mm</xsl:attribute>
		<xsl:attribute name="margin-bottom">1.5mm</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
		<xsl:attribute name="margin-right">1.5mm</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
		
		
		
	<xsl:template name="repartitionCompilations">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" >
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$ssk-3001-000703.repartitionCompilation"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="collapse" xsl:use-attribute-sets="repartition-column">
							<fo:table-column column-width="15mm" column-number="1"/>
							<fo:table-column column-width="45mm" column-number="2"/>
							<fo:table-column column-width="45mm" column-number="3"/>
							<fo:table-header>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="repartition-column" font-weight="normal">
										<fo:block><xsl:value-of select="$ssk-3001-000703.canton"/></fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="repartition-column" text-align="right" font-weight="normal">
										<fo:block><xsl:value-of select="$ssk-3001-000703.percentage"/></fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="3" xsl:use-attribute-sets="repartition-column" text-align="right" font-weight="normal">
										<fo:block><xsl:value-of select="$ssk-3001-000703.repartitionParticipation"/></fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-header>
							<fo:table-body>
								<xsl:apply-templates select="ssk-3001-000703:repartitionCompilation" />
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="ssk-3001-000703:repartitionCompilation">
		<fo:table-row >
			<fo:table-cell column-number="1" xsl:use-attribute-sets="repartition-column">
				<fo:block><xsl:value-of select="ssk-3001-000703:canton"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" text-align="right" xsl:use-attribute-sets="repartition-column">
				<fo:block><xsl:value-of select="format-number(ssk-3001-000703:percentage, $percent-format)"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="3" text-align="right" xsl:use-attribute-sets="repartition-column">
				<fo:block><xsl:value-of select="format-number(ssk-3001-000703:repartitionParticipation, $cents-format)"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

				
</xsl:stylesheet>