<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:sd="http://www.swissdec.ch/schema/sd/20130115/SalaryDeclaration" xmlns:ct="http://www.swissdec.ch/schema/sd/20130115/SalaryDeclarationContainer" xmlns:tns="http://www.swissdec.ch/schema/sd/20130115/SalaryDeclarationServiceTypes" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:import href="elm-txb-1-0-language_it.xsl"/>
	<xsl:import href="elm-txb-common-1-0_it.xsl"/>
	<!--
	###################################################################################################
	# PLEASE UPDATE THE VERSION VARIABLE AFTER EACH CHANGES TO THIS FILE:							 #
	# Format is, [filename-version], [yyyy-mm-dd]													 #
	###################################################################################################
	-->
	<xsl:variable name="stylesheet.version" select="'1-0, 2020-05-04'"/>
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"/>
	<!-- DeclareSalaryConsumer or DeclareSalary for itserve files ON THE FIRST ONLY-->
	<xsl:variable name="company" select="/*[local-name()='DeclareSalaryConsumer']/*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']"/>
	<xsl:variable name="sslNumber" select="$company/*[local-name()='Institutions']/*[local-name()='TaxCrossborder']/*[local-name()='CustomerIdentity']"/>
	<xsl:variable name="payrollUnit" select="$company/*[local-name()='Institutions']/*[local-name()='TaxCrossborder']/*[local-name()='PayrollUnit']"/>

	<xsl:variable name="personsTaxCrossborderFra" select="$company/*[local-name()='Staff']/*[local-name()='Person' and (descendant::*[local-name()='TaxCrossborderSalaries']/*[local-name()='TaxCrossborderSalary']/*[local-name()='ResidenceAbroadCountry']='FR')]"/>
	<xsl:variable name="taxCrossborderTaxableEarningsFra" select="$company/*[local-name()='Staff']/*[local-name()='Person']/*[local-name()='TaxCrossborderSalaries']/*[local-name()='TaxCrossborderSalary' and (descendant::*[local-name()='ResidenceAbroadCountry']='FR')]"/>
	<xsl:variable name="personsTaxCrossborderIta" select="$company/*[local-name()='Staff']/*[local-name()='Person' and (descendant::*[local-name()='TaxCrossborderSalaries']/*[local-name()='TaxCrossborderSalary']/*[local-name()='ResidenceAbroadCountry']='IT')]"/>
	<xsl:variable name="taxCrossborderTaxableEarningsIta" select="$company/*[local-name()='Staff']/*[local-name()='Person']/*[local-name()='TaxCrossborderSalaries']/*[local-name()='TaxCrossborderSalary' and (descendant::*[local-name()='ResidenceAbroadCountry']='IT')]"/>
	<!-- Sämtliche Personen mit EMA und oder mit vorhandenem Austrittsdatum sind aufzuführen. Hinweis: Dies entspricht somit nicht 1:1 der Personen in der ersten Tabelle (im Unterschied zur Tabelle werden Personen
		welche nur Korrekturen besitzen aber keine EMA/Austrittsdatum besitzen nicht aufgeführt).-->
	<xsl:variable name="personswithcorrectiondetails" select="$company/*[local-name()='Staff']/*[local-name()='Person' and (descendant::*[local-name()='Current']/*[local-name()='DeclarationCategory'] or descendant::*[local-name()='Work']/*[local-name()='WithdrawalDate']) and (descendant::*[local-name()='Current'])]"/>
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<!--<xsl:message>
			<xsl:copy-of select="$personswithcorrectionSalary"/>
		</xsl:message>-->
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">210mm</xsl:attribute>
					<xsl:attribute name="page-width">297mm</xsl:attribute>
					<xsl:variable name="bodymargin">
						<xsl:choose>
							<xsl:when test="//*[local-name()='TestCase']">
								<xsl:value-of select="$body-top-margin-test"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$body-top-margin"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<fo:region-body region-name="page-body" margin-top="{$bodymargin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages-details">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<xsl:variable name="bodymargin">
						<xsl:choose>
							<xsl:when test="//*[local-name()='TestCase']">
								<xsl:value-of select="$body-top-margin-test"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$body-top-margin"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<fo:region-body region-name="page-body" margin-top="{$bodymargin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
				<fo:page-sequence-master master-name="pages-content-details">
					<fo:repeatable-page-master-reference master-reference="other-pages-details"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<xsl:if test="//*[local-name()='TestCase']">
					<fo:static-content flow-name="page-header">
						<fo:block>
							<xsl:call-template name="testcase"/>
						</fo:block>
					</fo:static-content>
				</xsl:if>
				<fo:static-content flow-name="page-footer">
					<fo:block>
						<xsl:call-template name="page-footer">
							<xsl:with-param name="col1Width">
								<xsl:text>256mm</xsl:text>
							</xsl:with-param>
							<xsl:with-param name="col2Width">
								<xsl:text>15mm</xsl:text>
							</xsl:with-param>
						</xsl:call-template>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:call-template name="message-header-block"/>
					<fo:block background-color="white" font-family="{$font-family}">
						<xsl:call-template name="overview"/>
					</fo:block>
					<xsl:if test="not($personsTaxCrossborderIta) and not($personsTaxCrossborderFra)">
						<fo:block id="pageCounter" keep-with-previous="always"/>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
			<xsl:if test="$personsTaxCrossborderFra">
				<fo:page-sequence master-reference="pages-content">
					<xsl:if test="//*[local-name()='TestCase']">
						<fo:static-content flow-name="page-header">
							<fo:block>
								<xsl:call-template name="testcase"/>
							</fo:block>
						</fo:static-content>
					</xsl:if>
					<fo:static-content flow-name="page-footer">
						<fo:block>
							<xsl:call-template name="page-footer">
								<xsl:with-param name="col1Width">
									<xsl:text>256mm</xsl:text>
								</xsl:with-param>
								<xsl:with-param name="col2Width">
									<xsl:text>15mm</xsl:text>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:static-content>
					<fo:flow flow-name="page-body">
						<xsl:call-template name="message-header-message-block">
							<xsl:with-param name="message" select="$elm-txb.crossBorderHeaderFrance"/>
						</xsl:call-template>
						<fo:block background-color="white" font-family="{$font-family}">
							<xsl:call-template name="crossBorderFrance"/>
						</fo:block>
						<xsl:if test="not($personsTaxCrossborderIta)">
							<fo:block id="pageCounter" keep-with-previous="always"/>
						</xsl:if>
					</fo:flow>
				</fo:page-sequence>
			</xsl:if>
			<xsl:if test="$personsTaxCrossborderIta">
				<fo:page-sequence master-reference="pages-content">
					<xsl:if test="//*[local-name()='TestCase']">
						<fo:static-content flow-name="page-header">
							<fo:block>
								<xsl:call-template name="testcase"/>
							</fo:block>
						</fo:static-content>
					</xsl:if>
					<fo:static-content flow-name="page-footer">
						<fo:block>
							<xsl:call-template name="page-footer">
								<xsl:with-param name="col1Width">
									<xsl:text>256mm</xsl:text>
								</xsl:with-param>
								<xsl:with-param name="col2Width">
									<xsl:text>15mm</xsl:text>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:static-content>
					<fo:flow flow-name="page-body">
						<xsl:call-template name="message-header-message-block">
							<xsl:with-param name="message" select="$elm-txb.crossBorderHeaderItaly"/>
						</xsl:call-template>
						<fo:block background-color="white" font-family="{$font-family}">
							<xsl:call-template name="crossBorderItaly"/>
						</fo:block>
						<fo:block id="pageCounter" keep-with-previous="always"/>
					</fo:flow>

				</fo:page-sequence>
			</xsl:if>
		</fo:root>
	</xsl:template>
	<!-- Conditional "Alert" if message is test -->
	<xsl:template name="testcase">
		<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
			<xsl:value-of select="concat(' ** ', $elm-txb.testDeliveryFlag, ' ** ')"/>
		</fo:block>
	</xsl:template>
	<!-- Page footer, shows page numbers and some info from message header. -->
	<xsl:template name="page-footer">
		<xsl:param name="col1Width"/>
		<xsl:param name="col2Width"/>
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="{$col1Width}" column-number="1"/>
			<fo:table-column column-width="{$col2Width}" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="$elm-txb.period"/>:
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxCrossborderTotals']/*[local-name()='Period']/*[local-name()='from']"/>
							</xsl:call-template>
							<xsl:text> - </xsl:text>
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxCrossborderTotals']/*[local-name()='Period']/*[local-name()='until']"/>
							</xsl:call-template>
							| <xsl:value-of select="$elm-txb.transmissionDate"/>:
							<xsl:call-template name="format-datetime">
								<xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='TransmissionDate']"/>
							</xsl:call-template>
							| <xsl:value-of select="$elm-txb.stylesheet.version"/>: <xsl:value-of select="$stylesheet.version"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Fixed header block on page one -->
	<xsl:template name="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block xsl:use-attribute-sets="header-block">
								<xsl:value-of select="$elm-txb"/> | <xsl:value-of select="$elm-txb.taxCrossborder"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.swissdec.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<xsl:template name="message-header-message-block">
		<xsl:param name="message"/>
		<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block xsl:use-attribute-sets="header-block">
								<xsl:value-of select="$elm-txb"/> | <xsl:value-of select="$message"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<!-- Overview page -->
	<xsl:template name="overview">
		<fo:block>
			<xsl:call-template name="company-section"/>
			<xsl:call-template name="contactperson-section"/>
			<xsl:if test="$taxCrossborderTaxableEarningsFra">
				<xsl:call-template name="totalFR-section"/>
			</xsl:if>
			<xsl:if test="$taxCrossborderTaxableEarningsIta">
				<xsl:call-template name="totalIT-section"/>
			</xsl:if>
			<xsl:call-template name="elm-section"/>
			<xsl:if test="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']">
				<xsl:call-template name="substitution-section"/>
			</xsl:if>
		</fo:block>
	</xsl:template>
	<!--French border crossers -->
	<xsl:template name="crossBorderFrance">
		<fo:block>
			<xsl:call-template name="crossBorder-data">
				<xsl:with-param name="taxCrossborderPersons" select="$personsTaxCrossborderFra"/>
				<xsl:with-param name="countryCode" select="'FR'"/>
			</xsl:call-template>
			<fo:block padding-top="5mm"/>
			<fo:block xsl:use-attribute-sets="helper-text">
				<xsl:value-of select="$elm-txb.tablecolumnexplanationCrossBorder"/>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!--Italian border crossers -->
	<xsl:template name="crossBorderItaly">
		<fo:block>
			<xsl:call-template name="crossBorder-data">
				<xsl:with-param name="taxCrossborderPersons" select="$personsTaxCrossborderIta"/>
				<xsl:with-param name="countryCode" select="'IT'"/>
			</xsl:call-template>
			<fo:block padding-top="5mm"/>
			<fo:block xsl:use-attribute-sets="helper-text">
				<xsl:value-of select="$elm-txb.tablecolumnexplanationCrossBorder"/>
			</fo:block>
		</fo:block>
	</xsl:template>
	<xsl:template name="crossBorder-data">
		<xsl:param name="taxCrossborderPersons"/>
		<xsl:param name="countryCode"/>
		<!-- Table itslef -->
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="proportional-column-width(2.5)" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(2.5)" column-number="2"/>
			<fo:table-column column-width="proportional-column-width(2.5)" column-number="3"/>
			<fo:table-column column-width="proportional-column-width(1.5)" column-number="4"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="5"/>
			<fo:table-column column-width="proportional-column-width(0.5)" column-number="6"/>
			<fo:table-column column-width="proportional-column-width(0.5)" column-number="7"/>
			<fo:table-column column-width="proportional-column-width(1.5)" column-number="8"/>
			<fo:table-column column-width="proportional-column-width(1.5)" column-number="9"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="10"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="11"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="12"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="13"/>
			<fo:table-header xsl:use-attribute-sets="table-header-row">
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.svNumber"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.taxId"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.personName"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.dateOfBirthShort"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.cityOfBirthShort"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.countryAbr"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.cantonAbr"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.borderCrosserSince"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-txb.period"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-txb.qstLoan"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-txb.bvgContribution"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-txb.svContribution"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-txb.qstContribution"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-header>
			<fo:table-body>
				<xsl:for-each select="$taxCrossborderPersons">
					<!--					<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
					<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>-->
					<fo:table-row xsl:use-attribute-sets="table-main-row">
						<xsl:call-template name="crossBorder-personal-info">
							<xsl:with-param name="person" select="."/>
							<xsl:with-param name="taxCrossborderSalary" select="./*[local-name()='TaxCrossborderSalaries']/*[local-name()='TaxCrossborderSalary' and (descendant::*[local-name()='ResidenceAbroadCountry']=$countryCode)]"/>
						</xsl:call-template>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="crossBorder-personal-info">
		<xsl:param name="person"/>
		<xsl:param name="taxCrossborderSalary"/>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="ahv-number">
					<xsl:with-param name="insurance-identification" select="$person/*[local-name()='Particulars']/*[local-name()='Social-InsuranceIdentification']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$taxCrossborderSalary/*[local-name()='TaxID']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='Particulars']/*[local-name()='Lastname']"/>, <xsl:value-of select="$person/*[local-name()='Particulars']/*[local-name()='Firstname']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="format-date">
					<xsl:with-param name="value" select="$person/*[local-name()='Particulars']/*[local-name()='DateOfBirth']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$taxCrossborderSalary/*[local-name()='PlaceOfBirth']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$taxCrossborderSalary/*[local-name()='ResidenceAbroadCountry']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$taxCrossborderSalary/*[local-name()='TaxAtSourceCanton']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="format-date">
					<xsl:with-param name="value" select="$taxCrossborderSalary/*[local-name()='CrossborderValidAsOf']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="format-date">
					<xsl:with-param name="value" select="$taxCrossborderSalary/*[local-name()='Period']/*[local-name()='from']"/>
				</xsl:call-template>
				<xsl:text>- </xsl:text>
				<xsl:call-template name="format-date">
					<xsl:with-param name="value" select="$taxCrossborderSalary/*[local-name()='Period']/*[local-name()='until']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number($taxCrossborderSalary/*[local-name()='TaxableEarning'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number($taxCrossborderSalary/*[local-name()='BVG-LPP-ContributionRegular'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number($taxCrossborderSalary/*[local-name()='AHV-ALV-NBUV-AVS-AC-AANP-Contribution'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number($taxCrossborderSalary/*[local-name()='DeductionAtSource'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<!-- Table with persions with correction or EMA Löhne-->
	<!-- Table with persions with correction or EMA Verwaltungsratshonorare VR -->
	<!-- Table with persions with correction or EMA Geldwerte Leistungen (GWL) -->
	<!-- Table with persions with correction or EMA Sonderveinbarung (SV) -->
	<!-- Table with persons with correction or EMA or withdrawal date, these are the detail pages following the two tables -->
	<xsl:template name="ahv-number">
		<xsl:param name="insurance-identification"/>
		<xsl:choose>
			<xsl:when test="$insurance-identification/*[local-name()='SV-AS-Number']">
				<xsl:value-of select="$insurance-identification/*[local-name()='SV-AS-Number']"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$elm-txb.unknown"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
		Total France section
	-->
	<xsl:template name="totalFR-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.totalFR"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.period"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxCrossborderTotals']/*[local-name()='Period']/*[local-name()='from']"/>
											</xsl:call-template>
											<xsl:text> - </xsl:text>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxCrossborderTotals']/*[local-name()='Period']/*[local-name()='until']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.qstLoans"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsFra/*[local-name()='TaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.svContributions"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsFra/*[local-name()='AHV-ALV-NBUV-AVS-AC-AANP-Contribution'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.bvgContributions"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsFra/*[local-name()='BVG-LPP-ContributionRegular'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.qstContributions"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsFra/*[local-name()='DeductionAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Total Italy section
	-->
	<xsl:template name="totalIT-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.totalIT"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.period"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxCrossborderTotals']/*[local-name()='Period']/*[local-name()='from']"/>
											</xsl:call-template>
											<xsl:text> - </xsl:text>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxCrossborderTotals']/*[local-name()='Period']/*[local-name()='until']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.qstLoans"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsIta/*[local-name()='TaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.svContributions"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsIta/*[local-name()='AHV-ALV-NBUV-AVS-AC-AANP-Contribution'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.bvgContributions"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsIta/*[local-name()='BVG-LPP-ContributionRegular'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.qstContributions"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxCrossborderTaxableEarningsIta/*[local-name()='DeductionAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Elm section overview page
	-->
	<xsl:template name="elm-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.elm"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.creationDate"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-datetime">
												<xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='CreationDate']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.transmissionDate"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-datetime">
												<xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='TransmissionDate']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.declarationId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='DeclarationID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.requestId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='DistributorRequestID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.payrollAccounting"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='UserAgent']/*[local-name()='Name']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='UserAgent']/*[local-name()='Version']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='UserAgent']/*[local-name()='Producer']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Substitution section
	-->
	<xsl:template name="substitution-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.substitution"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.reference"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.referencetext"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.requestId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']/*[local-name()='MappedPredecessorDistributorRequestID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.responseId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']/*[local-name()='MappedPredecessorConsumerResponseID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Contact person section
	-->
	<xsl:template name="contactperson-section">
		<xsl:variable name="contactPerson" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='ContactPerson']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.contactPerson"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.personName"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='Name']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.email"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='EmailAddress']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.telefon"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='PhoneNumber']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.mobil"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='MobilePhoneNumber']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-txb.comment"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='Comment']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Company section
	-->
	<xsl:template name="company-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.company"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<xsl:call-template name="company-info">
							<xsl:with-param name="company" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']"/>
							<xsl:with-param name="sslNumber" select="$sslNumber"/>
						</xsl:call-template>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Company Info section, called with parameter @sslNumber in case of company info, without in case of delegate
	-->
	<xsl:template name="company-info">
		<xsl:param name="company"/>
		<xsl:param name="sslNumber"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
			<fo:table-column column-width="{$description-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<xsl:if test="$sslNumber">
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
							<fo:block>
								<xsl:value-of select="$elm-txb.sslNumber"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
							<fo:block>
								<xsl:value-of select="$sslNumber"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.payrollUnit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:value-of select="$payrollUnit"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.uidbfs"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:value-of select="$company/*[local-name()='UID-BFS']"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
						<fo:block>
							<xsl:value-of select="$elm-txb.name"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:value-of select="$company/*[local-name()='Name']/*[local-name()='HR-RC-Name']"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:call-template name="address">
					<xsl:with-param name="address" select="$company/*[local-name()='Address']"/>
				</xsl:call-template>
				<xsl:if test="$company/*[local-name()='Owner']">
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
							<fo:block>
								<xsl:value-of select="$elm-txb.owner"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
							<fo:block>
								<xsl:value-of select="$company/*[local-name()='Owner']/*[local-name()='Lastname']"/>
								<xsl:text>, </xsl:text>
								<xsl:value-of select="$company/*[local-name()='Owner']/*[local-name()='Firstname']"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="address">
		<xsl:param name="address"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$elm-txb.address"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<xsl:if test="$address/*[local-name()='ComplementaryLine']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='ComplementaryLine']"/>
					</fo:block>
				</xsl:if>
				<xsl:if test="$address/*[local-name()='Street']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Street']"/>
					</fo:block>
				</xsl:if>
				<xsl:if test="$address/*[local-name()='Postbox']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Postbox']"/>
					</fo:block>
				</xsl:if>
				<xsl:if test="$address/*[local-name()='Locality']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Locality']"/>
					</fo:block>
				</xsl:if>
				<fo:block>
					<xsl:value-of select="$address/*[local-name()='ZIP-Code']"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="$address/*[local-name()='City']"/>
				</fo:block>
				<xsl:if test="$address/*[local-name()='Country']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Country']"/>
					</fo:block>
				</xsl:if>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Template for formatting the amount right justified on 2 columns -->
	<xsl:template name="format-amount-right-justified-two-columns">
		<xsl:param name="amount"/>
		<xsl:param name="horizontal"/>
		<xsl:variable name="empty-col-width">
			<xsl:choose>
				<xsl:when test="$horizontal">
					<xsl:text>proportional-column-width(12.5)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>proportional-column-width(8)</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" start-indent="0in">
			<fo:table-column column-width="proportional-column-width(1)" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="2"/>
			<fo:table-column column-width="{$empty-col-width}" column-number="3"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="value-column">
						<fo:block>
							<!-- <xsl:if test="$amount"> -->
							<xsl:text>CHF</xsl:text>
							<!-- </xsl:if> -->
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column" text-align="right">
						<fo:block>
							<xsl:value-of select="format-number($amount, $cents-format)"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Template for formatting the address -->
</xsl:stylesheet>