<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exslt="http://exslt.org/common"
                xmlns:fo="http://www.w3.org/1999/XSL/Format">

    <xsl:output method="xml" encoding="utf-8" indent="yes"/>
    <xsl:variable name="TheXslVersion" select="20240618"/>
    <xsl:variable name="TheXslName" select="'ORDReport.xsl'"/>
    <xsl:param name="tempDir" select="'temp/'"/>
    <xsl:param name="verbose" select="'false'"/>
    <xsl:param name="fromPerson" select="'1'"/>
    <xsl:param name="toPerson" select="'1'"/>

    <!-- Infos zu BarcodeFiles -->
    <xsl:param name="barcodeImageInfosFile" select="'BarcodeImageInfos.xml'"/>
    <xsl:variable name="barcodeImageInfos" select="document($barcodeImageInfosFile)//BarcodeImageInfos"/>
    <xsl:param name="BarcodePrefix" select="'bcdImage'"/>

    <xsl:include href="text-attributes.xsl"/>
    <xsl:include href="page-attributes-landscape.xsl"/>
    <xsl:include href="Common_fr.xsl"/>

    <xsl:include href="ORDReport-common.xsl"/>
    <xsl:variable name="messages" select="document('ORDReport-messages.xml')/messages"/>

    <xsl:variable name="salaryDeclaration" select="//*[local-name()='SalaryDeclaration']"/>
    <xsl:variable name="company" select="$salaryDeclaration/*[local-name()='Company']"/>
    <xsl:variable name="isTestCase" select="//*[local-name()='TestCase']"/>
    <xsl:variable name="requestID" select="//*[local-name()='RequestContext']/*[local-name()='RequestID']" />
    <xsl:variable name="transmissionDate" select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='TransmissionDate']"/>

    <xsl:variable name="testDeliveryFlag">
        <xsl:call-template name="messageLookup">
            <xsl:with-param name="key" select="'testDeliveryFlag'"/>
        </xsl:call-template>
    </xsl:variable>


    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
                    <xsl:attribute name="page-height">210mm</xsl:attribute>
                    <xsl:attribute name="page-width">297mm</xsl:attribute>
                    <xsl:variable name="bodymargin">
                        <xsl:choose>
                            <xsl:when test="$isTestCase">
                                <xsl:value-of select="$body-top-margin-test"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="$body-top-margin"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <fo:region-body region-name="page-body" margin-top="{$bodymargin}"
                                    margin-bottom="{$body-bottom-margin}">
                        <xsl:attribute name="background-image">
<!--                            <xsl:choose>-->
<!--                                <xsl:when test="$Generator='Viewgen'">-->
                                    <xsl:value-of select="$backgroundImage"/>
<!--                                </xsl:when>-->
<!--                                <xsl:otherwise>-->
<!--                                    <xsl:value-of select="concat('file:/',$backgroundImage)"/>-->
<!--                                </xsl:otherwise>-->
<!--                            </xsl:choose>-->
                        </xsl:attribute>
                    </fo:region-body>
                    <fo:region-before region-name="page-header" extent="{$header-height}"/>
                    <fo:region-after region-name="page-footer" extent="{$footer-height}"/>
                </fo:simple-page-master>
                <fo:page-sequence-master master-name="pages-content">
                    <fo:repeatable-page-master-reference master-reference="other-pages"/>
                </fo:page-sequence-master>
            </fo:layout-master-set>

            <fo:page-sequence master-reference="pages-content">
                <xsl:if test="$isTestCase">
                    <fo:static-content flow-name="page-header">
                        <fo:block>
                            <xsl:call-template name="testcase"/>
                        </fo:block>
                    </fo:static-content>
                </xsl:if>
                <fo:static-content flow-name="page-footer">
                    <fo:block>
                        <xsl:call-template name="page-footer">
                            <xsl:with-param name="col1Width">
                                <xsl:text>256mm</xsl:text>
                            </xsl:with-param>
                            <xsl:with-param name="col2Width">
                                <xsl:text>15mm</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                    </fo:block>
                </fo:static-content>
                <fo:flow flow-name="page-body">
                    <xsl:apply-templates select="//*[local-name()='Staff']/*[local-name()='Person']">
                    </xsl:apply-templates>
                    <fo:block id="docEnd"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template match="*[local-name()='Person']">
        <xsl:variable name="counter" select="position()"/>
        <xsl:if test="($counter &gt;= number($fromPerson)) and ($counter &lt;= number($toPerson))">
            <xsl:variable name="bcfnPersonBase" select="concat($BarcodePrefix,'_', ./*[local-name()='Particulars']/*[local-name()='Social-InsuranceIdentification']/*[local-name()='SV-AS-Number'],
                                                            ./*[local-name()='Particulars']/*[local-name()='Lastname'],
                                                            ./*[local-name()='Particulars']/*[local-name()='Firstname'],$counter,
                                                            ./*[local-name()='Particulars']/*[local-name()='Sex'],
                                                            ./*[local-name()='Particulars']/*[local-name()='DateOfBirth'])"/>

            <xsl:apply-templates select="./*[local-name()='TaxSalaries']/*[local-name()='OwnershipRightDetail']">
                <xsl:with-param name="person" select="."/>
                <xsl:with-param name="bcfnPersonBase" select="$bcfnPersonBase"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>

    <xsl:template match="*[local-name()='OwnershipRightDetail']">
        <xsl:param name="person"/>
        <xsl:param name="bcfnPersonBase"/>

        <xsl:variable name="ordCounter" select="number(position())"/>
        <xsl:variable name="bcfnORDName" select="concat($bcfnPersonBase, 'OwnershipRightDetail', $ordCounter)"/>

        <!--Die Formulare A für diese Person erstellen-->
        <xsl:apply-templates select="./*[local-name()='FormularA']">
            <xsl:with-param name="person" select="$person"/>
            <xsl:with-param name="bcfnORDName" select="$bcfnORDName"/>
        </xsl:apply-templates>

        <!--Die Formulare B für diese Person erstellen-->
        <xsl:apply-templates select="./*[local-name()='FormularB']">
            <xsl:with-param name="person" select="$person"/>
            <xsl:with-param name="bcfnORDName" select="$bcfnORDName"/>
        </xsl:apply-templates>

        <!-- Die Formulare C für diese Person erstellen-->
        <xsl:apply-templates select="./*[local-name()='FormularC']">
            <xsl:with-param name="person" select="$person"/>
            <xsl:with-param name="bcfnORDName" select="$bcfnORDName"/>
        </xsl:apply-templates>

    </xsl:template>

    <!-- Conditional "Alert" if message is test -->
    <xsl:template name="testcase">
        <fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm"
                  background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}"
                  font-weight="bold">
            <xsl:value-of select="concat(' ** ', $testDeliveryFlag, ' ** ')"/>
        </fo:block>
    </xsl:template>

    <!-- Page footer, shows page numbers and some info from message header. -->
    <xsl:template name="page-footer">
        <xsl:param name="col1Width"/>
        <xsl:param name="col2Width"/>
        <fo:table table-layout="fixed" width="100%">
            <fo:table-column column-width="{$col1Width}" column-number="1"/>
            <fo:table-column column-width="{$col2Width}" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
                        <fo:block font-family="{$font-family}">
<!--                            <xsl:call-template name="messageLookup">-->
<!--                                <xsl:with-param name="key" select="'msgID'"/>-->
<!--                            </xsl:call-template>-->
<!--                            <xsl:text> </xsl:text>-->
<!--                            <xsl:value-of select="$requestID"/>-->
<!--                            |-->
<!--                            <xsl:call-template name="messageLookup">-->
<!--                                <xsl:with-param name="key" select="'transmissionDate'"/>-->
<!--                            </xsl:call-template>-->
<!--                            <xsl:text> </xsl:text>-->
<!--                            <xsl:call-template name="format-datetime">-->
<!--                                <xsl:with-param name="value" select="$transmissionDate"/>-->
<!--                            </xsl:call-template>-->
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
                        <fo:block font-family="{$font-family}">
                            <fo:page-number/>/<fo:page-number-citation-last ref-id="docEnd"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
        <fo:block margin-top="3mm">
            <xsl:call-template name="getSingleLineFooter"/>
        </fo:block>
    </xsl:template>

    <!-- Fixed header block on page one -->
    <xsl:template name="message-header-block">
        <xsl:param name="titel"/>
        <xsl:param name="zusatz"/>
        <fo:block-container height="20mm" width="190mm"
                            left="0mm"
                            top="0mm"
                            position="absolute">
            <fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
                <fo:table table-layout="fixed" width="100%">
                    <fo:table-column column-width="100%" column-number="1"/>
                    <fo:table-body>
                        <fo:table-row>
                            <fo:table-cell column-number="1" display-align="center">
                                <fo:block xsl:use-attribute-sets="header-block">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'elm-la'"/>
                                    </xsl:call-template>
                                    <xsl:text> | </xsl:text>
                                    <xsl:value-of select="$titel"/>
                                    <xsl:text> | </xsl:text>
                                    <xsl:value-of select="$zusatz"/>
                                </fo:block>
                                <fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.swissdec.ch</fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="titleFormAPage1">
        <xsl:call-template name="message-header-block">
            <xsl:with-param name="titel">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'bescheinigungLA'"/>
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="zusatz">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'mitarbeiterbeteiligung'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="titleFormAPage2">
        <xsl:call-template name="message-header-block">
            <xsl:with-param name="titel">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'anlageMAbet'"/>
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="zusatz">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'TaxableAsset'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <!--Formular A-->
    <xsl:template match="*[local-name()='FormularA']">
        <xsl:param name="person"/>
        <xsl:param name="bcfnORDName"/>

        <xsl:variable name="formACounter" select="number(position())"/>
        <xsl:variable name="bcfnFormularName" select="concat($bcfnORDName, 'FormularA', $formACounter)"/>
        <xsl:variable name="barcodeImageInfo" select="$barcodeImageInfos/*[local-name()='BarcodeImageInfo'][@name=$bcfnFormularName]"/>
        <xsl:variable name="currency" select="./*[local-name()='Header']/*[local-name()='Currency']"/>
        <xsl:variable name="header" select="./*[local-name()='Header']"/>

<!--        <xsl:call-template name="printMessage">-->
<!--            <xsl:with-param name="message">-->
<!--                formCounter: <xsl:value-of select="$formACounter"/>-->
<!--            </xsl:with-param>-->
<!--        </xsl:call-template>-->
<!--        <xsl:call-template name="printMessage">-->
<!--            <xsl:with-param name="message">-->
<!--                bcfnFormularName: <xsl:value-of select="$bcfnFormularName"/>-->
<!--            </xsl:with-param>-->
<!--        </xsl:call-template>-->
<!--        <xsl:call-template name="printMessage">-->
<!--            <xsl:with-param name="message">-->
<!--                barcodeImageInfo_name: <xsl:value-of select="$barcodeImageInfo/@name"/>-->
<!--            </xsl:with-param>-->
<!--        </xsl:call-template>-->

        <fo:block page-break-before="always"/>

        <!-- 1. Seite -->
        <xsl:variable name="linesIncomeFormA" select="./*[local-name()='TableAIncome']/*[local-name()='Line']"/>
        <xsl:variable name="totalIncomeDeclaredInSalaryCertificate" select="./*[local-name()='TableAIncome']/*[local-name()='TotalIncomeDeclaredInSalaryCertificate']"/>

        <xsl:choose>
            <xsl:when test="count($linesIncomeFormA) &lt; 16">
                <!-- The table is small enough to be on 1 page -->
                <xsl:call-template name="titleFormAPage1"/>

                <fo:block margin-bottom="2mm">
                    <xsl:call-template name="MitarbeiterInfos">
                        <xsl:with-param name="formularTyp" select="'A'"/>
                        <xsl:with-param name="header" select="$header"/>
                        <xsl:with-param name="person" select="$person"/>
                        <xsl:with-param name="titel1">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="datumTxtLabel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="bildNr" select="1"/>
                        <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                    </xsl:call-template>
                </fo:block>

                <fo:block-container height="100mm" width="280mm"
                                    left="0mm"
                                    top="100mm"
                                    position="absolute">

                    <fo:block margin-bottom="2mm">
                        <xsl:call-template name="TaxIncomeTableFormA">
                            <xsl:with-param name="lines" select="$linesIncomeFormA"/>
                            <xsl:with-param name="currency" select="$currency"/>
                            <xsl:with-param name="von" select="0"/>
                            <xsl:with-param name="bis" select="16"/>
                        </xsl:call-template>
                    </fo:block>

                    <fo:block page-break-after="always">
                        <xsl:call-template name="TaxIncomeTableFormASum">
                            <xsl:with-param name="totalIncomeDeclaredInSalaryCertificate" select="$totalIncomeDeclaredInSalaryCertificate"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:block-container>

                <fo:block break-after="page"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Split table on several pages -->
                <!-- <xsl:message>Split table on several pages</xsl:message>-->
                <xsl:for-each select="$linesIncomeFormA">
                    <xsl:message>linesIncomeFormA Position: <xsl:value-of select="position()"/></xsl:message>

                    <xsl:if test="(position() mod 15 = 0)or(position() = 1)">
                        <xsl:variable name="bildNr" select="floor(position() div 15) + 1"/>
<!--                        <xsl:message>bildNr: <xsl:value-of select="$bildNr"/></xsl:message>-->

                        <xsl:call-template name="titleFormAPage1"/>
                        <fo:block margin-bottom="2mm">
                            <xsl:call-template name="MitarbeiterInfos">
                                <xsl:with-param name="formularTyp" select="'A'"/>
                                <xsl:with-param name="header" select="$header"/>
                                <xsl:with-param name="person" select="$person"/>
                                <xsl:with-param name="titel1">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="datumTxtLabel">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="bildNr" select="$bildNr"/>
                                <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                            </xsl:call-template>
                        </fo:block>

                        <fo:block-container height="100mm" width="280mm"
                                            left="0mm"
                                            top="100mm"
                                            position="absolute">
                            <xsl:variable name="bis">
                                <xsl:choose>
                                    <xsl:when test="position() = 1">
                                        <xsl:value-of select="position()+14"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="position()+15"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <fo:block margin-bottom="2mm">
                                <xsl:call-template name="TaxIncomeTableFormA">
                                    <xsl:with-param name="lines" select="$linesIncomeFormA"/>
                                    <xsl:with-param name="currency" select="$currency"/>
                                    <xsl:with-param name="von" select="position()"/>
                                    <xsl:with-param name="bis" select="$bis"/>
                                </xsl:call-template>
                            </fo:block>
                            <xsl:choose>
                                <xsl:when test="not((position() + 15) &lt; count($linesIncomeFormA))">
<!--                                    <xsl:message>Final page of Form A page "1"</xsl:message>-->
                                    <!-- Last page with TaxIncomeTable Form A -->
                                    <fo:block page-break-after="always">
                                        <xsl:call-template name="TaxIncomeTableFormASum">
                                            <xsl:with-param name="totalIncomeDeclaredInSalaryCertificate"
                                                            select="$totalIncomeDeclaredInSalaryCertificate"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="continueNextPage"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </fo:block-container>
                        <xsl:if test="(position() + 15) &lt; count($linesIncomeFormA)">
<!--                            <xsl:message>Pagebreak in Form A page "1"</xsl:message>-->
                            <fo:block page-break-after="always"/>
                        </xsl:if>

                    </xsl:if>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>

        <fo:block break-after="page"/>
        <xsl:variable name="nextBildNr" select="floor(count($linesIncomeFormA) div 15) + 2"/>
<!--        floor(count($linesIncomeFormA) div 15) : Anzahl Bilder ohne "letzte" Seite-->
<!--        floor(count($linesIncomeFormA) div 15) + 1 : Anzahl Bilder mit "letzte" Seite-->
<!--        floor(count($linesIncomeFormA) div 15) + 2 : Nächstes Bild für "erste" Seite von Form A "Vermögen"-->

<!--        <xsl:message>count($linesIncomeFormA): <xsl:value-of select="count($linesIncomeFormA)"/></xsl:message>-->
<!--        <xsl:message>(count($linesIncomeFormA) div 15): <xsl:value-of select="(count($linesIncomeFormA) div 15)"/></xsl:message>-->
<!--        <xsl:message>nextBildNr: <xsl:value-of select="$nextBildNr"/></xsl:message>-->

        <!-- 2. Seite -->
        <xsl:variable name="linesWealthFormA" select="./*[local-name()='TableAWealth']/*[local-name()='Line']"/>
        <xsl:variable name="totalTaxableWealthInCH" select="./*[local-name()='TableAWealth']/*[local-name()='TotalTaxableWealthInCH']"/>

        <xsl:choose>
            <xsl:when test="count($linesWealthFormA) &lt; 16">
                <!-- The table is small enough to be on 1 page -->
                <xsl:call-template name="titleFormAPage2"/>

                <fo:block margin-bottom="2mm">
                    <xsl:call-template name="MitarbeiterInfos">
                        <xsl:with-param name="formularTyp" select="'A'"/>
                        <xsl:with-param name="header" select="$header"/>
                        <xsl:with-param name="person" select="$person"/>
                        <xsl:with-param name="titel1">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'anlageMAbets'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="datumTxtLabel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'DatumAnhang'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="bildNr" select="$nextBildNr"/>
                        <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                    </xsl:call-template>
                </fo:block>

                <fo:block-container height="100mm" width="280mm"
                                    left="0mm"
                                    top="100mm"
                                    position="absolute">

                    <fo:block margin-bottom="2mm">
                        <xsl:call-template name="TaxAssetTableFormA">
                            <xsl:with-param name="lines" select="$linesWealthFormA"/>
                            <xsl:with-param name="currency" select="$currency"/>
                            <xsl:with-param name="von" select="0"/>
                            <xsl:with-param name="bis" select="16"/>
                        </xsl:call-template>
                    </fo:block>
                    <fo:block>
                        <xsl:call-template name="TotalTaxableWealthInCH">
                            <xsl:with-param name="TotalTaxableWealthInCH" select="$totalTaxableWealthInCH"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:block-container>
            </xsl:when>
            <xsl:otherwise>
                <!-- Split table on several pages -->
                <xsl:for-each select="$linesWealthFormA">
                    <xsl:if test="(position() mod 15 = 0)or(position() = 1)">
                        <xsl:variable name="bildNr" select="$nextBildNr + floor(position() div 15)"/>

                        <xsl:call-template name="titleFormAPage2"/>

                        <fo:block margin-bottom="2mm">
                            <xsl:call-template name="MitarbeiterInfos">
                                <xsl:with-param name="formularTyp" select="'A'"/>
                                <xsl:with-param name="header" select="$header"/>
                                <xsl:with-param name="person" select="$person"/>
                                <xsl:with-param name="titel1">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'anlageMAbets'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="datumTxtLabel">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'DatumAnhang'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="bildNr" select="$bildNr"/>
                                <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                            </xsl:call-template>
                        </fo:block>

                        <fo:block-container height="100mm" width="280mm"
                                            left="0mm"
                                            top="100mm"
                                            position="absolute">
                            <fo:block margin-bottom="2mm">
                                <xsl:variable name="bis">
                                    <xsl:choose>
                                        <xsl:when test="position() = 1">
                                            <xsl:value-of select="position()+14"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="position()+15"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:variable>
                                <xsl:call-template name="TaxAssetTableFormA">
                                    <xsl:with-param name="lines" select="$linesWealthFormA"/>
                                    <xsl:with-param name="currency" select="$currency"/>
                                    <xsl:with-param name="von" select="position()"/>
                                    <xsl:with-param name="bis" select="$bis"/>
                                </xsl:call-template>
                            </fo:block>
                            <xsl:choose>
                                <xsl:when test="not((position() + 15) &lt; count($linesWealthFormA))">
                                    <fo:block>
                                        <xsl:call-template name="TotalTaxableWealthInCH">
                                            <xsl:with-param name="TotalTaxableWealthInCH" select="$totalTaxableWealthInCH"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="continueNextPage"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </fo:block-container>
                        <xsl:if test="(position() + 15) &lt; count($linesWealthFormA)">
                            <fo:block page-break-after="always"/>
                        </xsl:if>
                    </xsl:if>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>

        <xsl:variable name="tsugiBildNr" select="floor(count($linesWealthFormA) div 15) + $nextBildNr + 1"/>
<!--            <xsl:message>floor(count($linesWealthFormA) div 15): <xsl:value-of select="floor(count($linesWealthFormA) div 15)"/></xsl:message>-->
<!--            <xsl:message>tsugiBildNr: <xsl:value-of select="$tsugiBildNr"/></xsl:message>-->


        <xsl:if test="count($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']) &gt;= $tsugiBildNr">
            <xsl:call-template name="PrintAdditionalBarcodes">
                <xsl:with-param name="filenames" select="$barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']"/>
                <xsl:with-param name="titel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'anlageMAbet'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="formularName" select="'Form A'"/>
                <xsl:with-param name="baseNr" select="$tsugiBildNr"/>
                <xsl:with-param name="formularTyp" select="'A'"/>
                <xsl:with-param name="header" select="$header"/>
                <xsl:with-param name="titel1">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'anlageMAbets'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="datumTxtLabel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'DatumAnhang'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="barcodeID" select="$barcodeImageInfo/*[local-name()='BarcodeID']"/>
                <xsl:with-param name="person" select="$person"/>
            </xsl:call-template>
        </xsl:if>

    </xsl:template>

    <xsl:template name="titleFormB">
        <xsl:call-template name="message-header-block">
            <xsl:with-param name="titel">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'bescheinigungLA'"/>
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="zusatz">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'mitarbeiterbeteiligung'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <!--Formular B-->
    <xsl:template match="*[local-name()='FormularB']">
        <xsl:param name="person"/>
        <xsl:param name="bcfnORDName"/>

        <xsl:variable name="formBCounter" select="number(position())"/>
        <xsl:variable name="bcfnFormularName" select="concat($bcfnORDName, 'FormularB', $formBCounter)"/>
        <xsl:variable name="barcodeImageInfo" select="$barcodeImageInfos/*[local-name()='BarcodeImageInfo'][@name=$bcfnFormularName]"/>
        <xsl:variable name="currency" select="./*[local-name()='Header']/*[local-name()='Currency']"/>
        <xsl:variable name="header" select="./*[local-name()='Header']"/>
        <xsl:variable name="linesFormB" select="./*[local-name()='Line']"/>
        <xsl:variable name="totalFiscaleDeduction" select="./*[local-name()='TotalFiscaleDeduction']"/>
        <xsl:variable name="totalTaxableIncome" select="./*[local-name()='TotalTaxableIncome']"/>

        <fo:block page-break-before="always"/>

        <xsl:choose>
            <xsl:when test="count($linesFormB) &lt; 16">
                <!-- The table is small enough to be on 1 page -->
                <xsl:call-template name="titleFormB"/>

                <fo:block margin-bottom="2mm">
                    <xsl:call-template name="MitarbeiterInfos">
                        <xsl:with-param name="formularTyp" select="'B'"/>
                        <xsl:with-param name="header" select="$header"/>
                        <xsl:with-param name="person" select="$person"/>
                        <xsl:with-param name="titel1">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="datumTxtLabel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="bildNr" select="1"/>
                        <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                    </xsl:call-template>
                </fo:block>

                <fo:block-container height="100mm" width="280mm"
                                    left="0mm"
                                    top="100mm"
                                    position="absolute">

                    <fo:block margin-bottom="2mm">
                        <xsl:call-template name="TaxIncomeTableFormB">
                            <xsl:with-param name="lines" select="$linesFormB"/>
                            <xsl:with-param name="currency" select="$currency"/>
                            <xsl:with-param name="von" select="0"/>
                            <xsl:with-param name="bis" select="16"/>
                        </xsl:call-template>
                    </fo:block>
                    <fo:block>
                        <xsl:call-template name="TaxIncomeTableFormBSum">
                            <xsl:with-param name="totalFiscaleDeduction" select="$totalFiscaleDeduction"/>
                            <xsl:with-param name="totalTaxableIncome" select="$totalTaxableIncome"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:block-container>
            </xsl:when>
            <xsl:otherwise>
                <!-- Split table on several pages -->
                <xsl:for-each select="$linesFormB">
                    <xsl:if test="(position() mod 15 = 0)or(position() = 1)">
                        <xsl:variable name="bildNr" select="floor(position() div 15) + 1"/>
                        <xsl:call-template name="titleFormB"/>

                        <fo:block margin-bottom="2mm">
                            <xsl:call-template name="MitarbeiterInfos">
                                <xsl:with-param name="formularTyp" select="'B'"/>
                                <xsl:with-param name="header" select="$header"/>
                                <xsl:with-param name="person" select="$person"/>
                                <xsl:with-param name="titel1">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="datumTxtLabel">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="bildNr" select="$bildNr"/>
                                <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                            </xsl:call-template>
                        </fo:block>

                        <fo:block-container height="100mm" width="280mm"
                                            left="0mm"
                                            top="100mm"
                                            position="absolute">
                            <xsl:variable name="bis">
                                <xsl:choose>
                                    <xsl:when test="position() = 1">
                                        <xsl:value-of select="position()+14"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="position()+15"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <fo:block margin-bottom="2mm">
                                <xsl:call-template name="TaxIncomeTableFormB">
                                    <xsl:with-param name="lines" select="$linesFormB"/>
                                    <xsl:with-param name="currency" select="$currency"/>
                                    <xsl:with-param name="von" select="position()"/>
                                    <xsl:with-param name="bis" select="$bis"/>
                                </xsl:call-template>
                            </fo:block>
                            <xsl:choose>
                                <xsl:when test="not((position() + 15) &lt; count($linesFormB))">
                                    <fo:block>
                                        <xsl:call-template name="TaxIncomeTableFormBSum">
                                            <xsl:with-param name="totalFiscaleDeduction" select="$totalFiscaleDeduction"/>
                                            <xsl:with-param name="totalTaxableIncome" select="$totalTaxableIncome"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="continueNextPage"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </fo:block-container>
                        <xsl:if test="(position() + 15) &lt; count($linesFormB)">
                            <fo:block page-break-after="always"/>
                        </xsl:if>
                    </xsl:if>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>

<!--        <fo:block break-after="page"/>-->
        <xsl:variable name="nextBildNr" select="floor(count($linesFormB) div 15) + 2"/>
        <!--        floor(count($linesFormB) div 15) : Anzahl Bilder ohne "letzte" Seite-->
        <!--        floor(count($linesFormB) div 15) + 1 : Anzahl Bilder mit "letzte" Seite-->
        <!--        floor(count($linesFormB) div 15) + 2 : Nächstes Bild für "erste" Seite von Form B-->
<!--        <xsl:message>count($linesFormB): <xsl:value-of select="count($linesFormB)"/></xsl:message>-->
<!--        <xsl:message>(count($linesFormB) div 15): <xsl:value-of select="(count($linesFormB) div 15)"/></xsl:message>-->
<!--        <xsl:message>nextBildNr: <xsl:value-of select="$nextBildNr"/></xsl:message>-->
<!--        <xsl:message>count($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']): <xsl:value-of-->
<!--                select="count($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename'])"/></xsl:message>-->


        <xsl:if test="(count($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']) &gt;= $nextBildNr)">
            <xsl:call-template name="PrintAdditionalBarcodes">
                <xsl:with-param name="filenames" select="$barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']"/>
                <xsl:with-param name="titel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'bescheinigungLA'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="formularName" select="'Form B'"/>
                <xsl:with-param name="baseNr" select="$nextBildNr"/>
                <xsl:with-param name="titel1">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="datumTxtLabel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="formularTyp" select="'B'"/>
                <xsl:with-param name="header" select="$header"/>
                <xsl:with-param name="barcodeID" select="$barcodeImageInfo/*[local-name()='BarcodeID']"/>
                <xsl:with-param name="person" select="$person"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="titleFormC">
        <xsl:call-template name="message-header-block">
            <xsl:with-param name="titel">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'bescheinigungLA'"/>
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="zusatz">
                <xsl:call-template name="messageLookup">
                    <xsl:with-param name="key" select="'mitarbeiterbeteiligung'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <!--Formular C-->
    <xsl:template match="*[local-name()='FormularC']">
        <xsl:param name="person"/>
        <xsl:param name="bcfnORDName"/>

        <xsl:variable name="formCCounter" select="number(position())"/>
        <xsl:variable name="bcfnFormularName" select="concat($bcfnORDName, 'FormularC', $formCCounter)"/>
        <xsl:variable name="barcodeImageInfo" select="$barcodeImageInfos/*[local-name()='BarcodeImageInfo'][@name=$bcfnFormularName]"/>
        <xsl:variable name="currency" select="./*[local-name()='Header']/*[local-name()='Currency']"/>
        <xsl:variable name="header" select="./*[local-name()='Header']"/>
        <xsl:variable name="linesTableCOwnershipRightPortfolio" select="./*[local-name()='TableCOwnershipRightPortfolio']/*[local-name()='Line']"/>
        <xsl:variable name="linesTableCIncome" select="./*[local-name()='TableCIncome']/*[local-name()='Line']"/>
        <xsl:variable name="totalNumberOfOwnershipsAtEndOfPeriod" select="./*[local-name()='TableCOwnershipRightPortfolio']/*[local-name()='TotalNumberOfOwnershipsAtEndOfPeriod']"/>
        <xsl:variable name="grandTotalIncomeAtRealization" select="./*[local-name()='TableCIncome']/*[local-name()='GrandTotalIncomeAtRealization']"/>
        <xsl:variable name="totalPartIncomeCH" select="./*[local-name()='TableCIncome']/*[local-name()='TotalPartIncomeCH']"/>
        <xsl:variable name="totalPartIncomeAbroad" select="./*[local-name()='TableCIncome']/*[local-name()='TotalPartIncomeAbroad']"/>

        <fo:block page-break-before="always"/>

        <xsl:choose>
            <xsl:when test="count($linesTableCOwnershipRightPortfolio) + count($linesTableCIncome) &gt; 6">
                <!-- 1. Seite-->
                <xsl:choose>
                    <xsl:when test="count($linesTableCOwnershipRightPortfolio) &lt; 13">
                        <xsl:call-template name="titleFormC"/>

                        <fo:block>
                            <xsl:call-template name="MitarbeiterInfos">
                                <xsl:with-param name="formularTyp" select="'C'"/>
                                <xsl:with-param name="header" select="$header"/>
                                <xsl:with-param name="person" select="$person"/>
                                <xsl:with-param name="titel1">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="datumTxtLabel">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="bildNr" select="1"/>
                                <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                            </xsl:call-template>
                        </fo:block>

                        <fo:block-container height="100mm" width="280mm"
                                            left="0mm"
                                            top="105mm"
                                            position="absolute">

                            <fo:block margin-bottom="2mm">
                                <xsl:call-template name="MAbeteiligungenTableFormC">
                                    <xsl:with-param name="lines" select="$linesTableCOwnershipRightPortfolio"/>
                                    <xsl:with-param name="currency" select="$currency"/>
                                    <xsl:with-param name="von" select="0"/>
                                    <xsl:with-param name="bis" select="13"/>
                                </xsl:call-template>
                            </fo:block>

                            <fo:block>
                                <xsl:call-template name="MAbeteiligungenTableFormCSum">
                                    <xsl:with-param name="totalNumberOfOwnershipsAtEndOfPeriod"
                                                    select="$totalNumberOfOwnershipsAtEndOfPeriod"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:block-container>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Split table on several pages -->
                        <xsl:for-each select="$linesTableCOwnershipRightPortfolio">
                            <xsl:if test="(position() mod 12 = 0)or(position() = 1)">
                                <xsl:variable name="bildNr" select="floor(position() div 12) + 1"/>
                                <xsl:call-template name="titleFormC"/>
                                <fo:block>
                                    <xsl:call-template name="MitarbeiterInfos">
                                        <xsl:with-param name="formularTyp" select="'C'"/>
                                        <xsl:with-param name="header" select="$header"/>
                                        <xsl:with-param name="person" select="$person"/>
                                        <xsl:with-param name="titel1">
                                            <xsl:call-template name="messageLookup">
                                                <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                                            </xsl:call-template>
                                        </xsl:with-param>
                                        <xsl:with-param name="datumTxtLabel">
                                            <xsl:call-template name="messageLookup">
                                                <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                                            </xsl:call-template>
                                        </xsl:with-param>
                                        <xsl:with-param name="bildNr" select="$bildNr"/>
                                        <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                                    </xsl:call-template>
                                </fo:block>
                                <fo:block-container height="100mm" width="280mm"
                                                    left="0mm"
                                                    top="105mm"
                                                    position="absolute">
                                    <xsl:variable name="bis">
                                        <xsl:choose>
                                            <xsl:when test="position() = 1">
                                                <xsl:value-of select="position()+11"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="position()+12"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <fo:block margin-bottom="2mm">
                                        <xsl:call-template name="MAbeteiligungenTableFormC">
                                            <xsl:with-param name="lines" select="$linesTableCOwnershipRightPortfolio"/>
                                            <xsl:with-param name="currency" select="$currency"/>
                                            <xsl:with-param name="von" select="position()"/>
                                            <xsl:with-param name="bis" select="$bis"/>
                                        </xsl:call-template>
                                    </fo:block>
                                    <xsl:choose>
                                        <xsl:when test="not((position() + 12) &lt; count($linesTableCOwnershipRightPortfolio))">
                                            <fo:block>
                                                <xsl:call-template name="MAbeteiligungenTableFormCSum">
                                                    <xsl:with-param name="totalNumberOfOwnershipsAtEndOfPeriod"
                                                                    select="$totalNumberOfOwnershipsAtEndOfPeriod"/>
                                                </xsl:call-template>
                                            </fo:block>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:call-template name="continueNextPage"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </fo:block-container>
                                <xsl:if test="(position() + 12) &lt; count($linesTableCOwnershipRightPortfolio)">
                                    <fo:block page-break-after="always"/>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>

                    </xsl:otherwise>
                </xsl:choose>

                <!-- 2. Seite-->
                <fo:block page-break-before="always"/>

                <xsl:variable name="nextBildNr" select="floor(count($linesTableCOwnershipRightPortfolio) div 12) + 2"/>
                <!--        floor(count($linesTableCOwnershipRightPortfolio) div 15) : Anzahl Bilder ohne "letzte" Seite-->
                <!--        floor(count($linesTableCOwnershipRightPortfolio) div 15) + 1 : Anzahl Bilder mit "letzte" Seite-->
                <!--        floor(count($linesTableCOwnershipRightPortfolio) div 15) + 2 : Nächstes Bild für "erste" Seite von Form C -->
<!--                <xsl:message>count($linesTableCOwnershipRightPortfolio): <xsl:value-of select="count($linesTableCOwnershipRightPortfolio)"/></xsl:message>-->
<!--                <xsl:message>(count($linesTableCOwnershipRightPortfolio) div 12): <xsl:value-of select="(count($linesTableCOwnershipRightPortfolio) div 12)"/></xsl:message>-->
<!--                <xsl:message>nextBildNr: <xsl:value-of select="$nextBildNr"/></xsl:message>-->

                <xsl:choose>
                    <xsl:when test="count($linesTableCIncome) &lt; 13">
                        <!-- The table is small enough to be on 1 page -->
                        <xsl:call-template name="titleFormC"/>

                        <fo:block>
                            <xsl:call-template name="MitarbeiterInfos">
                                <xsl:with-param name="formularTyp" select="'C'"/>
                                <xsl:with-param name="header" select="$header"/>
                                <xsl:with-param name="person" select="$person"/>
                                <xsl:with-param name="titel1">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="datumTxtLabel">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                                    </xsl:call-template>
                                </xsl:with-param>
                                <xsl:with-param name="bildNr" select="$nextBildNr"/>
                                <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                            </xsl:call-template>
                        </fo:block>

                        <fo:block-container height="100mm" width="280mm"
                                            left="0mm"
                                            top="105mm"
                                            position="absolute">
                            <fo:block margin-bottom="2mm">
                                <xsl:call-template name="TaxableIncomeTableFormC">
                                    <xsl:with-param name="lines" select="$linesTableCIncome"/>
                                    <xsl:with-param name="currency" select="$currency"/>
                                    <xsl:with-param name="von" select="0"/>
                                    <xsl:with-param name="bis" select="13"/>
                                </xsl:call-template>
                            </fo:block>
                            <!--<fo:block margin-bottom="2mm">-->
                            <fo:block>
                                <xsl:call-template name="TaxableIncomeTableFormCSum">
                                    <xsl:with-param name="grandTotalIncomeAtRealization" select="$grandTotalIncomeAtRealization"/>
                                    <xsl:with-param name="totalPartIncomeCH" select="$totalPartIncomeCH"/>
                                    <xsl:with-param name="totalPartIncomeAbroad" select="$totalPartIncomeAbroad"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:block-container>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Split table on several pages -->
                        <xsl:for-each select="$linesTableCIncome">
                            <xsl:if test="(position() mod 12 = 0)or(position() = 1)">
                                <xsl:variable name="bildNr" select="$nextBildNr + floor(position() div 12)"/>
                                <xsl:call-template name="titleFormC"/>

                                <fo:block>
                                    <xsl:call-template name="MitarbeiterInfos">
                                        <xsl:with-param name="formularTyp" select="'C'"/>
                                        <xsl:with-param name="header" select="$header"/>
                                        <xsl:with-param name="person" select="$person"/>
                                        <xsl:with-param name="titel1">
                                            <xsl:call-template name="messageLookup">
                                                <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                                            </xsl:call-template>
                                        </xsl:with-param>
                                        <xsl:with-param name="datumTxtLabel">
                                            <xsl:call-template name="messageLookup">
                                                <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                                            </xsl:call-template>
                                        </xsl:with-param>
                                        <xsl:with-param name="bildNr" select="$bildNr"/>
                                        <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                                    </xsl:call-template>
                                </fo:block>

                                <fo:block-container height="100mm" width="280mm"
                                                    left="0mm"
                                                    top="105mm"
                                                    position="absolute">
                                    <xsl:variable name="bis">
                                        <xsl:choose>
                                            <xsl:when test="position() = 1">
                                                <xsl:value-of select="position()+11"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="position()+12"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <fo:block margin-bottom="2mm">
                                        <xsl:call-template name="TaxableIncomeTableFormC">
                                            <xsl:with-param name="lines" select="$linesTableCIncome"/>
                                            <xsl:with-param name="currency" select="$currency"/>
                                            <xsl:with-param name="von" select="position()"/>
                                            <xsl:with-param name="bis" select="$bis"/>
                                        </xsl:call-template>
                                    </fo:block>
                                    <xsl:choose>
                                        <xsl:when test="not((position() + 12) &lt; count($linesTableCIncome))">
                                            <fo:block>
                                                <xsl:call-template name="TaxableIncomeTableFormCSum">
                                                    <xsl:with-param name="grandTotalIncomeAtRealization" select="$grandTotalIncomeAtRealization"/>
                                                    <xsl:with-param name="totalPartIncomeCH" select="$totalPartIncomeCH"/>
                                                    <xsl:with-param name="totalPartIncomeAbroad" select="$totalPartIncomeAbroad"/>
                                                </xsl:call-template>
                                            </fo:block>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:call-template name="continueNextPage"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </fo:block-container>
                                <xsl:if test="(position() + 12) &lt; count($linesTableCIncome)">
                                    <fo:block page-break-after="always"/>
                                </xsl:if>
                            </xsl:if>

                        </xsl:for-each>

                    </xsl:otherwise>
                </xsl:choose>

                <xsl:variable name="tsugiBildNr" select="floor(count($linesTableCIncome) div 12) + $nextBildNr + 1"/>
<!--                <xsl:message>floor(count(linesTableCIncome) div 12): <xsl:value-of select="floor(count($linesTableCIncome) div 12)"/></xsl:message>-->
<!--                <xsl:message>tsugiBildNr: <xsl:value-of select="$tsugiBildNr"/></xsl:message>-->

                <xsl:if test="count($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']) &gt;= $tsugiBildNr">
                    <xsl:call-template name="PrintAdditionalBarcodes">
                        <xsl:with-param name="filenames" select="$barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']"/>
                        <xsl:with-param name="titel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'bescheinigungLA'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="formularName" select="'Form C'"/>
                        <xsl:with-param name="baseNr" select="$tsugiBildNr"/>
                        <xsl:with-param name="formularTyp" select="'C'"/>
                        <xsl:with-param name="header" select="$header"/>
                        <xsl:with-param name="datumTxtLabel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="titel1">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="barcodeID" select="$barcodeImageInfo/*[local-name()='BarcodeID']"/>
                        <xsl:with-param name="person" select="$person"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <!-- Only 1 page-->

                <xsl:call-template name="titleFormC"/>

                <!--<fo:block margin-bottom="2mm">-->
                <fo:block>
                    <xsl:call-template name="MitarbeiterInfos">
                        <xsl:with-param name="formularTyp" select="'C'"/>
                        <xsl:with-param name="header" select="$header"/>
                        <xsl:with-param name="person" select="$person"/>
                        <xsl:with-param name="titel1">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="datumTxtLabel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="bildNr" select="1"/>
                        <xsl:with-param name="bcfnFormularName" select="$bcfnFormularName"/>
                    </xsl:call-template>
                </fo:block>

                <fo:block-container height="100mm" width="280mm"
                                    left="0mm"
                                    top="105mm"
                                    position="absolute">

                    <fo:block margin-bottom="2mm">
                        <xsl:call-template name="MAbeteiligungenTableFormC">
                            <xsl:with-param name="lines" select="$linesTableCOwnershipRightPortfolio"/>
                            <xsl:with-param name="currency" select="$currency"/>
                            <xsl:with-param name="von" select="0"/>
                            <xsl:with-param name="bis" select="16"/>
                        </xsl:call-template>
                    </fo:block>
                    <!--<fo:block margin-bottom="2mm">-->
                    <fo:block>
                        <xsl:call-template name="MAbeteiligungenTableFormCSum">
                            <xsl:with-param name="totalNumberOfOwnershipsAtEndOfPeriod"
                                            select="$totalNumberOfOwnershipsAtEndOfPeriod"/>
                        </xsl:call-template>
                    </fo:block>

                    <fo:block margin-bottom="2mm">
                        <xsl:call-template name="TaxableIncomeTableFormC">
                            <xsl:with-param name="lines" select="$linesTableCIncome"/>
                            <xsl:with-param name="currency" select="$currency"/>
                            <xsl:with-param name="von" select="0"/>
                            <xsl:with-param name="bis" select="16"/>
                        </xsl:call-template>
                    </fo:block>
                    <!--<fo:block margin-bottom="2mm">-->
                    <fo:block>
                        <xsl:call-template name="TaxableIncomeTableFormCSum">
                            <xsl:with-param name="grandTotalIncomeAtRealization" select="$grandTotalIncomeAtRealization"/>
                            <xsl:with-param name="totalPartIncomeCH" select="$totalPartIncomeCH"/>
                            <xsl:with-param name="totalPartIncomeAbroad" select="$totalPartIncomeAbroad"/>
                        </xsl:call-template>
                    </fo:block>

                </fo:block-container>

                <xsl:if test="count($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename'])&gt;1">
                    <xsl:call-template name="PrintAdditionalBarcodes">
                        <xsl:with-param name="filenames" select="$barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename']"/>
                        <xsl:with-param name="titel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'bescheinigungLA'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="formularName" select="'Form C'"/>
                        <xsl:with-param name="baseNr" select="2"/>
                        <xsl:with-param name="formularTyp" select="'C'"/>
                        <xsl:with-param name="header" select="$header"/>
                        <xsl:with-param name="datumTxtLabel">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'CreateDateBescheiningung'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="titel1">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'BescheinigungMAbet'"/>
                            </xsl:call-template>
                        </xsl:with-param>
                        <xsl:with-param name="barcodeID" select="$barcodeImageInfo/*[local-name()='BarcodeID']"/>
                        <xsl:with-param name="person" select="$person"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <xsl:template name="PrintAdditionalBarcodes">
        <xsl:param name="filenames"/>
        <xsl:param name="titel"/>
        <xsl:param name="formularName"/>
        <xsl:param name="baseNr"/>
        <xsl:param name="titel1"/>
        <xsl:param name="datumTxtLabel"/>
        <xsl:param name="header"/>
        <xsl:param name="formularTyp"/>
        <xsl:param name="barcodeID"/>
        <xsl:param name="person"/>

        <xsl:for-each select="$filenames">
            <xsl:if test="position() &gt;= $baseNr">
                <xsl:variable name="bcdFilename" select="concat($tempDir,'/',.)"/>
<!--                <xsl:variable name="bcdFilename" select="concat('file:/',$tempDir,'/',.)"/>-->

                <fo:block break-after="page"/>
                <!-- Page break after last normal page and then after each additional page-->

                <xsl:call-template name="message-header-block">
                    <xsl:with-param name="titel" select="$titel"/>
                    <xsl:with-param name="zusatz">
                        <xsl:value-of select="'Barcode'"/>&#160;<xsl:value-of select="$formularName"/> -
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'sendAlso'"/>
                        </xsl:call-template>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="MAInfos1Spalte">
                    <xsl:with-param name="titel1" select="$titel1"/>
                    <xsl:with-param name="datumTxtLabel" select="$datumTxtLabel"/>
                    <xsl:with-param name="header" select="$header"/>
                    <xsl:with-param name="formularTyp" select="$formularTyp"/>
                </xsl:call-template>

                <xsl:call-template name="PrintBarcode">
                    <xsl:with-param name="BarcodeImageName" select="."/>
                    <xsl:with-param name="left" select="'200mm'"/>
                    <xsl:with-param name="top" select="'0mm'"/>
                    <xsl:with-param name="barcodeIDinfo" select="concat($barcodeID, ' / ', position() )"/>
                </xsl:call-template>

                <xsl:call-template name="Inhaberinformationen">
                    <xsl:with-param name="formularTyp" select="$formularTyp"/>
                    <xsl:with-param name="header" select="$header"/>
                </xsl:call-template>

            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="MAInfos1Spalte">
        <xsl:param name="formularTyp"/>
        <xsl:param name="header"/>
        <xsl:param name="datumTxtLabel"/>
        <xsl:param name="titel1"/>

        <!-- 1. Spalte links: Informationen zu Mitarbeiterbeteiligung, Firma, usw. -->
        <fo:block-container height="100mm" width="140mm" left="0mm" top="16mm" position="absolute">

            <!--Bescheinigung über Mitarbeiterbeteiligungen-->
            <xsl:variable name="BueMbMap">
                <map>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'artMAbeteiligungForm'"/>
                            </xsl:call-template>
                            <xsl:value-of select="$formularTyp"/>)
                        </name>
                        <value>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="concat($header/*[local-name()='TypeOfOwnership'],$formularTyp)"/>
                            </xsl:call-template>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:value-of select="$datumTxtLabel"/>
                        </name>
                        <value>
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="value"
                                                select="$header/*[local-name()='DateOfAttestation']"/>
                            </xsl:call-template>
                        </value>
                    </mapEntry>
                </map>
            </xsl:variable>

            <xsl:call-template name="info-section">
                <xsl:with-param name="titel" select="$titel1"/>
                <xsl:with-param name="dataMap" select="$BueMbMap"/>
                <xsl:with-param name="titleColumnWidth" select="$title-column-width"/>
                <xsl:with-param name="descriptionColumnWidth" select="$description-column-width"/>
            </xsl:call-template>

            <!--Ausgefüllt durch-->
            <xsl:variable name="FilledByMap">
                <map>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'CompanyName'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='CompanyName']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'ContactPerson'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of select="$header/*[local-name()='ContactName']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'Phone'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of select="$header/*[local-name()='ContactPhone']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'EMail'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of select="$header/*[local-name()='ContactEmail']"/>
                        </value>
                    </mapEntry>
                </map>
            </xsl:variable>

            <xsl:call-template name="info-section">
                <xsl:with-param name="titel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'FilledBy'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="dataMap" select="$FilledByMap"/>
                <xsl:with-param name="titleColumnWidth" select="$title-column-width"/>
                <xsl:with-param name="descriptionColumnWidth" select="$description-column-width"/>
            </xsl:call-template>

            <!--Ausgeber der Beteiligungsrechte-->
            <xsl:variable name="IssuerOwnershipRightsMap">
                <map>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'NameGroupEnterprise'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='ConcernName']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'NameAktieValNr'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of select="$header/*[local-name()='ShareName']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'CompanyEmployer'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of select="$header/*[local-name()='EmployerName']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'Currency'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of select="$header/*[local-name()='Currency']"/>
                        </value>
                    </mapEntry>

                </map>
            </xsl:variable>

            <xsl:call-template name="info-section">
                <xsl:with-param name="titel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'IssuerOwnershipRights'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="dataMap" select="$IssuerOwnershipRightsMap"/>
                <xsl:with-param name="titleColumnWidth" select="$title-column-width"/>
                <xsl:with-param name="descriptionColumnWidth" select="$description-column-width"/>
            </xsl:call-template>

            <!--Ruling-->
            <xsl:variable name="RulingMap">
                <map>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'RulingAllowed'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="value"
                                                select="$header/*[local-name()='Ruling']/*[local-name()='Allowed']"/>
                            </xsl:call-template>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'RulingCanton'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='Ruling']/*[local-name()='Canton']"/>
                        </value>
                    </mapEntry>
                </map>
            </xsl:variable>

            <xsl:call-template name="info-section">
                <xsl:with-param name="titel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'Ruling'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="dataMap" select="$RulingMap"/>
                <xsl:with-param name="titleColumnWidth" select="$title-column-width"/>
                <xsl:with-param name="descriptionColumnWidth" select="$description-column-width"/>
            </xsl:call-template>

            <xsl:if test="$formularTyp = 'C'">
                <!--Bemerkungen-->
                <xsl:call-template name="bemerkung-section">
                    <xsl:with-param name="titel">
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'Bemerkungen'"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="bemerkung" select="$header/*[local-name()='Comment']"/>
                </xsl:call-template>
            </xsl:if>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="MitarbeiterInfos">
        <xsl:param name="formularTyp"/>
        <xsl:param name="header"/>
        <xsl:param name="person"/>
        <xsl:param name="titel1"/>
        <xsl:param name="datumTxtLabel"/>
        <xsl:param name="bildNr"/>
        <xsl:param name="bcfnFormularName"/>


        <xsl:variable name="barcodeImageInfo" select="$barcodeImageInfos/*[local-name()='BarcodeImageInfo'][@name=$bcfnFormularName]"/>

        <xsl:call-template name="MAInfos1Spalte">
            <xsl:with-param name="formularTyp" select="$formularTyp"/>
            <xsl:with-param name="header" select="$header"/>
            <xsl:with-param name="datumTxtLabel" select="$datumTxtLabel"/>
            <xsl:with-param name="titel1" select="$titel1"/>
        </xsl:call-template>

        <!-- Barcode -->
        <xsl:variable name="bcdTestStr" select="concat('b0',$bildNr)"/>
        <xsl:for-each select="exslt:node-set($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename'])">
            <xsl:if test="contains(.,$bcdTestStr)">
                <xsl:call-template name="PrintBarcode">
                    <xsl:with-param name="BarcodeImageName" select="."/>
                    <xsl:with-param name="left" select="'200mm'"/>
                    <xsl:with-param name="top" select="'0mm'"/>
                    <xsl:with-param name="barcodeIDinfo" select="concat($barcodeImageInfo/*[local-name()='BarcodeID'], ' / ', $bildNr )"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:for-each>
        <!-- If there are more pages for the specific formular (due to enormous tables) than barcodes, $bildNr is greater than
        the count of the barcode filenames. In fact in some kind $bildNr is also the counter of the pages of the formular. -->
        <xsl:if test="$bildNr &gt; count($barcodeImageInfo/*[local-name()='BarcodeFileNames']/*[local-name()='Filename'])">
            <xsl:call-template name="PrintBarcode">
                <xsl:with-param name="BarcodeImageName" select="$barcodeImageInfo/*[local-name()='EmptyBarcode']"/>
                <xsl:with-param name="left" select="'200mm'"/>
                <xsl:with-param name="top" select="'0mm'"/>
                <xsl:with-param name="barcodeIDinfo" select="concat($barcodeImageInfo/*[local-name()='BarcodeID'], ' / Empty')"/>
            </xsl:call-template>
        </xsl:if>

        <xsl:call-template name="Inhaberinformationen">
            <xsl:with-param name="formularTyp" select="$formularTyp"/>
            <xsl:with-param name="header" select="$header"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="Inhaberinformationen">
        <xsl:param name="formularTyp"/>
        <xsl:param name="header"/>

        <!-- 2. Spalte: Inhaberinformationen -->
        <fo:block-container height="60mm" width="100mm" left="140mm" top="40mm" position="absolute">

            <!--Inhaber der Beteiligungen-->
            <xsl:variable name="OwnerMap">
                <map>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'AHVVN'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='Particulars']/*[local-name()='Social-InsuranceIdentification']/*[local-name()='SV-AS-Number']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'DateOfBirth'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="value"
                                        select="$header/*[local-name()='Particulars']/*[local-name()='DateOfBirth']"/>
                            </xsl:call-template>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'LastNameFirstName'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='Particulars']/*[local-name()='Lastname']"/>
                            <xsl:text> </xsl:text> <!-- Leerschlag -->
                            <xsl:value-of
                                    select="$header/*[local-name()='Particulars']/*[local-name()='Firstname']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'Street'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Street']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'ZipCodeCity'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='ZIP-Code']"/>
                            <xsl:text> </xsl:text> <!-- Leerschlag -->
                            <xsl:value-of
                                    select="$header/*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='City']"/>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'Country'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:value-of
                                    select="$header/*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Country']"/>
                        </value>
                    </mapEntry>
                </map>
            </xsl:variable>

            <xsl:call-template name="info-section">
                <xsl:with-param name="titel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'Owner'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="dataMap" select="$OwnerMap"/>
                <xsl:with-param name="titleColumnWidth" select="$titleColumnWidthMiddle"/>
                <xsl:with-param name="descriptionColumnWidth" select="$descriptionColumnWidthMiddle"/>
            </xsl:call-template>

            <xsl:if test="$formularTyp != 'C'">
                <!--Bemerkungen-->
                <xsl:call-template name="bemerkung-section">
                    <xsl:with-param name="titel">
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'Bemerkungen'"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="bemerkung"
                                    select="$header/*[local-name()='Comment']"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="$formularTyp = 'C'">
                <!--Aktivitäten und Residenzen-->
                <xsl:variable name="ActivitiesResidencesMap">
                    <map>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'DatumZuzugCH'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value" select="$header/*[local-name()='MoveToCH']"/>
                                </xsl:call-template>
                            </value>
                        </mapEntry>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'EntryConcern'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value"
                                                    select="$header/*[local-name()='EntryConcern']"/>
                                </xsl:call-template>
                            </value>
                        </mapEntry>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'EntryEmployerCH'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value"
                                                    select="$header/*[local-name()='EntryEmployerCH']"/>
                                </xsl:call-template>
                            </value>
                        </mapEntry>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'WithdrawalEmployerCH'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value"
                                                    select="$header/*[local-name()='WithdrawalEmployerCH']"/>
                                </xsl:call-template>
                            </value>
                        </mapEntry>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'WithdrawalConcern'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value"
                                                    select="$header/*[local-name()='WithdrawalConcern']"/>
                                </xsl:call-template>
                            </value>
                        </mapEntry>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'MoveFromCH'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value" select="$header/*[local-name()='MoveFromCH']"/>
                                </xsl:call-template>
                            </value>
                        </mapEntry>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'CountryOfDestinationResidenceOrWorkplace'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:value-of
                                        select="$header/*[local-name()='CountryOfDestinationResidenceOrWorkplace']"/>
                            </value>
                        </mapEntry>
                    </map>
                </xsl:variable>

                <xsl:call-template name="info-section">
                    <xsl:with-param name="titel">
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'ActivitiesResidences'"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="dataMap" select="$ActivitiesResidencesMap"/>
                    <xsl:with-param name="titleColumnWidth" select="$titleColumnWidthMiddle"/>
                    <xsl:with-param name="descriptionColumnWidth" select="$descriptionColumnWidthC"/>
                </xsl:call-template>

                <!--Land im Zeitpunkt der Einkommensrealisation	-->
                <xsl:variable name="CountryTimeIncomeMap">
                    <map>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'ResidenceAtRealisation'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:if test="$header/*[local-name()='ResidenceAtRealisation']='CH'">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'LocationCH'"/>
                                    </xsl:call-template>
                                </xsl:if>
                                <xsl:if test="$header/*[local-name()='ResidenceAtRealisation']='abroad'">
                                    <xsl:call-template name="messageLookup">
                                        <xsl:with-param name="key" select="'LocationAbroad'"/>
                                    </xsl:call-template>
                                </xsl:if>
                            </value>
                        </mapEntry>
                        <mapEntry>
                            <name>
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'WorkplaceAtRealisation'"/>
                                </xsl:call-template>
                            </name>
                            <value>
                                <xsl:choose>
                                    <xsl:when test="$header/*[local-name()='WorkplaceAtRealisation']='CH'">
                                        <xsl:call-template name="messageLookup">
                                            <xsl:with-param name="key" select="'LocationCH'"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="$header/*[local-name()='WorkplaceAtRealisation']='abroad'">
                                        <xsl:call-template name="messageLookup">
                                            <xsl:with-param name="key" select="'LocationCH'"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="$header/*[local-name()='WorkplaceAtRealisation']='noWorksForCompany'">
                                        <xsl:call-template name="messageLookup">
                                            <xsl:with-param name="key" select="'LocationNoWorksForCompany'"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="''"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </value>
                        </mapEntry>
                    </map>
                </xsl:variable>

                <xsl:variable name="descrColWidth">
                    <xsl:choose>
                        <xsl:when test="$header/*[local-name()='WorkplaceAtRealisation']='noWorksForCompany'">30mm</xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$descriptionColumnWidthC"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:variable name="valueColWidth">
                    <xsl:choose>
                        <xsl:when test="$header/*[local-name()='WorkplaceAtRealisation']='noWorksForCompany'">60mm</xsl:when>
                        <xsl:otherwise>30mm</xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>

                <xsl:call-template name="info-section">
                    <xsl:with-param name="titel">
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'CountryTimeIncome'"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="dataMap" select="$CountryTimeIncomeMap"/>
                    <xsl:with-param name="titleColumnWidth" select="$titleColumnWidthMiddle"/>
                    <xsl:with-param name="descriptionColumnWidth" select="$descrColWidth"/>
                    <xsl:with-param name="valueColumnWidth" select="$valueColWidth"/>
                </xsl:call-template>

            </xsl:if>
        </fo:block-container>

        <fo:block-container height="20mm" width="40mm" left="235mm" top="40mm" position="absolute">

            <!--Steuerperiode-->
            <xsl:variable name="TaxPeriodeMap">
                <map>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'TaxPeriodeFrom'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="value"
                                                select="$header/*[local-name()='Period']/*[local-name()='from']"/>
                            </xsl:call-template>
                        </value>
                    </mapEntry>
                    <mapEntry>
                        <name>
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'TaxPeriodeUntil'"/>
                            </xsl:call-template>
                        </name>
                        <value>
                            <xsl:call-template name="format-date">
                                <xsl:with-param name="value"
                                                select="$header/*[local-name()='Period']/*[local-name()='until']"/>
                            </xsl:call-template>
                        </value>
                    </mapEntry>
                </map>
            </xsl:variable>

            <xsl:call-template name="info-section">
                <xsl:with-param name="titel">
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'TaxPeriode'"/>
                    </xsl:call-template>
                </xsl:with-param>
                <xsl:with-param name="dataMap" select="$TaxPeriodeMap"/>
                <xsl:with-param name="titleColumnWidth" select="$titleColumnWidthRight"/>
                <xsl:with-param name="descriptionColumnWidth" select="$descriptionColumnWidthRight"/>
            </xsl:call-template>
        </fo:block-container>

    </xsl:template>

    <xsl:template name="PrintBarcode">
        <xsl:param name="BarcodeImageName"/>
        <xsl:param name="left"/>
        <xsl:param name="top"/>
        <xsl:param name="barcodeIDinfo"/>

        <xsl:variable name="bcdFilename">
            <xsl:value-of select="concat($tempDir,'/',$BarcodeImageName)"/>
        </xsl:variable>

        <fo:block-container height="65mm" width="75mm" left="{$left}" top="{$top}" position="absolute">
            <fo:block>
                <fo:external-graphic src="{$bcdFilename}" width="70mm" height="60mm"
                                     content-width="scale-to-fit" content-height="scale-to-fit"/>
            </fo:block>
        </fo:block-container>
        <fo:block-container reference-orientation="270" top="5mm" left="192mm" position="absolute">
            <fo:block font-size="10pt">
                <xsl:value-of select="$barcodeIDinfo"/>
            </fo:block>
        </fo:block-container>
    </xsl:template>

    <xsl:template name="bemerkung-section">
        <xsl:param name="titel"/>
        <xsl:param name="bemerkung"/>

        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}"
                  border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block>
                            <xsl:value-of select="$titel"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:block>
                            <xsl:if test="count($bemerkung) > 0">
                                <xsl:call-template name="Comment">
                                    <xsl:with-param name="comment" select="$bemerkung"/>
                                </xsl:call-template>
                            </xsl:if>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="info-section">
        <xsl:param name="titel"/>
        <xsl:param name="dataMap"/>
        <xsl:param name="titleColumnWidth"/>
        <xsl:param name="descriptionColumnWidth"/>
        <xsl:param name="valueColumnWidth" select="'proportional-column-width(1)'"/>

        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}"
                  border-collapse="separate">
            <fo:table-column column-width="{$titleColumnWidth}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block>
                            <xsl:value-of select="$titel"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <xsl:call-template name="showMap-section">
                            <xsl:with-param name="dataMap" select="$dataMap"/>
                            <xsl:with-param name="descriptionColumnWidth" select="$descriptionColumnWidth"/>
                            <xsl:with-param name="valueColumnWidth" select="$valueColumnWidth"/>
                        </xsl:call-template>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="showMap-section">
        <xsl:param name="dataMap"/>
        <xsl:param name="descriptionColumnWidth"/>
        <xsl:param name="valueColumnWidth"/>

        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
            <fo:table-column column-width="{$descriptionColumnWidth}" column-number="1"/>
            <fo:table-column column-width="{$valueColumnWidth}" column-number="2"/>
            <fo:table-body>
                <xsl:for-each select="exslt:node-set($dataMap)//mapEntry">
                    <fo:table-row>
                        <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                            <fo:block>
                                <xsl:value-of select="name"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                            <fo:block>
                                <xsl:value-of select="value"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </xsl:for-each>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="Comment">
        <xsl:param name="comment"/>

        <fo:table>
            <fo:table-column column-width="20mm"/>
            <fo:table-column column-width="10mm"/>
            <fo:table-column column-width="70mm"/>
            <fo:table-column column-width="10mm"/>
            <fo:table-body>
                <xsl:for-each select="$comment/*[local-name()='Notification']">
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block>
                                <xsl:value-of select="./*[local-name()='QualityLevel']"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block>
                                <xsl:value-of select="./*[local-name()='DescriptionCode']"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block>
                                <xsl:value-of select="./*[local-name()='Description']"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                    </fo:table-row>
                </xsl:for-each>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="TaxIncomeTableFormA_ColHeader">
        <xsl:param name="currency"/>

        <fo:table-column column-width="26mm"/>  <!--Mitarbeiterbeteiligungsplan-->
        <fo:table-column column-width="24mm"/>  <!--ADatumErwerbMAbeteiligung-->
        <fo:table-column column-width="23mm"/>  <!--DatumAblaufSperrfrist-->
        <fo:table-column column-width="19mm"/>  <!--EinschlagDauerSperrfrist-->
        <fo:table-column column-width="20mm"/>  <!--AnzMAbeteiligungen-->
        <fo:table-column column-width="28mm"/>  <!--VerkehrswertMAbetZeitpktErwerb oder FormelwertNotKotAktieZeitpktErwerb -->
        <fo:table-column column-width="19mm"/>  <!--AngewendeteBewertungsformel-->
        <fo:table-column column-width="23mm"/>  <!--DauerMoeglRueckgabeverpflichtung-->
        <fo:table-column column-width="20mm"/>  <!--ErwerbspreisMAbeteiligung-->
        <fo:table-column column-width="21mm"/>  <!--GeldwertVorteilMAbeteiligung-->
        <fo:table-column column-width="17mm"/>  <!--TotalGeldwerterVorteil-->
        <fo:table-column column-width="12mm"/>  <!--Wechselkurs-->
        <fo:table-column column-width="26mm"/>  <!--IncomeInLA-->
        <fo:table-header>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'MitarbeiterbeteiligungsplanA'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'ADatumErwerbMAbeteiligung'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'DatumAblaufSperrfrist'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'EinschlagDauerSperrfrist'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'AnzMAbeteiligungen'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'VerkehrswertMAbetZeitpktErwerb'"/>
                    </xsl:call-template>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="$currency"/>
                    <xsl:text>)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'AngewendeteBewertungsformel'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'DauerMoeglRueckgabeverpflichtung'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'ErwerbspreisMAbeteiligung'"/>
                    </xsl:call-template>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="$currency"/>
                    <xsl:text>)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'GeldwertVorteilMAbeteiligung'"/>
                    </xsl:call-template>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="$currency"/>
                    <xsl:text>)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'TotalGeldwerterVorteil'"/>
                    </xsl:call-template>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="$currency"/>
                    <xsl:text>)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'Wechselkurs'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'IncomeInLA'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-header>
    </xsl:template>

    <xsl:template name="TaxIncomeTableFormA_Row">
        <xsl:param name="line"/>
        <fo:table-row>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" text-align="left" display-align="center">
                <xsl:call-template name="shrinkString">
                    <xsl:with-param name="maxLength" select="17"/>
                    <xsl:with-param name="text" select="$line/*[local-name()='SharePlanDescription']"/>
                </xsl:call-template>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="value"
                                        select="$line/*[local-name()='AcquisitionDate']"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="value"
                                        select="$line/*[local-name()='ExpiryDateBlockingPeriod']"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of select="$line/*[local-name()='ReductionIncomePercentage']"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of select="$line/*[local-name()='NumberOfOwnershipAcquired']"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:choose>
                        <xsl:when test="count($line/*[local-name()='MarketValueAtAcquisitionDate'])=1">
                            <xsl:value-of
                                    select="format-number($line/*[local-name()='MarketValueAtAcquisitionDate'], $cents-format)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="format-number($line/*[local-name()='MarketValueFormula'], $cents-format)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" text-align="left" display-align="center">
                <xsl:call-template name="shrinkString">
                    <xsl:with-param name="maxLength" select="9"/>
                    <xsl:with-param name="text" select="$line/*[local-name()='Formula']"/>
                </xsl:call-template>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of select="$line/*[local-name()='DurationObligationToReturn']"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number(/*[local-name()='AcquisitionPricePerParticipation'], $cents-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='MonetaryValuesServicesPerShare'], $cents-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='MonetaryValuesServicesTotal'], $cents-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of select="$line/*[local-name()='CurrencyRate']"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"  display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='IncomeDeclaredInSalaryCertificate'], $integer-format)"/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template name="TaxIncomeTableFormA">
        <xsl:param name="lines"/>
        <xsl:param name="currency"/>
        <xsl:param name="von"/>
        <xsl:param name="bis"/>

        <fo:block font-weight="bold" font-size="11pt">
            <xsl:call-template name="messageLookup">
                <xsl:with-param name="key" select="'TaxableIncome'"/>
            </xsl:call-template>
        </fo:block>

<!--        <xsl:message>TaxIncome: von: <xsl:value-of select="$von"/> bis: <xsl:value-of select="$bis"/></xsl:message>-->

        <fo:table>
            <xsl:call-template name="TaxIncomeTableFormA_ColHeader">
                <xsl:with-param name="currency" select="$currency"/>
            </xsl:call-template>
            <fo:table-body>
                <xsl:for-each select="$lines">
                    <xsl:if test="(position() &gt;= $von)and(position() &lt; $bis)">
                        <xsl:call-template name="TaxIncomeTableFormA_Row">
                            <xsl:with-param name="line" select="."/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:for-each>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="TaxIncomeTableFormASum">
        <xsl:param name="totalIncomeDeclaredInSalaryCertificate"/>
        <fo:table  page-break-inside="auto">
            <fo:table-column column-width="118mm"/>
            <fo:table-column column-width="132mm"/>
            <fo:table-column column-width="2mm"/>
            <fo:table-column column-width="26mm"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block text-align="right" font-weight="bold" font-size="8pt" padding-right="2mm">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'FormAsumTxtS1'"/>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center" border-width="1.5pt">
                        <fo:block>
                            <xsl:value-of select="format-number($totalIncomeDeclaredInSalaryCertificate, $integer-format)"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>

    </xsl:template>

    <xsl:template name="TaxAssetTableFormA_ColHeader">
        <xsl:param name="currency"/>

        <fo:table-column column-width="27mm"/>      <!--Mitarbeiterbeteiligungsplan-->
        <fo:table-column column-width="21mm"/>      <!--ADatumErwerbMAbeteiligung-->
        <fo:table-column column-width="21mm"/>      <!--DatumAblaufSperrfrist-->
        <fo:table-column column-width="21mm"/>      <!--DauerVerbleibSperrfrist-->
        <fo:table-column column-width="21mm"/>      <!--ReductionAssetPercentage-->
        <fo:table-column column-width="23mm"/>      <!--AnzMAbeteiligungen-->
        <fo:table-column column-width="23mm"/>      <!--DauerMoeglRueckgabeverpflichtung-->
        <fo:table-column column-width="20mm"/>      <!--AnzMAbetEndePeriode-->
        <fo:table-column column-width="23mm"/>      <!--MarketValueAtEndOfPeriod_Formula-->
        <fo:table-column column-width="20mm"/>      <!--RedVerkehrWertMAbet-->
        <fo:table-column column-width="20mm"/>      <!--TotalRedVerkehrswert-->
        <fo:table-column column-width="13mm"/>      <!--Wechselkurs-->
        <fo:table-column column-width="24mm"/>      <!--TaxableWealthCH-->
        <fo:table-header>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'MitarbeiterbeteiligungsplanA'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'ADatumErwerbMAbeteiligung'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'DatumAblaufSperrfrist'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'DauerVerbleibSperrfrist'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'ReductionAssetPercentage'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'AnzMAbeteiligungen'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'DauerMoeglRueckgabeverpflichtung'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'AnzMAbetEndePeriode'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'MarketValueAtEndOfPeriod_Formula'"/>
                    </xsl:call-template>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="$currency"/>
                    <xsl:text>)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'RedVerkehrWertMAbet'"/>
                    </xsl:call-template>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="$currency"/>
                    <xsl:text>)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'TotalRedVerkehrswert'"/>
                    </xsl:call-template>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="$currency"/>
                    <xsl:text>)</xsl:text>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'Wechselkurs'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                <fo:block>
                    <xsl:call-template name="messageLookup">
                        <xsl:with-param name="key" select="'TaxableWealthCH'"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-header>

    </xsl:template>

    <xsl:template name="TaxAssetTableFormA_Row">
        <xsl:param name="line"/>

        <fo:table-row>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"  text-align="left" display-align="center">
                <xsl:call-template name="shrinkString">
                    <xsl:with-param name="maxLength" select="15"/>
                    <xsl:with-param name="text" select="$line/*[local-name()='SharePlanDescription']"/>
                </xsl:call-template>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="value"
                                        select="$line/*[local-name()='AcquisitionDate']"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:call-template name="format-date">
                        <xsl:with-param name="value"
                                        select="$line/*[local-name()='ExpiryDateBlockingPeriod']"/>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='DurationOfRemainingBlockingPeriod'], $percent-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='ReductionAssetPercentage'], $percent-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='NumberOfOwnershipsAcquired'], $integer-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='DurationObligationToReturn'], $integer-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='NumberOfOwnershipsAtEndOfPeriod'], $integer-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:if test="count(./*[local-name()='MarketValueAtEndOfPeriod'])&gt;0">
                        <xsl:value-of
                                select="format-number($line/*[local-name()='MarketValueAtEndOfPeriod'], $cents-format)"/>
                    </xsl:if>
                    <xsl:if test="count(./*[local-name()='MarketValueFormula'])&gt;0">
                        <xsl:value-of select="format-number($line/*[local-name()='MarketValueFormula'], $cents-format)"/>
                    </xsl:if>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='DiscountedMarketValue'], $cents-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='TotalValueExpected'], $cents-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of
                            select="format-number($line/*[local-name()='CurrencyRate'], $percent-format)"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                <fo:block>
                    <xsl:value-of select="format-number($line/*[local-name()='TaxableWealthInCH'], $integer-format)"/>
                </fo:block>
            </fo:table-cell>

        </fo:table-row>
    </xsl:template>

    <xsl:template name="TaxAssetTableFormA">
        <xsl:param name="lines"/>
        <xsl:param name="currency"/>
        <xsl:param name="von"/>
        <xsl:param name="bis"/>

        <fo:block font-weight="bold" font-size="11pt">
            <xsl:call-template name="messageLookup">
                <xsl:with-param name="key" select="'TaxableAsset'"/>
            </xsl:call-template>
        </fo:block>

<!--        <xsl:message>TaxAssetTableFormA: von: <xsl:value-of select="$von"/> bis: <xsl:value-of select="$bis"/></xsl:message>-->

        <fo:table>
            <xsl:call-template name="TaxAssetTableFormA_ColHeader">
                <xsl:with-param name="currency" select="$currency"/>
            </xsl:call-template>
            <fo:table-body>
                <xsl:choose>
                    <xsl:when test="count($lines)=0">
                        <fo:table-row>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                        </fo:table-row>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="$lines">
                            <xsl:if test="(position() &gt;= $von)and(position() &lt; $bis)">
                                <xsl:call-template name="TaxAssetTableFormA_Row">
                                    <xsl:with-param name="line" select="."/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="TotalTaxableWealthInCH">
        <xsl:param name="TotalTaxableWealthInCH"/>
        <fo:table>
            <fo:table-column column-width="49mm"/>
            <fo:table-column column-width="202mm"/>
            <fo:table-column column-width="2mm"/>
            <fo:table-column column-width="24mm"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block text-align="right" font-weight="bold" font-size="8pt" padding-right="2mm">
                            <xsl:call-template name="messageLookup">
                                <xsl:with-param name="key" select="'TotalTaxableWealthInCH'"/>
                            </xsl:call-template>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block/>
                    </fo:table-cell>
                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"  display-align="center" border-width="1.5pt">
                        <fo:block>
                            <xsl:value-of select="format-number($TotalTaxableWealthInCH, $integer-format)"/>
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="continueNextPage">
        <fo:block text-align="right" font-weight="bold" font-size="8pt" padding-right="2mm">
            <xsl:call-template name="messageLookup">
                <xsl:with-param name="key" select="'continueNextPage'"/>
            </xsl:call-template>
        </fo:block>
    </xsl:template>

    <xsl:template name="TaxIncomeTableFormB">
        <xsl:param name="lines"/>
        <xsl:param name="currency"/>
        <xsl:param name="von"/>
        <xsl:param name="bis"/>

        <fo:block font-weight="bold" font-size="11pt">
            <xsl:call-template name="messageLookup">
                <xsl:with-param name="key" select="'TaxableIncomeOrDeduction'"/>
            </xsl:call-template>
        </fo:block>

        <fo:table page-break-inside="auto">
            <fo:table-column column-width="20mm"/>   <!-- Bezeichnung des Mitarbeiterbeteiligungsplan -->
            <fo:table-column column-width="20mm"/>   <!-- ExpiryDateBeforeReleaseBlockingPeriod -->
            <fo:table-column column-width="22mm"/>   <!-- NumberOfOwnershipsUnlockedOrReturned -->
            <fo:table-column column-width="23mm"/>   <!-- MarketValue:_Verkehr_Formel -->
            <fo:table-column column-width="17mm"/>   <!-- Formula -->
            <fo:table-column column-width="16mm"/>   <!-- RestitutionPrice -->
            <fo:table-column column-width="18mm"/>   <!-- AcquisitionDateOfShare: Datum des Erwerbs der Aktie-->
            <fo:table-column column-width="16mm"/>   <!-- OriginalExpiryDateBlockingPeriod: Datum des ordentlichen Ablaufs der Sperrfrist -->
            <fo:table-column column-width="15mm"/>   <!-- DurationOfRemainingBlockingPeriod: Dauer der verbleibenden Sperrfrist (in Jahren)-->
            <fo:table-column column-width="20mm"/>   <!-- ReductionAssetPercentage -->
            <fo:table-column column-width="20mm"/>   <!-- ReducedMarketValue: Reduzierter Verkehrswert gemäss verbleibender Sperrfrist -->
            <fo:table-column column-width="20mm"/>   <!-- MonetaryValuesAdvantagesPerShare -->
            <fo:table-column column-width="18mm"/>   <!-- MonetaryValuesAdvantagesTotal -->
            <fo:table-column column-width="11mm"/>   <!-- CurrencyRate -->
            <fo:table-column column-width="18mm"/>   <!-- TaxableIncomeOrFiscaleDeduction -->
            <fo:table-header>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'Mitarbeiterbeteiligungsplan'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'ExpiryDateBeforeReleaseBlockingPeriod'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'NumberOfOwnershipsUnlockedOrReturned'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'MarketValue_Verkehr_Formel'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'Formula'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'RestitutionPrice'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'AcquisitionDateOfShare'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'OriginalExpiryDateBlockingPeriod'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'DurationOfRemainingBlockingPeriod'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'ReductionAssetPercentage'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'ReducedMarketValue'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'MonetaryValuesAdvantagesPerShare'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'MonetaryValuesAdvantagesTotal'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'Wechselkurs'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'calcFormB'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
            </fo:table-header>
            <fo:table-body>
                <xsl:for-each select="$lines">
                    <xsl:if test="(position() &gt;= $von)and(position() &lt; $bis)">
                        <fo:table-row>
                            <!-- (1) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" text-align="left" display-align="center">
                                <xsl:call-template name="shrinkString">
                                    <xsl:with-param name="maxLength" select="10"/>
                                    <xsl:with-param name="text" select="./*[local-name()='SharePlanDescription']"/>
                                </xsl:call-template>
                            </fo:table-cell>
                            <!-- (2) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:call-template name="format-date">
                                        <xsl:with-param name="value"
                                                        select="./*[local-name()='ExpiryDateBeforeReleaseBlockingPeriod']"/>
                                    </xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (3) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='NumberOfOwnershipsUnlockedOrReturned'], $integer-format)"/>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (4) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:if test="count(./*[local-name()='MarketValueAtTimeOfUnlockingOrRestitution'])&gt;0">
                                        <xsl:value-of
                                                select="format-number(./*[local-name()='MarketValueAtTimeOfUnlockingOrRestitution'], $cents-format)"/>
                                    </xsl:if>
                                    <xsl:if test="count(./*[local-name()='MarketValueFormula'])&gt;0">
                                        <xsl:value-of
                                                select="format-number(./*[local-name()='MarketValueFormula'], $cents-format)"/>
                                    </xsl:if>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (5) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" text-align="left" display-align="center">
                                <xsl:call-template name="shrinkString">
                                    <xsl:with-param name="maxLength" select="9"/>
                                    <xsl:with-param name="text" select="./*[local-name()='Formula']"/>
                                </xsl:call-template>
                            </fo:table-cell>
                            <!-- (6) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='RestitutionPrice'], $cents-format)"/>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (7) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:call-template name="format-date">
                                        <xsl:with-param name="value"
                                                        select="./*[local-name()='AcquisitionDateOfShare']"/>
                                    </xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (8) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:call-template name="format-date">
                                        <xsl:with-param name="value"
                                                        select="./*[local-name()='OriginalExpiryDateBlockingPeriod']"/>
                                    </xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (9) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='DurationOfRemainingBlockingPeriod'], $percent-format)"/>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (10) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='ReductionAssetPercentage'], $percent-format)"/>%
                                </fo:block>
                            </fo:table-cell>
                            <!-- (11) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='ReducedMarketValue'], $cents-format)"/>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (12) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='MonetaryValuesAdvantagesPerShare'], $cents-format)"/>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (13) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='MonetaryValuesAdvantagesTotal'], $cents-format)"/>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (14) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of
                                            select="format-number(./*[local-name()='CurrencyRate'], $percent-format)"/>
                                </fo:block>
                            </fo:table-cell>
                            <!-- (15) -->
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                <fo:block>
                                    <xsl:value-of select="format-number(./*[local-name()='TaxableIncomeOrFiscaleDeduction'], $integer-format)"/>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </xsl:if>
                </xsl:for-each>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="TaxIncomeTableFormBSum">
        <xsl:param name="totalFiscaleDeduction"/>
        <xsl:param name="totalTaxableIncome"/>

        <fo:block margin-bottom="3mm">
            <fo:table>
                <fo:table-column column-width="122mm"/>
                <fo:table-column column-width="132mm"/>
                <fo:table-column column-width="2mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="right" font-weight="bold" font-size="8pt" padding-right="2mm">
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'FormBsumTxt1'"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"  display-align="center" border-width="1.5pt">
                            <fo:block>
                                    <xsl:value-of select="format-number($totalFiscaleDeduction, $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:block>
        <fo:block margin-bottom="3mm">
            <fo:table>
                <fo:table-column column-width="122mm"/>
                <fo:table-column column-width="132mm"/>
                <fo:table-column column-width="2mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="right" font-weight="bold" font-size="8pt" padding-right="2mm">
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'FormBsumTxt2'"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center" border-width="1.5pt">
                            <fo:block>
                                    <xsl:value-of select="format-number($totalTaxableIncome, $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:block>
    </xsl:template>

    <xsl:template name="MAbeteiligungenTableFormC">
        <xsl:param name="lines"/>
        <xsl:param name="currency"/>
        <xsl:param name="von"/>
        <xsl:param name="bis"/>

        <fo:block font-weight="bold" font-size="11pt">
            <xsl:call-template name="messageLookup">
                <xsl:with-param name="key" select="'Mitarbeiterbeteiligungen'"/>
            </xsl:call-template>
        </fo:block>

        <fo:table page-break-inside="auto">
            <fo:table-column column-width="19mm"/>      <!-- Mitarbeiterbeteiligungsplan -->
            <fo:table-column column-width="18mm"/>      <!-- GrantDate -->
            <fo:table-column column-width="20mm"/>      <!-- WorkplaceAtTimeOfGrantedParticipations -->
            <fo:table-column column-width="17mm"/>      <!-- NumberOfOwnershipsGranted -->
            <fo:table-column column-width="17mm"/>      <!-- VestingDateSpecifiedInPlan -->
            <fo:table-column column-width="16mm"/>      <!-- ExpiryDateOfPossibleBlockingPeriodOfSharesHeld -->
            <fo:table-column column-width="13mm"/>      <!-- PotentialExercisePrice -->
            <fo:table-column column-width="17mm"/>      <!-- ExpiryDate -->
            <fo:table-column column-width="17mm"/>      <!-- VestingDate -->
            <fo:table-column column-width="20mm"/>      <!-- WorkplaceAtVestingDate -->
            <fo:table-column column-width="15mm"/>      <!-- NumberOfOwnershipsRealizedSinceGrant -->
            <fo:table-column column-width="15mm"/>      <!-- NumberCancelled -->
            <fo:table-column column-width="21mm"/>      <!-- WorkingDaysInCH-Emission-Vesting -->
            <fo:table-column column-width="18mm"/>      <!-- DaysEmission-Vesting -->
            <fo:table-column column-width="16mm"/>      <!-- PartRealizedInCH-Percentage -->
            <fo:table-column column-width="18mm"/>      <!-- NumberOfOwnershipsAtEndOfPeriod -->
            <fo:table-header>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'Mitarbeiterbeteiligungsplan'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'GrantDate'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'WorkplaceAtTimeOfGrantedParticipations'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'NumberOfOwnershipsGranted'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'VestingDateSpecifiedInPlan'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'ExpiryDateOfPossibleBlockingPeriodOfSharesHeld'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'PotentialExercisePrice'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'ExpiryDate'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'VestingDate'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'WorkplaceAtVestingDate'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'NumberOfOwnershipsRealizedSinceGrant'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'NumberCancelled'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'WorkingDaysInCH-Emission-Vesting'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'DaysEmission-Vesting'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'PartRealizedInCH-Percentage'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'NumberOfOwnershipsAtEndOfPeriod'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
            </fo:table-header>
            <fo:table-body>
                <xsl:choose>
                    <xsl:when test="count($lines)&gt;0">
                        <xsl:for-each select="$lines">
                            <xsl:if test="(position() &gt;= $von)and(position() &lt; $bis)">
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" text-align="left" display-align="center">
                                        <xsl:call-template name="shrinkString">
                                            <xsl:with-param name="maxLength" select="10"/>
                                            <xsl:with-param name="text" select="./*[local-name()='SharePlanDescription']"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:call-template name="format-date">
                                                <xsl:with-param name="value" select="./*[local-name()='GrantDate']"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" text-align="left" display-align="center">
                                        <xsl:call-template name="shrinkString">
                                            <xsl:with-param name="maxLength" select="11"/>
                                            <xsl:with-param name="text" select="./*[local-name()='WorkplaceAtTimeOfGrantedParticipations']"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of
                                                    select="format-number(./*[local-name()='NumberOfOwnershipsGranted'], $integer-format)"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:call-template name="format-date">
                                                <xsl:with-param name="value"
                                                                select="./*[local-name()='VestingDateSpecifiedInPlan']"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:call-template name="format-date">
                                                <xsl:with-param name="value"
                                                                select="./*[local-name()='ExpiryDateOfPossibleBlockingPeriodOfSharesHeld']"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of
                                                    select="format-number(./*[local-name()='PotentialExercisePrice'], $cents-format)"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:call-template name="format-date">
                                                <xsl:with-param name="value"
                                                                select="./*[local-name()='ExpiryDate']"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:call-template name="format-date">
                                                <xsl:with-param name="value"
                                                                select="./*[local-name()='VestingDate']"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of select="./*[local-name()='WorkplaceAtVestingDate']"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of
                                                    select="format-number(./*[local-name()='NumberOfOwnershipsRealizedSinceGrant'], $integer-format)"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of
                                                    select="format-number(./*[local-name()='NumberCancelled'], $integer-format)"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of
                                                    select="format-number(./*[local-name()='WorkingDaysInCH-Emission-Vesting'], $integer-format)"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of
                                                    select="format-number(./*[local-name()='DaysEmission-Vesting'], $integer-format)"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of
                                                    select="format-number(./*[local-name()='PartRealizedInCH-Percentage'], $percent-format)"/>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                        <fo:block>
                                            <xsl:value-of select="format-number(./*[local-name()='NumberOfOwnershipsAtEndOfPeriod'], $integer-format)"/>
                                        </fo:block>
                                    </fo:table-cell>

                                </fo:table-row>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:table-row>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold"><fo:block/></fo:table-cell>
                        </fo:table-row>
                    </xsl:otherwise>
                </xsl:choose>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template name="MAbeteiligungenTableFormCSum">
        <xsl:param name="totalNumberOfOwnershipsAtEndOfPeriod"/>

        <fo:block margin-bottom="3mm">
            <fo:table>
                <fo:table-column column-width="125mm"/>
                <fo:table-column column-width="132mm"/>
                <fo:table-column column-width="2mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="right" font-weight="bold" font-size="8pt" padding-right="2mm">
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'FormCsumTxt1'"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center" border-width="1.5pt">
                            <fo:block>
                                <xsl:value-of select="format-number($totalNumberOfOwnershipsAtEndOfPeriod, $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:block>
    </xsl:template>

    <xsl:template name="TaxableIncomeTableFormC">
        <xsl:param name="lines"/>
        <xsl:param name="currency"/>
        <xsl:param name="von"/>
        <xsl:param name="bis"/>

        <fo:block font-weight="bold" font-size="11pt">
            <xsl:call-template name="messageLookup">
                <xsl:with-param name="key" select="'TaxableIncome'"/>
            </xsl:call-template>
        </fo:block>

        <fo:table page-break-inside="auto">
            <fo:table-column column-width="20mm"/>      <!-- (1) Mitarbeiterbeteiligungsplan -->
            <fo:table-column column-width="16mm"/>      <!-- (2) RealizationDate -->
            <fo:table-column column-width="18mm"/>      <!-- (3) NumberOfOwnershipsRealizedDuringPeriod -->
            <fo:table-column column-width="18mm"/>      <!-- (4) GrantDate -->
            <fo:table-column column-width="18mm"/>      <!-- (5) VestingDate -->
            <fo:table-column column-width="13mm"/>      <!-- (6) PotentialExercisePrice  -->
            <fo:table-column column-width="24mm"/>      <!-- (7) MarketValue_FormularC -->
            <fo:table-column column-width="19mm"/>      <!-- (8) ExpiryDateOfPossibleBlockingPeriodOfSharesHeld2 -->
            <fo:table-column column-width="18mm"/>      <!-- (9) DurationBlockingPeriod -->
            <fo:table-column column-width="17mm"/>      <!-- (10) ReductionIncomePercentage -->
            <fo:table-column column-width="17mm"/>      <!-- (11) IncomTimeOfRealisation -->
            <fo:table-column column-width="18mm"/>      <!-- (12) CurrencyRateAtRealization -->
            <fo:table-column column-width="17mm"/>      <!-- (13) TotalIncomeAtRealization -->
            <fo:table-column column-width="15mm"/>      <!-- (14) PartInCH-Percentage -->
            <fo:table-column column-width="14mm"/>      <!-- (15) PartIncome-CH -->
            <fo:table-column column-width="18mm"/>      <!-- (16) PartIncomeAbroad -->
            <fo:table-header>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'Mitarbeiterbeteiligungsplan'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'RealizationDate'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'NumberOfOwnershipsRealizedDuringPeriod'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'GrantDate'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell-borderBold">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'VestingDate'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'PotentialExercisePrice'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'MarketValue_FormularC'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'ExpiryDateOfPossibleBlockingPeriodOfSharesHeld2'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'DurationBlockingPeriod'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'EinschlagDauerSperrfrist'"/>  <!--ReductionIncomePercentage-->
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'IncomTimeOfRealisation'"/>
                        </xsl:call-template>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="$currency"/>
                        <xsl:text>)</xsl:text>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'CurrencyRateAtRealization'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'GeldwertVorteilReal'"/>  <!-- TotalIncomeAtRealization -->
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'PartInCH-Percentage'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'PartIncome-CH'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
                <fo:table-cell xsl:use-attribute-sets="data-table-cell" text-align="center">
                    <fo:block>
                        <xsl:call-template name="messageLookup">
                            <xsl:with-param name="key" select="'PartIncomeAbroad'"/>
                        </xsl:call-template>
                    </fo:block>
                </fo:table-cell>
            </fo:table-header>
            <fo:table-body>
                <xsl:for-each select="$lines">
                    <xsl:if test="(position() &gt;= $von)and(position() &lt; $bis)">
                        <fo:table-row>
                        <!-- (1) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" text-align="left" display-align="center">
                            <xsl:call-template name="shrinkString">
                                <xsl:with-param name="maxLength" select="10"/>
                                <xsl:with-param name="text" select="./*[local-name()='SharePlanDescription']"/>
                            </xsl:call-template>
                        </fo:table-cell>
                        <!-- (2) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value" select="./*[local-name()='RealizationDate']"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (3) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='NumberOfOwnershipsRealizedDuringPeriod'], $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (4) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value" select="./*[local-name()='GrantDate']"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (5) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value" select="./*[local-name()='VestingDate']"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (6) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='PotentialExercisePrice'], $cents-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (7) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:if test="count(./*[local-name()='MarketValueAtTimeOfRealization'])&gt;0">
                                    <xsl:value-of select="format-number(./*[local-name()='MarketValueAtTimeOfRealization'], $cents-format)"/>
                                </xsl:if>
                                <xsl:if test="count(./*[local-name()='MarketValueAtTimeOfRealization'])&gt;0">
                                    <xsl:value-of select="format-number(./*[local-name()='MarketValueFormula'], $cents-format)"/>
                                </xsl:if>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (8) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:call-template name="format-date">
                                    <xsl:with-param name="value"
                                                    select="./*[local-name()='ExpiryDateOfPossibleBlockingPeriodOfSharesHeld']"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (9) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='DurationBlockingPeriod'], $percent-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (10) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='ReductionIncomePercentage'], $percent-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (11) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='IncomTimeOfRealisation'], $cents-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (12) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='CurrencyRateRealization'], $percent-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (13) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='TotalIncomeAtRealization'] , $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (14) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='PartInCH-Percentage'], $percent-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <!-- (15) -->
                        <xsl:choose>
                            <xsl:when test="./*[local-name()='PartIncomeCH'] &lt; 10000000">
                                <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                                    <fo:block>
                                        <xsl:value-of select="format-number(./*[local-name()='PartIncomeCH'], $integer-format)"/>
                                    </fo:block>
                                </fo:table-cell>
                            </xsl:when>
                            <xsl:otherwise>
                                <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold-Small" display-align="center">
                                    <fo:block>
                                        <xsl:value-of select="format-number(./*[local-name()='PartIncomeCH'], $integer-format)"/>
                                    </fo:block>
                                </fo:table-cell>
                            </xsl:otherwise>
                        </xsl:choose>
                        <!-- (16) -->
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center">
                            <fo:block>
                                <xsl:value-of select="format-number(./*[local-name()='PartIncomeAbroad'], $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                    </xsl:if>
                </xsl:for-each>
            </fo:table-body>
        </fo:table>


    </xsl:template>

    <xsl:template name="TaxableIncomeTableFormCSum">
        <xsl:param name="grandTotalIncomeAtRealization"/>
        <xsl:param name="totalPartIncomeCH"/>
        <xsl:param name="totalPartIncomeAbroad"/>

        <fo:block>
            <fo:table page-break-inside="auto">
                <fo:table-column column-width="82mm"/>
                <fo:table-column column-width="132mm"/>
                <fo:table-column column-width="2mm"/>
                <fo:table-column column-width="17mm"/>
                <fo:table-column column-width="15mm"/>
                <fo:table-column column-width="14mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="right" font-weight="bold" font-size="8pt" padding-right="2mm">
                                <xsl:call-template name="messageLookup">
                                    <xsl:with-param name="key" select="'FormCsumTxt2'"/>
                                </xsl:call-template>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center" border-width="1.5pt">
                            <fo:block>
                                <xsl:value-of select="format-number($grandTotalIncomeAtRealization, $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block/>
                        </fo:table-cell>
                        <xsl:choose>
                            <xsl:when test="$totalPartIncomeCH &lt; 10000000">
                                <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center" border-width="1.5pt">
                                    <fo:block>
                                        <xsl:value-of select="format-number($totalPartIncomeCH, $integer-format)"/>
                                    </fo:block>
                                </fo:table-cell>
                            </xsl:when>
                            <xsl:otherwise>
                                <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold-Small" display-align="center" border-width="1.5pt">
                                    <fo:block>
                                        <xsl:value-of select="format-number($totalPartIncomeCH, $integer-format)"/>
                                    </fo:block>
                                </fo:table-cell>
                            </xsl:otherwise>
                        </xsl:choose>
                        <fo:table-cell xsl:use-attribute-sets="data-table-cell-bold" display-align="center" border-width="1.5pt">
                            <fo:block>
                                <xsl:value-of select="format-number($totalPartIncomeAbroad, $integer-format)"/>
                            </fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
        </fo:block>
    </xsl:template>

    <xsl:template name="shrinkString">
        <xsl:param name="maxLength"/>   <!-- Initial maximum string length for the cell -->
        <xsl:param name="text"/>   <!-- The text to resize/shrink -->

        <xsl:variable name="fontTaille">
            <xsl:choose>
                <xsl:when test="string-length($text) &gt; $maxLength">
                    <xsl:variable name="fontGroesse" select="9 - (string-length($text) - $maxLength)*0.5"/>
                    <xsl:choose>
                        <xsl:when test="$fontGroesse &gt; 4">
                            <xsl:value-of select="$fontGroesse"/>
                        </xsl:when>
                        <xsl:otherwise>5</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>9</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="fontSize" select="concat($fontTaille,'pt')"/>

        <xsl:variable name="outputString">
            <xsl:choose>
                <xsl:when test="$fontTaille != 9">
                    <xsl:choose>
                        <xsl:when test="string-length($text) &gt; ($maxLength + $maxLength div 2)">
                            <xsl:value-of select="concat(substring($text,1,floor($maxLength + $maxLength div 2)),'...')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$text"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$text"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <fo:block font-size="{$fontSize}">
            <fo:inline vertical-align="middle">
                <xsl:value-of select="$outputString"/>
            </fo:inline>
        </fo:block>
    </xsl:template>

    <xsl:template name="printMessage">
        <xsl:param name="message"/>
        <xsl:if test="$verbose='true'">
            <xsl:message>
                <xsl:value-of select="$message"/>
            </xsl:message>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>