<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:template name="decode-sedex-id">
		<xsl:param name="id"/>
		<xsl:variable name="trimmed-id" select="normalize-space($id)"/>
		<xsl:variable name="domain-part" select="substring-before($trimmed-id, '-')"/>
		<xsl:variable name="test" select="substring($domain-part, 1, 1) = 'T'"/>
		<xsl:variable name="domain" select="substring($domain-part, string-length($domain-part), 1)"/>
		<xsl:variable name="unit" select="substring-before(substring-after($id, '-'), '-')"/>
		<xsl:variable name="function" select="substring-after(substring-after($id, '-'), '-')"/>
		<xsl:choose>
			<xsl:when test="$domain = '0'">
				<xsl:call-template name="decode-system-id">
					<xsl:with-param name="id" select="$trimmed-id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
					<xsl:with-param name="function" select="$function"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$domain = '1'">
				<xsl:call-template name="decode-commune-id">
					<xsl:with-param name="id" select="$trimmed-id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
					<xsl:with-param name="function" select="$function"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$domain = '2'">
				<xsl:call-template name="decode-canton-id">
					<xsl:with-param name="id" select="$trimmed-id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
					<xsl:with-param name="function" select="$function"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$domain = '3'">
				<xsl:call-template name="decode-federal-id">
					<xsl:with-param name="id" select="$trimmed-id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
					<xsl:with-param name="function" select="$function"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$domain = '5'">
				<xsl:call-template name="decode-district-id">
					<xsl:with-param name="id" select="$trimmed-id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
					<xsl:with-param name="function" select="$function"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$domain = '6'">
				<xsl:call-template name="decode-bsv-id">
					<xsl:with-param name="id" select="$trimmed-id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
					<xsl:with-param name="function" select="$function"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$domain = '7'">
				<xsl:call-template name="decode-private-id">
					<xsl:with-param name="id" select="$trimmed-id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
					<xsl:with-param name="function" select="$function"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-id"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-system-id">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:param name="function"/>
		<xsl:choose>
			<xsl:when test="$id = '0-sedex-0'">sedex system</xsl:when>
			<xsl:when test="$id = '0-sedex-1'">sedex monitoring system</xsl:when>
			<xsl:otherwise><xsl:value-of select="$id"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-commune-id">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:param name="function"/>
		<xsl:value-of select="$id"/>
	</xsl:template>
	
	<xsl:template name="decode-canton-id">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:param name="function"/>
		<xsl:choose>
			<xsl:when test="$function = '5'">
				<xsl:call-template name="decode-canton-tax">
					<xsl:with-param name="id" select="$id"/>
					<xsl:with-param name="test" select="$test"/>
					<xsl:with-param name="unit" select="$unit"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$id"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-canton-tax">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:variable name="test-prefix"><xsl:if test="$test = 'true'">Test - </xsl:if></xsl:variable>
		<xsl:choose>
			<xsl:when test="$unit = 'AG'"><xsl:value-of select="concat($test-prefix, 'KSTA Aargau')"/></xsl:when>
			<xsl:when test="$unit = 'AR'"><xsl:value-of select="concat($test-prefix, 'KSTV Appenzell Innerrhoden')"/></xsl:when>
			<xsl:when test="$unit = 'AI'"><xsl:value-of select="concat($test-prefix, 'KSTV appenzell Ausserrhoden')"/></xsl:when>
			<xsl:when test="$unit = 'BL'"><xsl:value-of select="concat($test-prefix, 'KSTV Basel-Landschaft')"/></xsl:when>
			<xsl:when test="$unit = 'BS'"><xsl:value-of select="concat($test-prefix, 'KSTV Basel-Stadt')"/></xsl:when>
			<xsl:when test="$unit = 'BE'"><xsl:value-of select="concat($test-prefix, 'KSTV Bern')"/></xsl:when>
			<xsl:when test="$unit = 'FR'"><xsl:value-of select="concat($test-prefix, 'SCC Fribourg')"/></xsl:when>
			<xsl:when test="$unit = 'GE'"><xsl:value-of select="concat($test-prefix, 'AFC Genève')"/></xsl:when>
			<xsl:when test="$unit = 'GL'"><xsl:value-of select="concat($test-prefix, 'KSTV Glarus')"/></xsl:when>
			<xsl:when test="$unit = 'GR'"><xsl:value-of select="concat($test-prefix, 'KSTV Graubünden')"/></xsl:when>
			<xsl:when test="$unit = 'JU'"><xsl:value-of select="concat($test-prefix, 'SCC Jura')"/></xsl:when>
			<xsl:when test="$unit = 'LU'"><xsl:value-of select="concat($test-prefix, 'DST Luzern')"/></xsl:when>
			<xsl:when test="$unit = 'NE'"><xsl:value-of select="concat($test-prefix, 'SC Neuchâtel')"/></xsl:when>
			<xsl:when test="$unit = 'NW'"><xsl:value-of select="concat($test-prefix, 'KSTA Nidwalden')"/></xsl:when>
			<xsl:when test="$unit = 'OW'"><xsl:value-of select="concat($test-prefix, 'KSTV Obwalden')"/></xsl:when>
			<xsl:when test="$unit = 'SG'"><xsl:value-of select="concat($test-prefix, 'KSTA St.Gallen')"/></xsl:when>
			<xsl:when test="$unit = 'SH'"><xsl:value-of select="concat($test-prefix, 'KSTV Schaffhausen')"/></xsl:when>
			<xsl:when test="$unit = 'SZ'"><xsl:value-of select="concat($test-prefix, 'KSTV Schwyz')"/></xsl:when>
			<xsl:when test="$unit = 'SO'"><xsl:value-of select="concat($test-prefix, 'KSTA Solothurn')"/></xsl:when>
			<xsl:when test="$unit = 'TG'"><xsl:value-of select="concat($test-prefix, 'KSTV Thurgau')"/></xsl:when>
			<xsl:when test="$unit = 'TI'"><xsl:value-of select="concat($test-prefix, 'DC Tessin')"/></xsl:when>
			<xsl:when test="$unit = 'UR'"><xsl:value-of select="concat($test-prefix, 'AFS Uri')"/></xsl:when>
			<xsl:when test="$unit = 'VD'"><xsl:value-of select="concat($test-prefix, 'ACI Vaud')"/></xsl:when>
			<xsl:when test="$unit = 'VS'"><xsl:value-of select="concat($test-prefix, 'SCC Valais')"/></xsl:when>
			<xsl:when test="$unit = 'ZG'"><xsl:value-of select="concat($test-prefix, 'KSTV Zug')"/></xsl:when>
			<xsl:when test="$unit = 'ZH'"><xsl:value-of select="concat($test-prefix, 'KSTA Zürich')"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$id"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-federal-id">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:param name="function"/>
		<xsl:choose>
			<xsl:when test="$id = '3-CH-30'">ESTV</xsl:when>
			<xsl:when test="$id = 'T3-CH-30'">Test - ESTV</xsl:when>
			<xsl:otherwise><xsl:value-of select="$id"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-district-id">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:param name="function"/>
		<xsl:value-of select="$id"/>
	</xsl:template>
	
	<xsl:template name="decode-bsv-id">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:param name="function"/>
		<xsl:choose>
			<xsl:when test="string-length($unit) = 6 and (substring($unit, 1, 1) = '0' or substring($unit, 1, 1) = '1')">
				<xsl:variable name="test-prefix"><xsl:if test="$test = 'true'">Test - </xsl:if></xsl:variable>
				<xsl:variable name="main-inst"><xsl:value-of select="concat('AK-', number(substring($unit, 1, 3)))"/></xsl:variable>
				<xsl:variable name="sub-inst"><xsl:if test="substring($unit, 4, 3) != '000'"><xsl:value-of select="concat('-', number(substring($unit, 4, 3)))"/></xsl:if></xsl:variable>
				<xsl:value-of select="concat($test-prefix, $main-inst, $sub-inst)"/>
			</xsl:when>
			<xsl:when test="$id = '6-301000-1'">IVST ZH</xsl:when>
			<xsl:when test="$id = '6-302000-1'">IVST BE</xsl:when>
			<xsl:when test="$id = '6-303000-1'">IVST LU</xsl:when>
			<xsl:when test="$id = '6-304000-1'">IVST UR</xsl:when>
			<xsl:when test="$id = '6-305000-1'">IVST SZ</xsl:when>
			<xsl:when test="$id = '6-306000-1'">IVST OW</xsl:when>
			<xsl:when test="$id = '6-307000-1'">IVST NW</xsl:when>
			<xsl:when test="$id = '6-308000-1'">IVST GL</xsl:when>
			<xsl:when test="$id = '6-309000-1'">IVST ZG</xsl:when>
			<xsl:when test="$id = '6-310000-1'">IVST FR</xsl:when>
			<xsl:when test="$id = '6-311000-1'">IVST SO</xsl:when>
			<xsl:when test="$id = '6-312000-1'">IVST BS</xsl:when>
			<xsl:when test="$id = '6-313000-1'">IVST BL</xsl:when>
			<xsl:when test="$id = '6-314000-1'">IVST SH</xsl:when>
			<xsl:when test="$id = '6-315000-1'">IVST AR</xsl:when>
			<xsl:when test="$id = '6-316000-1'">IVST AI</xsl:when>
			<xsl:when test="$id = '6-317000-1'">IVST SG</xsl:when>
			<xsl:when test="$id = '6-318000-1'">IVST GR</xsl:when>
			<xsl:when test="$id = '6-319000-1'">IVST AG</xsl:when>
			<xsl:when test="$id = '6-320000-1'">IVST TG</xsl:when>
			<xsl:when test="$id = '6-321000-1'">IVST TI</xsl:when>
			<xsl:when test="$id = '6-322000-1'">IVST VD</xsl:when>
			<xsl:when test="$id = 'T6-322000-1'">Test - IVST VD</xsl:when>
			<xsl:when test="$id = '6-323000-1'">IVST VS</xsl:when>
			<xsl:when test="$id = '6-324000-1'">IVST NE</xsl:when>
			<xsl:when test="$id = '6-325000-1'">IVST GE</xsl:when>
			<xsl:when test="$id = '6-327000-1'">IVST Versicherte Ausland</xsl:when>
			<xsl:when test="$id = '6-350000-1'">IVST JU</xsl:when>
			<xsl:when test="$id = 'T6-900001-1'">Test - Pool IGS</xsl:when>
			<xsl:when test="$id = 'T6-900001-2'">Test - Pool IGS</xsl:when>
			<xsl:when test="$id = '6-900002-1'">Pool IGAKIS</xsl:when>
			<xsl:when test="$id = 'T6-900003-1'">Test - Mathis und Scheitlin</xsl:when>
			<xsl:when test="$id = '6-900004-1'">Pool InfoRom</xsl:when>
			<xsl:when test="$id = '6-900005-1'">Pool GilAI</xsl:when>
			<xsl:when test="$id = 'T6-900005-1'">Test - Pool GilAI</xsl:when>
			<xsl:when test="$id = 'T6-900006-1'">Test - Globaz SA</xsl:when>
			<xsl:when test="$id = '6-900007-1'">Pool Allgemein</xsl:when>
			<xsl:when test="$id = '6-900008-1'">Löwenfels Partner AG</xsl:when>
			<xsl:when test="$id = 'T6-900008-1'">Test - Löwenfels Partner AG</xsl:when>
			<xsl:when test="$id = '6-900009-1'">Pool PIA</xsl:when>
			<xsl:when test="$id = '6-900010-1'">Insite AG</xsl:when>
			<xsl:when test="$id = '6-900011-1'">Soreco Publica AG</xsl:when>
			<xsl:when test="$id = 'T6-900012-1'">Test - OSIV Service Center</xsl:when>
			<xsl:when test="$id = 'T6-900013-1'">Test - Axensis</xsl:when>
			<xsl:when test="$id = 'T6-900014-1'">Test - CTP</xsl:when>
			<xsl:when test="$id = 'T6-900014-2'">Test - CTP</xsl:when>
			<xsl:when test="$id = '6-990000-1'">BSV</xsl:when>
			<xsl:when test="$id = 'T6-990000-1'">Test - BSV</xsl:when>
			<xsl:otherwise><xsl:value-of select="$id"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-private-id">
		<xsl:param name="id"/>
		<xsl:param name="test"/>
		<xsl:param name="unit"/>
		<xsl:param name="function"/>
		<xsl:choose>
			<xsl:when test="$id = 'T7-24-1'">Test - AWK</xsl:when>
			<xsl:when test="$id = 'T7-22-1'">Test - KMS</xsl:when>
			<xsl:otherwise><xsl:value-of select="$id"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>