<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/4" 
	xmlns:eahv-iv-2402-common="http://www.eahv-iv.ch/xmlns/eahv-iv-2402-common/0">
	
	<xsl:import href="../../eahv-iv-common/4/eahv-iv-common-4-0_de.xsl"/>
	<xsl:import href="eahv-iv-2402-common-language-0-9_de.xsl"/>
	
	
	<xsl:template match="eahv-iv-2402-common:contactInformation" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:email"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:other"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>

    <xsl:template match="eahv-iv-2402-common:compensationFund">
        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
            <fo:table-column column-width="{$title-column-width}" column-number="1"/>
            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
                        <fo:block>
                            <xsl:value-of select="$eahv-iv-2402-common.compensationFund"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
                        <fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
                            <fo:table-column column-width="{$description-column-width}" column-number="1"/>
                            <fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
                            <fo:table-body>
                                <xsl:apply-templates select="eahv-iv-2402-common:nameDe"/>
                            </fo:table-body>
                        </fo:table>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:id">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.compensationFundId"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:citizenshipCountry">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.country"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:affiliateID">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.compensationFundAffiliateId"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:organisationName">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.organisationName"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:nameDe">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.compensationFundName"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>


    <xsl:template match="eahv-iv-2402-common:titleDe">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.country"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                	<xsl:value-of select="."/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:activityStartDate">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.activityStartDate"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:activityEndDate">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.activityEndDate"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:startDate">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.startDate"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="eahv-iv-2402-common:endDate">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.endDate"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:call-template name="format-date">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>

    <xsl:template match="eahv-iv-2402-common:decisionVerdict">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.decisionVerdict"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="."/>
                    <xsl:call-template name="decode-VerdictDecision">
                    	<xsl:with-param name="value">
                            <xsl:value-of select="."/>
                        </xsl:with-param>
                    </xsl:call-template>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
        
    <xsl:template match="eahv-iv-2402-common:article">
        <fo:table-row>
            <fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
                <fo:block>
                    <xsl:value-of select="$eahv-iv-2402-common.decisionArticle"/>
                </fo:block>
            </fo:table-cell>
            <fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
                <fo:block>
                    <xsl:value-of select="eahv-iv-2402-common:titleDe"/>
                </fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="decode-VerdictDecision">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:text> (</xsl:text>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2402-common.positive"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2402-common.partialPositive"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2402-common.negative"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
    	<xsl:text>)</xsl:text>
	</xsl:template>
    
    <xsl:template name="decode-documentType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '01.01.12'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.01.12"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.01'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.01"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.02'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.02"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.03'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.03"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.04'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.04"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.05'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.05"/></xsl:when>
			<xsl:when test="$trimmed-value = '01.13.06'"><xsl:value-of select="$eahv-iv-2402-common.documentType.01.13.06"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
 	</xsl:template>
    

</xsl:stylesheet>
