<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/4" xmlns:eahv-iv-2402-common="http://www.eahv-iv.ch/xmlns/eahv-iv-2402-common/3"
	xmlns:eahv-iv-2402-000101="http://www.eahv-iv.ch/xmlns/eahv-iv-2402-000101/3">
	<xsl:import href="../../eahv-iv-2402-common/3/eahv-iv-2402-common-3-0_fr.xsl" />
	<xsl:import href="2402-000101-language-3-0_fr.xsl" />
	<!-- Parameter receipt date to be passed in when creating the message layout. This must be a valid xs:date -->
	<xsl:param name="dateOfReceipt" />
	<!-- override the description-column-table-width variable so that the list of the attachments won't be positioned too right. -->
	<xsl:variable name="description-column-table-width">
		52mm
	</xsl:variable>

	<!-- The main template, defining page masters, sequence masters and page sequence -->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}" />
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}" />
					<fo:region-after region-name="page-footer" extent="{$footer-height}" />
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}" />
					<fo:region-before region-name="page-header" extent="{$header-height}" />
					<fo:region-after region-name="page-footer" extent="{$footer-height}" />
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page" />
					<fo:repeatable-page-master-reference master-reference="other-pages" />
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2402-000101:header" mode="page-header" />
				</fo:static-content>

				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2402-000101:header" mode="page-footer" />
				</fo:static-content>

				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2402-000101:header" mode="message-header-block" />
					<xsl:apply-templates select="//eahv-iv-2402-000101:header" mode="special-message" />
					<xsl:apply-templates select="//eahv-iv-2402-000101:header" mode="page-header" />

					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2402-000101:header" />
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!-- Fixed header block on page one -->
	<xsl:template match="eahv-iv-2402-000101:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1" />
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-2402-000101" />
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1" />
						<fo:table-column column-width="{$header-right-column-width}" column-number="2" />
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1" />
										<fo:table-column column-width="47mm" column-number="2" />
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2402-000101.messageDate" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value">
																<xsl:value-of select="eahv-iv-2402-000101:messageDate" />
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.senderId" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id">
																<xsl:value-of select="eahv-iv-2402-000101:senderId" />
															</xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.recipientId" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="eahv-iv-2402-000101:recipientId">
															<xsl:if test="position() != 1">
																<xsl:text>, </xsl:text>
															</xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id">
																	<xsl:value-of select="." />
																</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2402-common.contactInformation" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="eahv-iv-2402-000101:extension/eahv-iv-2402-common:contactInformation" mode="block" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1" />
										<fo:table-column column-width="47mm" column-number="2" />
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2402-000101.action" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="eahv-iv-2402-000101:action" />
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2402-000101.ourBusinessReferenceId" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="eahv-iv-2402-000101:ourBusinessReferenceId" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-common.pages" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<fo:page-number-citation ref-id="pageCounter" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block>
														<xsl:value-of select="$eahv-iv-2402-000101.attachment" />
													</fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(eahv-iv-2402-000101:attachment)" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!-- Conditional "Alert" if there is something special about this message -->
	<xsl:template match="eahv-iv-2402-000101:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2402-000101:testDeliveryFlag = '1') or (eahv-iv-2402-000101:testDeliveryFlag = 'true')" />
		<xsl:variable name="is-special" select="eahv-iv-2402-000101:action != 1 and eahv-iv-2402-000101:action != 5 and eahv-iv-2402-000101:action != 6" />
		<xsl:variable name="is-priority" select="eahv-iv-2402-000101:messagePriority > 0" />
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm"
				font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2402-000101:action" />
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($eahv-iv-2402-000101.messagePriority, ': ')" />
					<xsl:value-of select="eahv-iv-2402-000101:messagePriority" />
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2402-000101.testDeliveryFlag, ' ** ')" />
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- Cover sheet: further information from the header part of the message -->
	<xsl:template match="eahv-iv-2402-000101:header">
		<xsl:apply-templates select="eahv-iv-2402-000101:extension" />
		<xsl:apply-templates select="//eahv-iv-2402-000101:content" />
		<xsl:if test="count(eahv-iv-2402-000101:attachment) > 0">
			<fo:table table-layout="fixed" width="100%" border-collapse="separate">
				<fo:table-column column-width="{$title-column-width}" column-number="1" />
				<fo:table-column column-width="{$description-column-table-width}" column-number="2" />
				<fo:table-column column-width="{$docpath-column-width}" column-number="3" />
				<fo:table-column column-width="{$doctype-column-width}" column-number="4" />
				<fo:table-header>
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
							<fo:block>
								<xsl:value-of select="$eahv-iv-2402-000101.attachment" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="table-denom-column">
							<fo:block />
						</fo:table-cell>
						<fo:table-cell column-number="3" xsl:use-attribute-sets="table-title-column">
							<fo:block>
								<xsl:value-of select="$eahv-iv-2402-000101.pathFileName" />
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="4" xsl:use-attribute-sets="table-title-column">
							<fo:block>
								<xsl:value-of select="$eahv-iv-2402-common.documentType" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-header>
				<fo:table-body>
					<xsl:for-each select="eahv-iv-2402-000101:attachment">
						<xsl:sort data-type="number" select="eahv-iv-2402-000101:sortOrder" />
						<xsl:apply-templates select="." />
					</xsl:for-each>
				</fo:table-body>
			</fo:table>
		</xsl:if>
		<!-- <xsl:apply-templates select="eahv-iv-2402-000101:comment"/> -->
	</xsl:template>

	<!-- Cover sheet: extension from the message header -->
	<xsl:template match="eahv-iv-2402-000101:content">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2402-common.insuredPerson" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1" />
							<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2402-000101:insuredPerson" />
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$eahv-iv-2402-common.citizenshipCountry" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:for-each select="eahv-iv-2402-000101:citizenshipCountry">
												<xsl:if test="position() != 1">
													<xsl:text>, </xsl:text>
												</xsl:if>
												<xsl:value-of select="." />
											</xsl:for-each>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<xsl:apply-templates select="eahv-iv-2402-000101:vn" />
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
		<xsl:apply-templates select="eahv-iv-2402-000101:activityCH" />
		<xsl:apply-templates select="eahv-iv-2402-000101:activityAbroad" />
		<xsl:if test="count(eahv-iv-2402-000101:familyMembers) > 0">
			<xsl:apply-templates select="eahv-iv-2402-000101:familyMembers" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="eahv-iv-2402-000101:insuredPerson">
		<xsl:apply-templates select="eahv-iv-common:officialName" />
		<xsl:apply-templates select="eahv-iv-common:firstName" />
		<xsl:apply-templates select="eahv-iv-common:sex" />
		<xsl:apply-templates select="eahv-iv-common:dateOfBirth" />
	</xsl:template>

	<xsl:template match="eahv-iv-2402-000101:activityCH">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2402-common.company" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1" />
							<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2402-common:companyAddress/eahv-iv-2402-common:organisationName" />
								<xsl:apply-templates select="eahv-iv-2402-common:affiliateID" />
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>

		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2402-common.compensationFund" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1" />
							<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2402-common:compensationFund/eahv-iv-2402-common:id" />
								<xsl:apply-templates select="eahv-iv-2402-common:compensationFund/eahv-iv-2402-common:nameDe" />
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="eahv-iv-2402-common:compensationFund">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2402-common.compensationFund" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1" />
							<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2402-common:nameDe" />
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="eahv-iv-2402-000101:activityAbroad">

		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2402-common.activityAbroad" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1" />
							<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2402-common:countryOfTemporaryActivity/eahv-iv-2402-common:titleFr" />
								<xsl:apply-templates select="eahv-iv-2402-common:activityStartDate" />
								<xsl:apply-templates select="eahv-iv-2402-common:activityEndDate" />
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Cover sheet: comment -->
	<xsl:template match="eahv-iv-2402-000101:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$eahv-iv-2402-000101.comment" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="." />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Cover sheet: attachment list from the message header -->
	<xsl:template match="eahv-iv-2402-000101:attachment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="table-left-column">
				<fo:block />
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="first-value-column">
				<fo:block>
					<xsl:value-of select="eahv-iv-2402-common:title" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
				<xsl:for-each select="eahv-iv-2402-common:file">
					<xsl:sort data-type="number" select="eahv-iv-2402-common:sortOrder" />
					<fo:block>
						<xsl:value-of select="substring-after(eahv-iv-common:pathFileName, '/')" />
					</fo:block>
				</xsl:for-each>
			</fo:table-cell>
			<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-documentType">
						<xsl:with-param name="value" select="eahv-iv-2402-common:documentType" />
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Page header, shows the message subject in a bar on first page and as header in subsequent pages. -->
	<xsl:template mode="page-header" match="eahv-iv-2402-000101:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1" />
			<fo:table-column column-width="proportional-column-width(1)" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-family="{$font-family}" font-weight="bold">
							<xsl:value-of select="eahv-iv-2402-000101:subject" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block />
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Page footer, shows page numbers and some info from message header. -->
	<xsl:template mode="page-footer" match="eahv-iv-2402-000101:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1" />
			<fo:table-column column-width="15mm" column-number="2" />
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2402-000101:messageType" />
							/
							<xsl:value-of select="eahv-iv-2402-000101:subMessageType" />
							|
							<xsl:value-of select="concat($eahv-iv-2402-000101.messageId, ' ')" />
							<xsl:value-of select="eahv-iv-2402-000101:messageId" />
							<xsl:if test="count(eahv-iv-2402-000101:referenceMessageId) != 0">
								|
								<xsl:value-of select="concat($eahv-iv-2402-000101.referenceMessageId, ' ')" />
								<xsl:value-of select="eahv-iv-2402-000101:referenceMessageId" />
							</xsl:if>
							<xsl:if test="eahv-iv-2402-000101:businessProcessId">
								|
								<xsl:value-of select="concat($eahv-iv-2402-000101.businessProcessId, ' ')" />
								<xsl:value-of select="eahv-iv-2402-000101:businessProcessId" />
							</xsl:if>
							|
							<xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')" />
							<xsl:call-template name="format-date">
								<xsl:with-param name="value">
									<xsl:value-of select="$dateOfReceipt" />
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number />
							/
							<fo:page-number-citation ref-id="pageCounter" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="eahv-iv-2402-000101:vn">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$eahv-iv-common.vn" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-vnType">
						<xsl:with-param name="value">
							<xsl:value-of select="." />
						</xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>
