<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/3"
	xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044/1"
	xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/1"
	xmlns:eahv-iv-2011-000103="http://www.eahv-iv.ch/xmlns/eahv-iv-2011-000103/2">
	
	<xsl:import href="../../eahv-iv-common/1/eahv-iv-common-1-2_de.xsl"/>
	<xsl:import href="2011-000103-language-2-0_de.xsl"/>
	
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2011-000103:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2011-000103:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2011-000103:header" mode="message-header-block"/>
					<xsl:apply-templates select="//eahv-iv-2011-000103:header" mode="special-message"/>
					<xsl:apply-templates select="//eahv-iv-2011-000103:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<xsl:if test="count(eahv-iv-2011-000103:message) > 0">
							<xsl:attribute name="page-break-after">always</xsl:attribute>
						</xsl:if>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2011-000103:header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm" font-family="{$font-family}">
							<xsl:apply-templates select="//eahv-iv-2011-000103:content"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="eahv-iv-2011-000103:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-common"/> | <xsl:value-of select="$eahv-iv-2011-000103"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="eahv-iv-2011-000103:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="eahv-iv-2011-000103:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2011-000103:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.declarationLocalReference"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="eahv-iv-2011-000103:declarationLocalReference" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="eahv-iv-2011-000103:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.originalSenderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id" select="eahv-iv-2011-000103:originalSenderId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.initialMessageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2011-000103:initialMessageDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2011-000103:ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2011-000103:yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.eventDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2011-000103:eventDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.eventPeriod"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-string">
															<xsl:with-param name="value" select="eahv-iv-2011-000103:eventPeriod"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000103.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(eahv-iv-2011-000103:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="eahv-iv-2011-000103:declarationLocalReference" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:email"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="eahv-iv-2011-000103:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2011-000103:testDeliveryFlag = '1') or (eahv-iv-2011-000103:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="eahv-iv-2011-000103:action != 1 and eahv-iv-2011-000103:action != 5 and eahv-iv-2011-000103:action != 6"/>
		<xsl:variable name="is-priority" select="eahv-iv-2011-000103:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2011-000103:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($eahv-iv-2011-000103.messagePriority, ': ')"/>
					<xsl:value-of select="eahv-iv-2011-000103:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2011-000103.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="eahv-iv-2011-000103:header">
		<xsl:apply-templates select="eahv-iv-2011-000103:object"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:comment"/>
	</xsl:template>
	
	<!--
		Cover sheet: object field from the message header
	-->
	<xsl:template match="eahv-iv-2011-000103:object[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.object"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-common:officialName"/>
								<xsl:apply-templates select="eahv-iv-common:firstName"/>
								<xsl:apply-templates select="eahv-iv-common:sex"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfBirth"/>
								<xsl:apply-templates select="eahv-iv-common:vn"/>
								<xsl:apply-templates select="eahv-iv-common:OtherPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:EuPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:address"/>
								<xsl:apply-templates select="eahv-iv-common:maritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfEntry"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfDeparture"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="eahv-iv-2011-000103:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.comment"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="eahv-iv-2011-000103:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2011-000103:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="eahv-iv-2011-000103:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2011-000103:messageType"/>/<xsl:value-of select="eahv-iv-2011-000103:subMessageType"/>
							| <xsl:value-of select="concat($eahv-iv-2011-000103.messageId, ' ')"/>
							<xsl:value-of select="eahv-iv-2011-000103:messageId"/>
							<xsl:if test="eahv-iv-2011-000103:referenceMessageId">
								| <xsl:value-of select="concat($eahv-iv-2011-000103.referenceMessageId, ' ')"/>
								<xsl:value-of select="eahv-iv-2011-000103:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="eahv-iv-2011-000103:businessProcessId">
								| <xsl:value-of select="concat($eahv-iv-2011-000103.businessProcessId, ' ')"/>
								<xsl:value-of select="eahv-iv-2011-000103:businessProcessId"/>
							</xsl:if>
							| <xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		****************  Message content starts here ***************
	 -->
	
	<!-- 
		"Main" template for the message content; shows all relevant content blocks
	-->
	<xsl:template match="eahv-iv-2011-000103:content">
		<xsl:call-template name="single-date-block">
			<xsl:with-param name="title" select="$eahv-iv-2011-000103.assessmentDate"/>
			<xsl:with-param name="value" select="eahv-iv-2011-000103:assessmentDate"/>
		</xsl:call-template>
		<xsl:apply-templates select="eahv-iv-2011-000103:assessmentType"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:reportType"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:taxpayer"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:spBasicData"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:spBusinessData"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:spPrivateData"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:spouse"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:epBasicData"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:epBusinessData"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:epPrivateData"/>
		<xsl:apply-templates select="eahv-iv-2011-000103:remark"/>
	</xsl:template>
	
	<!--
		Decode an assessment type to a human readable string. Empty and unknown values are shown as dash.
		@param value the assessment type to be decoded
	-->
	<xsl:template name="decode-assessmentType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2011-000103.assessmentType.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2011-000103.assessmentType.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2011-000103.assessmentType.3"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2011-000103.assessmentType.4"/></xsl:when>
			<xsl:when test="$trimmed-value = '5'"><xsl:value-of select="$eahv-iv-2011-000103.assessmentType.5"/></xsl:when>
			<xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eahv-iv-2011-000103.assessmentType.10"/></xsl:when>
			<xsl:when test="$trimmed-value = '11'"><xsl:value-of select="$eahv-iv-2011-000103.assessmentType.11"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:assessmentType">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.assessmentType"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-assessmentType">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Decode an assessment type to a human readable string. Empty and unknown values are shown as dash.
		@param value the assessment type to be decoded
	-->
	<xsl:template name="decode-reportType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2011-000103.reportType.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2011-000103.reportType.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2011-000103.reportType.4"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:reportType">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.reportType"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-reportType">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the taxpayer block. This is identical to the object block on cover sheet.
	-->
	<xsl:template match="eahv-iv-2011-000103:taxpayer[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.taxpayer"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-common:officialName"/>
								<xsl:apply-templates select="eahv-iv-common:firstName"/>
								<xsl:apply-templates select="eahv-iv-common:sex"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfBirth"/>
								<xsl:apply-templates select="eahv-iv-common:vn"/>
								<xsl:apply-templates select="eahv-iv-common:OtherPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:EuPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:address"/>
								<xsl:apply-templates select="eahv-iv-common:maritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfEntry"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfDeparture"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
		
	<!-- 
		Generate the basic data block for taxpayer
	-->
	<xsl:template match="eahv-iv-2011-000103:spBasicData[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.spBasicData"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2011-000103:employmentIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:incomeFromSelfEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:incomeInAgriculture"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:capital"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:assets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:nonDomesticIncomePresent"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:purchasingLPP"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:OASIBridgingPension"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the business data block for taxpayer
	-->
	<xsl:template match="eahv-iv-2011-000103:spBusinessData[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.spBusinessData"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2011-000103:commencementOfSelfEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:endOfSelfEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:mainIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:mainIncomeInAgriculture"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:mainIncomeInRealEstateTrade"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:partTimeEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:partTimeEmploymentInAgriculture"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:partTimeEmploymentInRealEstateTrade"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:realisationProfit"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:cooperativeShares"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:securitiesIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:otherIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessResidencyEntitlement"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:incomeRealEstate"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:debtInterest"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:donations"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessSecurities"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessCash"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessAssets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessRealEstateProperties"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:totalAssets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessDebts"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the private data block for taxpayer
	-->
	<xsl:template match="eahv-iv-2011-000103:spPrivateData[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.spPrivateData"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensions"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar1"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar2"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar3a"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar3b"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:annuities"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:otherPensions"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:militaryInsurancePensions"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:perDiemAllowance"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:maintenanceContribution"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:childAllowances"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:patentLicense"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateResidencyEntitlement"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateSecurities"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateCash"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:lifeInsurance"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:motorVehicle"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:inheritance"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:otherAssets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateRealEstateProperties"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:companyShares"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateDebts"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:taxableIncomeDBG"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:taxableIncomeExpenseTaxation"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the spouse block.
	-->
	<xsl:template match="eahv-iv-2011-000103:spouse[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.spouse"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-common:officialName"/>
								<xsl:apply-templates select="eahv-iv-common:firstName"/>
								<xsl:apply-templates select="eahv-iv-common:sex"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfBirth"/>
								<xsl:apply-templates select="eahv-iv-common:vn"/>
								<xsl:apply-templates select="eahv-iv-common:OtherPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:EuPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:address"/>
								<xsl:apply-templates select="eahv-iv-common:maritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfEntry"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfDeparture"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the basic data block for spouse
	-->
	<xsl:template match="eahv-iv-2011-000103:epBasicData[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.spBasicData"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2011-000103:employmentIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:incomeFromSelfEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:capital"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:assets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:nonDomesticIncomePresent"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:purchasingLPP"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:OASIBridgingPension"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the business data block for spouse
	-->
	<xsl:template match="eahv-iv-2011-000103:epBusinessData[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.spBusinessData"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2011-000103:commencementOfSelfEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:endOfSelfEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:mainIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:mainIncomeInAgriculture"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:mainIncomeInRealEstateTrade"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:partTimeEmployment"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:partTimeEmploymentInAgriculture"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:partTimeEmploymentInRealEstateTrade"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:realisationProfit"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:cooperativeShares"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:securitiesIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:otherIncome"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessResidencyEntitlement"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:incomeRealEstate"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:debtInterest"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:donations"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessSecurities"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessCash"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessAssets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessRealEstateProperties"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:totalAssets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:businessDebts"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the private data block for spouse
	-->
	<xsl:template match="eahv-iv-2011-000103:epPrivateData[*]">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.spPrivateData"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensions"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar1"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar2"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar3a"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:pensionsPillar3b"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:annuities"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:otherPensions"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:militaryInsurancePensions"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:perDiemAllowance"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:maintenanceContribution"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:childAllowances"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:patentLicense"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateResidencyEntitlement"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateSecurities"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateCash"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:lifeInsurance"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:motorVehicle"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:inheritance"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:otherAssets"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateRealEstateProperties"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:companyShares"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:privateDebts"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:taxableIncomeDBG"/>
								<xsl:apply-templates select="eahv-iv-2011-000103:taxableIncomeExpenseTaxation"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Message content, remarks
	-->
	<xsl:template match="eahv-iv-2011-000103:remark">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000103.remark"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- Helper templates for basic data -->
	
	<xsl:template match="eahv-iv-2011-000103:employmentIncome">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.employmentIncome"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:incomeFromSelfEmployment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.incomeFromSelfEmployment"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:pensionIncome">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.pensionIncome"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:incomeInAgriculture">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.incomeInAgriculture"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:capital">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.capital"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:assets">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.assets"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template name="decode-nonDomesticIncomePresent">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '0'"><xsl:value-of select="$eahv-iv-2011-000103.nonDomesticIncomePresent.0"/></xsl:when>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2011-000103.nonDomesticIncomePresent.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '-1'"><xsl:value-of select="$eahv-iv-2011-000103.nonDomesticIncomePresent.-1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:nonDomesticIncomePresent">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.nonDomesticIncomePresent"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="decode-nonDomesticIncomePresent">
						<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:purchasingLPP">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.purchasingLPP"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:OASIBridgingPension">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.OASIBridgingPension"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- Helper templates for business data -->
	
	<xsl:template match="eahv-iv-2011-000103:commencementOfSelfEmployment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.commencementOfSelfEmployment"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:endOfSelfEmployment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.endOfSelfEmployment"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="."/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:mainIncome">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.mainIncome"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:mainIncomeInAgriculture">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.mainIncomeInAgriculture"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:mainIncomeInRealEstateTrade">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.mainIncomeInRealEstateTrade"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:partTimeEmployment">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.partTimeEmployment"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:partTimeEmploymentInAgriculture">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.partTimeEmploymentInAgriculture"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:partTimeEmploymentInRealEstateTrade">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.partTimeEmploymentInRealEstateTrade"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:realisationProfit">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.realisationProfit"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:cooperativeShares">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.cooperativeShares"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:securitiesIncome">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.securitiesIncome"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:otherIncome">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.otherIncome"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:businessResidencyEntitlement">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.businessResidencyEntitlement"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:incomeRealEstate">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.incomeRealEstate"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:debtInterest">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.debtInterest"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:donations">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.donations"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:businessSecurities">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.businessSecurities"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:businessCash">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.businessCash"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:businessAssets">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.businessAssets"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:businessRealEstateProperties">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.businessRealEstateProperties"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:totalAssets">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.totalAssets"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:businessDebts">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.businessDebts"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!-- Helper templates for private data -->
	
	<xsl:template match="eahv-iv-2011-000103:pensions">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.pensions"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:pensionsPillar1">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.pensionsPillar1"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:pensionsPillar2">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.pensionsPillar2"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:pensionsPillar3a">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.pensionsPillar3a"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:pensionsPillar3b">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.pensionsPillar3b"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:annuities">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.annuities"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:otherPensions">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.otherPensions"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:militaryInsurancePensions">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.militaryInsurancePensions"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:perDiemAllowance">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.perDiemAllowance"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:maintenanceContribution">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.maintenanceContribution"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:childAllowances">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.childAllowances"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:patentLicense">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.patentLicense"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:privateResidencyEntitlement">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.privateResidencyEntitlement"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:privateSecurities">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.privateSecurities"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:privateCash">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.privateCash"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:lifeInsurance">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.lifeInsurance"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:motorVehicle">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.motorVehicle"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:inheritance">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.inheritance"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:otherAssets">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.otherAssets"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:privateRealEstateProperties">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.privateRealEstateProperties"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:companyShares">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.companyShares"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:privateDebts">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.privateDebts"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:taxableIncomeDBG">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.taxableIncomeDBG"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000103:taxableIncomeExpenseTaxation">
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block><xsl:value-of select="$eahv-iv-2011-000103.taxableIncomeExpenseTaxation"/></fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="format-number(., $integer-format)"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
</xsl:stylesheet>