<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0007="http://www.ech.ch/xmlns/eCH-0007/3"
	xmlns:eCH-0010="http://www.ech.ch/xmlns/eCH-0010/3"
	xmlns:eCH-0044="http://www.ech.ch/xmlns/eCH-0044/1"
	xmlns:eahv-iv-common="http://www.eahv-iv.ch/xmlns/eahv-iv-common/1"
	xmlns:eahv-iv-2011-000101="http://www.eahv-iv.ch/xmlns/eahv-iv-2011-000101/3">
	
	<xsl:import href="../../eahv-iv-common/1/eahv-iv-common-1-2_it.xsl"/>
	<xsl:import href="2011-000101-language-3-0_it.xsl"/>
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"></xsl:param>
	
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="first-page">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$first-body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="first-page-header" extent="{$first-header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<fo:region-body region-name="page-body" margin-top="{$body-top-margin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:single-page-master-reference master-reference="first-page"/>
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<fo:static-content flow-name="page-header">
					<xsl:apply-templates select="//eahv-iv-2011-000101:header" mode="page-header"/>
				</fo:static-content>
				<fo:static-content flow-name="page-footer">
					<xsl:apply-templates select="//eahv-iv-2011-000101:header" mode="page-footer"/>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:apply-templates select="//eahv-iv-2011-000101:header" mode="message-header-block"/>
					<xsl:apply-templates select="//eahv-iv-2011-000101:header" mode="special-message"/>
					<xsl:apply-templates select="//eahv-iv-2011-000101:header" mode="page-header"/>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<xsl:if test="count(eahv-iv-2011-000101:message) > 0">
							<xsl:attribute name="page-break-after">always</xsl:attribute>
						</xsl:if>
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2011-000101:header"/>
						</fo:block>
					</fo:block>
					<fo:block background-color="{$grey-background}" font-family="{$font-family}">
						<fo:block background-color="white" margin-left="3mm" padding-left="4mm">
							<xsl:apply-templates select="//eahv-iv-2011-000101:content"/>
						</fo:block>
					</fo:block>
					<fo:block id="pageCounter" keep-with-previous="always"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
		Fixed header block on page one
	-->
	<xsl:template match="eahv-iv-2011-000101:header" mode="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block margin-left="7mm" margin-top="1mm" font-weight="bold">
								<xsl:value-of select="$eahv-iv-common"/> | <xsl:value-of select="$eahv-iv-2011-000101"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.eahv-iv.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:block background-color="white" margin-top="3mm" margin-left="3mm">
				<fo:block margin-top="4mm" margin-left="4mm">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="{$header-left-column-width}" column-number="1"/>
						<fo:table-column column-width="{$header-right-column-width}" column-number="2"/>
						<fo:table-body>
							<fo:table-row>
								<!-- left column, show sender, recipient and local reference -->
								<fo:table-cell column-number="1" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.senderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id"><xsl:value-of select="eahv-iv-2011-000101:senderId"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.recipientId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:for-each select="eahv-iv-2011-000101:recipientId">
															<xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
															<xsl:call-template name="decode-sedex-id">
																<xsl:with-param name="id"><xsl:value-of select="."/></xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.messageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value"><xsl:value-of select="eahv-iv-2011-000101:messageDate"/></xsl:with-param>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.declarationLocalReference"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="eahv-iv-2011-000101:declarationLocalReference" mode="block"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>

											<!-- Rücksende-Adresse Start -->
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.postalAddress"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:apply-templates select="eahv-iv-2011-000101:postalAddress" />
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<!-- Rücksende-Adresse Ende -->
											
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
								<!-- right column, shows other header details -->
								<fo:table-cell column-number="2" margin-left="0mm">
									<fo:table table-layout="fixed" width="100%" border-collapse="separate">
										<fo:table-column column-width="38mm" column-number="1"/>
										<fo:table-column column-width="47mm" column-number="2"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.action"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-action">
															<xsl:with-param name="value" select="eahv-iv-2011-000101:action"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.originalSenderId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="decode-sedex-id">
															<xsl:with-param name="id" select="eahv-iv-2011-000101:originalSenderId"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.initialMessageDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2011-000101:initialMessageDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2011-000101:ourBusinessReferenceID"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><xsl:value-of select="eahv-iv-2011-000101:yourBusinessReferenceId"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.eventDate"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-date">
															<xsl:with-param name="value" select="eahv-iv-2011-000101:eventDate"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.eventPeriod"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:call-template name="format-string">
															<xsl:with-param name="value" select="eahv-iv-2011-000101:eventPeriod"/>
														</xsl:call-template>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-common.pages"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block><fo:page-number-citation ref-id="pageCounter"/></fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell column-number="1" xsl:use-attribute-sets="header-denom-column">
													<fo:block><xsl:value-of select="$eahv-iv-2011-000101.attachment"/></fo:block>
												</fo:table-cell>
												<fo:table-cell column-number="2" xsl:use-attribute-sets="header-value-column">
													<fo:block>
														<xsl:value-of select="count(eahv-iv-2011-000101:attachment)"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:block>
		</fo:block>
	</xsl:template>
	
	<!--
		Collaborator block within message header block
	-->
	<xsl:template match="eahv-iv-2011-000101:declarationLocalReference" mode="block">
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:name"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:department"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>T:
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:phone"/>
			</xsl:call-template>
		</fo:block>
		<fo:block>
			<xsl:call-template name="format-string">
				<xsl:with-param name="value" select="eahv-iv-common:email"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>
	
	<!--
		Conditional "Alert" if there is something special about this message
	-->
	<xsl:template match="eahv-iv-2011-000101:header" mode="special-message">
		<xsl:variable name="is-test" select="(eahv-iv-2011-000101:testDeliveryFlag = '1') or (eahv-iv-2011-000101:testDeliveryFlag = 'true')"/>
		<xsl:variable name="is-special" select="eahv-iv-2011-000101:action != 1 and eahv-iv-2011-000101:action != 5 and eahv-iv-2011-000101:action != 6"/>
		<xsl:variable name="is-priority" select="eahv-iv-2011-000101:messagePriority > 0"/>
		<xsl:if test="$is-test or $is-special or $is-priority">
			<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
				<xsl:if test="$is-special">
					<xsl:call-template name="decode-action">
						<xsl:with-param name="value" select="eahv-iv-2011-000101:action"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$is-priority">
					<xsl:if test="$is-special">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat($eahv-iv-2011-000101.messagePriority, ': ')"/>
					<xsl:value-of select="eahv-iv-2011-000101:messagePriority"/>
				</xsl:if>
				<xsl:if test="$is-test">
					<xsl:if test="($is-special or $is-priority)">
						<xsl:text> | </xsl:text>
					</xsl:if>
					<xsl:value-of select="concat(' ** ', $eahv-iv-2011-000101.testDeliveryFlag, ' ** ')"/>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	
	<!--
		Cover sheet: further information from the header part of the message
	-->
	<xsl:template match="eahv-iv-2011-000101:header">
		<xsl:apply-templates select="eahv-iv-2011-000101:object"/>
		<xsl:apply-templates select="eahv-iv-2011-000101:comment"/>
	</xsl:template>
	
	<!--
		Cover sheet: object field from the message header
	-->
	<xsl:template match="eahv-iv-2011-000101:object">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000101.object"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-common:officialName"/>
								<xsl:apply-templates select="eahv-iv-common:firstName"/>
								<xsl:apply-templates select="eahv-iv-common:sex"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfBirth"/>
								<xsl:apply-templates select="eahv-iv-common:vn"/>
								<xsl:apply-templates select="eahv-iv-common:OtherPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:EuPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:address"/>
								<xsl:apply-templates select="eahv-iv-common:maritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfEntry"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfDeparture"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Cover sheet: comment
	-->
	<xsl:template match="eahv-iv-2011-000101:comment">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000101.comment"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block linefeed-treatment="preserve">
							<xsl:value-of select="."/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!--
		Page header, shows the message subject in a bar on first page and as header in subsequent pages.
	-->
	<xsl:template mode="page-header" match="eahv-iv-2011-000101:header">
		<fo:table background-color="{$grey-background}" table-layout="fixed" width="100%">
			<fo:table-column column-width="3mm" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell height="7mm" column-number="2" display-align="center">
						<fo:block margin-left="4mm" font-weight="bold" font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2011-000101:subject"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell height="4mm" background-color="white" column-number="2">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!--
		Page footer, shows page numbers and some info from message header.
	-->
	<xsl:template mode="page-footer" match="eahv-iv-2011-000101:header">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="170mm" column-number="1"/>
			<fo:table-column column-width="15mm" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="eahv-iv-2011-000101:messageType"/>/<xsl:value-of select="eahv-iv-2011-000101:subMessageType"/>
							| <xsl:value-of select="concat($eahv-iv-2011-000101.messageId, ' ')"/>
							<xsl:value-of select="eahv-iv-2011-000101:messageId"/>
							<xsl:if test="eahv-iv-2011-000101:referenceMessageId">
								| <xsl:value-of select="concat($eahv-iv-2011-000101.referenceMessageId, ' ')"/>
								<xsl:value-of select="eahv-iv-2011-000101:referenceMessageId"/>
							</xsl:if>
							<xsl:if test="eahv-iv-2011-000101:businessProcessId">
								| <xsl:value-of select="concat($eahv-iv-2011-000101.businessProcessId, ' ')"/>
								<xsl:value-of select="eahv-iv-2011-000101:businessProcessId"/>
							</xsl:if>
							| <xsl:value-of select="concat($eahv-iv-common.dateOfReceipt, ' ')"/> 
							<xsl:call-template name="format-date">
								<xsl:with-param name="value"><xsl:value-of select="$dateOfReceipt"/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		****************  Message content starts here ***************
	 -->
	
	<!-- 
		"Main" template for the message content; shows all relevant content blocks
	-->
	<xsl:template match="eahv-iv-2011-000101:content">
		<xsl:apply-templates select="eahv-iv-2011-000101:orderScope"/>
		<xsl:apply-templates select="eahv-iv-2011-000101:taxpayer"/>
		<xsl:apply-templates select="eahv-iv-2011-000101:spouse"/>
	</xsl:template>
	
	<!--
		Decode an assessment type to a human readable string. Empty and unknown values are shown as dash.
		@param value the assessment type to be decoded
	-->
	<xsl:template name="decode-orderScope">
		<xsl:param name="value"/>
		<xsl:variable name="main-choice" select="$value mod 8"/>
		<xsl:variable name="supp-choice" select="$value - $main-choice"/>
		<xsl:choose>
			<xsl:when test="$main-choice = -1">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.-1"/>
			</xsl:when>
			<xsl:when test="$main-choice = 1">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.1"/>
			</xsl:when>
			<xsl:when test="$main-choice = 2">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.2"/>
			</xsl:when>
			<xsl:when test="$main-choice = 3">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.1"/>, <xsl:value-of select="$eahv-iv-2011-000101.orderScope.2"/>
			</xsl:when>
			<xsl:when test="$main-choice = 4">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.4"/>
			</xsl:when>
			<xsl:when test="$main-choice = 5">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.1"/>, <xsl:value-of select="$eahv-iv-2011-000101.orderScope.4"/>
			</xsl:when>
			<xsl:when test="$main-choice = 6">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.2"/>, <xsl:value-of select="$eahv-iv-2011-000101.orderScope.4"/>
			</xsl:when>
			<xsl:when test="$main-choice = 7">
				<xsl:value-of select="$eahv-iv-2011-000101.orderScope.1"/>, <xsl:value-of select="$eahv-iv-2011-000101.orderScope.2"/>, <xsl:value-of select="$eahv-iv-2011-000101.orderScope.4"/>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$supp-choice = 8">
				<xsl:value-of select="concat(', ', $eahv-iv-2011-000101.orderScope.8)"/>
			</xsl:when>
			<xsl:when test="$supp-choice = 16">
				<xsl:value-of select="concat(', ', $eahv-iv-2011-000101.orderScope.16)"/>
			</xsl:when>
			<xsl:when test="$supp-choice = 24">
				<xsl:value-of select="concat(', ', $eahv-iv-2011-000101.orderScope.8)"/><xsl:value-of select="concat(', ', $eahv-iv-2011-000101.orderScope.16)"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="eahv-iv-2011-000101:orderScope">
		<fo:table table-layout="fixed" width="100%" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000101.orderScope"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:block>
							<xsl:call-template name="decode-orderScope">
								<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<!-- 
		Generate the taxpayer block. This is identical to the object block on cover sheet.
	-->
	<xsl:template match="eahv-iv-2011-000101:taxpayer">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block><xsl:value-of select="$eahv-iv-2011-000101.taxpayer"/></fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:apply-templates select="eahv-iv-common:officialName"/>
								<xsl:apply-templates select="eahv-iv-common:firstName"/>
								<xsl:apply-templates select="eahv-iv-common:sex"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfBirth"/>
								<xsl:apply-templates select="eahv-iv-common:vn"/>
								<xsl:apply-templates select="eahv-iv-common:OtherPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:EuPersonId"/>
								<xsl:apply-templates select="eahv-iv-common:address"/>
								<xsl:apply-templates select="eahv-iv-common:maritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfMaritalStatus"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfEntry"/>
								<xsl:apply-templates select="eahv-iv-common:dateOfDeparture"/>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
		
	<!-- 
		Generate the spouse block.
	-->
	<xsl:template match="eahv-iv-2011-000101:spouse">
		<xsl:if test="*">
			<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
				<fo:table-column column-width="{$title-column-width}" column-number="1"/>
				<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
							<fo:block><xsl:value-of select="$eahv-iv-2011-000101.spouse"/></fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
							<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
								<fo:table-column column-width="{$description-column-width}" column-number="1"/>
								<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
								<fo:table-body>
									<xsl:apply-templates select="eahv-iv-common:officialName"/>
									<xsl:apply-templates select="eahv-iv-common:firstName"/>
									<xsl:apply-templates select="eahv-iv-common:sex"/>
									<xsl:apply-templates select="eahv-iv-common:dateOfBirth"/>
									<xsl:apply-templates select="eahv-iv-common:vn"/>
									<xsl:apply-templates select="eahv-iv-common:OtherPersonId"/>
									<xsl:apply-templates select="eahv-iv-common:EuPersonId"/>
									<xsl:apply-templates select="eahv-iv-common:address"/>
									<xsl:apply-templates select="eahv-iv-common:maritalStatus"/>
									<xsl:apply-templates select="eahv-iv-common:dateOfMaritalStatus"/>
									<xsl:apply-templates select="eahv-iv-common:dateOfEntry"/>
									<xsl:apply-templates select="eahv-iv-common:dateOfDeparture"/>
								</fo:table-body>
							</fo:table>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</xsl:if>
	</xsl:template>

	<!-- Template für die Erweiterung des Headers um die Rücksendeadresse -->
	<xsl:template match="eahv-iv-2011-000101:postalAddress" >
		<xsl:apply-templates select="eCH-0010:organisation"/>
		<xsl:apply-templates select="eCH-0010:addressInformation"/>
	</xsl:template>

	<xsl:template match="eCH-0010:organisation">
		<xsl:if test="eCH-0010:organisationName">
			<fo:block>
				<xsl:call-template name="format-string">
					<xsl:with-param name="value" select="eCH-0010:organisationName"/>
				</xsl:call-template>
			</fo:block>
		</xsl:if>
		<xsl:if test="eCH-0010:organisationNameAddOn1">
			<fo:block>
				<xsl:call-template name="format-string">
					<xsl:with-param name="value" select="eCH-0010:organisationNameAddOn1"/>
				</xsl:call-template>
			</fo:block>
		</xsl:if>
		<xsl:if test="eCH-0010:organisationNameAddOn2">
			<fo:block>
				<xsl:call-template name="format-string">
					<xsl:with-param name="value" select="eCH-0010:organisationNameAddOn2"/>
				</xsl:call-template>
			</fo:block>
		</xsl:if>
		<fo:block>
			<xsl:if test="eCH-0010:title">
				<xsl:value-of select="concat(eCH-0010:title, ' ')"/>
			</xsl:if>
			<xsl:if test="eCH-0010:firstName">
				<xsl:value-of select="concat(eCH-0010:firstName, ' ')"/>
			</xsl:if>
			<xsl:if test="eCH-0010:lastName">
				<xsl:value-of select="eCH-0010:lastName"/>
			</xsl:if>
		</fo:block>
	</xsl:template>

	<xsl:template match="eCH-0010:addressInformation">
		<xsl:apply-templates select="eCH-0010:addressLine1" mode="block"/>
		<xsl:apply-templates select="eCH-0010:addressLine2" mode="block"/>
		<xsl:apply-templates select="eCH-0010:street" mode="block"/>
		<xsl:apply-templates select="eCH-0010:postOfficeBoxText" mode="block"/>
		<xsl:apply-templates select="eCH-0010:locality" mode="block"/>
		<xsl:apply-templates select="eCH-0010:town" mode="block"/>		
	</xsl:template>
		
</xsl:stylesheet>