<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:eCH-0097="http://www.ech.ch/xmlns/eCH-0097/1">
	
	<xsl:import href="ech-0097-language-1-0_de.xsl"/>
	
	<!--
		Decode an organisationIdCategory to a human readable string.
		@param value the organisationIdCategory to be decoded
	-->
	<xsl:template name="decode-organisationIdCategory">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'CH.UID'"><xsl:value-of select="$eCH-0097.organisationIdCategory.CH.UID"/></xsl:when>
			<xsl:when test="$trimmed-value = 'CH.BUR'"><xsl:value-of select="$eCH-0097.organisationIdCategory.CH.BUR"/></xsl:when>
			<xsl:when test="$trimmed-value = 'CH.FTANbr'"><xsl:value-of select="$eCH-0097.organisationIdCategory.CH.FTANbr"/></xsl:when>
			<xsl:when test="$trimmed-value = 'CH.SHAB'"><xsl:value-of select="$eCH-0097.organisationIdCategory.CH.SHAB"/></xsl:when>
			<xsl:when test="$trimmed-value = 'CH.MWST'"><xsl:value-of select="$eCH-0097.organisationIdCategory.CH.MWST"/></xsl:when>
			<xsl:when test="$trimmed-value = 'CH.HR'"><xsl:value-of select="$eCH-0097.organisationIdCategory.CH.HR"/></xsl:when>
			<xsl:when test="$trimmed-value = 'CH.AGIS'"><xsl:value-of select="$eCH-0097.organisationIdCategory.CH.AGIS"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!--
		Decode an legalForm to a human readable string.
		@param value the legalForm to be decoded
	-->
	<xsl:template name="decode-legalForm">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '01'"><xsl:value-of select="$eCH-0097.legalForm.01"/></xsl:when>
			<xsl:when test="$trimmed-value = '0101'"><xsl:value-of select="$eCH-0097.legalForm.0101"/></xsl:when>
			<xsl:when test="$trimmed-value = '0102'"><xsl:value-of select="$eCH-0097.legalForm.0102"/></xsl:when>
			<xsl:when test="$trimmed-value = '0103'"><xsl:value-of select="$eCH-0097.legalForm.0103"/></xsl:when>
			<xsl:when test="$trimmed-value = '0104'"><xsl:value-of select="$eCH-0097.legalForm.0104"/></xsl:when>
			<xsl:when test="$trimmed-value = '0105'"><xsl:value-of select="$eCH-0097.legalForm.0105"/></xsl:when>
			<xsl:when test="$trimmed-value = '0106'"><xsl:value-of select="$eCH-0097.legalForm.0106"/></xsl:when>
			<xsl:when test="$trimmed-value = '0107'"><xsl:value-of select="$eCH-0097.legalForm.0107"/></xsl:when>
			<xsl:when test="$trimmed-value = '0108'"><xsl:value-of select="$eCH-0097.legalForm.0108"/></xsl:when>
			<xsl:when test="$trimmed-value = '0109'"><xsl:value-of select="$eCH-0097.legalForm.0109"/></xsl:when>
			<xsl:when test="$trimmed-value = '0110'"><xsl:value-of select="$eCH-0097.legalForm.0110"/></xsl:when>
			<xsl:when test="$trimmed-value = '0114'"><xsl:value-of select="$eCH-0097.legalForm.0114"/></xsl:when>
			<xsl:when test="$trimmed-value = '0115'"><xsl:value-of select="$eCH-0097.legalForm.0115"/></xsl:when>
			<xsl:when test="$trimmed-value = '0116'"><xsl:value-of select="$eCH-0097.legalForm.0116"/></xsl:when>
			<xsl:when test="$trimmed-value = '0117'"><xsl:value-of select="$eCH-0097.legalForm.0117"/></xsl:when>
			<xsl:when test="$trimmed-value = '0118'"><xsl:value-of select="$eCH-0097.legalForm.0118"/></xsl:when>
			<xsl:when test="$trimmed-value = '0119'"><xsl:value-of select="$eCH-0097.legalForm.0119"/></xsl:when>
			<xsl:when test="$trimmed-value = '02'"><xsl:value-of select="$eCH-0097.legalForm.02"/></xsl:when>
			<xsl:when test="$trimmed-value = '0220'"><xsl:value-of select="$eCH-0097.legalForm.0220"/></xsl:when>
			<xsl:when test="$trimmed-value = '0220'"><xsl:value-of select="$eCH-0097.legalForm.0220"/></xsl:when>
			<xsl:when test="$trimmed-value = '0221'"><xsl:value-of select="$eCH-0097.legalForm.0221"/></xsl:when>
			<xsl:when test="$trimmed-value = '0222'"><xsl:value-of select="$eCH-0097.legalForm.0222"/></xsl:when>
			<xsl:when test="$trimmed-value = '0223'"><xsl:value-of select="$eCH-0097.legalForm.0223"/></xsl:when>
			<xsl:when test="$trimmed-value = '0224'"><xsl:value-of select="$eCH-0097.legalForm.0224"/></xsl:when>
			<xsl:when test="$trimmed-value = '0225'"><xsl:value-of select="$eCH-0097.legalForm.0225"/></xsl:when>
			<xsl:when test="$trimmed-value = '0230'"><xsl:value-of select="$eCH-0097.legalForm.0230"/></xsl:when>
			<xsl:when test="$trimmed-value = '0231'"><xsl:value-of select="$eCH-0097.legalForm.0231"/></xsl:when>
			<xsl:when test="$trimmed-value = '0232'"><xsl:value-of select="$eCH-0097.legalForm.0232"/></xsl:when>
			<xsl:when test="$trimmed-value = '0233'"><xsl:value-of select="$eCH-0097.legalForm.0233"/></xsl:when>
			<xsl:when test="$trimmed-value = '0234'"><xsl:value-of select="$eCH-0097.legalForm.0234"/></xsl:when>
			<xsl:when test="$trimmed-value = '03'"><xsl:value-of select="$eCH-0097.legalForm.03"/></xsl:when>
			<xsl:when test="$trimmed-value = '0311'"><xsl:value-of select="$eCH-0097.legalForm.0311"/></xsl:when>
			<xsl:when test="$trimmed-value = '0312'"><xsl:value-of select="$eCH-0097.legalForm.0312"/></xsl:when>
			<xsl:when test="$trimmed-value = '0313'"><xsl:value-of select="$eCH-0097.legalForm.0313"/></xsl:when>
			<xsl:when test="$trimmed-value = '0327'"><xsl:value-of select="$eCH-0097.legalForm.0327"/></xsl:when>
			<xsl:when test="$trimmed-value = '0328'"><xsl:value-of select="$eCH-0097.legalForm.0328"/></xsl:when>
			<xsl:when test="$trimmed-value = '0329'"><xsl:value-of select="$eCH-0097.legalForm.0329"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 
		Generate a uid inline.
	-->
	<xsl:template match="eCH-0097:uid" mode="inline">	
		<xsl:value-of select="eCH-0097:uidOrganisationIdCategorie"/>
		<xsl:value-of select="eCH-0097:uidOrganisationId"/>
	</xsl:template>
	

</xsl:stylesheet>