<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:sd="http://www.swissdec.ch/schema/sd/20200220/SalaryDeclaration" xmlns:ct="http://www.swissdec.ch/schema/sd/20200220/SalaryDeclarationContainer" xmlns:tns="http://www.swissdec.ch/schema/sd/20200220/SalaryDeclarationServiceTypes" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:import href="elm-qst-2-2-language_de.xsl"/>
	<xsl:import href="elm-qst-common-2-2_de.xsl"/>
	<!--
	###################################################################################################
	# PLEASE UPDATE THE VERSION VARIABLE AFTER EACH CHANGES TO THIS FILE:							 #
	# Format is, [filename-version], [yyyy-mm-dd]													 #
	###################################################################################################
	-->
	<xsl:variable name="stylesheet.version" select="'2-2, 2022-10-24'"/>
	<!--
		Parameter receipt date to be passed in when creating the message layout.
		This must be a valid xs:date
	-->
	<xsl:param name="dateOfReceipt"/>
	<!-- DeclareSalaryConsumer or DeclareSalary for itserve files ON THE FIRST ONLY-->
	<xsl:variable name="company" select="/*[local-name()='DeclareSalaryConsumer']/*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']"/>
	<xsl:variable name="sslNumber" select="$company/*[local-name()='Institutions']/*[local-name()='TaxAtSource']/*[local-name()='CustomerIdentity']"/>
	<!-- Es sind nur Personen aufzuführen, welche unter TaxAtSourceSalary/Current bzw. TaxAtSourceSalary/Correction einen Eintrag haben. 
		  Personen welche nur historisierte Daten (TaxAtSourceSalary/History) bzw. Rekapitulationen (TaxAtSourceSalary/Recapitulation) aufweisen sind nicht aufzuführen.	
		  Alle Personen mit mindestens einer Korrektur und oder EMA und oder vorhandenem Austritt (<Work><WithdrawalDate>) sind in der ersten Tabelle aufzuführen. -->
	<xsl:variable name="personswithcorrection" select="$company/*[local-name()='Staff']/*[local-name()='Person' and (descendant::*[local-name()='Correction'] or descendant::*[local-name()='Current']/*[local-name()='DeclarationCategory'] or descendant::*[local-name()='Work']/*[local-name()='WithdrawalDate']) and (descendant::*[local-name()='Current'] or descendant::*[local-name()='Correction'])]"/>
	<xsl:variable name="personswithoutcorrection" select="$company/*[local-name()='Staff']/*[local-name()='Person' and not (descendant::*[local-name()='Correction'] or descendant::*[local-name()='Current']/*[local-name()='DeclarationCategory'] or descendant::*[local-name()='Work']/*[local-name()='WithdrawalDate']) and (descendant::*[local-name()='Current'] or descendant::*[local-name()='Correction'])]"/>
	<xsl:variable name="personswithcorrectionSalary" select="$personswithcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='TaxAtSourceCode']]]"/>
	<xsl:variable name="personswithoutcorrectionSalary" select="$personswithoutcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='TaxAtSourceCode']]]"/>
	<xsl:variable name="personswithcorrectionHonoraryBoardOfDirectors" select="$personswithcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='HEY' or *[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='HEN']]]"/>
	<xsl:variable name="personswithoutcorrectionHonoraryBoardOfDirectors" select="$personswithoutcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='HEY' or *[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='HEN']]]"/>
	<xsl:variable name="personswithcorrectionMonetaryValuesServices" select="$personswithcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='MEY'] or *[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='MEN']]"/>
	<xsl:variable name="personswithoutcorrectionMonetaryValuesServices" select="$personswithoutcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='MEY'] or *[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='MEN']]"/>
	<xsl:variable name="personswithcorrectionCategoryOpen" select="$personswithcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryOpen']]]"/>
	<xsl:variable name="personswithoutcorrectionCategoryOpen" select="$personswithoutcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryOpen']]]"/>
	<xsl:variable name="personswithCategoryOpen" select="$company/*[local-name()='Staff']/*[local-name()='Person' and (descendant::*[local-name()='Current' or local-name()='Correction' or local-name()='History']//*[local-name()='CategoryOpen'])]"/>
	<xsl:variable name="personswithcorrectionSpecialAgreement" select="$personswithcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='SFN']]"/>
	<xsl:variable name="personswithoutcorrectionSpecialAgreement" select="$personswithoutcorrection[*[descendant::*[local-name()='Current' or local-name()='Correction']//*[local-name()='CategoryPredefined']='SFN']]"/>
	<xsl:variable name="personsWithSpecialAgreement" select="$company/*[local-name()='Staff']/*[local-name()='Person' and (descendant::*[local-name()='Current' or local-name()='Correction' or local-name()='History']//*[local-name()='CategoryPredefined']='SFN')]"/>
	<!-- Sämtliche Personen mit EMA und oder mit vorhandenem Austrittsdatum sind aufzuführen. Hinweis: Dies entspricht somit nicht 1:1 der Personen in der ersten Tabelle (im Unterschied zur Tabelle werden Personen 
		welche nur Korrekturen besitzen aber keine EMA/Austrittsdatum besitzen nicht aufgeführt).
	SMCTESTING-514: Hinweis zu EMA-Angaben: Neu sollte auch dann ein Detailausdruck erzeugt werden, wenn es eine rückwirkende EMA-Angabe für einen alten Monat gibt. Konkret heisst das, dass es im angehängten Beispiel auch einen Ausdruck für Boletto, Franca geben sollte.
	-->
	<xsl:variable name="personswithcorrectiondetails" select="$company/*[local-name()='Staff']/*[local-name()='Person' and (descendant::*[local-name()='Current']/*[local-name()='DeclarationCategory'] or descendant::*[local-name()='Correction']/*[local-name()='New']/*[local-name()='DeclarationCategory'] or descendant::*[local-name()='Work']/*[local-name()='WithdrawalDate']) and (descendant::*[local-name()='Current'] or descendant::*[local-name()='New'])]"/>
	<xsl:variable name="accountPeriod">
		<xsl:call-template name="format-month">
			<xsl:with-param name="value" select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxAtSourceTotals']/*[local-name()='TotalMonth']/*[local-name()='CurrentMonth']"/>
			<xsl:with-param name="delimiter" select="'-'"/>
			<xsl:with-param name="yearDigits" select="4"/>
		</xsl:call-template>
	</xsl:variable>
	<!-- keys are used to find distinct value in combination with generate-id, so we can group the entries (variables are not accepted inside the match attribute, so we had to repeat the path). 
see http://stackoverflow.com/questions/2291567/how-to-use-xslt-to-create-distinct-values 
grouping and sorting: see "Grouping Nodes" http://docstore.mik.ua/orelly/xml/xslt/ch06_02.htm-->
	<xsl:key use="." match="/*[local-name()='DeclareSalaryConsumer']/*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='Staff']/*[local-name()='Person']/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']/*[local-name()='Month']" name="correctionMonth"/>
	<xsl:key use="." match="/*[local-name()='DeclareSalaryConsumer']/*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='Staff']/*[local-name()='Person']/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='CorrectionConfirmed']/*[local-name()='Month']" name="correctionConfirmedMonth"/>
	<!--
		The main template, defining page masters, sequence masters and page sequence
	-->
	<xsl:template match="/">
		<!--<xsl:message>
			<xsl:copy-of select="$personswithcorrectionSalary"/>
		</xsl:message>-->
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages">
					<xsl:attribute name="page-height">210mm</xsl:attribute>
					<xsl:attribute name="page-width">297mm</xsl:attribute>
					<xsl:variable name="bodymargin">
						<xsl:choose>
							<xsl:when test="//*[local-name()='TestCase']">
								<xsl:value-of select="$body-top-margin-test"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$body-top-margin"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<fo:region-body region-name="page-body" margin-top="{$bodymargin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:simple-page-master margin="{$page-margins}" master-name="other-pages-details">
					<xsl:attribute name="page-height">297mm</xsl:attribute>
					<xsl:attribute name="page-width">210mm</xsl:attribute>
					<xsl:variable name="bodymargin">
						<xsl:choose>
							<xsl:when test="//*[local-name()='TestCase']">
								<xsl:value-of select="$body-top-margin-test"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$body-top-margin"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<fo:region-body region-name="page-body" margin-top="{$bodymargin}" margin-bottom="{$body-bottom-margin}"/>
					<fo:region-before region-name="page-header" extent="{$header-height}"/>
					<fo:region-after region-name="page-footer" extent="{$footer-height}"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="pages-content">
					<fo:repeatable-page-master-reference master-reference="other-pages"/>
				</fo:page-sequence-master>
				<fo:page-sequence-master master-name="pages-content-details">
					<fo:repeatable-page-master-reference master-reference="other-pages-details"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pages-content">
				<xsl:if test="//*[local-name()='TestCase']">
					<fo:static-content flow-name="page-header">
						<fo:block>
							<xsl:call-template name="testcase"/>
						</fo:block>
					</fo:static-content>
				</xsl:if>
				<fo:static-content flow-name="page-footer">
					<fo:block>
						<xsl:call-template name="page-footer">
							<xsl:with-param name="col1Width">
								<xsl:text>256mm</xsl:text>
							</xsl:with-param>
							<xsl:with-param name="col2Width">
								<xsl:text>15mm</xsl:text>
							</xsl:with-param>
						</xsl:call-template>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="page-body">
					<xsl:call-template name="message-header-block"/>
					<fo:block background-color="white" font-family="{$font-family}">
						<xsl:call-template name="overview"/>
						<!-- call-template name="personswithcorrection" kept as control -->
						<!--
						<xsl:call-template name="personswithcorrection">
							<xsl:with-param name="persons" select="$personswithcorrection"/>
							<xsl:with-param name="withCorrections" select="true()"/>
						</xsl:call-template>
-->
						<xsl:call-template name="personswithcorrectionSalary">
							<xsl:with-param name="persons" select="$personswithcorrectionSalary"/>
							<xsl:with-param name="withCorrections" select="true()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionHonoraryBoardOfDirectors">
							<xsl:with-param name="persons" select="$personswithcorrectionHonoraryBoardOfDirectors"/>
							<xsl:with-param name="withCorrections" select="true()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionMonetaryValuesServices">
							<xsl:with-param name="persons" select="$personswithcorrectionMonetaryValuesServices"/>
							<xsl:with-param name="withCorrections" select="true()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionSpecialAgreement">
							<xsl:with-param name="persons" select="$personswithcorrectionSpecialAgreement"/>
							<xsl:with-param name="withCorrections" select="true()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionCategoryOpen">
							<xsl:with-param name="persons" select="$personswithcorrectionCategoryOpen"/>
							<xsl:with-param name="withCorrections" select="true()"/>
						</xsl:call-template>
						<!-- call-template name="personswithcorrection" kept as control -->
						<!--
						<xsl:call-template name="personswithcorrection">
							<xsl:with-param name="persons" select="$personswithoutcorrection"/>
							<xsl:with-param name="withCorrections" select="false()"/>
						</xsl:call-template>
-->
						<xsl:call-template name="personswithcorrectionSalary">
							<xsl:with-param name="persons" select="$personswithoutcorrectionSalary"/>
							<xsl:with-param name="withCorrections" select="false()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionHonoraryBoardOfDirectors">
							<xsl:with-param name="persons" select="$personswithoutcorrectionHonoraryBoardOfDirectors"/>
							<xsl:with-param name="withCorrections" select="false()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionMonetaryValuesServices">
							<xsl:with-param name="persons" select="$personswithoutcorrectionMonetaryValuesServices"/>
							<xsl:with-param name="withCorrections" select="false()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionSpecialAgreement">
							<xsl:with-param name="persons" select="$personswithoutcorrectionSpecialAgreement"/>
							<xsl:with-param name="withCorrections" select="false()"/>
						</xsl:call-template>
						<xsl:call-template name="personswithcorrectionCategoryOpen">
							<xsl:with-param name="persons" select="$personswithoutcorrectionCategoryOpen"/>
							<xsl:with-param name="withCorrections" select="false()"/>
						</xsl:call-template>
					</fo:block>
					<xsl:if test="not($personswithcorrectiondetails)">
						<fo:block id="pageCounter" keep-with-previous="always"/>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
			<!--			<xsl:if test="$personsWithSpecialAgreement">
				<fo:page-sequence master-reference="pages-content">
					<xsl:if test="//*[local-name()='TestCase']">
						<fo:static-content flow-name="page-header">
							<fo:block>
								<xsl:call-template name="testcase"/>
							</fo:block>
						</fo:static-content>
					</xsl:if>
					<fo:static-content flow-name="page-footer">
						<fo:block>
							<xsl:call-template name="page-footer">
								<xsl:with-param name="col1Width">
									<xsl:text>256mm</xsl:text>
								</xsl:with-param>
								<xsl:with-param name="col2Width">
									<xsl:text>15mm</xsl:text>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:static-content>
					<fo:flow flow-name="page-body">
						<xsl:call-template name="message-header-frenchBorder-block"/>
						<fo:block background-color="white" font-family="{$font-family}">
							<xsl:call-template name="overviewFrenchBorderCrossers"/>
						</fo:block>
					</fo:flow>
				</fo:page-sequence>
			</xsl:if>-->
			<xsl:if test="$personswithcorrectiondetails">
				<fo:page-sequence master-reference="pages-content-details">
					<xsl:if test="//*[local-name()='TestCase']">
						<fo:static-content flow-name="page-header">
							<fo:block>
								<xsl:call-template name="testcase"/>
							</fo:block>
						</fo:static-content>
					</xsl:if>
					<fo:static-content flow-name="page-footer">
						<fo:block>
							<xsl:call-template name="page-footer">
								<xsl:with-param name="col1Width">
									<xsl:text>170mm</xsl:text>
								</xsl:with-param>
								<xsl:with-param name="col2Width">
									<xsl:text>15mm</xsl:text>
								</xsl:with-param>
							</xsl:call-template>
						</fo:block>
					</fo:static-content>
					<fo:flow flow-name="page-body">
						<fo:block background-color="white" font-family="{$font-family}">
							<xsl:call-template name="personswithcorrectiondetails"/>
						</fo:block>
						<fo:block id="pageCounter" keep-with-previous="always"/>
					</fo:flow>
				</fo:page-sequence>
			</xsl:if>
		</fo:root>
	</xsl:template>
	<!-- Conditional "Alert" if message is test -->
	<xsl:template name="testcase">
		<fo:block margin-left="0mm" padding="1mm" padding-left="7mm" padding-right="0mm" background-color="{$grey-background}" space-after="1mm" font-family="{$font-family}" font-weight="bold">
			<xsl:value-of select="concat(' ** ', $elm-qst.testDeliveryFlag, ' ** ')"/>
		</fo:block>
	</xsl:template>
	<!-- Page footer, shows page numbers and some info from message header. -->
	<xsl:template name="page-footer">
		<xsl:param name="col1Width"/>
		<xsl:param name="col2Width"/>
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="{$col1Width}" column-number="1"/>
			<fo:table-column column-width="{$col2Width}" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="footer">
						<fo:block font-family="{$font-family}">
							<xsl:value-of select="$elm-qst.sslNumber"/>: <xsl:value-of select="$sslNumber"/>
							|
							<xsl:value-of select="$elm-qst.accountPeriod"/>: <xsl:value-of select="$accountPeriod"/>
							|
							<xsl:value-of select="$elm-qst.transmissionDate"/>:
							<xsl:call-template name="format-datetime">
								<xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='TransmissionDate']"/>
							</xsl:call-template>
							| <xsl:value-of select="$elm-qst.stylesheet.version"/>: <xsl:value-of select="$stylesheet.version"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="footer" text-align="end">
						<fo:block font-family="{$font-family}">
							<fo:page-number/>/<fo:page-number-citation ref-id="pageCounter"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Fixed header block on page one -->
	<xsl:template name="message-header-block">
		<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block xsl:use-attribute-sets="header-block">
								<xsl:value-of select="$elm-qst"/> | <xsl:value-of select="$elm-qst.taxAtSource"/>
							</fo:block>
							<fo:block margin-left="7mm" margin-bottom="1mm" font-size="8pt">www.swissdec.ch</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<xsl:template name="message-header-frenchBorder-block">
		<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
			<fo:table table-layout="fixed" width="100%">
				<fo:table-column column-width="100%" column-number="1"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" display-align="center">
							<fo:block xsl:use-attribute-sets="header-block">
								<xsl:value-of select="$elm-qst"/> | <xsl:value-of select="$elm-qst.frenchBorderCrossersStart"/>
								<xsl:value-of select="(//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='SalaryTotals']/*[local-name()='TaxAtSourceTotals']/*[local-name()='TotalYear']/*[local-name()='Period']/*[local-name()='from'])"/>
								<xsl:value-of select="$elm-qst.to"/>
								<xsl:value-of select="(//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='SalaryTotals']/*[local-name()='TaxAtSourceTotals']/*[local-name()='TotalYear']/*[local-name()='Period']/*[local-name()='until'])"/>
								<xsl:text>)</xsl:text>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<!-- Overview page -->
	<xsl:template name="overview">
		<xsl:variable name="taxAtSourceTotal" select="(//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='SalaryTotals']/*[local-name()='TaxAtSourceTotals'])[1]"/>
		<xsl:variable name="taxAtSourceSalary" select="$company/*[local-name()='Staff']/*[local-name()='Person']/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']"/>
		<fo:block>
			<xsl:call-template name="company-section"/>
			<xsl:call-template name="contactperson-section"/>
			<xsl:if test="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']/*[local-name()='Delegate']">
				<xsl:call-template name="delegate-section"/>
			</xsl:if>
			<!--current month-->
			<xsl:if test="$taxAtSourceTotal">
				<xsl:call-template name="overviewqst-month-section">
					<xsl:with-param name="month" select="$taxAtSourceTotal/*[local-name()='TotalMonth']"/>
				</xsl:call-template>
			</xsl:if>
			<!--corrections-->
			<xsl:for-each select="$taxAtSourceSalary/*[local-name()='Correction']/*[local-name()='Month'][generate-id()
                                       = generate-id(key('correctionMonth',.)[1])]">
				<xsl:sort select="." order="descending"/>
				<xsl:variable name="monthIndex" select="."/>
				<!--<xsl:message>SORTED??<xsl:value-of select="."/></xsl:message>-->
				<xsl:call-template name="overviewqst-month-section">
					<xsl:with-param name="month" select="$taxAtSourceSalary/*[local-name()='Correction'][*[local-name()='Month']=$monthIndex]"/>
				</xsl:call-template>
			</xsl:for-each>
			<!-- billing relevant -->
			<xsl:if test="$taxAtSourceTotal">
				<xsl:call-template name="overviewqst-billing-relevant-section">
					<xsl:with-param name="month" select="$taxAtSourceTotal/*[local-name()='TotalMonth']"/>
					<xsl:with-param name="corrections" select="$taxAtSourceSalary/*[local-name()='Correction']"/>
				</xsl:call-template>
			</xsl:if>
			<!--correctionsConfirmed-->
			<xsl:for-each select="$taxAtSourceSalary/*[local-name()='CorrectionConfirmed']/*[local-name()='Month'][generate-id()
                                       = generate-id(key('correctionConfirmedMonth',.)[1])]">
				<xsl:sort select="." order="descending"/>
				<xsl:variable name="correctionMonthIndex" select="."/>
				<xsl:call-template name="overviewqst-correction-confirmed-section">
					<xsl:with-param name="month" select="$taxAtSourceSalary/*[local-name()='CorrectionConfirmed'][*[local-name()='Month']=$correctionMonthIndex]"/>
				</xsl:call-template>
			</xsl:for-each>
			<xsl:if test="$taxAtSourceTotal">
				<xsl:call-template name="overviewqst-total-section">
					<xsl:with-param name="taxAtSourceTotals" select="$taxAtSourceTotal"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="elm-section"/>
			<xsl:if test="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']">
				<xsl:call-template name="substitution-section"/>
			</xsl:if>
			<!-- Substitution Section -->
			<xsl:call-template name="substitution-section"/>
		</fo:block>
	</xsl:template>
	<!--French border crossers -->
	<xsl:template name="overviewFrenchBorderCrossers">
		<fo:block>
			<xsl:call-template name="company-section"/>
			<xsl:call-template name="contactperson-section"/>
			<xsl:call-template name="frenchBorderCrossers-data">
				<xsl:with-param name="people" select="$personsWithSpecialAgreement"/>
				<xsl:with-param name="noTarifColumn" select="false()"/>
			</xsl:call-template>
			<fo:block padding-top="5mm"/>
			<xsl:call-template name="frenchBorderCrossers-data-total">
				<xsl:with-param name="people" select="$personsWithSpecialAgreement"/>
			</xsl:call-template>
			<fo:block xsl:use-attribute-sets="helper-text">
				<xsl:value-of select="$elm-qst.tablecolumnexplanationFrenchBorderCrossers"/>
			</fo:block>
		</fo:block>
	</xsl:template>
	<xsl:template name="frenchBorderCrossers-data">
		<xsl:param name="people"/>
		<xsl:param name="noTarifColumn"/>
		<!-- Table itslef -->
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="proportional-column-width(2.5)" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(3.5)" column-number="2"/>
			<fo:table-column column-width="proportional-column-width(1.5)" column-number="3"/>
			<fo:table-column column-width="proportional-column-width(0.5)" column-number="4"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="5"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="6"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="7"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="8"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="9"/>
			<fo:table-header xsl:use-attribute-sets="table-header-row">
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.ahvNumber"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.name"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.dateOfBirthShort"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.countryAbr"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.zipCode"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.workplace"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.in"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.out"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-qst.qstLtotal"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-header>
			<fo:table-body>
				<xsl:for-each select="$people">
					<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
					<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>
					<fo:table-row xsl:use-attribute-sets="table-main-row">
						<xsl:call-template name="frenchBorderCrossers-personal-info">
							<xsl:with-param name="person" select="."/>
							<xsl:with-param name="company" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']"/>
						</xsl:call-template>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="frenchBorderCrossers-personal-info">
		<xsl:param name="person"/>
		<xsl:param name="company"/>
		<xsl:variable name="currentWorkplace">
			<xsl:choose>
				<xsl:when test="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']">
					<xsl:value-of select="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']/@workplaceIDRef"/>
				</xsl:when>
				<xsl:when test="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Recapitulation']">
					<xsl:value-of select="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Recapitulation']/@lastWorkplaceIDRef"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="ahv-number">
					<xsl:with-param name="insurance-identification" select="$person/*[local-name()='Particulars']/*[local-name()='Social-InsuranceIdentification']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='Particulars']/*[local-name()='Lastname']"/>, <xsl:value-of select="$person/*[local-name()='Particulars']/*[local-name()='Firstname']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="format-date">
					<xsl:with-param name="value" select="$person/*[local-name()='Particulars']/*[local-name()='DateOfBirth']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$person/*[local-name()='Particulars']/*[local-name()='Address']/*[local-name()='Country']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$company/*[local-name()='Workplace'][@workplaceID=$currentWorkplace]/*[local-name()='AddressExtended']/*[local-name()='ZIP-Code']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$company/*[local-name()='Workplace'][@workplaceID=$currentWorkplace]/*[local-name()='AddressExtended']/*[local-name()='City']"/>
			</fo:block>
		</fo:table-cell>
		<xsl:call-template name="frenchBorderCrossers-dates">
			<xsl:with-param name="person" select="$person"/>
		</xsl:call-template>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number(sum($person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Recapitulation']/*[local-name()='TaxableEarningCumulative']), $cents-format)"/>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<xsl:template name="frenchBorderCrossers-dates">
		<xsl:param name="person"/>
		<fo:table-cell>
			<fo:block>
				<xsl:choose>
					<xsl:when test="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']/*[local-name()='DeclarationCategory']/*[local-name()='Entry']">
						<xsl:call-template name="format-date">
							<xsl:with-param name="value" select="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']"/>
							<xsl:with-param name="yearDigits" select="2"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']/*[local-name()='New']/*[local-name()='DeclarationCategory']/*[local-name()='Entry']">
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']/*[local-name()='New']/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']"/>
								<xsl:with-param name="yearDigits" select="2"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:choose>
					<xsl:when test="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']">
						<xsl:call-template name="format-date">
							<xsl:with-param name="value" select="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']"/>
							<xsl:with-param name="yearDigits" select="2"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']/*[local-name()='New']/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']">
						<xsl:call-template name="format-date">
							<xsl:with-param name="value" select="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']/*[local-name()='New']/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']"/>
							<xsl:with-param name="yearDigits" select="2"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="format-date">
							<xsl:with-param name="value" select="$person/*[local-name()='Work']/*[local-name()='WithdrawalDate']"/>
							<xsl:with-param name="yearDigits" select="2"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<xsl:template name="frenchBorderCrossers-data-total">
		<xsl:param name="people"/>
		<!-- Table itslef -->
		<fo:table table-layout="fixed" width="50%">
			<fo:table-column column-width="proportional-column-width(1)" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-header xsl:use-attribute-sets="table-header-row">
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.totals"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<!--No header-->
					</fo:block>
				</fo:table-cell>
			</fo:table-header>
			<fo:table-body>
				<fo:table-row xsl:use-attribute-sets="table-main-row">
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$elm-qst.totalFrenchBorderCrossers"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block text-align="right">
							<xsl:value-of select="count($people)"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row xsl:use-attribute-sets="table-main-row">
					<fo:table-cell>
						<fo:block>
							<xsl:value-of select="$elm-qst.sumQSTLohns"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block text-align="right">
							<xsl:value-of select="format-number(sum($people/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Recapitulation']/*[local-name()='TaxableEarningCumulative']), $cents-format)"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Table with persions with correction or EMA -->
	<xsl:template name="personswithcorrection">
		<xsl:param name="persons"/>
		<xsl:param name="withCorrections" select="false()"/>
		<xsl:if test="$persons">
			<fo:block page-break-before="always">
				<!-- Header -->
				<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="100%" column-number="1"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell column-number="1" display-align="center">
									<fo:block xsl:use-attribute-sets="header-block">
										<xsl:value-of select="$elm-qst"/>
										<xsl:text> | </xsl:text>
										<xsl:choose>
											<xsl:when test="$withCorrections = true()">
												<xsl:value-of select="$elm-qst.salerydatawithcorrection"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$elm-qst.salerydatawithoutcorrection"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text>, </xsl:text>
										<xsl:value-of select="$elm-qst.accountPeriod"/>
										<xsl:text> </xsl:text>
										<xsl:value-of select="$accountPeriod"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<!-- Table itslef-->
				<xsl:call-template name="salerydata">
					<xsl:with-param name="persons" select="$persons"/>
					<xsl:with-param name="showEmplLevel" select="true()"/>
				</xsl:call-template>
				<fo:block xsl:use-attribute-sets="helper-text">
					<xsl:value-of select="$elm-qst.tablecolumnexplanation1"/>
				</fo:block>
				<xsl:if test="$withCorrections = true()">
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnentryreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnwithdrawalreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnmutationreason"/>
					</fo:block>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- Table with persions with correction or EMA Löhne-->
	<!-- TODO: table explanations text, check if we have to filter out when person -->
	<xsl:template name="personswithcorrectionSalary">
		<xsl:param name="persons"/>
		<xsl:param name="withCorrections" select="false()"/>
		<xsl:if test="$persons">
			<fo:block page-break-before="always">
				<!-- Header -->
				<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="100%" column-number="1"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell column-number="1" display-align="center">
									<fo:block xsl:use-attribute-sets="header-block">
										<xsl:value-of select="$elm-qst"/>
										<xsl:text> | </xsl:text>
										<xsl:choose>
											<xsl:when test="$withCorrections = true()">
												<xsl:value-of select="$elm-qst.salerydatawithcorrection"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$elm-qst.salerydatawithoutcorrection"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text>, </xsl:text>
										<xsl:value-of select="$elm-qst.accountPeriod"/>
										<xsl:text> </xsl:text>
										<xsl:value-of select="$accountPeriod"/>
										<xsl:text> - </xsl:text>
										<xsl:value-of select="$elm-qst.salerydataEarning"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<!-- Table itslef-->
				<xsl:call-template name="salerydata">
					<xsl:with-param name="persons" select="$persons"/>
					<xsl:with-param name="filter" select="taxableEarning"/>
					<xsl:with-param name="showEmplLevel" select="true()"/>
				</xsl:call-template>
				<fo:block xsl:use-attribute-sets="helper-text">
					<xsl:value-of select="$elm-qst.tablecolumnexplanation1"/>
				</fo:block>
				<xsl:if test="$withCorrections = true()">
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnentryreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnwithdrawalreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnmutationreason"/>
					</fo:block>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- Table with persions with correction or EMA Verwaltungsratshonorare VR -->
	<!-- TODO: table explanations text, check if we have to filter out when person has more than one tarif -->
	<xsl:template name="personswithcorrectionHonoraryBoardOfDirectors">
		<xsl:param name="persons"/>
		<xsl:param name="withCorrections" select="false()"/>
		<xsl:if test="$persons">
			<fo:block page-break-before="always">
				<!-- Header -->
				<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="100%" column-number="1"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell column-number="1" display-align="center">
									<fo:block xsl:use-attribute-sets="header-block">
										<xsl:value-of select="$elm-qst"/>
										<xsl:text> | </xsl:text>
										<xsl:choose>
											<xsl:when test="$withCorrections = true()">
												<xsl:value-of select="$elm-qst.salerydatawithcorrection"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$elm-qst.salerydatawithoutcorrection"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text>, </xsl:text>
										<xsl:value-of select="$elm-qst.accountPeriod"/>
										<xsl:text> </xsl:text>
										<xsl:value-of select="$accountPeriod"/>
										<xsl:text> - </xsl:text>
										<xsl:value-of select="$elm-qst.salerydataHonoraryBoardOfDirectors"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<!-- Table itslef-->
				<xsl:call-template name="salerydata">
					<xsl:with-param name="persons" select="$persons"/>
					<xsl:with-param name="filter" select="'HonoraryBoardOfDirectors'"/>
					<xsl:with-param name="noTarifColumn" select="false()"/>
				</xsl:call-template>
				<fo:block xsl:use-attribute-sets="helper-text">
					<xsl:value-of select="$elm-qst.tablecolumnexplanationNoTarif"/>
				</fo:block>
				<xsl:if test="$withCorrections = true()">
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnentryreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnwithdrawalreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnmutationreason"/>
					</fo:block>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- Table with persions with correction or EMA Geldwerte Leistungen (GWL) -->
	<!-- TODO: table explanations text, check if we have to filter out when person has more than one tarif -->
	<xsl:template name="personswithcorrectionMonetaryValuesServices">
		<xsl:param name="persons"/>
		<xsl:param name="withCorrections" select="false()"/>
		<xsl:if test="$persons">
			<fo:block page-break-before="always">
				<!-- Header -->
				<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="100%" column-number="1"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell column-number="1" display-align="center">
									<fo:block xsl:use-attribute-sets="header-block">
										<xsl:value-of select="$elm-qst"/>
										<xsl:text> | </xsl:text>
										<xsl:choose>
											<xsl:when test="$withCorrections = true()">
												<xsl:value-of select="$elm-qst.salerydatawithcorrection"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$elm-qst.salerydatawithoutcorrection"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text>, </xsl:text>
										<xsl:value-of select="$elm-qst.accountPeriod"/>
										<xsl:text> </xsl:text>
										<xsl:value-of select="$accountPeriod"/>
										<xsl:text> - </xsl:text>
										<xsl:value-of select="$elm-qst.salerydataMonetaryValuesServices"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<!-- Table itslef -->
				<xsl:call-template name="salerydata">
					<xsl:with-param name="persons" select="$persons"/>
					<xsl:with-param name="filter" select="'MonetaryValuesServices'"/>
					<xsl:with-param name="noTarifColumn" select="false()"/>
				</xsl:call-template>
				<fo:block xsl:use-attribute-sets="helper-text">
					<xsl:value-of select="$elm-qst.tablecolumnexplanationNoTarif"/>
				</fo:block>
				<xsl:if test="$withCorrections = true()">
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnentryreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnwithdrawalreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnmutationreason"/>
					</fo:block>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- Table with persions with correction or EMA Sonderveinbarung (SV) -->
	<!-- TODO: table explanations text, check if we have to filter out when person has more than one tarif -->
	<xsl:template name="personswithcorrectionSpecialAgreement">
		<xsl:param name="persons"/>
		<xsl:param name="withCorrections" select="false()"/>
		<xsl:if test="$persons">
			<fo:block page-break-before="always">
				<!-- Header -->
				<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="100%" column-number="1"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell column-number="1" display-align="center">
									<fo:block xsl:use-attribute-sets="header-block">
										<xsl:value-of select="$elm-qst"/>
										<xsl:text> | </xsl:text>
										<xsl:choose>
											<xsl:when test="$withCorrections = true()">
												<xsl:value-of select="$elm-qst.salerydatawithcorrection"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$elm-qst.salerydatawithoutcorrection"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text>, </xsl:text>
										<xsl:value-of select="$elm-qst.accountPeriod"/>
										<xsl:text> </xsl:text>
										<xsl:value-of select="$accountPeriod"/>
										<xsl:text> - </xsl:text>
										<xsl:value-of select="$elm-qst.salerydataSpecialAgreement"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<!-- Table itslef -->
				<xsl:call-template name="salerydata">
					<xsl:with-param name="persons" select="$persons"/>
					<xsl:with-param name="filter" select="'SpecialAgreement'"/>
					<xsl:with-param name="noTarifColumn" select="false()"/>
				</xsl:call-template>
				<fo:block xsl:use-attribute-sets="helper-text">
					<xsl:value-of select="$elm-qst.tablecolumnexplanationNoTarif"/>
				</fo:block>
				<xsl:if test="$withCorrections = true()">
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnentryreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnwithdrawalreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnmutationreason"/>
					</fo:block>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
		<!-- Table with persions with free text (Offene Kategorie - CategoryOpen) -->
	<!-- TODO: table explanations text, check if we have to filter out when person has more than one tarif -->
	<xsl:template name="personswithcorrectionCategoryOpen">
		<xsl:param name="persons"/>
		<xsl:param name="withCorrections" select="false()"/>
		<xsl:if test="$persons">
			<fo:block page-break-before="always">
				<!-- Header -->
				<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="100%" column-number="1"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell column-number="1" display-align="center">
									<fo:block xsl:use-attribute-sets="header-block">
										<xsl:value-of select="$elm-qst"/>
										<xsl:text> | </xsl:text>
										<xsl:choose>
											<xsl:when test="$withCorrections = true()">
												<xsl:value-of select="$elm-qst.salerydatawithcorrection"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$elm-qst.salerydatawithoutcorrection"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text>, </xsl:text>
										<xsl:value-of select="$elm-qst.accountPeriod"/>
										<xsl:text> </xsl:text>
										<xsl:value-of select="$accountPeriod"/>
										<xsl:text> - </xsl:text>
										<xsl:value-of select="$elm-qst.salerydataOffeneKategorie"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<!-- Table itslef -->
				<xsl:call-template name="salerydata">
					<xsl:with-param name="persons" select="$persons"/>
					<xsl:with-param name="filter" select="'CategoryOpen'"/>
					<xsl:with-param name="showEmplLevel" select="true()"/>
					<xsl:with-param name="noTarifColumn" select="false()"/>
				</xsl:call-template>
				<fo:block xsl:use-attribute-sets="helper-text">
					<xsl:value-of select="$elm-qst.tablecolumnexplanationNoTarif"/>
				</fo:block>
				<xsl:if test="$withCorrections = true()">
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnentryreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnwithdrawalreason"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="helper-text">
						<xsl:value-of select="$elm-qst.tablecolumnmutationreason"/>
					</fo:block>
				</xsl:if>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- Table with persons with correction or EMA or withdrawal date, these are the detail pages following the two tables -->
	<xsl:template name="personswithcorrectiondetails">
		<xsl:if test="$personswithcorrectiondetails">
			<xsl:for-each select="$personswithcorrectiondetails[./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']/*[local-name()='DeclarationCategory']/*[local-name()='Entry']]">
				<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
				<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>
				<fo:block page-break-before="always">
					<!-- Header -->
					<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="100%" column-number="1"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" display-align="center">
										<fo:block xsl:use-attribute-sets="header-block">
											<xsl:value-of select="$elm-qst"/>
											<xsl:text> | </xsl:text>
											<xsl:call-template name="person-title">
												<xsl:with-param name="person" select="."/>
											</xsl:call-template>
											<xsl:value-of select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
					<!-- Table itself -->
					<xsl:call-template name="company-section"/>
					<xsl:call-template name="contactperson-section"/>
					<xsl:call-template name="personal-details">
						<xsl:with-param name="particulars" select="./*[local-name()='Particulars']"/>
						<xsl:with-param name="additionalParticulars" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']"/>
					</xsl:call-template>
					<xsl:call-template name="occupation-data">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
					<xsl:call-template name="qst-data-new">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
					<xsl:if test="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='MarriagePartner']">
						<xsl:call-template name="marriage-partner">
							<xsl:with-param name="partner" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='MarriagePartner']"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:variable name="children" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='Children']"/>
					<xsl:if test="$children">
						<xsl:call-template name="children-data">
							<xsl:with-param name="person" select="."/>
							<xsl:with-param name="children" select="$children"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:call-template name="concubinage-data">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
					<xsl:call-template name="qst-data">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
				</fo:block>
			</xsl:for-each>
			<xsl:for-each select="$personswithcorrectiondetails[not(./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']/*[local-name()='DeclarationCategory']/*[local-name()='Entry'])]">
				<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
				<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>
				<fo:block page-break-before="always">
					<!-- Header -->
					<fo:block background-color="{$grey-background}" space-after="5mm" font-family="{$font-family}">
						<fo:table table-layout="fixed" width="100%">
							<fo:table-column column-width="100%" column-number="1"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" display-align="center">
										<fo:block xsl:use-attribute-sets="header-block">
											<xsl:value-of select="$elm-qst"/>
											<xsl:text> | </xsl:text>
											<xsl:call-template name="person-title">
												<xsl:with-param name="person" select="."/>
											</xsl:call-template>
											<xsl:value-of select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
					<!-- Table itself -->
					<xsl:call-template name="company-section"/>
					<xsl:call-template name="contactperson-section"/>
					<xsl:call-template name="personal-details">
						<xsl:with-param name="particulars" select="./*[local-name()='Particulars']"/>
						<xsl:with-param name="additionalParticulars" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']"/>
					</xsl:call-template>
					<xsl:call-template name="occupation-data">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
					<xsl:call-template name="qst-data-new">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
					<xsl:if test="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='MarriagePartner']">
						<xsl:call-template name="marriage-partner">
							<xsl:with-param name="partner" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='MarriagePartner']"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:variable name="children" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='Children']"/>
					<xsl:if test="$children">
						<xsl:call-template name="children-data">
							<xsl:with-param name="person" select="."/>
							<xsl:with-param name="children" select="$children"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:call-template name="concubinage-data">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
					<xsl:call-template name="qst-data">
						<xsl:with-param name="person" select="."/>
					</xsl:call-template>
				</fo:block>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template name="person-title">
		<xsl:param name="person"/>
		<xsl:variable name="work" select="$person/*[local-name()='Work']"/>
		<xsl:variable name="taxAtSourceSalaries" select="$person/*[local-name()='TaxAtSourceSalaries']"/>
		<xsl:variable name="currentTaxAtSourceSalary" select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
		<xsl:choose>
			<xsl:when test="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='Reason']">
				<xsl:value-of select="$elm-qst.entry"/>
				<xsl:text>: </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$elm-qst.mutationorexit"/>
				<xsl:text>: </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Table with salery data -->
	<xsl:template name="salerydata">
		<xsl:param name="persons"/>
		<xsl:param name="noTarifColumn"/>
		<xsl:param name="filter"/>
		<xsl:param name="showEmplLevel"/>
		<!-- Table itslef -->
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="proportional-column-width(2.5)" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(3.5)" column-number="2"/>
			<fo:table-column column-width="proportional-column-width(1.5)" column-number="3"/>
			<fo:table-column column-width="proportional-column-width(0.5)" column-number="4"/>
			<fo:table-column column-width="proportional-column-width(0.5)" column-number="5"/>
			<fo:table-column column-width="proportional-column-width(0.7)" column-number="6"/>
			<fo:table-column column-width="proportional-column-width(0.5)" column-number="7"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="8"/>
			<fo:table-column column-width="proportional-column-width(1.25)" column-number="9"/>
			<fo:table-column column-width="proportional-column-width(1.25)" column-number="10"/>
			<xsl:choose>
				<xsl:when test="$showEmplLevel = true()">
					<fo:table-column column-width="proportional-column-width(1.25)" column-number="11"/>
					<fo:table-column column-width="proportional-column-width(1.25)" column-number="12"/>
					<fo:table-column column-width="proportional-column-width(1)" column-number="13"/>
					<fo:table-column column-width="proportional-column-width(1)" column-number="14"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="15"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="16"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="17"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="18"/>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-column column-width="proportional-column-width(1)" column-number="11"/>
					<fo:table-column column-width="proportional-column-width(1)" column-number="12"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="13"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="14"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="15"/>
					<fo:table-column column-width="proportional-column-width(2)" column-number="16"/>
				</xsl:otherwise>
			</xsl:choose>
			<fo:table-header xsl:use-attribute-sets="table-header-row">
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.ahvNumber"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.name"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.dateOfBirthShort"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.countryAbr"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.cantonAbr"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.communityAbr"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.correctionAbr"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.ema"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.in"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.out"/>
					</fo:block>
				</fo:table-cell>
				<xsl:if test="$showEmplLevel = true()">
					<fo:table-cell>
						<fo:block text-align="right" margin-right="5pt">
							<xsl:value-of select="$elm-qst.emplLevelAbr"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block text-align="right" margin-right="5pt">
							<xsl:value-of select="$elm-qst.emplLevelTotalAbr"/>
						</fo:block>
					</fo:table-cell>
				</xsl:if>
				<fo:table-cell>
					<fo:block>
						<xsl:value-of select="$elm-qst.month"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block>
						<xsl:if test="$noTarifColumn = false()">
							<xsl:value-of select="$elm-qst.tarif"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-qst.qstL"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-qst.qstA"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:if test="$noTarifColumn = false()">
							<xsl:value-of select="$elm-qst.sbL"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block text-align="right">
						<xsl:value-of select="$elm-qst.qstB"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-header>
			<fo:table-body>
				<xsl:for-each select="$persons">
					<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Lastname']"/>
					<xsl:sort select="./*[local-name()='Particulars']/*[local-name()='Firstname']"/>
					<xsl:variable name="person" select="."/>
					<fo:table-row xsl:use-attribute-sets="table-main-row">
						<xsl:call-template name="personal-info">
							<xsl:with-param name="paticulars" select="./*[local-name()='Particulars']"/>
						</xsl:call-template>
						<fo:table-cell>
							<xsl:attribute name="number-columns-spanned">
								<xsl:choose>
									<xsl:when test="$showEmplLevel = true()"><xsl:value-of select="15" /></xsl:when>
									<xsl:otherwise><xsl:value-of select="13" /></xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<fo:block>
								<fo:table table-layout="fixed" width="100%">
									<fo:table-column column-width="proportional-column-width(0.5)" column-number="1"/>
									<fo:table-column column-width="proportional-column-width(0.5)" column-number="2"/>
									<fo:table-column column-width="proportional-column-width(0.7)" column-number="3"/>
									<fo:table-column column-width="proportional-column-width(0.5)" column-number="4"/>
									<fo:table-column column-width="proportional-column-width(1)" column-number="5"/>
									<fo:table-column column-width="proportional-column-width(1.25)" column-number="6"/>
									<fo:table-column column-width="proportional-column-width(1.25)" column-number="7"/>
									<xsl:choose>
										<xsl:when test="$showEmplLevel = true()">
											<fo:table-column column-width="proportional-column-width(1.25)" column-number="8"/>
											<fo:table-column column-width="proportional-column-width(1.25)" column-number="9"/>
											<fo:table-column column-width="proportional-column-width(1)" column-number="10"/>
											<fo:table-column column-width="proportional-column-width(1)" column-number="11"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="12"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="13"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="14"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="15"/>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-column column-width="proportional-column-width(1)" column-number="8"/>
											<fo:table-column column-width="proportional-column-width(1)" column-number="9"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="10"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="11"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="12"/>
											<fo:table-column column-width="proportional-column-width(2)" column-number="13"/>
										</xsl:otherwise>
									</xsl:choose>
									<fo:table-body>
										<xsl:variable name="current" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
										<xsl:variable name="currentFilter">
											<xsl:choose>
												<xsl:when test="$filter='HonoraryBoardOfDirectors'">
													<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryPredefined']='HEY'] or *[descendant::*[local-name()='CategoryPredefined']='HEN']]"/>
												</xsl:when>
												<xsl:when test="$filter='MonetaryValuesServices'">
													<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryPredefined']='MEY'] or *[descendant::*[local-name()='CategoryPredefined']='MEN']]"/>
												</xsl:when>
												<xsl:when test="$filter='SpecialAgreement'">
													<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryPredefined']='SFN']]"/>
												</xsl:when>
												<xsl:when test="$filter='CategoryOpen'">
													<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryOpen']]]"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:copy-of select="$current[*[descendant::*[local-name()='TaxAtSourceCode']]]"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:variable name="correction" select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']"/>
										<xsl:variable name="correctionFilter">
											<xsl:choose>
												<xsl:when test="$filter='HonoraryBoardOfDirectors'">
													<xsl:copy-of select="$correction[*[descendant::*[local-name()='CategoryPredefined']='HEY'] or *[descendant::*[local-name()='CategoryPredefined']='HEN']]"/>
												</xsl:when>
												<xsl:when test="$filter='MonetaryValuesServices'">
													<xsl:copy-of select="$correction[*[descendant::*[local-name()='CategoryPredefined']='MEY'] or *[descendant::*[local-name()='CategoryPredefined']='MEN']]"/>
												</xsl:when>
												<xsl:when test="$filter='SpecialAgreement'">
													<xsl:copy-of select="$correction[*[descendant::*[local-name()='CategoryPredefined']='SFN']]"/>
												</xsl:when>
												<xsl:when test="$filter='CategoryOpen'">
													<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryOpen']]]"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:copy-of select="$correction[*[descendant::*[local-name()='TaxAtSourceCode']]]"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:variable>
										<xsl:for-each select="./*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']">
											<xsl:sort select="./*[local-name()='CurrentMonth']"/>
											<xsl:variable name="taxatsourcesalery" select="."/>
											<xsl:variable name="old" select="./*[local-name()='Correction']/*[local-name()='Old']"/>
											<xsl:variable name="oldFilter">
												<xsl:choose>
													<xsl:when test="$filter='HonoraryBoardOfDirectors'">
														<xsl:copy-of select="$old[*[descendant::*[local-name()='CategoryPredefined']='HEY'] or *[descendant::*[local-name()='CategoryPredefined']='HEN']]"/>
													</xsl:when>
													<xsl:when test="$filter='MonetaryValuesServices'">
														<xsl:copy-of select="$old[*[descendant::*[local-name()='CategoryPredefined']='MEY'] or *[descendant::*[local-name()='CategoryPredefined']='MEN']]"/>
													</xsl:when>
													<xsl:when test="$filter='SpecialAgreement'">
														<xsl:copy-of select="$old[*[descendant::*[local-name()='CategoryPredefined']='SFN']]"/>
													</xsl:when>
													<xsl:when test="$filter='CategoryOpen'">
													<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryOpen']]]"/>
												</xsl:when>
													<xsl:otherwise>
														<xsl:copy-of select="$old[*[descendant::*[local-name()='TaxAtSourceCode']]]"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:variable>
											<xsl:variable name="new" select="./*[local-name()='Correction']/*[local-name()='New']"/>
											<xsl:variable name="newFilter">
												<xsl:choose>
													<xsl:when test="$filter='HonoraryBoardOfDirectors'">
														<xsl:copy-of select="$new[*[descendant::*[local-name()='CategoryPredefined']='HEY'] or *[descendant::*[local-name()='CategoryPredefined']='HEN']]"/>
													</xsl:when>
													<xsl:when test="$filter='MonetaryValuesServices'">
														<xsl:copy-of select="$new[*[descendant::*[local-name()='CategoryPredefined']='MEY'] or *[descendant::*[local-name()='CategoryPredefined']='MEN']]"/>
													</xsl:when>
													<xsl:when test="$filter='SpecialAgreement'">
														<xsl:copy-of select="$new[*[descendant::*[local-name()='CategoryPredefined']='SFN']]"/>
													</xsl:when>
													<xsl:when test="$filter='CategoryOpen'">
														<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryOpen']]]"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:copy-of select="$new[*[descendant::*[local-name()='TaxAtSourceCode']]]"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:variable>
											<xsl:variable name="difference" select="./*[local-name()='Correction']/*[local-name()='Difference']"/>
											<xsl:variable name="differenceFilter">
												<xsl:choose>
													<xsl:when test="$filter='HonoraryBoardOfDirectors'">
														<xsl:copy-of select="$difference[*[descendant::*[local-name()='CategoryPredefined']='HEY'] or *[descendant::*[local-name()='CategoryPredefined']='HEN']]"/>
													</xsl:when>
													<xsl:when test="$filter='MonetaryValuesServices'">
														<xsl:copy-of select="$difference[*[descendant::*[local-name()='CategoryPredefined']='MEY'] or *[descendant::*[local-name()='CategoryPredefined']='MEN']]"/>
													</xsl:when>
													<xsl:when test="$filter='SpecialAgreement'">
														<xsl:copy-of select="$difference[*[descendant::*[local-name()='CategoryPredefined']='SFN']]"/>
													</xsl:when>
													<xsl:when test="$filter='CategoryOpen'">
														<xsl:copy-of select="$current[*[descendant::*[local-name()='CategoryOpen']]]"/>
												</xsl:when>
													<xsl:otherwise>
														<xsl:copy-of select="$difference[*[descendant::*[local-name()='TaxAtSourceCode']]]"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:variable>
											<!-- REACTIVATE IT FOR DEBUG PURPOSE
											<xsl:comment>
											filter: <xsl:copy-of select="$filter"/>
											Nodes
												correction:
												<xsl:copy-of select="$correction"/>
												new:
												<xsl:copy-of select="$new"/>
												old:
												<xsl:copy-of select="$old"/>
												difference:
												<xsl:copy-of select="$difference"/>
												current:
												<xsl:copy-of select="$current"/>
											Filters
												correction:
												<xsl:copy-of select="$correctionFilter"/>
												new:
												<xsl:copy-of select="$newFilter"/>
												old:
												<xsl:copy-of select="$oldFilter"/>
												difference:
												<xsl:copy-of select="$differenceFilter"/>
												current:
												<xsl:copy-of select="$currentFilter"/>
											</xsl:comment>
											-->
											<xsl:for-each select="./*[local-name()='Correction']">
												<xsl:sort select="./*[local-name()='Month']"/>
												<xsl:if test="exsl:node-set($oldFilter)/*">
													<fo:table-row xsl:use-attribute-sets="table-row">
														<xsl:call-template name="taxatsource-general">
															<xsl:with-param name="taxatsourcegeneral" select="$taxatsourcesalery"/>
															<xsl:with-param name="taxatsource" select="./*[local-name()='Old']"/>
														</xsl:call-template>
														<xsl:call-template name="tax-at-source">
															<xsl:with-param name="person" select="$person"/>
															<xsl:with-param name="taxatsource" select="./*[local-name()='Old']"/>
															<xsl:with-param name="correctiontype" select="concat('', 'CorrectionOld')"/>
															<xsl:with-param name="noTarifColumn" select="$noTarifColumn"/>
															<xsl:with-param name="showEmplLevel" select="$showEmplLevel"/>
														</xsl:call-template>
													</fo:table-row>
												</xsl:if>
												<xsl:if test="exsl:node-set($newFilter)/*">
													<fo:table-row xsl:use-attribute-sets="table-row">
														<xsl:call-template name="taxatsource-general">
															<xsl:with-param name="taxatsourcegeneral" select="$taxatsourcesalery"/>
															<xsl:with-param name="taxatsource" select="./*[local-name()='New']"/>
														</xsl:call-template>
														<xsl:call-template name="tax-at-source">
															<xsl:with-param name="person" select="$person"/>
															<xsl:with-param name="taxatsource" select="./*[local-name()='New']"/>
															<xsl:with-param name="correctiontype" select="concat('', 'CorrectionNew')"/>
															<xsl:with-param name="noTarifColumn" select="$noTarifColumn"/>
															<xsl:with-param name="showEmplLevel" select="$showEmplLevel"/>
														</xsl:call-template>
													</fo:table-row>
												</xsl:if>
												<xsl:if test="exsl:node-set($differenceFilter)/*">
													<fo:table-row xsl:use-attribute-sets="table-row">
														<xsl:call-template name="taxatsource-general">
															<xsl:with-param name="taxatsourcegeneral" select="$taxatsourcesalery"/>
															<xsl:with-param name="taxatsource" select="./*[local-name()='Difference']"/>
														</xsl:call-template>
														<xsl:call-template name="tax-at-source">
															<xsl:with-param name="person" select="$person"/>
															<xsl:with-param name="taxatsource" select="./*[local-name()='Difference']"/>
															<xsl:with-param name="correctiontype" select="concat('', 'Difference')"/>
															<xsl:with-param name="noTarifColumn" select="$noTarifColumn"/>
															<xsl:with-param name="showEmplLevel" select="$showEmplLevel"/>
														</xsl:call-template>
													</fo:table-row>
												</xsl:if>
											</xsl:for-each>
											<xsl:if test="exsl:node-set($currentFilter)/*">
												<!--a taxatsourcesalary can simultaneously be a correction AND current -->
												<fo:table-row xsl:use-attribute-sets="table-row">
													<xsl:call-template name="taxatsource-general">
														<xsl:with-param name="taxatsourcegeneral" select="$taxatsourcesalery"/>
														<xsl:with-param name="taxatsource" select="./*[local-name()='Current']"/>
													</xsl:call-template>
													<xsl:call-template name="tax-at-source">
														<xsl:with-param name="person" select="$person"/>
														<xsl:with-param name="taxatsource" select="./*[local-name()='Current']"/>
														<xsl:with-param name="correctiontype" select="concat('', 'Current')"/>
														<xsl:with-param name="noTarifColumn" select="$noTarifColumn"/>
														<xsl:with-param name="showEmplLevel" select="$showEmplLevel"/>
													</xsl:call-template>
												</fo:table-row>
											</xsl:if>
										</xsl:for-each>
										<xsl:if test="not(exsl:node-set($correctionFilter)/*) and not(exsl:node-set($currentFilter)/*)">
											<fo:table-row>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
										</xsl:if>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="ahv-number">
		<xsl:param name="insurance-identification"/>
		<xsl:if test="$insurance-identification/*[local-name()='SV-AS-Number']">
			<xsl:value-of select="$insurance-identification/*[local-name()='SV-AS-Number']"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="personal-info">
		<xsl:param name="paticulars"/>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="ahv-number">
					<xsl:with-param name="insurance-identification" select="$paticulars/*[local-name()='Social-InsuranceIdentification']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$paticulars/*[local-name()='Lastname']"/>, <xsl:value-of select="$paticulars/*[local-name()='Firstname']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="format-date">
					<xsl:with-param name="value" select="$paticulars/*[local-name()='DateOfBirth']"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<xsl:template name="taxatsource-general">
		<xsl:param name="taxatsourcegeneral"/>
		<xsl:param name="taxatsource"/>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$taxatsource/*[local-name()='Residence']/*[local-name()='AbroadCountry']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$taxatsourcegeneral/*[local-name()='TaxAtSourceCanton']"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:value-of select="$taxatsourcegeneral/*[local-name()='TaxAtSourceMunicipalityID']"/>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<xsl:template name="tax-at-source">
		<xsl:param name="person"/>
		<xsl:param name="taxatsource"/>
		<xsl:param name="correctiontype"/>
		<xsl:param name="noTarifColumn"/>
		<xsl:param name="showEmplLevel"/>
		<xsl:variable name="ema">
			<xsl:call-template name="ema">
				<xsl:with-param name="taxatsource" select="$taxatsource"/>
			</xsl:call-template>
		</xsl:variable>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="correction-type">
					<xsl:with-param name="value" select="$correctiontype"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block wrap-option="wrap">
				<xsl:value-of select="$ema"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:if test="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Entry']">
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']"/>
						<xsl:with-param name="yearDigits" select="2"/>
					</xsl:call-template>
				</xsl:if>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:choose>
					<xsl:when test="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']">
						<xsl:call-template name="format-date">
							<xsl:with-param name="value" select="$taxatsource/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']"/>
							<xsl:with-param name="yearDigits" select="2"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="$person/*[local-name()='Work']/*[local-name()='WithdrawalDate']">
							<xsl:call-template name="format-date">
								<xsl:with-param name="value" select="$person/*[local-name()='Work']/*[local-name()='WithdrawalDate']"/>
								<xsl:with-param name="yearDigits" select="2"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</fo:block>
		</fo:table-cell>
		<xsl:if test="$showEmplLevel =  true()">
			<fo:table-cell>
				<fo:block wrap-option="wrap" text-align="right" margin-right="5pt">
					<xsl:if test="$correctiontype = 'Current'">
						<xsl:value-of select="format-number($person/*[local-name()='Work']/*[local-name()='WorkingTime']/*[local-name()='Steady']/*[local-name()='ActivityRate'], $percent-format)"/>
					</xsl:if>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block wrap-option="wrap" text-align="right" margin-right="5pt">
					<xsl:if test="$correctiontype = 'Current'">
						<xsl:choose>
							<xsl:when test="$person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='OtherActivities']/*[local-name()='TotalActivityRate']">
								<xsl:value-of select="format-number(
																$person/*[local-name()='Work']/*[local-name()='WorkingTime']/*[local-name()='Steady']/*[local-name()='ActivityRate'] +
																 $person/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='OtherActivities']/*[local-name()='TotalActivityRate'],
																 $percent-format)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="format-number($person/*[local-name()='Work']/*[local-name()='WorkingTime']/*[local-name()='Steady']/*[local-name()='ActivityRate'], $percent-format)"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</fo:block>
			</fo:table-cell>
		</xsl:if>
		<fo:table-cell>
			<fo:block>
				<xsl:call-template name="taxmonth">
					<xsl:with-param name="correctiontype" select="$correctiontype"/>
					<xsl:with-param name="taxatsource" select="$taxatsource"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block>
				<xsl:if test="$noTarifColumn = false()">
					<xsl:call-template name="decode-taxatsource-category">
						<xsl:with-param name="value" select="$taxatsource/*[local-name()='TaxAtSourceCategory']"/>
					</xsl:call-template>
					<xsl:if test="$taxatsource/*[local-name()='GrantTaxAtSourceCode']">
						<xsl:text>*</xsl:text>
					</xsl:if>
				</xsl:if>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number($taxatsource/*[local-name()='TaxableEarning'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number($taxatsource/*[local-name()='SporadicBenefits'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:if test="$noTarifColumn = false()">
					<xsl:value-of select="format-number($taxatsource/*[local-name()='AscertainedTaxableEarning'], $cents-format)"/>
				</xsl:if>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block text-align="right">
				<xsl:value-of select="format-number($taxatsource/*[local-name()='TaxAtSource'], $cents-format)"/>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<xsl:template name="taxmonth">
		<xsl:param name="correctiontype"/>
		<xsl:param name="taxatsource"/>
		<xsl:variable name="trimmed-value" select="normalize-space($correctiontype)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'Current'">
				<xsl:call-template name="format-month">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='CurrentMonth']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'CorrectionOld'">
				<xsl:call-template name="format-month">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='Month']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'CorrectionNew'">
				<xsl:call-template name="format-month">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='Month']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'Difference'">
				<xsl:call-template name="format-month">
					<xsl:with-param name="value" select="$taxatsource/../*[local-name()='Month']"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<!--
		Elm section overview page
	-->
	<xsl:template name="elm-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.elm"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.creationDate"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-datetime">
												<xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='CreationDate']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.transmissionDate"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-datetime">
												<xsl:with-param name="value" select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='TransmissionDate']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.declarationId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='DeclarationID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.requestId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='DistributorRequestID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.payrollAccounting"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='UserAgent']/*[local-name()='Name']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='UserAgent']/*[local-name()='Version']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='RequestContext']/*[local-name()='UserAgent']/*[local-name()='Producer']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Substitution section
	-->
	<xsl:template name="substitution-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.substitution"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.reference"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.referencetext"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.requestId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']/*[local-name()='MappedPredecessorDistributorRequestID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.responseId"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalaryConsumer']/*[local-name()='DistributorRequestContext']/*[local-name()='SubstitutionMapping']/*[local-name()='MappedPredecessorConsumerResponseID']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Overview QST Month Section
	-->
	<xsl:template name="overviewqst-month-section">
		<xsl:param name="month"/>
		<!--<xsl:message>
			<xsl:copy-of select="$month"/>
		</xsl:message>-->
		<xsl:variable name="monthLabel">
			<xsl:choose>
				<xsl:when test="local-name($month) = 'TotalMonth'">
					<xsl:value-of select="$elm-qst.totalMonth"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$elm-qst.totalCorrection"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="isTotalMonth" select="local-name($month) = 'TotalMonth'"/>
		<xsl:variable name="periodLabel">
			<xsl:choose>
				<xsl:when test="local-name($month) = 'TotalMonth'">
					<xsl:value-of select="$elm-qst.accountPeriod"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$elm-qst.monthPeriod"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="currentMonth">
			<xsl:choose>
				<xsl:when test="local-name($month) = 'TotalMonth'">
					<xsl:value-of select="$month/*[local-name()='CurrentMonth']"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$month/*[local-name()='Month']"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="perTaxTypeStartPoint" select="$company/*[local-name()='Staff']/*[local-name()='Person']/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
		<xsl:variable name="perTaxTypeStartPointForCorrections" select="$month/*[local-name()='Old' or local-name()='New' or local-name()='Difference']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block margin-top="0.5mm">
							<xsl:value-of select="$monthLabel"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="3"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="4"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="5"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="6"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="7"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$periodLabel"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-month">
												<xsl:with-param name="value" select="$currentMonth"/>
												<xsl:with-param name="delimiter" select="'-'"/>
												<xsl:with-param name="yearDigits" select="4"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.ofTaxableEarning"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxHeyHen"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="5" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxMeyMen"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="6" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxSfn"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="7" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxOffeneKat"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst löhne -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxableEarning)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="$month/*[local-name()='TotalTaxableEarning']"/>
															<!--<xsl:value-of select="sum($perTaxTypeStartPoint/*[local-name()='TaxableEarning'])"/>-->
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections/*[local-name()='TaxableEarning'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="firstCell" select="true()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxableEarning'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxableEarning'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']/*[local-name()='TaxableEarning'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="
																sum($perTaxTypeStartPointForCorrections[
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']/*[local-name()='TaxableEarning'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="5" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']/*[local-name()='TaxableEarning'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="
																sum($perTaxTypeStartPointForCorrections[
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']/*[local-name()='TaxableEarning'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="6" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxableEarning'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxableEarning'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="7" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxableEarning'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxableEarning'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst-beträge -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxAtSource)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="$month/*[local-name()='TotalTaxAtSource']"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections/*[local-name()='TaxAtSource'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="firstCell" select="true()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxAtSource'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxAtSource'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']/*[local-name()='TaxAtSource'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="
																sum($perTaxTypeStartPointForCorrections[
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']/*[local-name()='TaxAtSource'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="5" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
																*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']/*[local-name()='TaxAtSource'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="
																sum($perTaxTypeStartPointForCorrections[
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
																	*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']/*[local-name()='TaxAtSource'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="6" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxAtSource'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxAtSource'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="7" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="sum($perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxAtSource'])"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="sum($perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxAtSource'])"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- Kommission -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalCommission)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount">
													<xsl:choose>
														<xsl:when test="$isTotalMonth = true()">
															<xsl:value-of select="$month/*[local-name()='TotalCommission']"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$company/*[local-name()='SalaryTotals']/*[local-name()='TaxAtSourceTotals']/*[local-name()='CorrectionMonth'][*[local-name()='Month']=$currentMonth]/*[local-name()='TotalCommission']"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="firstCell" select="true()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<!-- commission is available only in TotalsSection of the xml, so it is impossible to have the details per tax type: so we left the rest of the line empty.-->
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column" number-columns-spanned="4">
										<fo:block/>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Overview QST Billing Relevant Section
	-->
	<xsl:template name="overviewqst-billing-relevant-section">
		<xsl:param name="month"/>
		<xsl:param name="corrections"/>
		<xsl:variable name="monthLabel" select="$elm-qst.totalBillingRelevant"/>
		<xsl:variable name="periodLabel" select="''"/>
		<xsl:variable name="perTaxTypeStartPoint" select="$company/*[local-name()='Staff']/*[local-name()='Person']/*[local-name()='TaxAtSourceSalaries']/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
		<xsl:variable name="perTaxTypeStartPointForCorrections" select="$corrections/*[local-name()='Old' or local-name()='New' or local-name()='Difference']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block margin-top="0.5mm">
							<xsl:value-of select="$monthLabel"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="3"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="4"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="5"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="6"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="7"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$periodLabel"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block/>
									</fo:table-cell>
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.ofTaxableEarning"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxHeyHen"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="5" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxMeyMen"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="6" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxSfn"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="7" xsl:use-attribute-sets="value-column" text-align="right">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxOffeneKat"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst löhne -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxableEarning)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum($month/*[local-name()='TotalTaxableEarning'] | $perTaxTypeStartPointForCorrections/*[local-name()='TaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="firstCell" select="true()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxableEarning'] |
													$perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']
													/*[local-name()='TaxableEarning']  |
													$perTaxTypeStartPointForCorrections[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']
													/*[local-name()='TaxableEarning'] )"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="5" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']
													/*[local-name()='TaxableEarning']  |
													$perTaxTypeStartPointForCorrections[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']
													/*[local-name()='TaxableEarning'] )"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="6" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxableEarning'] |
													$perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="7" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxableEarning'] |
													$perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst-beträge -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxAtSource)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum($month/*[local-name()='TotalTaxAtSource'] | $perTaxTypeStartPointForCorrections/*[local-name()='TaxAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="firstCell" select="true()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum($perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxAtSource'] | $perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='TaxAtSourceCode']]/*[local-name()='TaxAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="4" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']
													/*[local-name()='TaxAtSource']  |
													$perTaxTypeStartPointForCorrections[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='HEN']
													/*[local-name()='TaxAtSource'] )"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="5" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']
													/*[local-name()='TaxAtSource']  |
													$perTaxTypeStartPointForCorrections[
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEY' or
														*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='MEN']
													/*[local-name()='TaxAtSource'] )"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="6" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxAtSource'] |
													$perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryPredefined']='SFN']/*[local-name()='TaxAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
										<fo:table-cell column-number="7" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum(
													$perTaxTypeStartPoint[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxAtSource'] |
													$perTaxTypeStartPointForCorrections[*[local-name()='TaxAtSourceCategory']/*[local-name()='CategoryOpen']]/*[local-name()='TaxAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="printCurrency" select="false()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- Kommission -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalCommission)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified">
												<xsl:with-param name="amount" select="sum($month/*[local-name()='TotalCommission'] | $company/*[local-name()='SalaryTotals']/*[local-name()='TaxAtSourceTotals']/*[local-name()='CorrectionMonth']/*[local-name()='TotalCommission'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
												<xsl:with-param name="firstCell" select="true()"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
									<!-- commission is available only in TotalsSection of the xml, so it is impossible to have the details per tax type: so we left the rest of the line empty.-->
									<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column" number-columns-spanned="4">
										<fo:block/>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Overview QST correction confirmed Section
	-->
	<xsl:template name="overviewqst-correction-confirmed-section">
		<xsl:param name="month"/>
		<xsl:variable name="monthLabel" select="$elm-qst.totalCorrectionConfirmed"/>
		<xsl:variable name="isTotalMonth" select="local-name($month) = 'TotalMonth'"/>
		<xsl:variable name="periodLabel" select="$elm-qst.monthPeriod"/>
		<xsl:variable name="currentMonth" select="$month/*[local-name()='Month']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block margin-top="0.5mm">
							<xsl:value-of select="$monthLabel"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$periodLabel"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-month">
												<xsl:with-param name="value" select="$currentMonth"/>
												<xsl:with-param name="delimiter" select="'-'"/>
												<xsl:with-param name="yearDigits" select="4"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst löhne -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxableEarning)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($month/*[local-name()='TaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst-beträge -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxAtSource)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($month/*[local-name()='TaxAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Overview QST Total Section
	-->
	<xsl:template name="overviewqst-total-section">
		<xsl:param name="taxAtSourceTotals"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block margin-top="0.5mm">
							<xsl:value-of select="$elm-qst.total"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block/>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block/>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst löhne -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxableEarning)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxAtSourceTotals/*[local-name()='TotalMonth' or local-name()='CorrectionMonth']/*[local-name()='TotalTaxableEarning'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- qst beträge -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalTaxAtSource)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxAtSourceTotals/*[local-name()='TotalMonth' or local-name()='CorrectionMonth']/*[local-name()='TotalTaxAtSource'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- komission -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="concat(' - ', $elm-qst.totalCommission)"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-amount-right-justified-two-columns">
												<xsl:with-param name="amount" select="sum($taxAtSourceTotals/*[local-name()='TotalMonth' or local-name()='CorrectionMonth']/*[local-name()='TotalCommission'])"/>
												<xsl:with-param name="horizontal" select="'true'"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Contact person section
	-->
	<xsl:template name="contactperson-section">
		<xsl:variable name="contactPerson" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='ContactPerson']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.contactPerson"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.name"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='Name']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.email"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='EmailAddress']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.telefon"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='PhoneNumber']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.mobil"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$contactPerson/*[local-name()='MobilePhoneNumber']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.comment"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='GeneralSalaryDeclarationDescription']/*[local-name()='Comment']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Company section
	-->
	<xsl:template name="company-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.company"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<xsl:call-template name="company-info">
							<xsl:with-param name="company" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']"/>
							<xsl:with-param name="sslNumber" select="$sslNumber"/>
							<xsl:with-param name="companyDetails" select="$company"/>
						</xsl:call-template>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Delegate section
	-->
	<xsl:template name="delegate-section">
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.delegate"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<xsl:call-template name="company-info">
							<xsl:with-param name="company" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']/*[local-name()='Delegate']"/>
							<xsl:with-param name="companyDetails" select="$company"/>
						</xsl:call-template>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
		Company Info section, called with parameter @sslNumber in case of company info, without in case of delegate
	-->
	<xsl:template name="company-info">
		<xsl:param name="company"/>
		<xsl:param name="sslNumber"/>
		<xsl:param name="companyDetails"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
			<fo:table-column column-width="{$description-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<xsl:if test="$sslNumber">
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
							<fo:block>
								<xsl:value-of select="$elm-qst.sslNumber"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
							<fo:block>
								<xsl:value-of select="$sslNumber"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.payrollUnit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:value-of select="$companyDetails/*[local-name()='Institutions']/*[local-name()='TaxAtSource']/*[local-name()='PayrollUnit']"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:if test="$company/*[local-name()='CompanyDescription']/*[local-name()='Owner']">
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
							<fo:block>
								<xsl:value-of select="$elm-qst.owner"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
							<fo:block>
								<xsl:value-of select="$company/*[local-name()='CompanyDescription']/*[local-name()='Owner']/*[local-name()='Lastname']"/>
								<xsl:text>, </xsl:text>
								<xsl:value-of select="$company/*[local-name()='CompanyDescription']/*[local-name()='Owner']/*[local-name()='Firstname']"/>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</xsl:if>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.uidbfs"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:choose>
								<xsl:when test="$company/*[local-name()='UID-BFS']/*[local-name()='UID']">
									<xsl:value-of select="$company/*[local-name()='UID-BFS']/*[local-name()='UID']"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$elm-qst.unknown"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.name2"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:value-of select="$company/*[local-name()='Name']/*[local-name()='HR-RC-Name']"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:call-template name="address">
					<xsl:with-param name="address" select="$company/*[local-name()='Address']"/>
				</xsl:call-template>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="address">
		<xsl:param name="address"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$elm-qst.address"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<xsl:if test="$address/*[local-name()='ComplementaryLine']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='ComplementaryLine']"/>
					</fo:block>
				</xsl:if>
				<xsl:if test="$address/*[local-name()='Street']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Street']"/>
					</fo:block>
				</xsl:if>
				<xsl:if test="$address/*[local-name()='Postbox']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Postbox']"/>
					</fo:block>
				</xsl:if>
				<xsl:if test="$address/*[local-name()='Locality']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Locality']"/>
					</fo:block>
				</xsl:if>
				<fo:block>
					<xsl:value-of select="$address/*[local-name()='ZIP-Code']"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="$address/*[local-name()='City']"/>
				</fo:block>
				<xsl:if test="$address/*[local-name()='Country']">
					<fo:block>
						<xsl:value-of select="$address/*[local-name()='Country']"/>
					</fo:block>
				</xsl:if>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!-- Personal details -->
	<xsl:template name="personal-details">
		<xsl:param name="particulars"/>
		<xsl:param name="additionalParticulars"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.personalDetails"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.ahvNumber"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$particulars/*[local-name()='Social-InsuranceIdentification']/*[local-name()='SV-AS-Number']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.name"/>, <xsl:value-of select="$elm-qst.firstName"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$particulars/*[local-name()='Lastname']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="$particulars/*[local-name()='Firstname']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.residentAddress"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<xsl:call-template name="format-address">
											<xsl:with-param name="address" select="$particulars/*[local-name()='Address']"/>
										</xsl:call-template>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.sex"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="decode-sex">
												<xsl:with-param name="value" select="$particulars/*[local-name()='Sex']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.dateOfBirth"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="$particulars/*[local-name()='DateOfBirth']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.nationality"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$particulars/*[local-name()='Nationality']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.civilStatus"/>
											<xsl:text> / </xsl:text>
											<xsl:value-of select="$elm-qst.date"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="decode-civilStatus">
												<xsl:with-param name="value" select="$particulars/*[local-name()='CivilStatus']/*[local-name()='Status']"/>
											</xsl:call-template>
											<xsl:if test="$particulars/*[local-name()='CivilStatus']/*[local-name()='ValidAsOf']">, </xsl:if>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="$particulars/*[local-name()='CivilStatus']/*[local-name()='ValidAsOf']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.denomination"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="decode-denomination">
												<xsl:with-param name="additionalParticulars" select="$additionalParticulars"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--Occupation data-->
	<xsl:template name="occupation-data">
		<xsl:param name="person"/>
		<xsl:variable name="work" select="$person/*[local-name()='Work']"/>
		<xsl:variable name="taxAtSourceSalaries" select="$person/*[local-name()='TaxAtSourceSalaries']"/>
		<xsl:variable name="currentTaxAtSourceSalary" select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.occupation"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.workplace"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-address">
												<xsl:with-param name="address" select="
													//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']/*[local-name()='Workplace' and
													@workplaceID=$currentTaxAtSourceSalary/@workplaceIDRef]/*[local-name()='AddressExtended']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- <xsl:if test="$work/*[local-name()='WorkingTime']/*[local-name()='Steady']/*[local-name()='ActivityRate']"> -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.emplLevel"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:if test="$work/*[local-name()='WorkingTime']/*[local-name()='Steady']/*[local-name()='ActivityRate']">
												<xsl:value-of select="$work/*[local-name()='WorkingTime']/*[local-name()='Steady']/*[local-name()='ActivityRate']"/> %
											</xsl:if>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- </xsl:if> -->
								<!-- <xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='OtherActivities']"> -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.otherIncome"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='OtherActivities']">
												<xsl:value-of select="$elm-qst.yes"/>
											</xsl:if>
											<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='OtherActivities']/*[local-name()='TotalActivityRate']">,
												<xsl:value-of select="$elm-qst.emplLevelTotal"/>:
												<xsl:value-of select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='OtherActivities']/*[local-name()='TotalActivityRate'] + $work/*[local-name()='WorkingTime']/*[local-name()='Steady']/*[local-name()='ActivityRate']"/> %
											</xsl:if>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<!-- </xsl:if> -->
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.residenceCategory"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="decode-residenceCategory">
												<xsl:with-param name="value" select="$person/*[local-name()='Particulars']/*[local-name()='ResidenceCategory']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.residence"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="decode-residence">
												<xsl:with-param name="residence" select="$currentTaxAtSourceSalary/*[local-name()='Residence']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.kindOfResidence"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:if test="$currentTaxAtSourceSalary/*[local-name()='Residence']/*[local-name()='KindOfResidence']/*[local-name()='Daily']">
												<xsl:value-of select="$elm-qst.dailyResidence"/>
											</xsl:if>
											<xsl:if test="$currentTaxAtSourceSalary/*[local-name()='Residence']/*[local-name()='KindOfResidence']/*[local-name()='Weekly']">
												<xsl:value-of select="$elm-qst.weeklyResidence"/>
											</xsl:if>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.weeklyResidentAddress"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:if test="$currentTaxAtSourceSalary/*[local-name()='Residence']/*[local-name()='KindOfResidence']/*[local-name()='Weekly']">
												<xsl:call-template name="format-address">
													<xsl:with-param name="address" select="$currentTaxAtSourceSalary/*[local-name()='Residence']/*[local-name()='KindOfResidence']/*[local-name()='Weekly']"/>
												</xsl:call-template>
											</xsl:if>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--QST data (new) -->
	<xsl:template name="qst-data-new">
		<xsl:param name="person"/>
		<xsl:variable name="work" select="$person/*[local-name()='Work']"/>
		<xsl:variable name="taxAtSourceSalaries" select="$person/*[local-name()='TaxAtSourceSalaries']"/>
		<xsl:variable name="currentTaxAtSourceSalary" select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
		<xsl:variable name="newTaxAtSourceSalary" select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']/*[local-name()='New']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.qstDataNew"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.tarifNew"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$currentTaxAtSourceSalary/*[local-name()='TaxAtSourceCategory']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxableEarningNew"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<xsl:call-template name="format-amount-right-justified">
											<xsl:with-param name="amount" select="$currentTaxAtSourceSalary/*[local-name()='TaxableEarning']"/>
										</xsl:call-template>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.aperLeistungenNew"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<xsl:call-template name="format-amount-right-justified">
											<xsl:with-param name="amount" select="$currentTaxAtSourceSalary/*[local-name()='SporadicBenefits']"/>
										</xsl:call-template>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.ascertainedTaxableEarningNew"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<xsl:call-template name="format-amount-right-justified">
											<xsl:with-param name="amount" select="$currentTaxAtSourceSalary/*[local-name()='AscertainedTaxableEarning']"/>
										</xsl:call-template>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.taxAtSourceAmountNew"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<xsl:call-template name="format-amount-right-justified">
											<xsl:with-param name="amount" select="$currentTaxAtSourceSalary/*[local-name()='TaxAtSource']"/>
										</xsl:call-template>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- End of QST Datai (New) -->
	<!--Children data-->
	<xsl:template name="children-data">
		<xsl:param name="person"/>
		<xsl:param name="children"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.childrenData"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<xsl:for-each select="$children">
									<xsl:call-template name="child-details">
										<xsl:with-param name="child" select="."/>
										<xsl:with-param name="position" select="position()"/>
									</xsl:call-template>
								</xsl:for-each>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="child-details">
		<xsl:param name="child"/>
		<xsl:param name="position"/>
		<fo:table-row>
			<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
				<fo:block>
					<xsl:value-of select="$elm-qst.child"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="$position"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
				<fo:block>
					<xsl:value-of select="$child/*[local-name()='Lastname']"/>
					<xsl:text>, </xsl:text>
					<xsl:value-of select="$child/*[local-name()='Firstname']"/>
					<xsl:text>, </xsl:text>
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="$child/*[local-name()='DateOfBirth']"/>
					</xsl:call-template>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	<!--Concubinage data-->
	<xsl:template name="concubinage-data">
		<xsl:param name="person"/>
		<xsl:variable name="work" select="$person/*[local-name()='Work']"/>
		<xsl:variable name="taxAtSourceSalaries" select="$person/*[local-name()='TaxAtSourceSalaries']"/>
		<xsl:variable name="currentTaxAtSourceSalary" select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
		<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='SingleParentFamily']">
			<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
				<fo:table-column column-width="{$title-column-width}" column-number="1"/>
				<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
							<fo:block>
								<xsl:value-of select="$elm-qst.concubinageData"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
							<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
								<fo:table-column column-width="{$description-column-width}" column-number="1"/>
								<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
											<fo:block>
												<xsl:value-of select="$elm-qst.concubinage"/>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
											<fo:block>
												<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='SingleParentFamily']/*[local-name()='Concubinage']">
													<xsl:value-of select="$elm-qst.yes"/>
												</xsl:if>
												<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='SingleParentFamily']/*[local-name()='NoConcubinage']">
													<xsl:value-of select="$elm-qst.no"/>
												</xsl:if>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
											<fo:block>
												<xsl:value-of select="$elm-qst.custody"/>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
											<fo:block>
												<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='SingleParentFamily']/*[local-name()='Concubinage']">
													<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='SingleParentFamily']/*[local-name()='Concubinage']
														/*[local-name()='SoleCustody']">
														<xsl:value-of select="$elm-qst.soleCustody"/>
													</xsl:if>
													<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='SingleParentFamily']/*[local-name()='Concubinage']
														/*[local-name()='ShareCustodyAndHigherIncome']">
														<xsl:value-of select="$elm-qst.shareCustodyAndHigherIncome"/>
													</xsl:if>
													<xsl:if test="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='AdditionalParticulars']/*[local-name()='SingleParentFamily']/*[local-name()='Concubinage']
														/*[local-name()='AdultChildAndHigherIncome']">
														<xsl:value-of select="$elm-qst.adultChildAndHigherIncome"/>
													</xsl:if>
												</xsl:if>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</xsl:if>
	</xsl:template>
	<!-- QST Data -->
	<xsl:template name="qst-data">
		<xsl:param name="person"/>
		<xsl:variable name="work" select="$person/*[local-name()='Work']"/>
		<xsl:variable name="taxAtSourceSalaries" select="$person/*[local-name()='TaxAtSourceSalaries']"/>
		<xsl:variable name="currentTaxAtSourceSalary" select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='Current']"/>
		<xsl:variable name="newTaxAtSourceSalary" select="$taxAtSourceSalaries/*[local-name()='TaxAtSourceSalary']/*[local-name()='Correction']/*[local-name()='New']"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.qstData"/>
						</fo:block>
						<fo:block>
							<xsl:value-of select="$elm-qst.emaLong"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.entryDate"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:choose>
												<xsl:when test="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']">
													<xsl:call-template name="format-date">
														<xsl:with-param name="value" select="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="$newTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']">
													<xsl:call-template name="format-date">
														<xsl:with-param name="value" select="$newTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='ValidAsOf']"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="format-date">
														<xsl:with-param name="value" select="$work/*[local-name()='EntryDate']"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.entryReason"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:choose>
												<xsl:when test="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='Reason']">
													<xsl:call-template name="decode-entryReason">
														<xsl:with-param name="value" select="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='Reason']"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="decode-entryReason">
														<xsl:with-param name="value" select="$newTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Entry']/*[local-name()='Reason']"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.withdrawalDate"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:choose>
												<xsl:when test="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']">
													<xsl:call-template name="format-date">
														<xsl:with-param name="value" select="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="$newTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']">
													<xsl:call-template name="format-date">
														<xsl:with-param name="value" select="$newTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='ValidAsOf']"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="format-date">
														<xsl:with-param name="value" select="$work/*[local-name()='WithdrawalDate']"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.withdrawalReason"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:choose>
												<xsl:when test="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='Reason']">
													<xsl:call-template name="decode-withdrawalReason">
														<xsl:with-param name="value" select="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='Reason']"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="decode-withdrawalReason">
														<xsl:with-param name="value" select="$newTaxAtSourceSalary/*[local-name()='DeclarationCategory']/*[local-name()='Withdrawal']/*[local-name()='Reason']"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.mutations"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:choose>
												<xsl:when test="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']">
													<xsl:call-template name="mutations">
														<xsl:with-param name="declarationcat" select="$currentTaxAtSourceSalary/*[local-name()='DeclarationCategory']"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="mutations">
														<xsl:with-param name="declarationcat" select="$newTaxAtSourceSalary/*[local-name()='DeclarationCategory']"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Marriage partner -->
	<xsl:template name="marriage-partner">
		<xsl:param name="partner"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" space-after="{$space-after-blocks}" border-collapse="separate">
			<fo:table-column column-width="{$title-column-width}" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="main-left-column">
						<fo:block>
							<xsl:value-of select="$elm-qst.partner"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="main-right-column">
						<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" border-collapse="separate">
							<fo:table-column column-width="{$description-column-width}" column-number="1"/>
							<fo:table-column column-width="proportional-column-width(1)" column-number="2"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.name"/>, <xsl:value-of select="$elm-qst.firstName"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$partner/*[local-name()='Lastname']"/>
											<xsl:text>, </xsl:text>
											<xsl:value-of select="$partner/*[local-name()='Firstname']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.ahvNumber"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:value-of select="$partner/*[local-name()='Social-InsuranceIdentification']/*[local-name()='SV-AS-Number']"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.dateOfBirth"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-date">
												<xsl:with-param name="value" select="$partner/*[local-name()='DateOfBirth']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.employed"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="decode-employed">
												<xsl:with-param name="payment" select="$partner/*[local-name()='Payment']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell column-number="1" xsl:use-attribute-sets="denom-column">
										<fo:block>
											<xsl:value-of select="$elm-qst.address"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column">
										<fo:block>
											<xsl:call-template name="format-address">
												<xsl:with-param name="address" select="$partner/*[local-name()='SeparateAddress']"/>
											</xsl:call-template>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Template for decoding sex value-->
	<xsl:template name="decode-sex">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'M'">
				<xsl:value-of select="$elm-qst.male"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'F'">
				<xsl:value-of select="$elm-qst.female"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template for decoding civil status value-->
	<xsl:template name="decode-civilStatus">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'unknown'">
				<xsl:value-of select="$elm-qst.unknown"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'single'">
				<xsl:value-of select="$elm-qst.single"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'married'">
				<xsl:value-of select="$elm-qst.married"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'widowed'">
				<xsl:value-of select="$elm-qst.widowed"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'divorced'">
				<xsl:value-of select="$elm-qst.divorced"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'separated'">
				<xsl:value-of select="$elm-qst.separated"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'registeredPartnership'">
				<xsl:value-of select="$elm-qst.registeredPartnership"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'partnershipDissolvedByLaw'">
				<xsl:value-of select="$elm-qst.partnershipDissolvedByLaw"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'partnershipDissolvedByDeath'">
				<xsl:value-of select="$elm-qst.partnershipDissolvedByDeath"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'partnershipDissolvedByDeclarationOfLost'">
				<xsl:value-of select="$elm-qst.partnershipDissolvedByDeclarationOfLost"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template for decoding entry reason value-->
	<xsl:template name="decode-entryReason">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'entryCompany'">
				<xsl:value-of select="$elm-qst.entryCompany"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'cantonChange'">
				<xsl:value-of select="$elm-qst.cantonChange"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'others'">
				<xsl:value-of select="$elm-qst.other"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'other'">
				<xsl:value-of select="$elm-qst.other"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template for decoding withdrawal reason value-->
	<xsl:template name="decode-withdrawalReason">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'withdrawalCompany'">
				<xsl:value-of select="$elm-qst.withdrawalCompany"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'naturalization'">
				<xsl:value-of select="$elm-qst.naturalization"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'settled-C'">
				<xsl:value-of select="$elm-qst.settled-C"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'temporary'">
				<xsl:value-of select="$elm-qst.temporary"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'cantonChange'">
				<xsl:value-of select="$elm-qst.cantonChange"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'other'">
				<xsl:value-of select="$elm-qst.other"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="mutations">
		<xsl:param name="declarationcat"/>
		<xsl:if test="$declarationcat/*[local-name()='Mutation']">
			<xsl:for-each select="$declarationcat/*[local-name()='Mutation']">
				<xsl:call-template name="decode-mutation">
					<xsl:with-param name="value" select="./*[local-name()='Reason']"/>
				</xsl:call-template>
				<xsl:if test="./*[local-name()='ValidAsOf']">
					<xsl:text> (</xsl:text>
					<xsl:call-template name="format-date">
						<xsl:with-param name="value" select="./*[local-name()='ValidAsOf']"/>
					</xsl:call-template>
					<xsl:text>)</xsl:text>
				</xsl:if>
				<xsl:if test="position() != last()">
					<xsl:text>, </xsl:text>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!-- Template for decoding the mutation value-->
	<xsl:template name="decode-mutation">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'civilstate'">
				<xsl:value-of select="$elm-qst.civilStatus"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'partnerWork'">
				<xsl:value-of select="$elm-qst.partnerWork"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'sideline'">
				<xsl:value-of select="$elm-qst.sideline"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'partnerWorkIT'">
				<xsl:value-of select="$elm-qst.partnerWorkIT"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'residence'">
				<xsl:value-of select="$elm-qst.residentAddress"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'childrenDeduction'">
				<xsl:value-of select="$elm-qst.childrenDeduction"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'churchTax'">
				<xsl:value-of select="$elm-qst.churchTax"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'activityRate'">
				<xsl:value-of select="$elm-qst.activityRate"/>
			</xsl:when>
			<xsl:when test="$trimmed-value = 'others'">
				<xsl:value-of select="$elm-qst.other"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template for decoding residence category -->
	<xsl:template name="decode-residenceCategory">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="contains($trimmed-value, 'shortTerm')">
				<xsl:value-of select="$elm-qst.shortTerm"/>
			</xsl:when>
			<xsl:when test="contains($trimmed-value, 'annual')">
				<xsl:value-of select="$elm-qst.annual"/>
			</xsl:when>
			<xsl:when test="contains($trimmed-value, 'settled')">
				<xsl:value-of select="$elm-qst.settled"/>
			</xsl:when>
			<xsl:when test="contains($trimmed-value, 'crossBorder')">
				<xsl:value-of select="$elm-qst.crossBorder"/>
			</xsl:when>
			<xsl:when test="contains($trimmed-value, 'asylumSeeker')">
				<xsl:value-of select="$elm-qst.asylumSeeker"/>
			</xsl:when>
			<xsl:when test="contains($trimmed-value, 'needForProtection')">
				<xsl:value-of select="$elm-qst.needForProtection"/>
			</xsl:when>
			<xsl:when test="contains($trimmed-value, 'othersNotSwiss')">
				<xsl:value-of select="$elm-qst.other"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$trimmed-value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template for decoding residence -->
	<xsl:template name="decode-residence">
		<xsl:param name="residence"/>
		<xsl:if test="$residence/*[local-name()='CantonCH']">
			<xsl:value-of select="$elm-qst.canton"/>
			<xsl:text>: </xsl:text>
			<xsl:value-of select="$residence/*[local-name()='CantonCH']"/>
		</xsl:if>
		<xsl:if test="$residence/*[local-name()='AbroadCountry']">
			<xsl:value-of select="$elm-qst.country"/>
			<xsl:text>: </xsl:text>
			<xsl:value-of select="$residence/*[local-name()='AbroadCountry']"/>
		</xsl:if>
	</xsl:template>
	<!-- Template for formatting the amount right justified -->
	<xsl:template name="format-amount-right-justified">
		<xsl:param name="amount"/>
		<xsl:param name="horizontal"/>
		<xsl:param name="firstCell" select="false()"/>
		<xsl:param name="printCurrency" select="true()"/>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid">
			<xsl:if test="$firstCell = true() or not($horizontal)">
				<xsl:attribute name="start-indent">0in</xsl:attribute>
			</xsl:if>
			<fo:table-column column-width="proportional-column-width(1)" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="2"/>
			<xsl:if test="not($horizontal)">
				<fo:table-column column-width="proportional-column-width(8)" column-number="3"/>
			</xsl:if>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:if test="($amount or $amount = 0) and $printCurrency=true()">
								<xsl:text>CHF</xsl:text>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column" text-align="right">
						<fo:block>
							<xsl:value-of select="format-number($amount, $cents-format)"/>
						</fo:block>
					</fo:table-cell>
					<xsl:if test="not($horizontal)">
						<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
							<fo:block/>
						</fo:table-cell>
					</xsl:if>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Template for formatting the amount right justified on 2 columns -->
	<xsl:template name="format-amount-right-justified-two-columns">
		<xsl:param name="amount"/>
		<xsl:param name="horizontal"/>
		<xsl:variable name="empty-col-width">
			<xsl:choose>
				<xsl:when test="$horizontal">
					<xsl:text>proportional-column-width(12.5)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>proportional-column-width(8)</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<fo:table table-layout="fixed" width="100%" page-break-inside="avoid" start-indent="0in">
			<fo:table-column column-width="proportional-column-width(1)" column-number="1"/>
			<fo:table-column column-width="proportional-column-width(2)" column-number="2"/>
			<fo:table-column column-width="{$empty-col-width}" column-number="3"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell column-number="1" xsl:use-attribute-sets="value-column">
						<fo:block>
							<xsl:if test="$amount or $amount = 0">
								<xsl:text>CHF</xsl:text>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="value-column" text-align="right">
						<fo:block>
							<xsl:value-of select="format-number($amount, $cents-format)"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell column-number="3" xsl:use-attribute-sets="value-column">
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!-- Template for formatting the address -->
	<xsl:template name="format-address">
		<xsl:param name="address"/>
		<xsl:if test="$address/*[local-name()='Street']">
			<fo:block>
				<xsl:value-of select="$address/*[local-name()='Street']"/>
			</fo:block>
		</xsl:if>
		<fo:block>
			<xsl:value-of select="$address/*[local-name()='ZIP-Code']"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="$address/*[local-name()='City']"/>
			<xsl:if test="$address/*[local-name()='Country']">
				<xsl:text>, </xsl:text>
				<xsl:value-of select="$address/*[local-name()='Country']"/>
			</xsl:if>
		</fo:block>
	</xsl:template>
	<!-- Template for decoding the employment status of the marriage partner -->
	<xsl:template name="decode-employed">
		<xsl:param name="payment"/>
		<xsl:if test="$payment/*[local-name()='WorkOrCompensatory']/*[local-name()='SideJob']">
			<xsl:value-of select="$elm-qst.yes"/>
			<xsl:text> (</xsl:text>
			<xsl:value-of select="$elm-qst.sideJob"/>
			<xsl:text>)</xsl:text>
		</xsl:if>
		<xsl:if test="$payment/*[local-name()='WorkOrCompensatory'] and not($payment/*[local-name()='WorkOrCompensatory']/*[local-name()='SideJob'])">
			<xsl:value-of select="$elm-qst.yes"/>
		</xsl:if>
		<xsl:if test="$payment/*[local-name()='Annuity']">
			<xsl:value-of select="$elm-qst.pension"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="decode-taxatsource-category-verbose">
		<xsl:param name="value"/>
		<!-- TaxAtSourceCategory -->
		<xsl:if test="$value/*[local-name()='TaxAtSourceCode']">
			<xsl:value-of select="$elm-qst.taxAtSourceCategoryNormal"/>
		</xsl:if>
		<xsl:if test="$value/*[local-name()='CategoryPredefined']">
			<xsl:variable name="trimmed-value" select="normalize-space($value/*[local-name()='CategoryPredefined'])"/>
			<xsl:choose>
				<xsl:when test="$trimmed-value = 'SFN'">
					<xsl:value-of select="$elm-qst.taxAtSourceCategorySpecialAgreement"/>
				</xsl:when>
				<xsl:when test="$trimmed-value = 'HEY' or $trimmed-value = 'HEN'">
					<xsl:value-of select="$elm-qst.taxAtSourceCategoryDirectorsAbroad"/>
				</xsl:when>
				<xsl:when test="$trimmed-value = 'MEY' or $trimmed-value = 'MEN'">
					<xsl:value-of select="$elm-qst.taxAtSourceCategoryValuesServicesAbroad"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$trimmed-value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$value/*[local-name()='CategoryOpen']">
			<xsl:value-of select="$elm-qst.taxAtSourceCategoryOpen"/>
		</xsl:if>
		<!--<xsl:if test="$value/*[local-name()]">
			<xsl:value-of select="$elm-qst.taxAtSourceCategoryOpen"/>
		</xsl:if> -->
	</xsl:template>
	<!-- Template for decoding the denomination -->
	<xsl:template name="decode-denomination">
		<xsl:param name="additionalParticulars"/>
		<xsl:if test="$additionalParticulars/*[local-name()='Denomination']">
			<xsl:variable name="trimmed-value" select="normalize-space($additionalParticulars/*[local-name()='Denomination'])"/>
			<xsl:choose>
				<xsl:when test="$trimmed-value = 'romanCatholic'">
					<xsl:value-of select="$elm-qst.romanCatholic"/>
				</xsl:when>
				<xsl:when test="$trimmed-value = 'christianCatholic'">
					<xsl:value-of select="$elm-qst.christianCatholic"/>
				</xsl:when>
				<xsl:when test="$trimmed-value = 'reformedEvangelical'">
					<xsl:value-of select="$elm-qst.reformedEvangelical"/>
				</xsl:when>
				<xsl:when test="$trimmed-value = 'jewishCommunity'">
					<xsl:value-of select="$elm-qst.jewishCommunity"/>
				</xsl:when>
				<xsl:when test="$trimmed-value = 'otherOrNone'">
					<xsl:value-of select="$elm-qst.otherOrNone"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- Template for decoding the denomination -->
	<xsl:template name="decode-sidejob">
		<xsl:param name="additionalParticulars"/>
		<xsl:choose>
			<xsl:when test="$additionalParticulars/*[local-name()='Employment']">
				<xsl:variable name="trimmed-value" select="normalize-space($additionalParticulars/*[local-name()='Employment'])"/>
				<xsl:choose>
					<xsl:when test="$trimmed-value = 'sideJob'">
						<xsl:value-of select="$elm-qst.yes"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$elm-qst.no"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$elm-qst.no"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="decode-workplace">
		<xsl:param name="workplaceId"/>
		<xsl:call-template name="format-address">
			<xsl:with-param name="address" select="//*[local-name()='DeclareSalary']/*[local-name()='SalaryDeclaration']/*[local-name()='Company']/*[local-name()='CompanyDescription']/*[local-name()='Workplace' and @workplaceID=$workplaceId]/*[local-name()='AddressExtended']"/>
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>