<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:import href="eahv-iv-2015-common-language-7-0_de.xsl"/>
	
	<!--
		Format a time stamp for display in PDF.
		@param value the date to be formatted (eg 2001-12-17T09:30:47Z)
	-->
	<xsl:template name="format-timestamp">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="string-length($trimmed-value) > 0">
				<xsl:variable name="year" select="substring($trimmed-value, 1, 4)"/>
				<xsl:variable name="month" select="substring($trimmed-value, 6, 2)"/>
				<xsl:variable name="day" select="substring($trimmed-value, 9, 2)"/>
				<xsl:variable name="hour" select="substring($trimmed-value, 12, 2)"/>
				<xsl:variable name="min" select="substring($trimmed-value, 15, 2)"/>
				<xsl:variable name="sec" select="substring($trimmed-value, 18, 2)"/>
				<xsl:value-of select="$day"/>.<xsl:value-of select="$month"/>.<xsl:value-of select="$year"/><xsl:text> </xsl:text><xsl:value-of select="$hour"/>:<xsl:value-of select="$min"/>:<xsl:value-of select="$sec"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- Layout used only by EO Meldungen -->
	<!-- (Like main-right-column, but not in bold) -->
	<xsl:attribute-set name="main-right-column-regular">
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="margin-left">1.5mm</xsl:attribute>
		<xsl:attribute name="border-left-color">black</xsl:attribute>
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
	</xsl:attribute-set>
	
	<!--
		Decode a boolean value to a human readable string (yes/no)
		@param value the boolean to be decoded 
	-->
    <xsl:template name="decode-boolean">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = 'true'"><xsl:value-of select="$eahv-iv-2015-common.yes"/></xsl:when>
			<xsl:when test="$trimmed-value = 'false'"><xsl:value-of select="$eahv-iv-2015-common.no"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
    </xsl:template>	
	
	<!--
		Decode a canton to a human readable string.
		@param value the canton to be decoded
	-->
	<xsl:template name="decode-canton">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-common.canton.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2015-common.canton.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2015-common.canton.3"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2015-common.canton.4"/></xsl:when>
			<xsl:when test="$trimmed-value = '5'"><xsl:value-of select="$eahv-iv-2015-common.canton.5"/></xsl:when>
			<xsl:when test="$trimmed-value = '6'"><xsl:value-of select="$eahv-iv-2015-common.canton.6"/></xsl:when>
			<xsl:when test="$trimmed-value = '7'"><xsl:value-of select="$eahv-iv-2015-common.canton.7"/></xsl:when>
			<xsl:when test="$trimmed-value = '8'"><xsl:value-of select="$eahv-iv-2015-common.canton.8"/></xsl:when>
			<xsl:when test="$trimmed-value = '9'"><xsl:value-of select="$eahv-iv-2015-common.canton.9"/></xsl:when>
			<xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eahv-iv-2015-common.canton.10"/></xsl:when>
			<xsl:when test="$trimmed-value = '11'"><xsl:value-of select="$eahv-iv-2015-common.canton.11"/></xsl:when>
			<xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eahv-iv-2015-common.canton.12"/></xsl:when>
			<xsl:when test="$trimmed-value = '13'"><xsl:value-of select="$eahv-iv-2015-common.canton.13"/></xsl:when>
			<xsl:when test="$trimmed-value = '14'"><xsl:value-of select="$eahv-iv-2015-common.canton.14"/></xsl:when>
			<xsl:when test="$trimmed-value = '15'"><xsl:value-of select="$eahv-iv-2015-common.canton.15"/></xsl:when>
			<xsl:when test="$trimmed-value = '16'"><xsl:value-of select="$eahv-iv-2015-common.canton.16"/></xsl:when>
			<xsl:when test="$trimmed-value = '17'"><xsl:value-of select="$eahv-iv-2015-common.canton.17"/></xsl:when>
			<xsl:when test="$trimmed-value = '18'"><xsl:value-of select="$eahv-iv-2015-common.canton.18"/></xsl:when>
			<xsl:when test="$trimmed-value = '19'"><xsl:value-of select="$eahv-iv-2015-common.canton.19"/></xsl:when>
			<xsl:when test="$trimmed-value = '20'"><xsl:value-of select="$eahv-iv-2015-common.canton.20"/></xsl:when>
			<xsl:when test="$trimmed-value = '21'"><xsl:value-of select="$eahv-iv-2015-common.canton.21"/></xsl:when>
			<xsl:when test="$trimmed-value = '22'"><xsl:value-of select="$eahv-iv-2015-common.canton.22"/></xsl:when>
			<xsl:when test="$trimmed-value = '23'"><xsl:value-of select="$eahv-iv-2015-common.canton.23"/></xsl:when>
			<xsl:when test="$trimmed-value = '24'"><xsl:value-of select="$eahv-iv-2015-common.canton.24"/></xsl:when>
			<xsl:when test="$trimmed-value = '25'"><xsl:value-of select="$eahv-iv-2015-common.canton.25"/></xsl:when>
			<xsl:when test="$trimmed-value = '50'"><xsl:value-of select="$eahv-iv-2015-common.canton.50"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!--
		Decode a country to a human readable string.
		@param value the country to be decoded (gemäss Dokument "Die Schlüsselzahlen der Staaten" vom BSV)
	-->
	<xsl:template name="decode-country">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '100'"><xsl:value-of select="$eahv-iv-2015-common.country.100"/></xsl:when>
			<xsl:when test="$trimmed-value = '201'"><xsl:value-of select="$eahv-iv-2015-common.country.201"/></xsl:when>
			<xsl:when test="$trimmed-value = '202'"><xsl:value-of select="$eahv-iv-2015-common.country.202"/></xsl:when>
			<xsl:when test="$trimmed-value = '204'"><xsl:value-of select="$eahv-iv-2015-common.country.204"/></xsl:when>
			<xsl:when test="$trimmed-value = '205'"><xsl:value-of select="$eahv-iv-2015-common.country.205"/></xsl:when>
			<xsl:when test="$trimmed-value = '206'"><xsl:value-of select="$eahv-iv-2015-common.country.206"/></xsl:when>
			<xsl:when test="$trimmed-value = '207'"><xsl:value-of select="$eahv-iv-2015-common.country.207"/></xsl:when>
			<xsl:when test="$trimmed-value = '211'"><xsl:value-of select="$eahv-iv-2015-common.country.211"/></xsl:when>
			<xsl:when test="$trimmed-value = '212'"><xsl:value-of select="$eahv-iv-2015-common.country.212"/></xsl:when>
			<xsl:when test="$trimmed-value = '214'"><xsl:value-of select="$eahv-iv-2015-common.country.214"/></xsl:when>
			<xsl:when test="$trimmed-value = '215'"><xsl:value-of select="$eahv-iv-2015-common.country.215"/></xsl:when>
			<xsl:when test="$trimmed-value = '216'"><xsl:value-of select="$eahv-iv-2015-common.country.216"/></xsl:when>
			<xsl:when test="$trimmed-value = '217'"><xsl:value-of select="$eahv-iv-2015-common.country.217"/></xsl:when>
			<xsl:when test="$trimmed-value = '218'"><xsl:value-of select="$eahv-iv-2015-common.country.218"/></xsl:when>
			<xsl:when test="$trimmed-value = '222'"><xsl:value-of select="$eahv-iv-2015-common.country.222"/></xsl:when>
			<xsl:when test="$trimmed-value = '223'"><xsl:value-of select="$eahv-iv-2015-common.country.223"/></xsl:when>
			<xsl:when test="$trimmed-value = '224'"><xsl:value-of select="$eahv-iv-2015-common.country.224"/></xsl:when>
			<xsl:when test="$trimmed-value = '226'"><xsl:value-of select="$eahv-iv-2015-common.country.226"/></xsl:when>
			<xsl:when test="$trimmed-value = '227'"><xsl:value-of select="$eahv-iv-2015-common.country.227"/></xsl:when>
			<xsl:when test="$trimmed-value = '228'"><xsl:value-of select="$eahv-iv-2015-common.country.228"/></xsl:when>
			<xsl:when test="$trimmed-value = '229'"><xsl:value-of select="$eahv-iv-2015-common.country.229"/></xsl:when>
			<xsl:when test="$trimmed-value = '230'"><xsl:value-of select="$eahv-iv-2015-common.country.230"/></xsl:when>
			<xsl:when test="$trimmed-value = '231'"><xsl:value-of select="$eahv-iv-2015-common.country.231"/></xsl:when>
			<xsl:when test="$trimmed-value = '232'"><xsl:value-of select="$eahv-iv-2015-common.country.232"/></xsl:when>
			<xsl:when test="$trimmed-value = '233'"><xsl:value-of select="$eahv-iv-2015-common.country.233"/></xsl:when>
			<xsl:when test="$trimmed-value = '234'"><xsl:value-of select="$eahv-iv-2015-common.country.234"/></xsl:when>
			<xsl:when test="$trimmed-value = '235'"><xsl:value-of select="$eahv-iv-2015-common.country.235"/></xsl:when>
			<xsl:when test="$trimmed-value = '236'"><xsl:value-of select="$eahv-iv-2015-common.country.236"/></xsl:when>
			<xsl:when test="$trimmed-value = '239'"><xsl:value-of select="$eahv-iv-2015-common.country.239"/></xsl:when>
			<xsl:when test="$trimmed-value = '240'"><xsl:value-of select="$eahv-iv-2015-common.country.240"/></xsl:when>
			<xsl:when test="$trimmed-value = '241'"><xsl:value-of select="$eahv-iv-2015-common.country.241"/></xsl:when>
			<xsl:when test="$trimmed-value = '242'"><xsl:value-of select="$eahv-iv-2015-common.country.242"/></xsl:when>
			<xsl:when test="$trimmed-value = '243'"><xsl:value-of select="$eahv-iv-2015-common.country.243"/></xsl:when>
			<xsl:when test="$trimmed-value = '244'"><xsl:value-of select="$eahv-iv-2015-common.country.244"/></xsl:when>
			<xsl:when test="$trimmed-value = '249'"><xsl:value-of select="$eahv-iv-2015-common.country.249"/></xsl:when>
			<xsl:when test="$trimmed-value = '250'"><xsl:value-of select="$eahv-iv-2015-common.country.250"/></xsl:when>
			<xsl:when test="$trimmed-value = '251'"><xsl:value-of select="$eahv-iv-2015-common.country.251"/></xsl:when>
			<xsl:when test="$trimmed-value = '252'"><xsl:value-of select="$eahv-iv-2015-common.country.252"/></xsl:when>
			<xsl:when test="$trimmed-value = '255'"><xsl:value-of select="$eahv-iv-2015-common.country.255"/></xsl:when>
			<xsl:when test="$trimmed-value = '260'"><xsl:value-of select="$eahv-iv-2015-common.country.260"/></xsl:when>
			<xsl:when test="$trimmed-value = '261'"><xsl:value-of select="$eahv-iv-2015-common.country.261"/></xsl:when>
			<xsl:when test="$trimmed-value = '262'"><xsl:value-of select="$eahv-iv-2015-common.country.262"/></xsl:when>
			<xsl:when test="$trimmed-value = '263'"><xsl:value-of select="$eahv-iv-2015-common.country.263"/></xsl:when>
			<xsl:when test="$trimmed-value = '264'"><xsl:value-of select="$eahv-iv-2015-common.country.264"/></xsl:when>
			<xsl:when test="$trimmed-value = '265'"><xsl:value-of select="$eahv-iv-2015-common.country.265"/></xsl:when>
			<xsl:when test="$trimmed-value = '266'"><xsl:value-of select="$eahv-iv-2015-common.country.266"/></xsl:when>
			<xsl:when test="$trimmed-value = '301'"><xsl:value-of select="$eahv-iv-2015-common.country.301"/></xsl:when>
			<xsl:when test="$trimmed-value = '302'"><xsl:value-of select="$eahv-iv-2015-common.country.302"/></xsl:when>
			<xsl:when test="$trimmed-value = '303'"><xsl:value-of select="$eahv-iv-2015-common.country.303"/></xsl:when>
			<xsl:when test="$trimmed-value = '304'"><xsl:value-of select="$eahv-iv-2015-common.country.304"/></xsl:when>
			<xsl:when test="$trimmed-value = '305'"><xsl:value-of select="$eahv-iv-2015-common.country.305"/></xsl:when>
			<xsl:when test="$trimmed-value = '307'"><xsl:value-of select="$eahv-iv-2015-common.country.307"/></xsl:when>
			<xsl:when test="$trimmed-value = '308'"><xsl:value-of select="$eahv-iv-2015-common.country.308"/></xsl:when>
			<xsl:when test="$trimmed-value = '309'"><xsl:value-of select="$eahv-iv-2015-common.country.309"/></xsl:when>
			<xsl:when test="$trimmed-value = '310'"><xsl:value-of select="$eahv-iv-2015-common.country.310"/></xsl:when>
			<xsl:when test="$trimmed-value = '311'"><xsl:value-of select="$eahv-iv-2015-common.country.311"/></xsl:when>
			<xsl:when test="$trimmed-value = '312'"><xsl:value-of select="$eahv-iv-2015-common.country.312"/></xsl:when>
			<xsl:when test="$trimmed-value = '313'"><xsl:value-of select="$eahv-iv-2015-common.country.313"/></xsl:when>
			<xsl:when test="$trimmed-value = '314'"><xsl:value-of select="$eahv-iv-2015-common.country.314"/></xsl:when>
			<xsl:when test="$trimmed-value = '315'"><xsl:value-of select="$eahv-iv-2015-common.country.315"/></xsl:when>
			<xsl:when test="$trimmed-value = '317'"><xsl:value-of select="$eahv-iv-2015-common.country.317"/></xsl:when>
			<xsl:when test="$trimmed-value = '319'"><xsl:value-of select="$eahv-iv-2015-common.country.319"/></xsl:when>
			<xsl:when test="$trimmed-value = '320'"><xsl:value-of select="$eahv-iv-2015-common.country.320"/></xsl:when>
			<xsl:when test="$trimmed-value = '321'"><xsl:value-of select="$eahv-iv-2015-common.country.321"/></xsl:when>
			<xsl:when test="$trimmed-value = '322'"><xsl:value-of select="$eahv-iv-2015-common.country.322"/></xsl:when>
			<xsl:when test="$trimmed-value = '323'"><xsl:value-of select="$eahv-iv-2015-common.country.323"/></xsl:when>
			<xsl:when test="$trimmed-value = '324'"><xsl:value-of select="$eahv-iv-2015-common.country.324"/></xsl:when>
			<xsl:when test="$trimmed-value = '325'"><xsl:value-of select="$eahv-iv-2015-common.country.325"/></xsl:when>
			<xsl:when test="$trimmed-value = '326'"><xsl:value-of select="$eahv-iv-2015-common.country.326"/></xsl:when>
			<xsl:when test="$trimmed-value = '327'"><xsl:value-of select="$eahv-iv-2015-common.country.327"/></xsl:when>
			<xsl:when test="$trimmed-value = '329'"><xsl:value-of select="$eahv-iv-2015-common.country.329"/></xsl:when>
			<xsl:when test="$trimmed-value = '330'"><xsl:value-of select="$eahv-iv-2015-common.country.330"/></xsl:when>
			<xsl:when test="$trimmed-value = '331'"><xsl:value-of select="$eahv-iv-2015-common.country.331"/></xsl:when>
			<xsl:when test="$trimmed-value = '332'"><xsl:value-of select="$eahv-iv-2015-common.country.332"/></xsl:when>
			<xsl:when test="$trimmed-value = '333'"><xsl:value-of select="$eahv-iv-2015-common.country.333"/></xsl:when>
			<xsl:when test="$trimmed-value = '334'"><xsl:value-of select="$eahv-iv-2015-common.country.334"/></xsl:when>
			<xsl:when test="$trimmed-value = '335'"><xsl:value-of select="$eahv-iv-2015-common.country.335"/></xsl:when>
			<xsl:when test="$trimmed-value = '336'"><xsl:value-of select="$eahv-iv-2015-common.country.336"/></xsl:when>
			<xsl:when test="$trimmed-value = '337'"><xsl:value-of select="$eahv-iv-2015-common.country.337"/></xsl:when>
			<xsl:when test="$trimmed-value = '340'"><xsl:value-of select="$eahv-iv-2015-common.country.340"/></xsl:when>
			<xsl:when test="$trimmed-value = '341'"><xsl:value-of select="$eahv-iv-2015-common.country.341"/></xsl:when>
			<xsl:when test="$trimmed-value = '343'"><xsl:value-of select="$eahv-iv-2015-common.country.343"/></xsl:when>
			<xsl:when test="$trimmed-value = '344'"><xsl:value-of select="$eahv-iv-2015-common.country.344"/></xsl:when>
			<xsl:when test="$trimmed-value = '345'"><xsl:value-of select="$eahv-iv-2015-common.country.345"/></xsl:when>
			<xsl:when test="$trimmed-value = '346'"><xsl:value-of select="$eahv-iv-2015-common.country.346"/></xsl:when>
			<xsl:when test="$trimmed-value = '347'"><xsl:value-of select="$eahv-iv-2015-common.country.347"/></xsl:when>
			<xsl:when test="$trimmed-value = '348'"><xsl:value-of select="$eahv-iv-2015-common.country.348"/></xsl:when>
			<xsl:when test="$trimmed-value = '349'"><xsl:value-of select="$eahv-iv-2015-common.country.349"/></xsl:when>
			<xsl:when test="$trimmed-value = '350'"><xsl:value-of select="$eahv-iv-2015-common.country.350"/></xsl:when>
			<xsl:when test="$trimmed-value = '351'"><xsl:value-of select="$eahv-iv-2015-common.country.351"/></xsl:when>
			<xsl:when test="$trimmed-value = '352'"><xsl:value-of select="$eahv-iv-2015-common.country.352"/></xsl:when>
			<xsl:when test="$trimmed-value = '353'"><xsl:value-of select="$eahv-iv-2015-common.country.353"/></xsl:when>
			<xsl:when test="$trimmed-value = '354'"><xsl:value-of select="$eahv-iv-2015-common.country.354"/></xsl:when>
			<xsl:when test="$trimmed-value = '356'"><xsl:value-of select="$eahv-iv-2015-common.country.356"/></xsl:when>
			<xsl:when test="$trimmed-value = '357'"><xsl:value-of select="$eahv-iv-2015-common.country.357"/></xsl:when>
			<xsl:when test="$trimmed-value = '358'"><xsl:value-of select="$eahv-iv-2015-common.country.358"/></xsl:when>
			<xsl:when test="$trimmed-value = '359'"><xsl:value-of select="$eahv-iv-2015-common.country.359"/></xsl:when>
			<xsl:when test="$trimmed-value = '360'"><xsl:value-of select="$eahv-iv-2015-common.country.360"/></xsl:when>
			<xsl:when test="$trimmed-value = '362'"><xsl:value-of select="$eahv-iv-2015-common.country.362"/></xsl:when>
			<xsl:when test="$trimmed-value = '401'"><xsl:value-of select="$eahv-iv-2015-common.country.401"/></xsl:when>
			<xsl:when test="$trimmed-value = '402'"><xsl:value-of select="$eahv-iv-2015-common.country.402"/></xsl:when>
			<xsl:when test="$trimmed-value = '403'"><xsl:value-of select="$eahv-iv-2015-common.country.403"/></xsl:when>
			<xsl:when test="$trimmed-value = '405'"><xsl:value-of select="$eahv-iv-2015-common.country.405"/></xsl:when>
			<xsl:when test="$trimmed-value = '406'"><xsl:value-of select="$eahv-iv-2015-common.country.406"/></xsl:when>
			<xsl:when test="$trimmed-value = '407'"><xsl:value-of select="$eahv-iv-2015-common.country.407"/></xsl:when>
			<xsl:when test="$trimmed-value = '408'"><xsl:value-of select="$eahv-iv-2015-common.country.408"/></xsl:when>
			<xsl:when test="$trimmed-value = '409'"><xsl:value-of select="$eahv-iv-2015-common.country.409"/></xsl:when>
			<xsl:when test="$trimmed-value = '410'"><xsl:value-of select="$eahv-iv-2015-common.country.410"/></xsl:when>
			<xsl:when test="$trimmed-value = '411'"><xsl:value-of select="$eahv-iv-2015-common.country.411"/></xsl:when>
			<xsl:when test="$trimmed-value = '415'"><xsl:value-of select="$eahv-iv-2015-common.country.415"/></xsl:when>
			<xsl:when test="$trimmed-value = '417'"><xsl:value-of select="$eahv-iv-2015-common.country.417"/></xsl:when>
			<xsl:when test="$trimmed-value = '418'"><xsl:value-of select="$eahv-iv-2015-common.country.418"/></xsl:when>
			<xsl:when test="$trimmed-value = '419'"><xsl:value-of select="$eahv-iv-2015-common.country.419"/></xsl:when>
			<xsl:when test="$trimmed-value = '420'"><xsl:value-of select="$eahv-iv-2015-common.country.420"/></xsl:when>
			<xsl:when test="$trimmed-value = '421'"><xsl:value-of select="$eahv-iv-2015-common.country.421"/></xsl:when>
			<xsl:when test="$trimmed-value = '423'"><xsl:value-of select="$eahv-iv-2015-common.country.423"/></xsl:when>
			<xsl:when test="$trimmed-value = '424'"><xsl:value-of select="$eahv-iv-2015-common.country.424"/></xsl:when>
			<xsl:when test="$trimmed-value = '425'"><xsl:value-of select="$eahv-iv-2015-common.country.425"/></xsl:when>
			<xsl:when test="$trimmed-value = '427'"><xsl:value-of select="$eahv-iv-2015-common.country.427"/></xsl:when>
			<xsl:when test="$trimmed-value = '429'"><xsl:value-of select="$eahv-iv-2015-common.country.429"/></xsl:when>
			<xsl:when test="$trimmed-value = '430'"><xsl:value-of select="$eahv-iv-2015-common.country.430"/></xsl:when>
			<xsl:when test="$trimmed-value = '431'"><xsl:value-of select="$eahv-iv-2015-common.country.431"/></xsl:when>
			<xsl:when test="$trimmed-value = '432'"><xsl:value-of select="$eahv-iv-2015-common.country.432"/></xsl:when>
			<xsl:when test="$trimmed-value = '435'"><xsl:value-of select="$eahv-iv-2015-common.country.435"/></xsl:when>
			<xsl:when test="$trimmed-value = '436'"><xsl:value-of select="$eahv-iv-2015-common.country.436"/></xsl:when>
			<xsl:when test="$trimmed-value = '437'"><xsl:value-of select="$eahv-iv-2015-common.country.437"/></xsl:when>
			<xsl:when test="$trimmed-value = '438'"><xsl:value-of select="$eahv-iv-2015-common.country.438"/></xsl:when>
			<xsl:when test="$trimmed-value = '439'"><xsl:value-of select="$eahv-iv-2015-common.country.439"/></xsl:when>
			<xsl:when test="$trimmed-value = '440'"><xsl:value-of select="$eahv-iv-2015-common.country.440"/></xsl:when>
			<xsl:when test="$trimmed-value = '441'"><xsl:value-of select="$eahv-iv-2015-common.country.441"/></xsl:when>
			<xsl:when test="$trimmed-value = '442'"><xsl:value-of select="$eahv-iv-2015-common.country.442"/></xsl:when>
			<xsl:when test="$trimmed-value = '443'"><xsl:value-of select="$eahv-iv-2015-common.country.443"/></xsl:when>
			<xsl:when test="$trimmed-value = '444'"><xsl:value-of select="$eahv-iv-2015-common.country.444"/></xsl:when>
			<xsl:when test="$trimmed-value = '445'"><xsl:value-of select="$eahv-iv-2015-common.country.445"/></xsl:when>
			<xsl:when test="$trimmed-value = '501'"><xsl:value-of select="$eahv-iv-2015-common.country.501"/></xsl:when>
			<xsl:when test="$trimmed-value = '502'"><xsl:value-of select="$eahv-iv-2015-common.country.502"/></xsl:when>
			<xsl:when test="$trimmed-value = '503'"><xsl:value-of select="$eahv-iv-2015-common.country.503"/></xsl:when>
			<xsl:when test="$trimmed-value = '504'"><xsl:value-of select="$eahv-iv-2015-common.country.504"/></xsl:when>
			<xsl:when test="$trimmed-value = '505'"><xsl:value-of select="$eahv-iv-2015-common.country.505"/></xsl:when>
			<xsl:when test="$trimmed-value = '506'"><xsl:value-of select="$eahv-iv-2015-common.country.506"/></xsl:when>
			<xsl:when test="$trimmed-value = '507'"><xsl:value-of select="$eahv-iv-2015-common.country.507"/></xsl:when>
			<xsl:when test="$trimmed-value = '508'"><xsl:value-of select="$eahv-iv-2015-common.country.508"/></xsl:when>
			<xsl:when test="$trimmed-value = '510'"><xsl:value-of select="$eahv-iv-2015-common.country.510"/></xsl:when>
			<xsl:when test="$trimmed-value = '511'"><xsl:value-of select="$eahv-iv-2015-common.country.511"/></xsl:when>
			<xsl:when test="$trimmed-value = '512'"><xsl:value-of select="$eahv-iv-2015-common.country.512"/></xsl:when>
			<xsl:when test="$trimmed-value = '513'"><xsl:value-of select="$eahv-iv-2015-common.country.513"/></xsl:when>
			<xsl:when test="$trimmed-value = '514'"><xsl:value-of select="$eahv-iv-2015-common.country.514"/></xsl:when>
			<xsl:when test="$trimmed-value = '515'"><xsl:value-of select="$eahv-iv-2015-common.country.515"/></xsl:when>
			<xsl:when test="$trimmed-value = '516'"><xsl:value-of select="$eahv-iv-2015-common.country.516"/></xsl:when>
			<xsl:when test="$trimmed-value = '517'"><xsl:value-of select="$eahv-iv-2015-common.country.517"/></xsl:when>
			<xsl:when test="$trimmed-value = '518'"><xsl:value-of select="$eahv-iv-2015-common.country.518"/></xsl:when>
			<xsl:when test="$trimmed-value = '519'"><xsl:value-of select="$eahv-iv-2015-common.country.519"/></xsl:when>
			<xsl:when test="$trimmed-value = '521'"><xsl:value-of select="$eahv-iv-2015-common.country.521"/></xsl:when>
			<xsl:when test="$trimmed-value = '522'"><xsl:value-of select="$eahv-iv-2015-common.country.522"/></xsl:when>
			<xsl:when test="$trimmed-value = '523'"><xsl:value-of select="$eahv-iv-2015-common.country.523"/></xsl:when>
			<xsl:when test="$trimmed-value = '525'"><xsl:value-of select="$eahv-iv-2015-common.country.525"/></xsl:when>
			<xsl:when test="$trimmed-value = '526'"><xsl:value-of select="$eahv-iv-2015-common.country.526"/></xsl:when>
			<xsl:when test="$trimmed-value = '527'"><xsl:value-of select="$eahv-iv-2015-common.country.527"/></xsl:when>
			<xsl:when test="$trimmed-value = '528'"><xsl:value-of select="$eahv-iv-2015-common.country.528"/></xsl:when>
			<xsl:when test="$trimmed-value = '529'"><xsl:value-of select="$eahv-iv-2015-common.country.529"/></xsl:when>
			<xsl:when test="$trimmed-value = '530'"><xsl:value-of select="$eahv-iv-2015-common.country.530"/></xsl:when>
			<xsl:when test="$trimmed-value = '532'"><xsl:value-of select="$eahv-iv-2015-common.country.532"/></xsl:when>
			<xsl:when test="$trimmed-value = '533'"><xsl:value-of select="$eahv-iv-2015-common.country.533"/></xsl:when>
			<xsl:when test="$trimmed-value = '534'"><xsl:value-of select="$eahv-iv-2015-common.country.534"/></xsl:when>
			<xsl:when test="$trimmed-value = '535'"><xsl:value-of select="$eahv-iv-2015-common.country.535"/></xsl:when>
			<xsl:when test="$trimmed-value = '537'"><xsl:value-of select="$eahv-iv-2015-common.country.537"/></xsl:when>
			<xsl:when test="$trimmed-value = '539'"><xsl:value-of select="$eahv-iv-2015-common.country.539"/></xsl:when>
			<xsl:when test="$trimmed-value = '541'"><xsl:value-of select="$eahv-iv-2015-common.country.541"/></xsl:when>
			<xsl:when test="$trimmed-value = '542'"><xsl:value-of select="$eahv-iv-2015-common.country.542"/></xsl:when>
			<xsl:when test="$trimmed-value = '545'"><xsl:value-of select="$eahv-iv-2015-common.country.545"/></xsl:when>
			<xsl:when test="$trimmed-value = '546'"><xsl:value-of select="$eahv-iv-2015-common.country.546"/></xsl:when>
			<xsl:when test="$trimmed-value = '547'"><xsl:value-of select="$eahv-iv-2015-common.country.547"/></xsl:when>
			<xsl:when test="$trimmed-value = '560'"><xsl:value-of select="$eahv-iv-2015-common.country.560"/></xsl:when>
			<xsl:when test="$trimmed-value = '561'"><xsl:value-of select="$eahv-iv-2015-common.country.561"/></xsl:when>
			<xsl:when test="$trimmed-value = '562'"><xsl:value-of select="$eahv-iv-2015-common.country.562"/></xsl:when>
			<xsl:when test="$trimmed-value = '563'"><xsl:value-of select="$eahv-iv-2015-common.country.563"/></xsl:when>
			<xsl:when test="$trimmed-value = '564'"><xsl:value-of select="$eahv-iv-2015-common.country.564"/></xsl:when>
			<xsl:when test="$trimmed-value = '565'"><xsl:value-of select="$eahv-iv-2015-common.country.565"/></xsl:when>
			<xsl:when test="$trimmed-value = '566'"><xsl:value-of select="$eahv-iv-2015-common.country.566"/></xsl:when>
			<xsl:when test="$trimmed-value = '567'"><xsl:value-of select="$eahv-iv-2015-common.country.567"/></xsl:when>
			<xsl:when test="$trimmed-value = '601'"><xsl:value-of select="$eahv-iv-2015-common.country.601"/></xsl:when>
			<xsl:when test="$trimmed-value = '602'"><xsl:value-of select="$eahv-iv-2015-common.country.602"/></xsl:when>
			<xsl:when test="$trimmed-value = '604'"><xsl:value-of select="$eahv-iv-2015-common.country.604"/></xsl:when>
			<xsl:when test="$trimmed-value = '605'"><xsl:value-of select="$eahv-iv-2015-common.country.605"/></xsl:when>
			<xsl:when test="$trimmed-value = '607'"><xsl:value-of select="$eahv-iv-2015-common.country.607"/></xsl:when>
			<xsl:when test="$trimmed-value = '608'"><xsl:value-of select="$eahv-iv-2015-common.country.608"/></xsl:when>
			<xsl:when test="$trimmed-value = '610'"><xsl:value-of select="$eahv-iv-2015-common.country.610"/></xsl:when>
			<xsl:when test="$trimmed-value = '612'"><xsl:value-of select="$eahv-iv-2015-common.country.612"/></xsl:when>
			<xsl:when test="$trimmed-value = '614'"><xsl:value-of select="$eahv-iv-2015-common.country.614"/></xsl:when>
			<xsl:when test="$trimmed-value = '615'"><xsl:value-of select="$eahv-iv-2015-common.country.615"/></xsl:when>
			<xsl:when test="$trimmed-value = '616'"><xsl:value-of select="$eahv-iv-2015-common.country.616"/></xsl:when>
			<xsl:when test="$trimmed-value = '617'"><xsl:value-of select="$eahv-iv-2015-common.country.617"/></xsl:when>
			<xsl:when test="$trimmed-value = '618'"><xsl:value-of select="$eahv-iv-2015-common.country.618"/></xsl:when>
			<xsl:when test="$trimmed-value = '619'"><xsl:value-of select="$eahv-iv-2015-common.country.619"/></xsl:when>
			<xsl:when test="$trimmed-value = '998'"><xsl:value-of select="$eahv-iv-2015-common.country.998"/></xsl:when>
			<xsl:when test="$trimmed-value = '999'"><xsl:value-of select="$eahv-iv-2015-common.country.999"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-serviceType">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '10'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.10"/></xsl:when>
			<xsl:when test="$trimmed-value = '11'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.11"/></xsl:when>
			<xsl:when test="$trimmed-value = '12'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.12"/></xsl:when>
			<xsl:when test="$trimmed-value = '13'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.13"/></xsl:when>
			<xsl:when test="$trimmed-value = '14'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.14"/></xsl:when>
			<xsl:when test="$trimmed-value = '15'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.15"/></xsl:when>
			<xsl:when test="$trimmed-value = '16'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.16"/></xsl:when>
			<xsl:when test="$trimmed-value = '20'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.20"/></xsl:when>
			<xsl:when test="$trimmed-value = '21'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.21"/></xsl:when>
			<xsl:when test="$trimmed-value = '22'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.22"/></xsl:when>
			<xsl:when test="$trimmed-value = '23'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.23"/></xsl:when>
			<xsl:when test="$trimmed-value = '30'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.30"/></xsl:when>
			<xsl:when test="$trimmed-value = '40'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.40"/></xsl:when>
			<xsl:when test="$trimmed-value = '41'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.41"/></xsl:when>
			<xsl:when test="$trimmed-value = '50'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.50"/></xsl:when>
			<xsl:when test="$trimmed-value = '90'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.90"/></xsl:when>
			<xsl:when test="$trimmed-value = '91'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.91"/></xsl:when>
			<xsl:when test="$trimmed-value = '92'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.92"/></xsl:when>
			<xsl:when test="$trimmed-value = '93'"><xsl:value-of select="$eahv-iv-2015-common.serviceType.93"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="decode-paymentMethod">
		<xsl:param name="value"/>
		<xsl:variable name="trimmed-value" select="normalize-space($value)"/>
		<xsl:choose>
			<xsl:when test="$trimmed-value = '1'"><xsl:value-of select="$eahv-iv-2015-common.paymentMethod.1"/></xsl:when>
			<xsl:when test="$trimmed-value = '2'"><xsl:value-of select="$eahv-iv-2015-common.paymentMethod.2"/></xsl:when>
			<xsl:when test="$trimmed-value = '3'"><xsl:value-of select="$eahv-iv-2015-common.paymentMethod.3"/></xsl:when>
			<xsl:when test="$trimmed-value = '4'"><xsl:value-of select="$eahv-iv-2015-common.paymentMethod.4"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$trimmed-value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>