DECLARE @intErrorCode INT
begin transaction
-- Syntax is for SQL Server
declare @amount Int, @beforeDate datetime
-- DON'T SET LESS THAN 32 DAYS, otherwise you can lose some processes forever as the sedex timeout is 31 days
set @amount = 60
-- possible valued for the first argument are day, month, year
set @beforeDate = dateadd(day,-@amount,getdate());

begin transaction;
select * from ProcessMapping where messageId in (select messageId from Message where lastChange < @beforeDate);
-- delete from ProcessMapping where messageId in (select messageId from Message where lastChange < @beforeDate);

select * from smAudit where Message_id in (select id from Message where lastChange < @beforeDate);
-- delete from smAudit where Message_id in (select id from Message where lastChange < @beforeDate);

select * from GroupedMessageAudit where Message_id in (select id from Message where lastChange < @beforeDate);
-- delete from GroupedMessageAudit where Message_id in (select id from Message where lastChange < @beforeDate);

select * from Message where lastChange < @beforeDate;
-- delete from Message where lastChange < @beforeDate;

SELECT @intErrorCode = @@ERROR
    IF (@intErrorCode <> 0) GOTO PROBLEM
commit transaction;
PROBLEM:
IF (@intErrorCode <> 0) BEGIN
    ROLLBACK TRAN
END