-- based on camunda 7.7 schema https://docs.camunda.org/manual/7.7/user-guide/process-engine/database/
-- Syntax is for SQLPLUS query
-- DON'T SET LESS THAN 32 DAYS, otherwise you can lose some processes forever as the sedex timeout is 31 days
define amount = 60;
-- possible valued for interval are day, month, year
define beforeDate = current_timestamp-interval'&&amount'day(9);

-- create temporary tables
CREATE GLOBAL TEMPORARY TABLE IDSFROMVARINST 
                        AS (select v.BYTEARRAY_ID_
                        from ACT_HI_VARINST v, ACT_HI_PROCINST p 
                        where p.ID_ = v.PROC_INST_ID_ 
                            and v.BYTEARRAY_ID_ is not null
                            and p.END_TIME_ is not null
                            and p.END_TIME_ < &&beforeDate);
create unique index IDX_IDSFROMVARINST on IDSFROMVARINST(BYTEARRAY_ID_);
INSERT INTO IDSFROMVARINST 
    select v.BYTEARRAY_ID_
                        from ACT_HI_VARINST v, ACT_HI_PROCINST p 
                        where p.ID_ = v.PROC_INST_ID_ 
                            and v.BYTEARRAY_ID_ is not null
                            and p.END_TIME_ is not null
                            and p.END_TIME_ < &&beforeDate;

CREATE GLOBAL TEMPORARY TABLE IDSFROMDETAIL 
                        AS (select v.BYTEARRAY_ID_
                        from ACT_HI_DETAIL v, ACT_HI_PROCINST p 
                        where p.ID_ = v.PROC_INST_ID_ 
                            and v.BYTEARRAY_ID_ is not null
                            and p.END_TIME_ < &&beforeDate);
create unique index IDX_IDSFROMDETAIL on IDSFROMDETAIL(BYTEARRAY_ID_);
INSERT INTO IDSFROMDETAIL 
    select v.BYTEARRAY_ID_
                        from ACT_HI_DETAIL v, ACT_HI_PROCINST p 
                        where p.ID_ = v.PROC_INST_ID_ 
                            and v.BYTEARRAY_ID_ is not null
                            and p.END_TIME_ < &&beforeDate;

CREATE GLOBAL TEMPORARY TABLE IDSFROMPROCINST 
                        AS (select ID_ from ACT_HI_PROCINST where END_TIME_ < &&beforeDate);
create unique index IDX_IDSFROMPROCINST on IDSFROMPROCINST(ID_);
INSERT INTO IDSFROMPROCINST 
    select ID_ from ACT_HI_PROCINST where END_TIME_ < &&beforeDate;

-- delete act_ge_bytearray table, query can be slow
delete from ACT_GE_BYTEARRAY where ID_ IN (select BYTEARRAY_ID_ from IDSFROMVARINST);
delete from ACT_GE_BYTEARRAY where ID_ IN (select BYTEARRAY_ID_ from IDSFROMDETAIL);

-- delete all act_hi_* tables which have reference to a process instance (proc_inst_id)
delete from ACT_HI_ACTINST where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_ATTACHMENT where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_COMMENT where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_DECINST where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_DETAIL where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_EXT_TASK_LOG where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_INCIDENT where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_JOB_LOG where PROCESS_INSTANCE_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_OP_LOG where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_TASKINST where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);
delete from ACT_HI_VARINST where PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);

-- finally delete all process instances
delete from ACT_HI_PROCINST where END_TIME_ is not null 
    and PROC_INST_ID_ IN (select ID_ from IDSFROMPROCINST);

-- remove temporary tables
truncate table IDSFROMVARINST;
drop index IDX_IDSFROMVARINST;
drop table IDSFROMVARINST;
truncate table IDSFROMDETAIL;
drop index IDX_IDSFROMDETAIL;
drop table IDSFROMDETAIL;
truncate table IDSFROMPROCINST;
drop index IDX_IDSFROMPROCINST;
drop table IDSFROMPROCINST;

commit; 

-- following tables are not used: act_hi_batch, act_hi_caseactinst, act_hi_dec_in, act_hi_dec_out, act_hi_identitylink