-- based on camunda 7.7 schema https://docs.camunda.org/manual/7.7/user-guide/process-engine/database/
-- Syntax is for mysql query with mysql program
use smclient
-- DON'T SET LESS THAN 32 DAYS, otherwise you can lose some processes forever as the sedex timeout is 31 days
set @amount = 60;
-- possible valued for interval are day, month, year
set @beforeDate = current_timestamp - interval @amount day;


CREATE TEMPORARY TABLE IF NOT EXISTS idsFromVarInst AS (select v.BYTEARRAY_ID_
from ACT_HI_VARINST v, ACT_HI_PROCINST p 
where p.ID_ = v.PROC_INST_ID_ 
    and v.BYTEARRAY_ID_ is not null
    and p.END_TIME_ is not null
    and p.END_TIME_ < @beforeDate);
create unique index idx_idsFromVarInst on idsFromVarInst(BYTEARRAY_ID_);

CREATE TEMPORARY TABLE IF NOT EXISTS idsFromDetail AS (select v.BYTEARRAY_ID_
from ACT_HI_DETAIL v, ACT_HI_PROCINST p 
where p.ID_ = v.PROC_INST_ID_ 
    and v.BYTEARRAY_ID_ is not null
    and p.END_TIME_ < @beforeDate);
create unique index idx_idsFromDetail on idsFromDetail(BYTEARRAY_ID_);

CREATE TEMPORARY TABLE IF NOT EXISTS idsFromProcInst AS (select ID_ from ACT_HI_PROCINST where END_TIME_ < @beforeDate);
create unique index idx_idsFromProcInst on idsFromProcInst(ID_);
-- delete act_ge_bytearray table, query can be slow
delete ba from ACT_GE_BYTEARRAY as ba inner join idsFromVarInst as ids on ba.ID_ = ids.BYTEARRAY_ID_;
delete ba from ACT_GE_BYTEARRAY as ba inner join idsFromDetail as ids on ba.ID_ = ids.BYTEARRAY_ID_;

-- delete all act_hi_* tables which have reference to a process instance (proc_inst_id)
delete ai from ACT_HI_ACTINST as ai inner join idsFromProcInst as ids on ai.PROC_INST_ID_ = ids.ID_;
delete att from ACT_HI_ATTACHMENT as att inner join idsFromProcInst as ids on att.PROC_INST_ID_ = ids.ID_;
delete c from ACT_HI_COMMENT as c inner join idsFromProcInst as ids on c.PROC_INST_ID_ = ids.ID_;
delete di from ACT_HI_DECINST as di inner join idsFromProcInst as ids on di.PROC_INST_ID_ = ids.ID_;
delete t from ACT_HI_DETAIL as t inner join idsFromProcInst as ids on t.PROC_INST_ID_ = ids.ID_;
delete t from ACT_HI_EXT_TASK_LOG as t inner join idsFromProcInst as ids on t.PROC_INST_ID_ = ids.ID_;
delete t from ACT_HI_INCIDENT as t inner join idsFromProcInst as ids on t.PROC_INST_ID_ = ids.ID_;
delete t from ACT_HI_JOB_LOG as t inner join idsFromProcInst as ids on t.PROCESS_INSTANCE_ID_ = ids.ID_;
delete t from ACT_HI_OP_LOG as t inner join idsFromProcInst as ids on t.PROC_INST_ID_ = ids.ID_;
delete t from ACT_HI_TASKINST as t inner join idsFromProcInst as ids on t.PROC_INST_ID_ = ids.ID_;
delete t from ACT_HI_VARINST as t inner join idsFromProcInst as ids on t.PROC_INST_ID_ = ids.ID_;

-- finally delete all process instances
delete t from ACT_HI_PROCINST as t 
        inner join idsFromProcInst as ids on t.PROC_INST_ID_ = ids.ID_
        where END_TIME_ is not null;
-- Uncomment the next line if the underlying mysql don't use auto_commit
-- commit; 

-- following tables are not used: act_hi_batch, act_hi_caseactinst, act_hi_dec_in, act_hi_dec_out, act_hi_identitylink