-- based on camunda 7.7 schema https://docs.camunda.org/manual/7.7/user-guide/process-engine/database/
DECLARE @intErrorCode INT
begin transaction
-- Syntax is for SQL Server
declare @amount Int, @beforeDate datetime
-- DON'T SET LESS THAN 32 DAYS, otherwise you can lose some processes forever as the sedex timeout is 31 days
set @amount = 60
-- possible valued for the first argument are day, month, year
set @beforeDate = dateadd(day,-@amount,getdate());

select v.BYTEARRAY_ID_
INTO #idsFromVarInst
from ACT_HI_VARINST v, ACT_HI_PROCINST p 
where p.ID_ = v.PROC_INST_ID_ 
    and v.BYTEARRAY_ID_ is not null
    and p.END_TIME_ is not null
    and p.END_TIME_ < @beforeDate;
create unique index idx_idsFromVarInst on #idsFromVarInst(BYTEARRAY_ID_);

select v.BYTEARRAY_ID_
into #idsFromDetail
from ACT_HI_DETAIL v, ACT_HI_PROCINST p 
where p.ID_ = v.PROC_INST_ID_ 
    and v.BYTEARRAY_ID_ is not null
    and p.END_TIME_ < @beforeDate;
create unique index idx_idsFromDetail on #idsFromDetail(BYTEARRAY_ID_);

select ID_ into #idsFromProcInst from ACT_HI_PROCINST where END_TIME_ < @beforeDate;
create unique index idx_idsFromProcInst on #idsFromProcInst(ID_);

-- delete act_ge_bytearray table, query can be slow
delete from ACT_GE_BYTEARRAY where ID_ in (select BYTEARRAY_ID_ from #idsFromVarInst);
delete from ACT_GE_BYTEARRAY where ID_ in (select BYTEARRAY_ID_ from #idsFromDetail);

-- delete all act_hi_* tables which have reference to a process instance (proc_inst_id)
delete from ACT_HI_ACTINST where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_ATTACHMENT where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_COMMENT where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_DECINST where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_DETAIL where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_EXT_TASK_LOG where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_INCIDENT where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_JOB_LOG where PROCESS_INSTANCE_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_OP_LOG where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_TASKINST where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);
delete from ACT_HI_VARINST where PROC_INST_ID_ in (select ID_ from #idsFromProcInst);

-- finally delete all process instances
delete from ACT_HI_PROCINST where END_TIME_ is not NULL 
								and ID_ in (select ID_ from #idsFromProcInst);

SELECT @intErrorCode = @@ERROR
    IF (@intErrorCode <> 0) GOTO PROBLEM
commit transaction;
PROBLEM:
IF (@intErrorCode <> 0) BEGIN
    ROLLBACK TRAN
END

-- following tables are not used: act_hi_batch, act_hi_caseactinst, act_hi_dec_in, act_hi_dec_out, act_hi_identitylink